-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section models the aerodynamic forces and moments due
--| to deflection of each aileron.  These are assembled in
--| coefficient form from functions of deflection angle, local
--| angle of attack and flap setting.  The coefficients are
--| dimensionalized using dynamic pressures based on the local
--| velocities at each aileron.  The use of local flow
--| conditions, adjusted to account for aircraft roll and yaw
--| rates, serves to extend the valid range of the model from
--| the purely static case to dynamic flight conditions
--| involving high rates of roll or yaw (including spins).

--| The aerodynamic hinge moments generated by each aileron are
--| also calculated in this section.  Like the aileron force
--| and moment contributions, these hinge moments are based on
--| the local flow conditions.
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Normalized_Types;

--| Tire Locations are computed in this package.
package Tire_Geometry is

   type Instance is private;

   procedure Assign_Tire_Radius (Init_Tire_Radius :in     Length_Types.Feet;
                                 An_Instance              :in out Instance);

   function Tire_Rad (An_Instance :in Instance) return Length_Types.Feet;

   procedure Calc_Dist_ext_cp_to_cg_ba
     (Cg_Loc               :in     Coordinate_Types.Reference_System;
      Axle_loc             :in     Coordinate_Types.Reference_System;
      Pitch_Angle          :in     Angle_Types.Radians;
      An_Instance          :in out Instance);

   procedure Assign_Dist_ext_cp_to_cg_ba
     (Init_Ext_Tire_Location       :in     Coordinate_Types.Cartesian;
                      An_Instance  :in out Instance);

   function Get_Dist_ext_cp_to_cg_ba
     (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Calc_tire_cp_to_cg_ea
     (L_3         :in     Float;
      M_3         :in     Float;
      N_3         :in     Float;
      An_Instance :in out Instance);

   procedure Assign_tire_cp_to_cg_ea
     (Init_Z_pos_CP_ext       :in     Length_Types.Feet;
      An_Instance             :in out Instance);

   function Get_tire_cp_to_cg_ea
     (An_Instance :in Instance) return Length_Types.Feet;

   procedure Calc_tire_to_cg
     (Height_above_Ground :in     Length_Types.Feet;
      L_3                 :in     Float;
      M_3                 :in     Float;
      N_3                 :in     Float;
      An_Instance         :in out Instance);

   procedure Assign_tire_to_cg
     (Init_Tire_To_Cg     :in     Coordinate_Types.Cartesian;
      An_Instance         :in out Instance);

   function Get_tire_to_cg
     (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Assign_WOW (WOW          :in     Boolean;
                         An_Instance  :in out Instance);

   function Get_WOW (An_Instance :in Instance) return Boolean;

private
   type Instance is
      record
         The_Tire_Radius           : Length_Types.Feet;
         The_Ext_Tire_Location     : Coordinate_Types.Cartesian;
         The_Z_pos_CP_ext          : Length_Types.Feet;
         The_Tire_To_Cg            : Coordinate_Types.Cartesian;
         The_WOW                   : Boolean;

      end record;
end Tire_Geometry;


