-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
--------------------------------------------------------------------------

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;

package body Tire_Geometry is

   procedure Assign_Tire_Radius (Init_Tire_Radius :in  Length_Types.Feet;
                                 An_Instance      :in out Instance) is
   begin
        An_Instance.The_Tire_Radius := Init_Tire_Radius;
   end Assign_Tire_Radius;

   function Tire_Rad (An_Instance :in Instance) return Length_Types.Feet is
   begin
      return An_Instance.The_Tire_Radius;
   end Tire_Rad;

   --| Calculate location of the bottom of the tire with reference
   --| to aircraft center of gravity in body axis.(strut extended)
   procedure Calc_Dist_ext_cp_to_cg_ba
     (Cg_Loc              :in     Coordinate_Types.Reference_System;
      axle_loc            :in     Coordinate_Types.Reference_System;
      Pitch_Angle         :in     Angle_Types.Radians;
      An_Instance         :in out Instance) is
   begin
      An_Instance.The_Ext_Tire_Location.x := Cg_Loc.Fs - axle_loc.fs -
               An_Instance.The_Tire_Radius * Sin(Pitch_Angle);
      An_Instance.The_Ext_Tire_Location.y := Cg_Loc.Bl - axle_loc.Bl;
      An_Instance.The_Ext_Tire_Location.z := Cg_Loc.Wl - axle_loc.Wl +
               An_Instance.The_Tire_Radius * Cos(Pitch_Angle);
   end Calc_Dist_ext_cp_to_cg_ba;

   procedure Assign_Dist_ext_cp_to_cg_ba
     (Init_Ext_Tire_Location :in  Coordinate_Types.Cartesian;
      An_Instance            :in out Instance) is
   begin
      An_Instance.The_Ext_Tire_Location := Init_Ext_Tire_Location;
   end Assign_Dist_ext_cp_to_cg_ba;

   function Get_Dist_ext_cp_to_cg_ba
     (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Ext_Tire_Location;
   end Get_Dist_ext_cp_to_cg_ba;

   --| Calculate the location of the tire_contact point, strut extended
   --| referenced to CG
   procedure Calc_tire_cp_to_cg_ea
     (L_3         :in     Float;
      M_3         :in     Float;
      N_3         :in     Float;
      An_Instance :in out Instance) is
   begin
      An_Instance.The_Z_pos_CP_ext:=
              L_3 * An_Instance.The_Ext_Tire_Location.X +
              M_3 * An_Instance.The_Ext_Tire_Location.Y +
              N_3 * An_Instance.The_Ext_Tire_Location.z;
   end Calc_tire_cp_to_cg_ea;

   procedure Assign_tire_cp_to_cg_ea
     (Init_Z_pos_CP_ext          :in Length_Types.Feet;
      An_Instance                :in out Instance) is
   begin
      An_Instance.The_Z_pos_CP_ext :=  Init_Z_pos_CP_ext;
   end Assign_tire_cp_to_cg_ea;

   function Get_tire_cp_to_cg_ea
     (An_Instance :in Instance) return Length_Types.Feet is
   begin
      return An_Instance.The_Z_pos_CP_ext;
   end Get_tire_cp_to_cg_ea;

   --| Calculate the compressed tire locations in body axis as a function
   --| of aircraft c.g. height above ground.
   procedure Calc_tire_to_cg
     (Height_above_Ground   :in     Length_Types.Feet;
      L_3                   :in     Float;
      M_3                   :in     Float;
      N_3                   :in     Float;
      An_Instance           :in out Instance) is
   begin
      An_Instance.The_Tire_To_Cg.y
                    := An_Instance.The_Ext_Tire_Location.y;
      An_Instance.The_Tire_To_Cg.z := (-Height_above_Ground
                  - L_3 * An_Instance.The_Tire_To_Cg.X
                  - M_3 * An_Instance.The_Tire_To_Cg.y) / N_3;
      An_Instance.The_Tire_To_Cg.x := An_Instance.The_Ext_Tire_Location.X;
   --            neglected cant of struts from RAC model (HL)
   end Calc_tire_to_cg;

   procedure Assign_Tire_To_Cg
     (Init_Tire_To_Cg            :in     Coordinate_Types.Cartesian;
      An_Instance                :in out Instance) is
   begin
      An_Instance.The_Tire_To_Cg.x := Init_Tire_To_Cg.x;
      An_Instance.The_Tire_To_Cg.y := Init_Tire_To_Cg.y;
      An_Instance.The_Tire_To_Cg.z := Init_Tire_To_Cg.z;
   end Assign_tire_to_cg;

   function Get_tire_to_cg
     (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Tire_To_Cg;
   end Get_tire_to_cg;

   procedure Assign_WOW (Wow          :in  Boolean;
                         An_Instance  :in out Instance) is
   begin
         An_Instance.The_WOW := WOW;
   end Assign_WOW;

   function Get_WOW (An_Instance :in Instance) return Boolean is
   begin
      return An_Instance.The_WOW;
   end Get_WOW;

end Tire_Geometry;












