-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section models the forces and moments between the tires and
--| the runway (or ground).  Forces and moments are computed in an
--| axis system aligned with the tire's direction of travel then resolved
--| into body axis
--------------------------------------------------------------------------

with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;

package Tire_Dynamics is

   type Instance is private;
   package It renames Interpolation_Table;

   procedure Compute_Tire_Force_Tire_Axis
     (Commanded_Brake_Force        :in     Force_Types.Lbf;
      Brake_Force_Limit            :in     Force_Types.Lbf;
      SF_Saturation                :in     Float;
      Tire_U_ep                    :in     Length_Types.Feet_per_Sec;
      Tire_V_ep                    :in     Length_Types.Feet_per_Sec;
      Normal_Tire_Force            :in     Force_Types.Lbf;
      V_Avg_Mains                  :in     Length_Types.Feet_per_Sec;
      Surface_Condition            :in     Float;
      Q_Eng                        :in     Float;
      MUROLL_Table                 :in out IT.Doubly_Indexed.Instance;
      MUY_Table                    :in out IT.Doubly_Indexed.Instance;
      An_Instance                  :in out Instance);

   --| If the tire is skidding (main wheels only).
   procedure Compute_Tire_Force_Tire_Axis_in_Skid
     (Normal_Tire_Force          :in     Force_Types.Lbf;
      Tire_U_ep                  :in     Length_Types.Feet_per_Sec;
      Tire_V_ep                  :in     Length_Types.Feet_per_Sec;
      V_Avg_Mains                :in     Length_Types.Feet_per_Sec;
      Surface_Condition          :in     Float;
      Brake_Force                :in     Float;
      Brake_Limit                :in     Float;
      MUBRAKE_Table              :in out IT.Doubly_Indexed.Instance;
      MUSKID_Table               :in out IT.Singly_Indexed.Instance;
      An_Instance                :in out Instance);

   --| Use Calc_gear_up_force for belly landing
   procedure Calc_gear_up_force
     (Normal_Tire_Force          :in     Force_Types.Lbf;
      Tire_U_Ep                  :in     Length_Types.Feet_per_Sec;
      Tire_V_Ep                  :in     Length_Types.Feet_per_Sec;
      V_Avg_Mains                :in     Length_Types.Feet_per_Sec;
      Surface_Condition          :in     Float;
      MUBRAKE_Table              :in out IT.Doubly_Indexed.Instance;
      MUSKID_Table               :in out IT.Singly_Indexed.Instance;
      An_Instance                :in out Instance);

   function Get_Tire_Force_Tire_Axis (An_Instance :in Instance) return Coordinate_Types.Cartesian ;

   procedure Compute_Tire_Force_Body_Axis
     (Nose_Wheel_Angle     :in     Angle_Types.Degrees;
      Normal_Tire_Force    :in     Force_Types.Lbf;
      L_1                  :in     Float;
      M_1                  :in     Float;
      N_1                  :in     Float;
      L_2                  :in     Float;
      M_2                  :in     Float;
      N_2                  :in     Float;
      L_3                  :in     Float;
      M_3                  :in     Float;
      N_3                  :in     Float;
      Wow                  :in     Boolean;
      An_Instance          :in out Instance);

   function Get_Tire_Force_Body_Axis (An_Instance :in Instance)
                             return Coordinate_Types.Cartesian;

   procedure Compute_Tire_Moment_Body_Axis
                    (Tire_To_Cg        :in  Coordinate_Types.Cartesian;
                     An_Instance       :in out Instance);

   function Get_Tire_Moment_Body_Axis (An_Instance :in Instance)
                            return Coordinate_Types.Cartesian;

   procedure set_Sideforce(Sideforce     :in     Float;
                           An_Instance   :in out Instance);

     private
   type Instance is
      record
         The_Tire_Force_Tire_Axis  : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         The_Tire_Force_Body_Axis  : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         The_Tire_Moment_Body_Axis : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         Old_Force_Ta              : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         Old_Y_Vel                 : Float := 0.0;
      end record;

end Tire_Dynamics;


