-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|  This section creates the vibrations from the landing gear which are felt
--|  in the cockpit: Touchdown bump, runway tar strips, gear extension and
--|  retraction, flat tires, nose wheel scuffing.
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with Normalized_Types;

package Tire_Buffets is

   type Instance is private;

 --| Displacement_Bump, is only There for Nose wheel/tire.
   procedure Assign_Displacement_Bump(Displacement_Bump  :in     Float;
                                      An_Instance        :in out Instance);

   function Get_Displacement_Bump(An_Instance :in Instance) return Float;

   procedure Calc_Td_Bump
     (Td_Bump_Gain                          :in     Float;
      Td_Descent_Rate                       :in     Float;
      Rate_of_Climb                         :in     Length_Types.Feet_per_Min;
      An_Angular_Rate_Gain                  :in     Float;
      An_Angular_Rate                       :in     Angle_Types.Radians_per_Sec;
      X_Cg                                  :in     Length_Types.Feet;
      tire_fs                               :in     Length_Types.Feet;
      An_Instance                           :in out Instance);

   procedure Assign_Td_Bump(Td_Bump_Amp     :in     Float;
                            An_Instance     :in out Instance);

   function Get_Td_Bump(An_Instance :in Instance) return Float;

   procedure Assign_Td_Occured(Td_Occured      :in     Boolean;
                               An_Instance     :in out Instance);

   function Get_Td_Occured(An_Instance :in Instance) return Boolean;


   procedure Calc_Runway_Crack_Distance(Dt              :in     Float;
                                        Ground_Speed    :in     Length_Types.Feet_per_Sec;
                                        An_Instance     :in out Instance);

   procedure Assign_Runway_Crack_Distance(Crack_Dist    :in     Length_Types.Feet;
                                          An_Instance   :in out Instance);

   function Get_Runway_Crack_Distance(An_Instance :in Instance) return Length_Types.Feet;

   procedure Calc_Runway_Crack_Bump(Roughness_Fact  :in     Float;
                                    An_Instance     :in out Instance);

   procedure Assign_Runway_Crack_Bump (Runway_Crack_Bump      : in     Float;
                                       An_Instance            : in out Instance);

   function Get_Runway_Crack_Bump(An_Instance :in Instance) return Float;

   procedure Assign_Cycle_Bump(Cycle_Bump  : in     Float;
                               An_Instance : in out Instance);

   function Get_Cycle_Bump(An_Instance :in Instance) return Float;

   procedure Calc_Flat_Tire_Time (Dt             :in     Float;
                                 Ground_Speed    :in     Length_Types.Feet_per_Sec;
                                 An_Instance     :in out Instance);

   procedure Assign_Flat_Tire_Time (Flat_Tire_Time :in     Float;
                                    An_Instance    :in out Instance);

   function Get_Flat_Tire_Time(An_Instance :in Instance) return Float;

   procedure Calc_Flat_Tire_Amplitude
     (Tire_Number         :in     Float; --| 1.0 for Left, 2.0 for Right, 3.0 for Nose tire
      Ground_Speed        :in     Length_Types.Feet_per_Sec;
      An_Instance         :in out Instance);

   procedure Assign_Flat_Tire_Amplitude (Flat_Tire_Amp :in     Float;
                                         An_Instance   :in out Instance);

   function Get_Flat_Tire_Amplitude(An_Instance :in Instance) return Float;

   procedure Calc_Runway_Rumble(Roughness_Fact   : in     Float;
                                Ground_Speed     : in     Length_Types.Feet_per_Sec;
                                An_Instance      : in out Instance);

   procedure Calc_Runway_Rumble_For_Partial_Gear_Extension
     ( Ground_Speed  : in     Length_Types.Feet_per_Sec;
       An_Instance   : in out Instance);

   procedure Assign_Runway_Rumble (Runway_Rumble :in     Float;
                                   An_Instance   :in out Instance);

   function Get_Runway_Rumble(An_Instance :in Instance) return Float;

   procedure Assign_Wheel_Scuffing_Buffet(Wheel_Scuffing_Buffet :in     Float;
                                          An_Instance           :in out Instance);

   function Get_Wheel_Scuffing_Buffet(An_Instance :in Instance) return Float;

   procedure Calc_Landing_Gear_Buffet(Landing_Gear_Position :in     Normalized_Types.Normalize;
                                      Calibrated_Airspeed   :in     Length_Types.Knots;
                                      An_Instance           :in out Instance);

   procedure Assign_Landing_Gear_Buffet (Landing_Gear_Buffet :in     Float;
                                         An_Instance         :in out Instance);

   function Get_Landing_Gear_Buffet(An_Instance :in Instance) return Float ;
private
   type Instance is
      record
         The_Displacement_Bump               : Float := 0.0;
         The_Td_Occured                      : Boolean := false;
         The_Td_Bump_Amplitude               : Float := 0.0;
         Cycle_Bump_Amplitude                : Float := 0.0;
         The_Runway_Crack_Distance           : Length_Types.Feet := 1.0;
         The_Runway_Crack_Bump               : Float := 0.0;
         The_Cycle_Bump                      : Float := 0.0;
         The_Flat_Tire_Time                  : Float := 0.0;
         The_Flat_Tire_Amplitude             : Float := 0.0;
         The_Runway_Rumble                   : Float := 0.0;
         The_Wheel_Scuffing_Buffet           : Float := 0.0;
         The_Landing_Gear_Buffet             : Float := 0.0;
      end record;

end Tire_Buffets;






