-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section models the forces and moments due generated by the tires (or aircraft
--| structure) contacting the ground.
-------------------------------------------------------------------------------
--|
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Temperature_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;

--| Tire Side Forces and Braking.
package Tire_Brakes is
package It renames Interpolation_Table;
   type Instance is private;

   procedure Set_Comp_Tire_Def
     (Normal_Tire_Force   :in     Force_Types.Lbf;
      TDFLx_Table         :in out IT.Singly_Indexed.Instance;
      An_Instance         :in out Instance);

   function Comp_Tire_Def (An_Instance :in Instance) return Float;

--| set constants When the Tire package is instantiated which will be set
--| and will not be changed  during the running of the simulator
   procedure Assign_Tire_Specific_Local_Attributes
     (k_spr_lat_defl :in     Float;
      An_Instance    :in out Instance);

   procedure Set_Normalized_Tire_Lateral_Deflection
     (Tire_Radius                :in     Length_Types.Feet;
      Tire_U_Ea                  :in     Length_Types.Feet_per_Sec;
      Tire_V_Ea                  :in     Length_Types.Feet_per_Sec;
      Normal_Tire_Force          :in     Force_Types.Lbf;
      V_Avg_Mains                :in     Length_Types.Feet_per_Sec;
      Grnd_Fric                  :in     Float;
      TLDREFF_Table              :in out IT.Singly_Indexed.Instance;
      MUYREF_Table               :in out IT.Doubly_Indexed.Instance;
      An_Instance                :in out Instance);

   function Get_Normalized_Tire_Lateral_Deflection (An_Instance :in Instance) return Float;

   --| Set_Lat_Defl_Lim_for_Tire_Side_Scuffing to be used
   --| during Tire Side Scuffing, i.e. when,
   --| An_Instance.The_Norm_Lat_Defl >= 1.5
   procedure Set_Lat_Defl_Lim_for_Tire_Side_Scuffing
     (V_Avg_Mains           :in     Length_Types.Feet_per_Sec;
      Grnd_Fric             :in     Float;
      K_Scuff               :in     Float;
      MUBRAKE_Table         :in out IT.Doubly_Indexed.Instance;
      MUSKID_Table          :in out IT.Singly_Indexed.Instance;
      MUY_Table             :in out IT.Doubly_Indexed.Instance;
      An_Instance           :in out Instance);

   --| Set_Lat_Defl_Lim to be used when,
   --| An_Instance.The_Norm_Lat_Defl < 1.5
   procedure Set_Lat_Defl_Lim
     (TLDL_Table         :in out IT.Singly_Indexed.Instance;
      An_Instance        :in out Instance);

   function Get_Lat_Defl_Lim (An_Instance :in Instance) return Float;

   procedure Assign_Lat_Defl_Lim(lat_lim        :in     Float;
                                 An_Instance    :in out Instance);

   procedure Set_Eff_Brake_Coef
     (V_Avg_Mains         :in     Length_Types.Feet_per_Sec;
      Grnd_Fric           :in     Float;
      MUBRAKE_Table       :in out IT.Doubly_Indexed.Instance;
      An_Instance         :in out Instance);

   function Get_Eff_Braking_Coefficient (An_Instance :in Instance) return Float;

   procedure Set_Brake_Cooling_Const
     (Cas           :in     Length_Types.Feet_per_Sec;
      Gear_Pos      :in     Float;
      An_Instance   :in out Instance);

   procedure Set_Commanded_Brake_Force
     (Tire_Radius           :in     Length_Types.Feet;
      x_Force_Ta            :in     Force_Types.Lbf;
      Tire_U_Ea             :in     Length_Types.Feet_per_Sec;
      V_Avg_Mains           :in     Length_Types.Feet_per_Sec;
      OAT                   :in     Temperature_Types.Celsius;
      Brake_Press           :in     Force_Types.Psi;
      BTSF_Table            :in out IT.Singly_Indexed.Instance;
      BFADEF_Table          :in out IT.Singly_Indexed.Instance;
      Stopped               :in     Boolean;
      Thrust_X              :in     Float;
      Dt                    :in     Float;
      An_Instance           :in out Instance);

   function Get_Relative_Brake_Energy (An_Instance :in Instance) return Float;

   function Get_Commanded_Brake_Force (An_Instance :in Instance) return Force_Types.Lbf;

   --| TSFBF_Table, be careful for nose tire, set TSFBF_Table = TSFBFN_Table (to
   --| be created full of 0.0, which is for nose tire.
   procedure Set_Brake_Force_Limit
     (Normal_Tire_Force :in     Force_Types.Lbf;
      TSFBF_Table         :in out IT.Singly_Indexed.Instance;
      An_Instance         :in out Instance);

   function Get_SF_Saturation (An_Instance :in Instance) return Float;

   function Get_Brake_Force_Limit (An_Instance :in Instance) return Force_Types.Lbf;

   procedure Assign_Skidding (Skid :in     Boolean;
                              An_Instance           :in out Instance);

   function Get_Skidding (An_Instance :in Instance) return Boolean;

private
   type Instance is
      record
         The_k_spr_lat_defl             : Float := 0.0;
         The_Comp_Tire_Def              : Float := 0.0;
         The_Norm_Lat_Defl              : Float := 0.0;
         The_Lat_Defl_Lim               : Float := 0.0;
         The_Eff_Braking_Coefficient    : Float := 0.0;
         The_Cooling_Time_Constant      : Float := 0.0;
         The_Relative_Brake_Energy      : Float := 0.0;
         The_Commanded_Brake_Force      : Force_Types.Lbf := 0.0;
         The_SF_Saturation              : Float := 0.0;
         The_Brake_Force_Limit          : Force_Types.Lbf := 0.0;
         The_Skidding                   : Boolean := false;
      end record;

end Tire_Brakes;
