-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-----------------------------------------------------------------------------
--
-- This package models the forces due to the strut and tires based on their
-- compression, compression rate, and various spring and damping contants
--
---------------------------------------------------------------------------
with Force_Types;
with Length_Types;
with Normalized_Types;
with Interpolation_Table.Singly_Indexed;

package Strut is
   type Instance is private;

   procedure Calc_Compression_Rate
     (Vz_Tire :in     Length_Types.Feet_per_Sec;
      Compressed_Tire_z_Velocity       :in     Length_Types.Feet_per_Sec;
      An_Instance                      :in out Instance);

   function Get_comp_rate_ba (An_Instance :in Instance)
     return Length_Types.Feet_per_Sec;

   function Get_long_comp_rate (An_Instance :in Instance)
     return Length_Types.Feet_per_Sec;

   procedure Assign_Tire_Specific_Local_Attributes
     (fric_damp_const       :in     Float;
      k_hyd_dmp_ext         :in     Float;
      k_hyd_dmp_comp        :in     Float;
      ltd_damp_force_const  :in     Float;
      An_Instance           :in out Instance);

   procedure Calc_Strut_Compression
     (ext_tire_z_to_cg      :in     Length_Types.Feet;
      tire_z_to_cg          :in     Length_Types.Feet;
      An_Instance           :in out Instance);

   function Get_Strut_Compression
          (An_Instance :in Instance) return Length_Types.Feet;

   procedure Calc_Static_Strut_Force
        (FSTRUT_Table :in out Interpolation_Table.Singly_Indexed.Instance;
         An_Instance  :in out Instance);

   function Get_Static_Strut_Force
     (An_Instance :in Instance) return Force_Types.Lbf;

   procedure Calc_Friction_Damping_Strut_Force
     (An_Instance :in out Instance);

   function Get_Friction_Damping_Strut_Force
     (An_Instance :in Instance) return Force_Types.Lbf;

   procedure Calc_hyd_damp_Extended_Strut(An_Instance :in out Instance);

   procedure Calc_hyd_damp_Compressed_Strut(An_Instance :in out Instance);

   function Get_Hydraulic_Damping_Strut_Force
                (An_Instance :in Instance) return Force_Types.Lbf;

   procedure Calc_Normal_Tire_Force(N_3         :in     Float;
                                   An_Instance :in out Instance);

   function Get_Normal_Tire_Force (An_Instance :in Instance)
                      return Force_Types.Lbf;

private
   type Instance is
      record
         The_comp_rate_ba             : Length_Types.Feet_per_Sec := 0.0;
         The_long_comp_rate           : Length_Types.Feet_per_Sec := 0.0;
         The_fric_damp_const          : Float := 0.0;
         The_k_hyd_dmp_ext            : Float := 0.0;
         The_k_hyd_dmp_comp           : Float := 0.0;
         The_ltd_damp_force_const     : Float := 0.0;
         The_Strut_Compression        : Length_Types.Feet := 0.0;
         The_Static_Strut_Force       : Force_Types.Lbf := 0.0;
         friction_force               : Force_Types.Lbf := 0.0;
         hydraulic_force              : Force_Types.Lbf := 0.0;
--         F_Damp_Lim    : Force_Types.Lbf := 0.0;
         The_Normal_Tire_Force              : Force_Types.Lbf := 0.0;
      end record;
end Strut;
