-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section models the aerodynamic forces and moments due
--| to deflection of each aileron.  These are assembled in
--| coefficient form from functions of deflection angle, local
--| angle of attack and flap setting.  The coefficients are
--| dimensionalized using dynamic pressures based on the local
--| velocities at each aileron.  The use of local flow
--| conditions, adjusted to account for aircraft roll and yaw
--| rates, serves to extend the valid range of the model from
--| the purely static case to dynamic flight conditions
--| involving high rates of roll or yaw (including spins).

--| The aerodynamic hinge moments generated by each aileron are
--| also calculated in this section.  Like the aileron force
--| and moment contributions, these hinge moments are based on
--| the local flow conditions.
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Force_Types;
with Length_Types;
with Torque_Types;
with Coordinate_Types;
--| During ground operation the nose wheel is controlled by one of two methods.
--| When nose wheel steering is selected (by depressing the button on the stick
--| grip) and the hydraulic and electric systems are properly configured and
--| weight is on the nose gear, a hydraulic actuator controls the steering angle.
--| This actuator is commanded mechanically via a push-pull cable by the rudder
--| pedals.  When the steering is not selected, the nose wheel is free to castor.
--| Additionally, the steering angle is centered by hydraulic power during the
--| gear retraction cycle.
--|
--| This model includes both the castoring and hydraulic steering modes.  The
--| actuator model accounts for the effect of varying system pressure and steering
--| resistance on actuation rate, as well as the availability of electrical power
--| at the selector valve.  Fluid flow rate is calculated during actuation for
--| feedback to the hydraulic pressure source model.

package Steering is

   type Instance is private;

   procedure Calc_Commanded_Nose_Angle
             (Pedal_Position   :in     Angle_Types.Degrees;
              Speed            :in     Float;
              An_Instance      :in out Instance);
   procedure Assign_Cmd_NWA
           (Nwa            :in     Angle_Types.Degrees;
            An_Instance    :in out Instance);

   function Get_Cmd_nwa(An_Instance :in Instance)
           return Angle_Types.Degrees;

   procedure Calc_Nose_Angle
               (Dt            :in     Float;
                An_Instance   :in out Instance);
   procedure Zero_NWA (An_Instance  :in out Instance);
   procedure Assign_NWA
           (Nwa            :in     Angle_Types.Degrees;
            An_Instance    :in out Instance);

   function Get_NWA(An_Instance :in Instance)
              return Angle_Types.Degrees;

   procedure Calc_Nose_Angle_Rate
     (Sign                       :in     Float;
      y_Force                   :in     Force_Types.Lbf;
      Norm_Hyd_Press_Fac         :in     Float;
      Dt                         :in     Float;
      An_Instance                :in out Instance);

   procedure Calc_Nose_Angle_Rate_for_Castor
     (y_Force          :in     Force_Types.Lbf;
      An_Instance      :in out Instance);

   procedure Zero_Nwa_Rate
               (An_Instance   :in out Instance);

   function Get_Nose_Angle_Rate(An_Instance :in Instance)
          return Angle_Types.Degrees_per_Sec;

   procedure Calc_Hydraulic_Flow_Rate
              (Dt           :in     Float;
               An_Instance  :in out Instance);

   procedure zero_hyd_Flow (An_Instance :in out Instance);

   function Get_Hydraulic_Flow_Rate
                  (An_Instance :in Instance) return Float;

private
   type Instance is
      record
         The_CMD_NWA        : Angle_Types.Degrees := 0.0;
         The_NWA            : Angle_Types.Degrees := 0.0;
         The_Nwa_rate       : Angle_Types.Degrees_per_Sec := 0.0;
         The_Hyd_Flow       : Float := 0.0;   --| gallons/min
         The_Turn_Time      : Float := 1000.0;
         The_Turn_Rate      : Angle_Types.Radians_per_Sec := 0.0;
         The_Turn_Accel     : Float := 0.0;
         The_Turn_Radius    : Length_Types.Feet := 10000.0;
         The_FY_Mains       : Force_Types.lbf := 0.0;
         The_FY_Nose        : Force_Types.lbf := 0.0;
         The_Mz_Gear        : Torque_Types.Ft_Lbf:= 0.0;
      end record;
end Steering;
