-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section describes the rudder's aerodynamic hinge moment, aerodynamic
--| and system neutral positions.

with Angle_Types;
with Force_Types;
with Length_Types;
with Mass_Types;
with Torque_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;

package Rudder is
   package It renames Interpolation_Table;
   type Instance is private;


   function Pos(An_Instance :in Instance) return Angle_Types.Degrees;

   procedure Calc_Eff_Pos
      (Rud_Tab_Position        :in     Angle_Types.Degrees;
       Yaw_Rate                :in     Angle_Types.Radians_per_Sq_Sec;
       Aoa                     :in     Angle_Types.degrees;
       Dt                      :in     Float;
       An_Instance             :in out Instance);
   function Eff_Pos(An_Instance :in Instance)
           return Angle_Types.Degrees;
   function Lag_Eff_Pos(An_Instance :in Instance)
           return Angle_Types.Degrees;
   procedure Calc_HM
     (VT_Q   :in     Force_Types.Pounds_per_Sq_Feet;
      Rud_Tab           :in     Angle_Types.Degrees;
      VT_AOA            :in     Angle_Types.Degrees;
      FCHRTAB_t         :in out IT.Doubly_Indexed.Instance;
      KCHRTAB_t         :in out IT.Singly_Indexed.Instance;
      CHR_t             :in out IT.multiply_Indexed.Instance;
      DCHRDR_t          :in out IT.multiply_Indexed.Instance;
      HMRSPRING_t       :in out IT.Singly_Indexed.Instance;
      Flap_Pos          :in     Angle_Types.Degrees;
      Test_Flag         :in     Boolean;
      An_Instance           :in out Instance);
   function HM
          (An_Instance :in Instance) return Torque_Types.Ft_Lbf;
   function Spring_HM
          (An_Instance :in Instance) return Torque_Types.Ft_Lbf;
   function Aero_Grad
          (An_Instance :in Instance) return Float;
   function Aero_HM_pD
          (An_Instance :in Instance) return Float;
   procedure Calc_Neut_Pos
     (DHMRSPRNGDR_t     :in out IT.Singly_Indexed.Instance;
      An_Instance       :in out Instance);
   function Aero_Neut_Pos (An_Instance :in Instance)
           return Angle_Types.Degrees;
   function Sys_Neut_Pos (An_Instance :in Instance)
           return Angle_Types.Degrees;
   procedure Calc_Damping
     (Air_Dens      :in     Mass_Types.Slugs_per_Cubic_Feet;
      Vt_Q          :in     Float;
      Tas           :in     Length_Types.Feet_per_Sec;
      dt            :in     Float;
      An_Instance   :in out Instance);
   function Damping (An_Instance :in Instance) return Float;
   procedure Assign_Position (Rudder_Position :in     Angle_Types.Degrees;
                              An_Instance     :in out Instance);

private
   type Instance is
      record
         The_Aerodynamic_Gradient           : Float               := 0.0;
         The_Aerodynamic_HM_per_Degree      : Float               := 0.0;
         The_Aerodynamic_Neutral_Position   : Angle_Types.Degrees := 0.0;
         The_Area                           : Length_Types.Sq_Feet:= 7.96;
         The_Chord                          : Length_Types.Feet   := 1.54;
         The_Damping                        : Float               := 0.0;
         The_HM                             : Torque_Types.Ft_Lbf := 0.0;
         The_Position                       : Angle_Types.Degrees := 0.0;
         The_Eff_Position                   : Angle_Types.Degrees := 0.0;
         The_Last_Pass_Eff_Position         : Angle_Types.Degrees := 0.0;
         The_Lag_Eff_Position               : Angle_Types.Degrees := 0.0;
         The_Last_Pass_Lag_Eff_Position     : Angle_Types.Degrees := 0.0;
         The_Spring_HM                      : Torque_Types.Ft_Lbf := 0.0;
         The_System_Neutral_Position        : Angle_Types.Degrees := 0.0;
      end record;
end Rudder;
