-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Yogesh Tupe
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--|
--| This package defines JPATS project specific attributes and types/subtypes.

with Angle_Types;
with Length_Types;
with Simulation_Dictionary;

package JPATS_Aircraft_Body_Types is

   --| Path to directory where data files are stored in.

    File_Path  : String := Simulation_Dictionary.Lookup ("Aircraft_Body_Dir");

   Ht_Cm            : Float := -0.0085;
   Vt_cn            : Float := -0.0064;
   Vt_Sidewash_K    : Float := 231.0;
   Le_mac           : Length_Types.Feet := 12.705;

end JPATS_Aircraft_Body_Types;
