-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--|
--| This package provides access to variables in the aircraft body
--| to other categories of the simulation

with Angle_Types;
with Coordinate_Types;
with Length_Types;

package JPATS_Aircraft_Body is

--| flight Controls
    function Left_Ail_HM return Float;
    function Left_Ail_HM_pD return Float;
    function Right_Ail_HM return Float;
    function Right_Ail_HM_pD return Float;
    function Elev_Aero_HM_PD return Float;
    function Elev_Aero_Neutral_Pos return Angle_Types.Degrees;
    function Get_Rudder_Position return Angle_Types.degrees;
    function Get_Rudder_Spring_Hinge_Moment return Float;
    function Rud_Aero_HM_pD return Float;
    function Rud_Aero_Neutral_Pos return Angle_Types.Degrees;

    --| Wing Body Plus
    function Get_Wing_Body_Plus_Weight_Ice return float;
    function Crash_Nose_Impact return Boolean;
    function Crash_Wingtip_Impact return Boolean;
    function Crash_Tail_Impact return Boolean;

    --| Left Tire
    function Get_Left_Wow return Boolean;
    function Get_Left_Vel_Ep return Coordinate_Types.Cartesian;
    function Get_Left_Td_Bump return Float;
    function Get_Flat_Left_Amplitude return Float;
    function Get_Left_Gear_Buffets return Float;
    function Get_Left_Wheel_Speed return Length_Types.Feet_per_Sec;

    --| Right Tire
    function Get_Right_WOW return Boolean;
    function Get_Right_Vel_Ep return Coordinate_Types.Cartesian;
    function Get_Right_Td_Bump return Float;
    function Get_Flat_Right_Amplitude return Float;
    function Get_Right_Gear_Buffets return Float;
    function Get_Right_Wheel_Speed return Length_Types.Feet_per_Sec;

--| Nose Tire
    function Get_Nwa return Angle_Types.Degrees_per_Sec;
    function Get_Nose_Vel_Ep return Coordinate_Types.Cartesian;
    function Get_Nose_Steering_Hydraulic_Flow_Rate return Float;
    function Get_Nose_WOW return Boolean;
    function Get_Nose_Force_Body_Axis return Coordinate_Types.Cartesian;
    function Get_Nose_Td_Bump return Float;
    function Get_Flat_nose_Amplitude return Float;
    function Nose_Wheel_Scuffing return Float;
    function Get_Nose_Gear_Buffets return Float;
    function Get_Nose_Wheel_Speed return Length_Types.Feet_per_Sec;
    --| Tail_Skid
    function Get_Tail_WOW return Boolean;

--| combined aircraft body components
    function Get_WOW return Boolean;
    function Tar_Strip_Bump return Float;
    function Get_Cycle_Bump return Float;
    function Get_Aircraft_Runway_Rumble return Float;
    function Get_Aircraft_Landing_Gear_Buffet return Float;
    function Get_Force return Coordinate_Types.Cartesian;
    function Get_Moment return Coordinate_Types.Cartesian;
    function aero_Force return Coordinate_Types.Cartesian;
    function aero_Moment return Coordinate_Types.Cartesian;
    function gear_Force return Coordinate_Types.Cartesian;
    function gear_Moment return Coordinate_Types.Cartesian;
    function Get_Stand_Still return Boolean;
    function Debug0 return Float;
    function Debug1 return Float;
    function Debug2 return Float;
    function Debug3 return Float;
    function Debug4 return Float;
    function Debug5 return Float;
    function Debug6 return Float;
    function Debug7 return Float;
    function Debug8 return Float;
    function Debug9 return Float;
    function Latency_Trigger return Boolean;
    
end JPATS_Aircraft_Body;








