-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--|
--| This package provides access to variables in the aircraft body
--| to other categories of the simulation

with Aileron;
with Aircraft_Body;
with Elevator;
with Rudder;
with Wing_Body_Plus;
with Steering;
with Tire_Buffets;
with Tire_Dynamics;
with Tire_Geometry;
with Tire_Velocity;
with JPATS_Aircraft_Body.Container;

package body JPATS_Aircraft_Body is

  use Container;
  package Cnt renames Container;
  ab : aircraft_body.Instance renames Cnt.This_Subsystem.The_aircraft_body;
  Sub : Instance renames Cnt.This_Subsystem;

  function Left_Ail_HM return Float is
  begin
    return Aileron.Get_Hinge_Moment(Sub.The_Left_Aileron);
  end Left_Ail_HM;

  function Left_Ail_HM_PD return Float is
  begin
    return Aileron.Get_Aerodynamic_Hinge_Moment_Per_Degree(Sub.The_Left_Aileron);
  end Left_Ail_HM_PD;

  function Right_Ail_HM return Float is
  begin
    return Aileron.Get_Hinge_Moment(Sub.The_Right_Aileron);
  end Right_Ail_HM;

  function Right_Ail_HM_PD return Float is
  begin
    return Aileron.Get_Aerodynamic_Hinge_Moment_Per_Degree(Sub.The_Right_Aileron);
  end Right_Ail_HM_PD;

  function Elev_Aero_HM_PD return Float is
  begin
    return Elevator.Get_Aero_HM_PD(Sub.The_Elevator);
  end Elev_Aero_HM_PD;

  function Elev_Aero_Neutral_Pos return Angle_Types.Degrees is
  begin
    return Elevator.Get_Aerodynamic_Neutral_Position(Sub.The_Elevator);
  end Elev_Aero_Neutral_Pos;

  function Get_Rudder_Position return Angle_Types.Degrees is
  begin
    return Rudder.Pos(Sub.The_Rudder);
  end Get_Rudder_Position;

  function Get_Rudder_Spring_Hinge_Moment return Float is
  begin
    return Rudder.Spring_HM(Sub.The_Rudder);
  end Get_Rudder_Spring_Hinge_Moment;

  function Rud_Aero_HM_PD return Float is
  begin
    return Rudder.Aero_HM_PD(Sub.The_Rudder);
  end Rud_Aero_HM_PD;

  function Rud_Aero_Neutral_Pos return Angle_Types.Degrees is
  begin
    return Rudder.Aero_Neut_Pos(Sub.The_Rudder);
  end Rud_Aero_Neutral_Pos;

  --| Wing Body Plus

  function Get_Wing_Body_Plus_Weight_Ice return Float is
  begin
    return Wing_Body_Plus.Get_Weight_Ice(Sub.The_Wing_Body_Plus);
  end Get_Wing_Body_Plus_Weight_Ice;

  function Crash_Nose_Impact return Boolean is
  begin
    return Wing_Body_Plus.Get_Crash_Nose_Impact(Sub.The_Wing_Body_Plus);
  end Crash_Nose_Impact;

  function Crash_Wingtip_Impact return Boolean is
  begin
    return Wing_Body_Plus.Get_Crash_Wingtip_Impact(Sub.The_Wing_Body_Plus);
  end Crash_Wingtip_Impact;

  function Crash_Tail_Impact return Boolean is
  begin
    return Wing_Body_Plus.Get_Crash_Tail_Impact(Sub.The_Wing_Body_Plus);
  end Crash_Tail_Impact;


  function Get_Left_WOW return Boolean is
  begin
    return Tire_Geometry.Get_WOW(Sub.The_Tires(Left).The_Geometry);
  end Get_Left_Wow;

  function Get_left_Vel_Ep return Coordinate_Types.Cartesian is
  begin
    return Tire_Velocity.Get_Tire_Vel_Ep(Sub.The_Tires(Left).The_Velocity);
  end Get_left_Vel_Ep;

  function Get_Left_Td_Bump return Float is
  begin
    return Tire_Buffets.Get_Td_Bump(Sub.The_Tires(Left).The_Buffets);
  end Get_Left_Td_Bump;

  function Get_Flat_Left_Amplitude return Float is
  begin
    return Tire_Buffets.Get_Flat_Tire_Amplitude(Sub.The_Tires(Left).The_Buffets);
  end Get_Flat_Left_Amplitude;

  function Get_Left_Gear_Buffets return Float is
  begin
    return Tire_Buffets.Get_Landing_Gear_Buffet(Sub.The_Tires(Left).The_Buffets);
  end Get_Left_Gear_Buffets;

  function Get_Left_Wheel_Speed return Length_Types.Feet_Per_Sec is
  begin
    return Angle_Types.Rpm_To_Radians_Per_Sec(Tire_Velocity.Get_Wheel_Speed(Sub.The_Tires(Left).The_Velocity))*Tire_Geometry.Tire_Rad(Sub.The_Tires(Left).The_Geometry);
  end Get_Left_Wheel_Speed;
    
  function Get_Right_WOW return Boolean is
  begin
    return Tire_Geometry.Get_WOW(Sub.The_Tires(Right).The_Geometry);
  end Get_Right_WOW;

  function Get_Right_Vel_Ep return Coordinate_Types.Cartesian is
  begin
    return Tire_Velocity.Get_Tire_Vel_Ep(Sub.The_Tires(Right).The_Velocity);
  end Get_Right_Vel_Ep;

   function Get_Flat_right_Amplitude return Float is
  begin
    return Tire_Buffets.Get_Flat_Tire_Amplitude(Sub.The_Tires(right).The_Buffets);
  end Get_Flat_right_Amplitude;

  function Get_Right_Td_Bump return Float is
  begin
    return Tire_Buffets.Get_Td_Bump(Sub.The_Tires(Right).The_Buffets);
  end Get_Right_Td_Bump;

  function Get_Right_Gear_Buffets return Float is
  begin
    return Tire_Buffets.Get_Landing_Gear_Buffet(Sub.The_Tires(Right).The_Buffets);
  end Get_Right_Gear_Buffets;

  function Get_Right_Wheel_Speed return Length_Types.Feet_Per_Sec is
  begin
    return Angle_Types.Rpm_To_Radians_Per_Sec(Tire_Velocity.Get_Wheel_Speed(Sub.The_Tires(Right).The_Velocity))*Tire_Geometry.Tire_Rad(Sub.The_Tires(Right).The_Geometry);
  end Get_Right_Wheel_Speed;
    
  function Get_Nwa return Angle_Types.Degrees is
  begin
    return Steering.Get_NWA(Sub.Nw_Steering);
  end Get_Nwa;

  function Get_Nose_Vel_Ep return Coordinate_Types.Cartesian is
  begin
    return Tire_Velocity.Get_Tire_Vel_Ep(Sub.The_Tires(Nose).The_Velocity);
  end Get_Nose_Vel_Ep;

  function Get_Nose_Steering_Hydraulic_Flow_Rate return Float is --gallons/min
  begin
    return Steering.Get_Hydraulic_Flow_Rate(Sub.Nw_Steering);
  end Get_Nose_Steering_Hydraulic_Flow_Rate;

   function Get_Nose_WOW return Boolean is
  begin
    return Tire_Geometry.Get_WOW(Sub.The_Tires(Nose).The_Geometry);
  end Get_Nose_WOW;

  function Get_Nose_Force_Body_Axis return Coordinate_Types.Cartesian is
  begin
    return Tire_Dynamics.Get_Tire_Force_Body_Axis(Sub.The_Tires(Nose).The_Dynamics);
  end Get_Nose_Force_Body_Axis;

  function Get_Nose_Td_Bump return Float is
  begin
    return Tire_Buffets.Get_Td_Bump(Sub.The_Tires(Nose).The_Buffets);
  end Get_Nose_Td_Bump;

  function Get_Flat_Nose_Amplitude return Float is
  begin
    return Tire_Buffets.Get_Flat_Tire_Amplitude(Sub.The_Tires(Nose).The_Buffets);
  end Get_Flat_Nose_Amplitude;

  function Nose_Wheel_Scuffing return Float is
  begin
    return Tire_Buffets.Get_Wheel_Scuffing_Buffet(Sub.The_Tires(Nose).The_Buffets);
  end Nose_Wheel_Scuffing;

  function Get_Nose_Gear_Buffets return Float is
  begin
    return Tire_Buffets.Get_Landing_Gear_Buffet(Sub.The_Tires(Nose).The_Buffets);
  end Get_Nose_Gear_Buffets;

  function Get_Nose_Wheel_Speed return Length_Types.Feet_Per_Sec is
  begin
    return Angle_Types.Rpm_To_Radians_Per_Sec(Tire_Velocity.Get_Wheel_Speed(Sub.The_Tires(Nose).The_Velocity))*Tire_Geometry.Tire_Rad(Sub.The_Tires(Nose).The_Geometry);
  end Get_Nose_Wheel_Speed;
    
  function Get_Tail_WOW return Boolean is
  begin
    return Tire_Geometry.Get_WOW(Sub.The_Tires(Tail).The_Geometry);
  end Get_Tail_WOW;

  function Get_WOW return Boolean is
  begin
    return Aircraft_Body.Get_WOW(Ab);
  end Get_WOW;

  function Tar_Strip_Bump return Float is
  begin
    return Aircraft_Body.Get_Runway_Crack_Bump(Ab);
  end Tar_Strip_Bump;

  function Get_Cycle_Bump return Float is
  begin
    return Aircraft_Body.Get_Cycle_Bump_Amplitude(Ab);
  end Get_Cycle_Bump;

  function Get_Aircraft_Runway_Rumble return Float is
  begin
    return Aircraft_Body.Get_Runway_Rumble(Ab);
  end Get_Aircraft_Runway_Rumble;

  function Get_Aircraft_Landing_Gear_Buffet return Float is
  begin
    return Aircraft_Body.Get_Landing_Gear_Buffet(Ab);
  end Get_Aircraft_Landing_Gear_Buffet;

  function Get_Force return Coordinate_Types.Cartesian is
  begin
    return Aircraft_Body.Get_Force(Ab);
  end Get_Force;

  function Get_Moment return Coordinate_Types.Cartesian is
  begin
    return Aircraft_Body.Get_Moment(Ab);
  end Get_Moment;

  function Aero_Force return Coordinate_Types.Cartesian is
  begin
    return Aircraft_Body.Aero_Force(Ab);
  end Aero_Force;

  function Aero_Moment return Coordinate_Types.Cartesian is
  begin
    return Aircraft_Body.Aero_Moment(Ab);
  end Aero_Moment;

  function Gear_Force return Coordinate_Types.Cartesian is
  begin
    return Aircraft_Body.Gear_Force(Ab);
  end Gear_Force;

  function Gear_Moment return Coordinate_Types.Cartesian is
  begin
    return Aircraft_Body.Gear_Moment(Ab);
  end Gear_Moment;

  function Get_Stand_Still return Boolean is
  begin
    return Aircraft_Body.Get_Stand_Still(Ab);
  end Get_Stand_Still;


  function Debug0 return Float is
  begin
    return Sub.Debug0;
  end Debug0;

  function Debug1 return Float is
  begin
    return Sub.Debug1;
  end Debug1;

  function Debug2 return Float is
  begin
    return Sub.Debug2;
  end Debug2;

  function Debug3 return Float is
  begin
    return Sub.Debug3;
  end Debug3;

  function Debug4 return Float is
  begin
    return Sub.Debug4;
  end Debug4;

  function Debug5 return Float is
  begin
    return Sub.Debug5;
  end Debug5;

  function Debug6 return Float is
  begin
    return Sub.Debug6;
  end Debug6;

  function Debug7 return Float is
  begin
    return Sub.Debug7;
  end Debug7;

  function Debug8 return Float is
  begin
    return Sub.Debug8;
  end Debug8;

  function Debug9 return Float is
  begin
    return Sub.Debug9;
  end Debug9;

  function Latency_Trigger return Boolean is
  begin
    return Sub.Latency_Trigger;
  end Latency_Trigger;

end JPATS_Aircraft_Body;
