-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Yogesh Tupe
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--|
--| This package is a collection of all the instances of domain classes that go
--| into building the full character of the aircraft body category.


with Aileron;
with Aircraft_Body;
with Elevator;
with Horizontal_Tail;
with Rudder;
with Vertical_Tail;
with Wing_Body_Plus;
--| Landing Gear Components
with Steering;
with Strut;
with Tire_Brakes;
with Tire_Buffets;
with Tire_Dynamics;
with Tire_Geometry;
with Tire_Velocity;
with Normalized_Types;
with Temperature_Types;
with Force_Types;

private package JPATS_Aircraft_Body.Container is

   type Tire_Locations is
      ( Nose, Left, Right, Tail );

   -- The tail "tire" is really just a bumper
   -- This subtype excludes the tail
   subtype Real_Tires is
      Tire_Locations range Nose .. Right;

   type Tire_Geometry_Constants is
      record
         The_Radius  : Length_Types.Feet;
         The_BL      : Length_Types.Feet;
         The_FS      : Length_Types.Feet;
         The_WL_Ext  : Length_Types.Feet;
         The_Wl_Ret  : Length_Types.Feet;
      end record;

   type Strut_Constants is
      record
         The_Damping_Friction_Force    : Float;
         The_Hyd_Dmp_Ext               : Float;
         The_Hyd_Dmp_Comp              : Float;
         The_Damping_Limited_Force     : Float;
         The_K_Spr_Lat_Defl            : Float;
      end record;

   type Tire_Buffet_Constants is
      record
         The_Going_Up_Value           : Float;
         The_Going_Down_Value         : Float;
         The_Td_Bump_Gain             : Float;
         The_Td_Descent_Rate_Gain     : Float;
         The_Angular_Rate_Gain        : Float;
      end record;

   type Tire_Constants is
      record
         The_Geometry : Tire_Geometry_Constants;
         The_Strut    : Strut_Constants;
         The_Buffet   : Tire_Buffet_Constants;
      end record;

   type Tire_Constant_Array is
      array ( Tire_Locations ) of Tire_Constants;

   The_Tire_Constants : constant Tire_Constant_Array
     := ( Left =>
            ( The_Geometry =>
                ( The_Radius   => 0.833,
                  The_Bl       => -4.17,
                  The_FS       => 15.076,  --15.076,mved 0.9"fwd
                  The_Wl_Ext   =>  3.576,
                  The_wl_Ret   =>  6.045),
              The_Strut =>
                ( The_Damping_Friction_Force => 200.0,
                  The_Hyd_Dmp_Ext   => 1100.0,
                  The_Hyd_Dmp_Comp =>  700.0,
                  The_Damping_Limited_Force => 15300.0,
                  The_K_Spr_Lat_Defl => 17252.0 ),
              The_Buffet =>
                ( The_Going_Up_Value => 0.014,
                  The_Going_Down_Value => 0.030,
                  The_Td_Bump_Gain => 0.40,
                  The_Td_Descent_Rate_Gain => 0.005_1,
                  The_Angular_Rate_Gain => 1.5 ) ),
          Right =>
            ( The_Geometry =>
                ( The_Radius   => 0.833,
                  The_Bl       => 4.17,
                  The_FS       => 15.076,  --15.076,mved 0.9"fwd
                  The_Wl_Ext   =>  3.576,
                  The_Wl_Ret   =>  6.045),
              The_Strut =>
                ( The_Damping_Friction_Force => 200.0,
                  The_Hyd_Dmp_Ext   => 1100.0,
                  The_Hyd_Dmp_Comp =>  700.0,
                  The_Damping_Limited_Force => 15300.0,
                  The_K_Spr_Lat_Defl => 17252.0 ),
              The_Buffet =>
                ( The_Going_Up_Value => 0.014,
                  The_Going_Down_Value => 0.030,
                  The_Td_Bump_Gain => 0.40,
                  The_Td_Descent_Rate_Gain => 0.005_1,
                  The_Angular_Rate_Gain => 1.5 ) ),
          Nose =>
            ( The_Geometry =>
                ( The_Radius   =>  0.654,
                  The_Bl       =>  0.0,
                  The_Fs       =>  7.498,
                  The_Wl_Ext   =>  3.18, -- was 3.114,
                  The_Wl_Ret   =>  6.293),
              The_Strut =>
                ( The_Damping_Friction_Force => 160.0,
                  The_Hyd_Dmp_Ext   => 870.0,
                  The_Hyd_Dmp_Comp =>  550.0,
                  The_Damping_Limited_Force => 12250.0,
                  The_K_Spr_Lat_Defl =>  10504.0 ),
              The_Buffet =>
                ( The_Going_Up_Value => 0.030,
                  The_Going_Down_Value => 0.020,
                  The_Td_Bump_Gain => 0.12,
                  The_Td_Descent_Rate_Gain => 0.005_1,
                  The_Angular_Rate_Gain => 0.40 ) ),
          Tail =>
            ( The_Geometry =>
                ( The_Radius   =>  0.0,
                  The_Bl       =>  0.0,
                  The_FS       => 29.833,  -- was 21.833
                  The_Wl_Ext   =>  7.016,  -- was 6.416
                  The_Wl_Ret   =>  7.016), --was 6.416
              The_Strut =>
                ( The_Damping_Friction_Force => 0.0,
                  The_Hyd_Dmp_Ext   => 0.0,
                  The_Hyd_Dmp_Comp =>  0.0,
                  The_Damping_Limited_Force => 0.0,
                  The_K_Spr_Lat_Defl => 0.0 ),
              The_Buffet =>
                ( The_Going_Up_Value => 0.0,
                  The_Going_Down_Value => 0.0,
                  The_Td_Bump_Gain => 0.0,
                  The_Td_Descent_Rate_Gain => 0.0,
                  The_Angular_Rate_Gain =>  0.0 )));

   Nose_Wheel_Displacement_Bump_Magnitude : Float := 0.003;

   type Tire is
      record
         The_Geometry        : Tire_Geometry.Instance;
         The_Velocity        : Tire_Velocity.Instance;
         The_Strut           : Strut.Instance;
         The_Brakes          : Tire_Brakes.Instance;
         The_Dynamics        : Tire_Dynamics.Instance;
         The_Buffets         : Tire_Buffets.Instance;
      end record;

   type Tire_Array is
      array ( Tire_Locations ) of Tire;

   type Tire_Bool_Array is array (Tire_Locations) of Boolean;

   type Instance is
      record
         The_Aircraft_Body             : Aircraft_Body.Instance;
         The_Left_Aileron              : Aileron.Instance;
         The_Right_Aileron             : Aileron.Instance;
         The_Elevator                  : Elevator.Instance;
         The_Horizontal_tail           : Horizontal_tail.Instance;
         The_Rudder                    : Rudder.Instance;
         The_Vertical_Tail             : Vertical_Tail.Instance;
         The_Wing_Body_plus            : Wing_Body_Plus.Instance;
         The_Tires                     : Tire_Array;
         Nw_Steering                   : Steering.Instance;
         Latency_Trigger               : Boolean;
         Debug0                        : Float := 1.0;
         Debug1                        : Float := 1.0;
         Debug2                        : Float := 1.0;
         Debug3                        : Float := 1.0;
         Debug4                        : Float := 1.0;
         Debug5                        : Float := 1.0;
         Debug6                        : Float := 1.0;
         Debug7                        : Float := 1.0;
         Debug8                        : Float := 1.0;
         Debug9                        : Float := 1.0;
         Old_Rud_Tab                   : Float;  -- moved to container
         Old_Ele_Tab                   : Float;  -- moved to container
         Old_Aileron_Position          : Angle_Types.Degrees := 0.0; -- moved to container
         Old_Elevator_Position         : Angle_Types.Degrees := 0.0; -- moved to container
         Old_Q                         : Float := 0.0;               -- moved to container
         Old_Rudder_Position           : Angle_Types.Degrees := 0.0; -- moved to container
         Old_Tas                       : Float := 0.0;               -- moved to container
         Below_Breakout                : Boolean := True; -- container
         Below_Breakout1               : Boolean := True; -- container
         Below_Breakout2               : Boolean := True; -- container
         Below_Breakout3               : Boolean := True; -- container
         Up_Lock_Pv                    : Tire_Bool_Array; -- array (Tire_Locations'range) of Boolean; -- container
         Down_Lock_Pv                  : Tire_Bool_Array; -- array (Tire_Locations'range) of Boolean; -- container
         Ht_Dyn_Downwash               : Float := 0.0; -- container
         LG_Buffet                     : Float:= 0.0; -- container
         Local_Time                    : Float := 0.0; -- container
         Nwa                           : Angle_Types.Degrees;  -- container
         Oat                           : Temperature_Types.Rankine; -- container
         Test_Case                     : Integer := 0; -- classwide for testing
         Test_Ct                       : Integer := 0; -- container
         WOW                           : Boolean := True; -- container
         Y_Tfta                        : Force_Types.Lbf := 0.0; -- container

      end record;

   This_Subsystem : Instance;

   type Tire_Boolean_Array is
      array (Tire_Locations) of Boolean;

end JPATS_Aircraft_Body.Container;






