-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section describes the flowfield seen the horizontal tail,
--| the downwash angle and a dynamic pressure ratio
--| Changes in wing lift require a finite time to effect the downwash angle
--| at the tail.  This convection delay is modeled here as a first-order lag
--| imposed on the computed downwash, with a time constant equal to the
--| convection time between wing and tail.
--| A first-order lag is also imposed on the thrust-induced component of the
--| dynamic pressure.  The time constant in this case is the convection time
--| between propeller and tail, adjusted for the air velocity within the
--| propeller wake.

--| The aerodynamic contributions of the horizontal tail are computed

with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Mass_Types;
with Normalized_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;

package Horizontal_Tail is
   package It renames Interpolation_Table;
   type Instance is private;

   procedure Calc_Moment_Arm
      (X_CG               :in     Length_Types.Feet;
       Y_CG               :in     Length_Types.Feet;
       Z_CG               :in     Length_Types.Feet;
       An_Instance        :in out Instance);

   function Get_Dynamic_Downwash_Angle
           (An_Instance :in Instance) return Angle_Types.Degrees;

   function Get_Static_Downwash_Angle
           (An_Instance :in Instance) return Angle_Types.Degrees;

   procedure Compute_Dynamic_Pressure_Ratio
     (AOA                       :in     Angle_Types.Degrees;
      Beta                      :in     Angle_Types.Degrees;
      Flap_Position             :in     Angle_Types.Degrees;
      Ct                        :in     Float;
      prop_x_dist               :in     Length_Types.Feet;
      x_V_B                     :in     Length_Types.Feet_per_Sec;
      NHA_Table                 :in out It.Doubly_Indexed.Instance;
      FNHTA_Table               :in out It.Doubly_Indexed.Instance;
      FNHTB_Table               :in out It.Doubly_Indexed.Instance;
      KNHT_Table                :in out It.Doubly_Indexed.Instance;
      KNHB_Table                :in out It.Singly_Indexed.Instance;
      Dt                        :in     Float;
      Test_Flag                 :in     Boolean;
      An_Instance               :in out Instance);

   function Get_Dynamic_Pressure_Ratio (An_Instance :in Instance) return Float;
   function Get_Unlagged_Thrust_Induced
                 (An_Instance :in Instance) return Float;
   function Get_Convection_Lag_Thrust_Induced
                 (An_Instance :in Instance) return Float;
   procedure Calc_Attributes(True_Airspeed :in Length_Types.Feet_per_Sec;
                         AOA            :in Angle_Types.Degrees;
                         Roll_Rate      :in Angle_Types.Radians_per_Sec;
                         Pitch_Rate     :in Angle_Types.Radians_per_Sec;
                         An_Air_Density :in Mass_Types.Slugs_per_Cubic_Feet;
                         An_Instance    :in out Instance);

   function Get_Local_AOA (An_Instance :in Instance)
                           return Angle_Types.Degrees;
   function Get_Local_Q (An_Instance :in Instance)
                           return Force_Types.Pounds_per_Sq_Feet;

   procedure Calc_Coefficient
                   (Eff_Elev_Pos     :in     Angle_Types.Degrees;
                    cm               :in     Float;
                    Mach             :in     Length_Types.Mach;
                    Ship_Num         :in     Integer;
                    CLH_Table        :in out It.Multiply_Indexed.Instance;
                    CDH_Table        :in out It.Doubly_Indexed.Instance;
                    An_Instance      :in out Instance);

   procedure Calc_Force(An_Instance :in out Instance);

   function Get_Force(An_Instance :in Instance)
                 return Coordinate_Types.Cartesian;

   procedure Calc_Moment(Test_Flag   :in     Boolean;
                         An_Instance :in out Instance);

   function Get_Moment (An_Instance :in Instance)
     return Coordinate_Types.Cartesian;

   procedure Assign_Dyn_downwash (Dyn_Dw   :in  Angle_Types.degrees;
                        An_Instance    :in out Instance);

private
   type Instance is
      record
         The_Area                         : Length_Types.Sq_Feet := 36.56;
         The_Chord                        : Length_Types.Feet := 3.36;
         The_x_Moment_Arm                 : Length_Types.Feet;
         The_y_Moment_Arm                 : Length_Types.Feet;
         The_z_Moment_Arm                 : Length_Types.Feet;
         The_Dynamic_Downwash_Angle       : Angle_Types.Degrees := 0.0;
         The_Static_Downwash_Angle        : Angle_Types.Degrees := 0.0;
         The_old_Unlagged_Q_component     : Float := 0.0;
         The_Unlagged_q_component         : Float := 0.0;
         The_lagged_Q_component           : Float := 0.0;
         The_Dynamic_Pressure_Ratio       : Float := 0.0;
         AOA                              : Angle_Types.Degrees := 0.0;
         The_Q                            : Force_Types.Pounds_per_Sq_Feet := 0.0;
         The_Cl                           : Float := 0.0;
         The_Cd                           : Float := 0.0;
         The_Cm                           : Float := 0.0;
         The_Force                        : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         The_Moment                       : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
      end record;
end Horizontal_Tail;
