-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section describes the elevator's aerodynamic hinge moment, aerodynamic
--| and system neutral positions.

with Angle_Types;
with Force_Types;
with Length_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Mass_Types;
with Torque_Types;


package Elevator is

   type Instance is private;
   package It renames Interpolation_Table;

   procedure Assign_Position (Elev_Pos     :in     Angle_Types.Degrees;
                              An_Instance  :in out Instance);

   procedure Calc_HM
     (Ht_q                    :in     Force_Types.Pounds_per_Sq_Feet;
      E_tab_pos               :in     Angle_Types.Degrees;
      Side_Slip_Angle         :in     Angle_Types.Degrees;
      Ht_Local_AOA            :in     Angle_Types.Degrees;
      Flap_Position           :in     Angle_Types.Degrees;
      Ship_Num                :in     Integer;
      FCHETAB_t               :in out IT.Doubly_Indexed.Instance;
      KCHETAB_t               :in out IT.Singly_Indexed.Instance;
      DCHEB_t                 :in out It.doubly_Indexed.Instance;
      CHE_t                   :in out IT.Doubly_Indexed.Instance;
      DCHEDE_t                :in out IT.Doubly_Indexed.Instance;
      Test_Flag               :in     Boolean;
      An_Instance             :in out Instance);

--   function Get_HM (An_Instance :in Instance) return Torque_Types.Ft_Lbf;
--   function Get_Spring_HM (An_Instance :in Instance) return Torque_Types.Ft_Lbf;
--   function Get_Aerodynamic_Gradient (An_Instance :in Instance) return Float;
   function Get_Aero_HM_pD (An_Instance :in Instance) return Float;
   procedure Calc_Neutral_Position(An_Instance :in out Instance);
   function Get_Aerodynamic_Neutral_Position (An_Instance :in Instance)
                  return Angle_Types.Degrees;
--   function Get_System_Neutral_Position (An_Instance :in Instance)
--                  return Angle_Types.Degrees;
--   procedure Calc_Damping
--     (dens           :in     Mass_Types.Slugs_per_Cubic_Feet;
--      Q_ht           :in     Float;
--      Tas            :in     Length_Types.Feet_per_Sec;
--      An_Instance    :in out Instance);

--   function Get_Damping (An_Instance :in Instance) return Float;

private

   type Instance is
      record
         The_Aerodynamic_Gradient             : Float := 0.0;
         The_Aerodynamic_HM_per_Degree        : Float := 0.0;
         The_Aerodynamic_Neutral_Position     : Angle_Types.Degrees := 0.0;
         The_Area                             : Length_Types.Sq_Feet := 11.280;
         The_Chord                            : Length_Types.Feet :=  1.038;
--         The_Damping                          : Float := 0.0;
         The_HM                               : Torque_Types.Ft_Lbf := 0.0;
         The_Position                         : Angle_Types.Degrees := 0.0;
         The_Spring_Constant                  : Float := 0.086;
         The_Spring_HM                        : Torque_Types.Ft_Lbf := 0.0;
--         The_System_Neutral_Position          : Angle_Types.Degrees := 0.0;
      end record;
end Elevator;

