-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


package body Elevator is

   procedure Assign_Position (Elev_Pos        :in     Angle_Types.Degrees;
                              An_Instance     :in out Instance) is
   begin
        An_Instance.The_Position   := Elev_Pos;
   end Assign_Position;

   procedure Calc_HM
     (Ht_q                  :in     Force_Types.Pounds_per_Sq_Feet;
      E_tab_pos             :in     Angle_Types.Degrees;
      Side_Slip_Angle       :in     Angle_Types.Degrees;
      Ht_Local_AOA          :in     Angle_Types.Degrees;
      Flap_Position         :in     Angle_Types.Degrees;
      Ship_Num              :in     Integer;
      FCHETAB_t             :in out It.Doubly_Indexed.Instance;
      KCHETAB_t             :in out It.Singly_Indexed.Instance;
      DCHEB_t               :in out It.doubly_Indexed.Instance;
      CHE_t                 :in out It.Doubly_Indexed.Instance;
      DCHEDE_t              :in out It.Doubly_Indexed.Instance;
      Test_Flag             :in     Boolean;
      An_Instance           :in out Instance) is

      FCHE_Tab   : Float;
      KCHE_tab   : Float;
      DCHE_beta  : Float;
      CHE_de_Tab : Float;
      che_de     : Float;
      CHE        : Float;
      Dche0      : Float;
      Dit        : Float;
   begin
      if Ship_Num < 4  then
         Dche0 := 0.0012;
         Dit   := -0.9;
      elsif Ship_Num > 5 then
         Dche0 := 0.0;
         Dit := -0.9;
      else
         Dche0 := 0.0;
         Dit := 0.0;
      end if;
      FCHE_Tab := It.Doubly_Indexed.Interpolate
                      (E_tab_pos,Flap_Position,FCHETAB_t'access);
      KCHE_tab  := It.Singly_Indexed.Interpolate
                      (An_Instance.The_Position,KCHEtab_t'access);
      DCHE_beta  := It.doubly_Indexed.Interpolate
                       (Side_Slip_Angle,Flap_Position,DCHEB_t'access);
      CHE_de_Tab  := KCHE_tab * FCHE_Tab;
      che_de:= It.Doubly_Indexed.Interpolate
                  (Ht_Local_Aoa+ dit,An_Instance.The_Position,CHE_t'access);
      CHE := che_de+ DCHE_Beta + CHE_de_Tab + dche0;
      An_Instance.The_HM :=  Ht_Q * An_Instance.The_Area *
           An_Instance.The_Chord * CHE;
      An_Instance.The_Spring_HM := 9.20 -
             An_Instance.The_Spring_Constant * An_Instance.The_Position;
      An_Instance.The_Aerodynamic_Gradient := It.Doubly_Indexed.Interpolate
        (Ht_Local_AOA,An_Instance.The_Position,DCHEDE_t'access);
      An_Instance.The_Aerodynamic_HM_per_Degree :=  Ht_Q * An_Instance.The_Area
        * An_Instance.The_Chord * An_Instance.The_Aerodynamic_Gradient;
      if Test_Flag then
       Put(   " ELEVATOR HINGE MOMENT"); New_Line;
       Put("HMe        = "); Put( An_Instance.The_HM   ); New_Line;
       Put("CHe        = "); Put( che); New_Line;
       Put("CHe_de     = "); Put(Che_de); New_Line;
       Put("Che_de_tab = "); Put(Che_De_tab); New_Line;
       Put("KCHetab    = "); Put( Kche_tab); New_Line;
       Put("dCHe beta  = "); Put(DCHE_beta ); New_Line;
       Put("fchetab    = "); Put( Fche_tab); New_Line;
       Put("delta_che0 = "); Put( dche0); New_Line;
       Put(" delta it  = "); Put(Dit); New_Line;
       Put(" dHM/de    = "); Put(An_Instance.The_Aerodynamic_gradient); New_Line;
       Put(" dHM/deaer = "); Put(An_Instance.The_Aerodynamic_Hm_Per_degree); New_Line;
--       Put(" damping   = "); Put(An_Instance.The_Damping); New_Line;
       New_Line;
    end if;
   end Calc_HM;

--   function Get_HM (An_Instance :in Instance) return Torque_Types.Ft_Lbf is
--   begin
--      return An_Instance.The_HM;
--   end Get_HM;

--   function Get_Spring_HM (An_Instance :in Instance)
--        return Torque_Types.Ft_Lbf is
--   begin
--        return An_Instance.The_Spring_HM;
--   end Get_Spring_HM;

--   function Get_Aerodynamic_Gradient (An_Instance :in Instance) return Float is
--   begin
--      return An_Instance.The_Aerodynamic_Gradient;
--   end Get_Aerodynamic_Gradient;

   function Get_Aero_HM_pD (An_Instance :in Instance)
       return Float is
   begin
      return An_Instance.The_Aerodynamic_HM_per_Degree;
   end Get_Aero_HM_pD;

   procedure Calc_Neutral_Position(An_Instance :in out Instance) is
   begin
      An_Instance.The_Aerodynamic_Neutral_Position :=  An_Instance.The_Position
        - An_Instance.The_HM / An_Instance.The_Aerodynamic_HM_per_Degree;

--      An_Instance.The_System_Neutral_Position      :=  An_Instance.The_Position
--        -    (An_Instance.The_HM + An_Instance.The_Spring_HM)
--        / (An_Instance.The_Aerodynamic_HM_per_Degree - An_Instance.The_Spring_Constant);

   end Calc_Neutral_Position;

   function Get_Aerodynamic_Neutral_Position (An_Instance :in Instance)
       return Angle_Types.Degrees is
   begin
      return An_Instance.The_Aerodynamic_Neutral_Position;
   end Get_Aerodynamic_Neutral_Position;

--   function Get_System_Neutral_Position (An_Instance :in Instance)
--        return Angle_Types.Degrees is
--   begin
--        return An_Instance.The_System_Neutral_Position;
--   end Get_System_Neutral_Position;

--   procedure Calc_Damping
--     (dens            :in     Mass_Types.Slugs_per_Cubic_Feet;
--      Q_ht            :in     Float;
--      Tas             :in     Length_Types.Feet_per_Sec;
--      An_Instance     :in out Instance) is
--   begin
--      An_Instance.The_Damping := -0.008_75 * dens * Tas
--           * Sqrt(Q_ht) * An_Instance.The_Area
--           * An_Instance.The_Chord **2;
--   end Calc_Damping;

--   function Get_Damping (An_Instance :in Instance) return Float is
--   begin
--      return An_Instance.The_Damping;
--   end Get_Damping;
end Elevator;










