-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;

package Aircraft_Body is

   type Instance is private;

   procedure Assign_Force (Body_Force  :in     Coordinate_Types.Cartesian;
                           An_Instance :in out Instance);

    function Get_Force (An_Instance :in Instance) return Coordinate_Types.Cartesian;

    procedure Store_gear_Force (gear_Force  :in     Coordinate_Types.Cartesian;
                                An_Instance :in out Instance);

    procedure Store_aero_Force (Aero_Force  :in     Coordinate_Types.Cartesian;
                                An_Instance :in out Instance);

    function aero_Force (An_Instance :in Instance) return Coordinate_Types.Cartesian;
    function gear_Force (An_Instance :in Instance) return Coordinate_Types.Cartesian;

    procedure Assign_Moment (Body_Moment :in     Coordinate_Types.Cartesian;
                             An_Instance :in out Instance);

    function Get_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian;

    procedure Store_gear_Moment (gear_Moment :in     Coordinate_Types.Cartesian;
                                 An_Instance :in out Instance);

    procedure Store_aero_Moment (Aero_Moment :in     Coordinate_Types.Cartesian;
                                 An_Instance :in out Instance);

    function aero_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian;
    function gear_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Assign_WOW (WOW         :in     Boolean;
                         An_Instance :in out Instance);

   function Get_WOW (An_Instance :in Instance) return Boolean;

   procedure Assign_Runway_Crack_Bump
     (Runway_Crack_Bump :in    Float;
      An_Instance       :in out Instance);

   function Get_Runway_Crack_Bump(An_Instance :in Instance) return Float;

   procedure Assign_Cycle_Bump_Amplitude
     (Cycle_Bump  :in    Float;
      An_Instance :in out Instance);

   function Get_Cycle_Bump_Amplitude(An_Instance :in Instance) return Float;

   procedure Assign_Runway_Rumble (Runway_Rumble :in    Float;
                                   An_Instance   :in out Instance);

   function Get_Runway_Rumble(An_Instance :in Instance) return Float;

   procedure Assign_Landing_Gear_Buffet(Landing_Gear_Buffet :in    Float;
                                        An_Instance         :in out Instance);

   function Get_Landing_Gear_Buffet(An_Instance :in Instance) return float;

   --| Zero Velocity Breakout Flag

   procedure Assign_Stand_Still (Stand_Still :in     Boolean;
                                 An_Instance :in out Instance);

   function Get_Stand_Still (An_Instance :in Instance) return Boolean;

private
   type Instance is
      record
         The_Force                    : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Gear_Force               : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Aero_Force               : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Moment                   : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Gear_Moment              : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Aero_Moment              : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Runway_Crack_Bump        : Float:=0.0;
         The_Cycle_Bump               : Float:=0.0;
         The_Runway_Rumble            : Float:=0.0;
         The_Landing_Gear_Buffet      : Float:=0.0;
         The_Wow                      : Boolean:= true;
         The_Aircraft_On_Jacks        : Boolean:= false;
         The_Stand_Still              : Boolean:= true;
      end record;

end Aircraft_Body;

