-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
package body Aircraft_Body is

   procedure Assign_Force (Body_Force   :in     Coordinate_Types.Cartesian;
                           An_Instance  :in out Instance) is
   begin
      An_Instance.The_Force := Body_Force;
   end Assign_Force;

   procedure Store_gear_Force (gear_Force :in     Coordinate_Types.Cartesian;
                           An_Instance                          :in out Instance) is
   begin
      An_Instance.The_Gear_Force := gear_Force;
   end Store_gear_Force;

    procedure Store_aero_Force (Aero_Force  :in     Coordinate_Types.Cartesian;
                                An_Instance :in out Instance) is
   begin
      An_Instance.The_Aero_Force := aero_Force;
   end Store_aero_Force;

   function Get_Force (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Force;
   end Get_Force;

   function aero_Force (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Aero_Force;
   end aero_Force;

    function gear_Force (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_gear_Force;
   end gear_Force;

   procedure Assign_Moment (Body_Moment :in     Coordinate_Types.Cartesian;
                            An_Instance :in out Instance) is
   begin
      An_Instance.The_Moment := Body_Moment;
   end Assign_Moment;


   procedure Store_gear_Moment (gear_Moment :in     Coordinate_Types.Cartesian;
                           An_Instance                          :in out Instance) is
   begin
      An_Instance.The_Gear_Moment := gear_Moment;
   end Store_gear_Moment;

    procedure Store_aero_Moment (Aero_Moment :in     Coordinate_Types.Cartesian;
                           An_Instance                          :in out Instance) is
   begin
      An_Instance.The_Aero_Moment := aero_Moment;
   end Store_aero_Moment;


   function Get_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Moment;
   end Get_Moment;

   function aero_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Aero_Moment;
   end aero_Moment;

   function gear_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian is
   begin
      return An_Instance.The_Gear_Moment;
   end Gear_Moment;

   procedure Assign_WOW (WOW :in     Boolean;
                                      An_Instance                   :in out Instance) is
   begin
      An_Instance.The_WOW := WOW;
   end Assign_WOW;

   function Get_WOW (An_Instance :in Instance) return Boolean is
   begin
      return An_Instance.The_WOW;
   end Get_WOW;

   --| Runway Crack Bump for the aircraft as a whole is set here.  The value of Runway
   --| Crack Bump even if calculated seperately by the several instances of Tire_Buffets
   --| (left tire buffet/right tire buffet and the nose tire buffet) will be same and
   --| one of these values will be used to make an asignment or runway crack bump for
   --| the entire aircraft.
   procedure Assign_Runway_Crack_Bump
     (Runway_Crack_Bump :in    Float;
      An_Instance       :in out Instance) is
   begin
      An_Instance.The_Runway_Crack_Bump := Runway_Crack_Bump;
   end Assign_Runway_Crack_Bump;

   function Get_Runway_Crack_Bump(An_Instance :in Instance) return Float is
   begin
      return An_Instance.The_Runway_Crack_Bump;
   end Get_Runway_Crack_Bump;

   procedure Assign_Cycle_Bump_Amplitude
     (Cycle_Bump  :in    Float;
      An_Instance :in out Instance) is
   begin
      An_Instance.The_Cycle_Bump := Cycle_Bump;
   end Assign_Cycle_Bump_Amplitude;

   function Get_Cycle_Bump_Amplitude(An_Instance :in Instance) return Float is
   begin
      return An_Instance.The_Cycle_Bump;
   end Get_Cycle_Bump_Amplitude;

   --| Runway Rumble for the aircraft as a whole is set here.  The value of Runway
   --| Rumble even if calculated seperately by the several instances of Tire_Buffets
   --| (left tire buffet/right tire buffet and the nose tire buffet) will be same
   --| and one of these values will be used to make an asignment or runway rumble
   --| for the entire aircraft.
   procedure Assign_Runway_Rumble (Runway_Rumble :in    Float;
                                   An_Instance                :in out Instance) is
   begin
      An_Instance.The_Runway_Rumble := Runway_Rumble;
   end Assign_Runway_Rumble;

   function Get_Runway_Rumble(An_Instance :in Instance) return Float is
   begin
      return An_Instance.The_Runway_Rumble;
   end Get_Runway_Rumble;

   --| The Sum of the Buffet due to left/right/nose tires/wheels is assigned here.
   procedure Assign_Landing_Gear_Buffet(Landing_Gear_Buffet :in    Float;
                                        An_Instance                      :in out Instance) is
   begin
      An_Instance.The_Landing_Gear_Buffet := Landing_Gear_Buffet;
   end Assign_Landing_Gear_Buffet;

   function Get_Landing_Gear_Buffet(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_Landing_Gear_Buffet;
   end Get_Landing_Gear_Buffet;

   --| Zero Velocity Breakout Flag

   procedure Assign_Stand_Still (Stand_Still :in     Boolean;
                                 An_Instance              :in out Instance) is
   begin
      An_Instance.The_Stand_Still := Stand_Still;
   end Assign_Stand_Still;

   function Get_Stand_Still (An_Instance :in Instance) return Boolean is
   begin
      return An_Instance.The_Stand_Still;
   end Get_Stand_Still;

end Aircraft_Body;

