-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section models the aerodynamic forces and moments due
--| to deflection of each aileron.  These are assembled in
--| coefficient form from functions of deflection angle, local
--| angle of attack and flap setting.  The coefficients are
--| dimensionalized using dynamic pressures based on the local
--| velocities at each aileron.  The use of local flow
--| conditions, adjusted to account for aircraft roll and yaw
--| rates, serves to extend the valid range of the model from
--| the purely static case to dynamic flight conditions
--| involving high rates of roll or yaw (including spins).

--| The aerodynamic hinge moments generated by each aileron are
--| also calculated in this section.  Like the aileron force
--| and moment contributions, these hinge moments are based on
--| the local flow conditions.
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;

with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;


package Aileron is

   type Instance is private;
   package It renames Interpolation_Table;

   procedure Assign_Position (Aileron_Position :in     Angle_Types.Degrees;
                              An_Instance         :in out Instance);

   procedure Calc_Attributes(Aileron_BL     :in     Length_Types.Feet;
                             Air_Density    :in     Mass_Types.Slugs_per_Cubic_Feet;
                             x_V_B          :in     Length_Types.Feet_per_Sec;
                             z_V_B          :in     Length_Types.Feet_per_Sec;
                             Roll_Rate      :in     Angle_Types.Radians_per_Sec;
                             Yaw_Rate       :in     Angle_Types.Radians_per_Sec;
                             Test_Flag      :in     Boolean;
                             An_Instance    :in out Instance);

   procedure Calc_Coefficient
        (Mach            :in     Length_Types.Mach;
         Flap_Position   :in     Angle_Types.Degrees;
         Sign            :in     Float;
         FCLAA_T         :in out IT.Doubly_Indexed.Instance;
         FCDAA_T         :in out IT.Doubly_Indexed.Instance;
         CD0A_T          :in out IT.Doubly_Indexed.Instance;
         FCMAA_T         :in out IT.Doubly_Indexed.Instance;
         FCYAA_T         :in out IT.Doubly_Indexed.Instance;
         FCNAA_T         :in out IT.Doubly_Indexed.Instance;
         CN0A_T          :in out IT.Doubly_Indexed.Instance;
         KCLAA_T         :in out IT.Singly_Indexed.Instance;
         KCMAA_T         :in out IT.Singly_Indexed.Instance;
         KCRAA_T         :in out IT.Singly_Indexed.Instance;
         FCRAA_T         :in out IT.Multiply_Indexed.Instance;
         Test_Flag    :in     Boolean;
         An_Instance     :in out Instance);

   function Get_Roll_Moment_Coefficient_wrt_Position(An_Instance :in Instance) return Float;

   procedure Calc_Force(Wing_Area   :in     Length_Types.Sq_Feet;
                        Test_Flag   :in     Boolean;
                       An_Instance  :in out Instance);

   function Get_Force(An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Calc_Moment(Wing_Area   :in     Length_Types.Sq_Feet;
                        Wing_Span    :in     Length_Types.Feet;
                        Wing_Chord   :in     Length_Types.Feet;
                        WB_Mom_arm   :in     Coordinate_Types.Cartesian;
                        Test_Flag    :in     Boolean;
                        An_Instance  :in out Instance);

   function Get_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Calc_Hinge_Moment
     (Sign         :in     Float;
      Beta         :in     angle_Types.Degrees;
      Flaps        :in     angle_Types.Degrees;
      CHA_T        :in out IT.Doubly_Indexed.Instance;
      DCHADA_T     :in out IT.Doubly_Indexed.Instance;
      DCHAB_T      :in out IT.Doubly_Indexed.Instance;
      Test_Flag    :in     Boolean;
      An_Instance  :in out Instance);


   function Get_Hinge_Moment (An_Instance :in Instance) return Torque_Types.Ft_Lbf;
   function Get_Aerodynamic_Gradient (An_Instance :in Instance) return Float;
   function Get_Aerodynamic_Hinge_Moment_per_Degree (An_Instance :in Instance) return Float;


private
   type Instance is
      record
         AOA                             : Angle_Types.Degrees  := 0.0;
         The_Drag                        : Float := 0.0;
         The_Q                           : Force_Types.Pounds_per_Sq_Feet := 0.0;
         The_Lift                        : Float := 0.0;
         The_Pitch_Moment                : Float := 0.0;
         The_Roll_Moment                 : Float := 0.0;
         cr_pos                          : Float := 0.0;
         The_Sideforce                   : Float := 0.0;
         The_Yaw_Moment                  : Float := 0.0;
         The_Force                       : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         The_HM                          : Torque_Types.Ft_Lbf := 1.0;
         The_Moment                      : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
         The_Position                    : Angle_Types.Degrees := 0.0;
         The_Aerodynamic_Neutral_Position: Angle_Types.Degrees := 0.0;
         The_Aerodynamic_Gradient        : Float := 0.0;
         The_Aerodynamic_HM_per_Degree   : Float := 0.0;
      end record;

end Aileron;

