/*==========================================================================
**
**	if_zxeRlk.h - ZNYX RAIN Link layer support
**
**==========================================================================
**
**	(c) Copyright 1998 ZNYX Corporation
**	All Rights Reserved.
**
**==========================================================================
**
**	Modification History:
**
**==========================================================================
**
**	Notes:
**==========================================================================
*/


#define	MAX_PORTS	16

typedef struct zxe_rlk_ppa_list {
	int	rlk_type;
	int	rlk_mode;
	int	rlk_timeout;
	int	rlk_ppa_list[MAX_PORTS+1];
} zxe_rlk_ppa_list_t;


/* types */

#define	RLK_TRUNK		1
#define	RLK_FAILOVER		2


/* modes */

/*
 * Layer 2 Mode creates a Fast EtherChannel and causes
 * the MAC address to be used in the port selection process.
 */
#define	LAYER_2_MODE		0x1

/*
 * Layer 2 Mode creates a Fast EtherChannel and causes
 * the IP address to be used in the port selection process.
 */
#define	LAYER_3_MODE		0x2

/*
 * In IP trunking mode, the ports are used for system to system
 * trunking. The resulting zrl device will allow a single connection
 * between two systems to utilize all ports. When doing system to
 * system trunking, both sides must be setup identically.
 */
#define	IP_TRUNKING_MODE	0x10


/* mode modifiers */

/*
 * In Balance Mode the Fast EtherChannel load is dynamically
 * distributed across all ports attempting to balance the load
 * equally. Balance Mode is on by default.
 */
#define	NO_BALANCE_MODE		0x20

/*
 * In timeout mode if traffic is not received within the timeout period,
 * the active port is automatically switched to another up port in the
 * Failover group. Typically, the port is only switched if the Ethernet
 * link fails. The timeout period is in seconds.
 */
#define	TIMEOUT_MODE		0x4


#define HUB_MODE		0x100

#define SNAP_BCAST_MODE		0x200

extern zxe_rlk_ppa_list_t *zxe_rlk_config_tbl[];

extern zxe_rlk_ppa_list_t *zxe_get_rlk_ppa_list(int index);


