/*==========================================================================
**
**	if_zxeRlk.c - ZNYX RAIN Link layer support
**
**==========================================================================
**
**	(c) Copyright 1998 ZNYX Corporation
**	All Rights Reserved.
**
**==========================================================================
**
**	Modification History:
**
**==========================================================================
**
**	Notes:
**==========================================================================
*/


#include "if_zxeRlk.h"



/*
 * 4-Port System to System Trunking
 */
zxe_rlk_ppa_list_t zxe_rlss4[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, 2, 3, -1 } },
	{ 0, }
};


/*
 * 4-Port Fast Etherchannel - Layer 3 Mode
 */
zxe_rlk_ppa_list_t zxe_rlfe4[] = {
	{ RLK_TRUNK, LAYER_3_MODE, 0, { 0, 1, 2, 3, -1 } },
	{ 0, }
};


/*
 * 4-Port Fast Failover
 */
zxe_rlk_ppa_list_t zxe_rlff4[] = {
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 0, 1, 2, 3, -1 } },
	{ 0, }
};


/*
 * 4-Port Fast Failover - with hub mode 
 */
zxe_rlk_ppa_list_t zxe_rlff4h[] = {
	{ RLK_FAILOVER, TIMEOUT_MODE | HUB_MODE, 20000, { 0, 1, 2, 3, -1 } },
	{ 0, }
};


/*
 * 4-Port Fast Failover - with hub mode 
 */
zxe_rlk_ppa_list_t zxe_rlff4hs[] = {
	{ RLK_FAILOVER, HUB_MODE | SNAP_BCAST_MODE, 20000, { 0, 1, 2, 3, -1 } },
	{ 0, }
};

/*
 * 2-Port System to System Trunking
 */
zxe_rlk_ppa_list_t zxe_rlss2[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, -1 } },
	{ 0, }
};


/*
 * 2-Port Fast Etherchannel - Layer 3 Mode
 */
zxe_rlk_ppa_list_t zxe_rlfe2[] = {
	{ RLK_TRUNK, LAYER_3_MODE, 0, { 0, 1, -1 } },
	{ 0, }
};


/*
 * 2-Port Fast Failover - Timeout Mode, 20 second timeout
 */
zxe_rlk_ppa_list_t zxe_rlff2[] = {
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 0, 1, -1 } },
	{ 0, }
};




#define PA_TEST
#ifdef PA_TEST
/*
 * 2-Port Failover of 2 2-Port Trunks - Timeout Mode, 20 second timeout
 */
zxe_rlk_ppa_list_t zxe_rlff2ss2[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, -1 } },
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 2, 3, -1 } },
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 0, 2, -1 } },
	{ 0, }
};

/*
 * 3-Port Fast Etherchannel - Layer 2 Mode
 */
zxe_rlk_ppa_list_t zxe_rlfe3[] = {
	{ RLK_TRUNK, LAYER_2_MODE, 0, { 0, 1, 2, -1 } },
	{ 0, }
};

/*
 * 4-Port Fast Etherchannel - Layer 2 Mode (out of order)
 *
 * (DO NOT USE)
 */
zxe_rlk_ppa_list_t zxe_rlfe4x[] = {
	{ RLK_TRUNK, LAYER_2_MODE, 0, { 1, 3, 0, 2, -1 } },
	{ 0, }
};

/*
 * 2 2-Port Fast Etherchannel - Layer 3 Mode
 */
zxe_rlk_ppa_list_t zxe_rlss2a[] = {
	{ RLK_TRUNK, LAYER_3_MODE, 0, { 0, 1, -1 } },
	{ 0, }
};

zxe_rlk_ppa_list_t zxe_rlss2b[] = {
	{ RLK_TRUNK, LAYER_3_MODE, 0, { 2, 3, -1 } },
	{ 0, }
};

/*
 * 3-Port Failover - Timeout Mode, 20 second timeout
 */
zxe_rlk_ppa_list_t zxe_rlff3[] = {
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 0, 1, 2, -1 } },
	{ 0, }
};

/*
 * 2 2-Port Failover - Timeout Mode, 20000 second timeout
 */
zxe_rlk_ppa_list_t zxe_rlff2a[] = {
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 0, 1, -1 } },
	{ 0, }
};

zxe_rlk_ppa_list_t zxe_rlff2b[] = {
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 2, 3, -1 } },
	{ 0, }
};

/*
 * 3-Port Failover of 1 2-Port Trunk 2 znb(s) - Timeout Mode, 20 second timeout
 */
zxe_rlk_ppa_list_t zxe_rlff3ss2[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, -1 } },
	{ RLK_FAILOVER, TIMEOUT_MODE, 20000, { 0, 2, 3, -1 } },
	{ 0, }
};

/*
 * 8-Port System to System Trunking
 */
zxe_rlk_ppa_list_t zxe_rlss8[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, 2, 3, 4, 5, 6, 7, -1 } },
	{ 0, }
};

zxe_rlk_ppa_list_t zxe_rlff2ss2qf[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, -1 } },
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 2, 3, -1 } },
	{ RLK_FAILOVER, TIMEOUT_MODE, 500, { 0, 2, -1 } },
	{ 0, }
};
zxe_rlk_ppa_list_t zxe_rlff2ss2nt[] = {
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 0, 1, -1 } },
	{ RLK_TRUNK, IP_TRUNKING_MODE, 0, { 2, 3, -1 } },
	{ RLK_FAILOVER, 0, 0, { 0, 2, -1 } },
	{ 0, }
};

#endif



/*
**
******************* RAIN Management Configuration Table ********************
**
*/


zxe_rlk_ppa_list_t *zxe_rlk_config_tbl[] = {
	zxe_rlss4,		/* 0 */
	zxe_rlfe4,		/* 1 */
	zxe_rlff4,		/* 2 */
	zxe_rlss2,		/* 3 */
	zxe_rlfe2,		/* 4 */
	zxe_rlff2,		/* 5 */
#ifdef PA_TEST
	zxe_rlff2ss2,		/* 6 */
	zxe_rlfe3,		/* 7 */
	zxe_rlfe4x,		/* 8 */
	zxe_rlss2a,		/* 9 */
	zxe_rlss2b,		/* 10 */
	zxe_rlff3,		/* 11 */
	zxe_rlff2a,		/* 12 */
	zxe_rlff2b,		/* 13 */
	zxe_rlff3ss2,		/* 14 */
	zxe_rlff4h,		/* 15 */
	zxe_rlff4hs,		/* 16 */
	zxe_rlss8,		/* 17 */
	zxe_rlff2ss2qf,		/* 18 */
	zxe_rlff2ss2nt,		/* 19 */
#endif
	0
};



zxe_rlk_ppa_list_t *
zxe_get_rlk_ppa_list(int index)
{
	int i;

	for (i=0; zxe_rlk_config_tbl[i] != 0; i++)
		;

	if (i <= index)
		return(0);

	return(zxe_rlk_config_tbl[index]);
}


