/*==========================================================================
**
**	if_zxePci.h - ZNYX Intel PCI interface support
**
**==========================================================================
**
**	(c) Copyright 1998 ZNYX Corporation
**	All Rights Reserved.
**
**==========================================================================
**
**	Modification History:
**
**==========================================================================
**
**	Notes:
**==========================================================================
*/

#include <vxWorks.h>

#define	ZXE_VECTOR_GET	20
#define	ZXE_MEMBASE_GET	21
#define	ZXE_MEMBASE_SET	22
#define	ZXE_IOBASE_GET	23
#define	ZXE_IOBASE_SET	24
#define	ZXE_ILEVEL_GET	25
#define	ZXE_ILEVEL_SET	26
#define	ZXE_NPPA_GET	27
#define ZXE_CFCS_SET	28
#define	ZXE_BUS_GET	29
#define	ZXE_SLOT_GET	30


int zxePciIoctl(int ppa, int cmd, UINT32 param);
UINT32 zxePciGetLong(int ppa, UINT32 offset);
void zxePciSetByte(int ppa, UINT32 offset, UINT8 value);
void zxePciSetWord(int ppa, UINT32 offset, UINT16 value);
void zxePciSetLong(int ppa, UINT32 offset, UINT32 value);

void zxeIntEnable(int intLevel);
void zxeIntDisable(int intLevel);
int zxeIntConnect(void *vector, void *routine, int param);
int zxeIntDisconnect(void *vector, void *routine);

void *zxeVToBus(void *v);

