/*==========================================================================
**
**	configZxe.c
**
**==========================================================================
**
**	(c) Copyright 1998 ZNYX Corporation
**	All Rights Reserved.
**
**==========================================================================
**
**	Modification History:
**
**==========================================================================
**
**	Notes:
**==========================================================================
*/

#include "vxWorks.h"
#include "end.h"

#include "muxLib.h"
#include "ifLib.h"
#include "netinet/if_ether.h"

#include "stdio.h"


IMPORT int ipDetach();
IMPORT int ipAttach();


#ifndef MAX_PORTS
#ifdef IP_MAX_UNITS
#define MAX_PORTS IP_MAX_UNITS
#else
#define MAX_PORTS 64 
#endif
#endif
static void* zxeCookieT[MAX_PORTS];

static M2_INTERFACETBL zxeM2Tbl[MAX_PORTS];


/* ZNYX END Load functions */

extern END_OBJ* znbEndLoad(char*, void*);
extern END_OBJ* zrlEndLoad(char*, void*);

/* ZNYX RAIN Management functions */
                                    
extern int zxePciInit2();



/*
 * zxeUp - initialize the driver and the device
 *
 * This routine initializes the driver and the device to the operational state.
 *
 *
 * <devString> parameter specifies the device to initialize, e.g. "znb0", "zrl1"
 *
 * <paddr> parameter specifies the IP address of the device, e.g. "1.2.3.4"
 *
 * <iMask> parameter specifies the IP netmask, e.g. 0xff000000
 *
 * <mediaType> parameter defines the media type of the device, def. 0
 *
 * <index> parameter specifies the configuration index to use, e.g. 0
 *
 */

#define	ZXE_RECVBUFS	32		/* default */
#define	ZXE_XMITBUFS	32		/* default */
#define	ZXE_STATICBUFS	32		/* default */

/* For Intel x86 */
#define	ZXE_MEMBASE	0x00000000
#define	ZXE_FLAGS	0x0000		/* Default */

#ifdef	MCP750
#undef	ZXE_MEMBASE
#undef	ZXE_FLAGS
#define ZXE_MEMBASE	0x80000000
#define ZXE_FLAGS	0x0800		/* Use IO base */
#endif

static int zxeInitCount=0;

int
zxeUp(char *devString, char *pAddr, ULONG iMask, int mediaType, int index)
{
	END_OBJ* pEnd;
	char devStr[8];
	char initStr[64];
	int unit;
	void *cookie;

	if (zxeInitCount == 0) { 
		zxePciInit2();

		for (unit = 0; unit < MAX_PORTS; unit++) {
			zxeCookieT[unit] = NULL;
		}
	}

	zxeInitCount++;

	sscanf(devString, "%3c%d", devStr, &unit);
	devStr[3] = (char)0;

	if ((unit < 0) || (unit >= MAX_PORTS)) {
		printf("unit error for %s\n", devString);
		return(ERROR);
	}

	sprintf(initStr, "%d:0x%x:%d:%d:%d:%d:0x%x", index, ZXE_MEMBASE, mediaType, ZXE_RECVBUFS, ZXE_XMITBUFS, ZXE_STATICBUFS, ZXE_FLAGS);

	if (strcmp(devStr, "znb") == 0)
		cookie = muxDevLoad(unit, znbEndLoad, initStr, TRUE, NULL);

	if (strcmp(devStr, "zrl") == 0)
		cookie = muxDevLoad(unit, zrlEndLoad, initStr, TRUE, NULL);

	if (cookie == NULL) {
		printf("muxLoad failed for %s%d\n", devStr, unit);
		return(ERROR);
	}

	zxeCookieT[unit] = cookie;

	muxAddrResFuncAdd(M2_ifType_ethernet_csmacd, 0x800, arpresolve);

	if (ipAttach(unit, devStr) != OK) {
		printf("Failed to attach TCP/IP to %s\n", devString);
		return(ERROR);
	}
	printf("Attached TCP/IP interface to %s\n", devString);

	if (iMask)
		ifMaskSet(devString, iMask);
	ifAddrSet(devString, pAddr);

	if (muxDevStart(zxeCookieT[unit]) != OK) {
		printf("Failed to start device %s\n", devString);
		return(ERROR);
	}

	return(OK);
}


int
zxeDown(char *devString)
{
	char devStr[8];
	int unit;

	sscanf(devString, "%3c%d", devStr, &unit);
	devStr[3] = (char)0;

	if ((unit < 0) || (unit >= MAX_PORTS)) {
		printf("parameter error for %s\n", devString);
		return(ERROR);
	}

	if (muxDevStop(zxeCookieT[unit]) != OK) {
		printf("Failed to stop device %s\n", devString);
		return(ERROR);
	}

	if (ipDetach(unit, devStr) != OK) {
		printf("Failed to detach TCP/IP from %s\n", devString);
		return(ERROR);
	}
	printf("Detached TCP/IP interface from %s\n", devString);

	if (muxDevUnload(devStr, unit) != OK) {
		printf("Failed to unload device %s\n", devString);
		return(ERROR);
	}

	return(OK);
}



