/* configNet.h - Network configuration header file */

/* Copyright 1984-1999 Wind River Systems, Inc. */

/*
modification history
--------------------
01g,31mar99,dat  SPR 25958, added #ifndef IP_MAX_UNITS
01f,12mar99,cn   added support for SMC el3c90xEnd driver (SPR# 25327).
01e,08mar99,sbs  added support for SMC Elite Ultra card.(SPR #25234)
                 changed elt3c509 end support to use sysElt3c509End routine
                 added support for ne2000End driver (SPR #25398)
01d,01feb99,jkf  added support for AMD 7997x PCI card.
01c,26nov98,ms_  add support for end enabled elt3c509
01b,12nov98,dat  added INCLUDE_FEI_END around fei unit 0 entry
01a,31mar98,cn   written.
*/

#ifndef INCconfigNeth
#define INCconfigNeth

#include "vxWorks.h"
#include "end.h"
#include "configZxe.h"

#ifdef INCLUDE_FEI_END

#define FEI82557_LOAD_FUNC   fei82557EndLoad     /* driver external interface */
#define FEI82557_BUFF_LOAN   1                   /* enable buffer loaning */

/*
 * The fei82557End initialization string format is:
 *
 * <memBase>:<memSize>:<nCFDs>:<nRFDs>:<userFlags>
 */

#define FEI82557_LOAD_STRING "-1:0x00:0x20:0x20:0x00"

IMPORT END_OBJ* FEI82557_LOAD_FUNC (char*, void*);

#endif /* INCLUDE_FEI_END */

#ifdef INCLUDE_ELT_3C509_END

#define END_3C509_LOAD_FUNC   sysElt3c509EndLoad
#define END_3C509_BUFF_LOAN   1                   /* enable buffer loaning */
#define END_3C509_LOAD_STRING ""

IMPORT END_OBJ * END_3C509_LOAD_FUNC (char *, void*);

#endif /* INCLUDE_ELT_3C509_END */

/* smc elite ultra driver definitions */

#ifdef INCLUDE_ULTRA_END

#define END_ULTRA_LOAD_FUNC     sysUltraEndLoad
#define END_ULTRA_BUFF_LOAN     1               /* enable buffer loaning */
#define END_ULTRA_LOAD_STRING ""

IMPORT END_OBJ* END_ULTRA_LOAD_FUNC (char*, void*);

#endif /* INCLUDE_ULTRA_END */

/* ne2000 (ene) driver definitions */

#ifdef INCLUDE_ENE_END

#define END_ENE_LOAD_FUNC   sysNe2000EndLoad
#define END_ENE_BUFF_LOAN           1
#define END_ENE_LOAD_STRING ""  /* created in sysNE2000EndLoad */

IMPORT END_OBJ * END_ENE_LOAD_FUNC (char *, void*);

#endif /* INCLUDE_ENE_END */


/* ln7997x END driver defines */
 
#ifdef INCLUDE_LN_97X_END
 
/*
 * load string format
 * <devMemAddr>:<devIoAddr>:<pciMemBase:<vecnum>:<intLvl>:<memAdrs>:
 * <memSize>:<memWidth>:<csr3b>:<offset>:<flags>
 */
 
#define LN_97X_LOAD_FUNC        ln97xEndLoad
#define LN_97X_BUFF_LOAN_0      1
#define LN_97X_LOAD_STR_0       endLoadStr[0] /* First entry loc */
#define LN_97X_LOAD_COUNT       4

IMPORT END_OBJ * LN_97X_LOAD_FUNC (char *, void *);
 
char endLoadStr [LN_97X_LOAD_COUNT] [END_DESC_MAX];
 
#endif /* INCLUDE_LN_97X_END */

#ifdef INCLUDE_EL_3C90X_END
 
/*
 * load string format
 * <devMemAddr>:<devIoAddr>:<pciMemBase>:<vecnum>:<intLvl>:<memAdrs>:
 * <memSize>:<memWidth>:<flags>:<buffMultiplier>
 */
 
#define EL_3C90X_LOAD_FUNC      sysEl3c90xEndLoad
#define EL_3C90X_BUFF_LOAN_0    1
#define EL_3C90X_LOAD_STR_0     ""
 
IMPORT END_OBJ * EL_3C90X_LOAD_FUNC (char *, void *);
 
#endif /* INCLUDE_EL_3C90X_END */
 
/* max number of SENS ipAttachments we can have */

#ifndef IP_MAX_UNITS
#   define IP_MAX_UNITS (NELEMENTS (endDevTbl) - 1)
#endif
 
END_TBL_ENTRY endDevTbl [] =
    {
#ifdef INCLUDE_EL_3C90X_END
    {0, EL_3C90X_LOAD_FUNC, EL_3C90X_LOAD_STR_0, EL_3C90X_BUFF_LOAN_0,
    NULL, FALSE},
#endif /* INCLUDE_EL_3C90X_END */

#ifdef INCLUDE_LN_97X_END
    {0, LN_97X_LOAD_FUNC, LN_97X_LOAD_STR_0, TRUE, NULL, FALSE},
#endif /* INCLUDE_LN_97X_END */

#ifdef INCLUDE_FEI_END
    { 0, FEI82557_LOAD_FUNC, FEI82557_LOAD_STRING, FEI82557_BUFF_LOAN,
	NULL, FALSE},
#endif /* INCLUDE_FEI_END */

#ifdef INCLUDE_ELT_3C509_END
    {0, END_3C509_LOAD_FUNC, END_3C509_LOAD_STRING, END_3C509_BUFF_LOAN, 
	NULL, FALSE},
#endif /* INCLUDE_ELT_3C509_END */

#ifdef INCLUDE_ULTRA_END
    {0, END_ULTRA_LOAD_FUNC, END_ULTRA_LOAD_STRING, END_ULTRA_BUFF_LOAN,
        NULL, FALSE},
#endif /* INCLUDE_ULTRA_END */

#ifdef INCLUDE_ENE_END
    {0, END_ENE_LOAD_FUNC, END_ENE_LOAD_STRING, END_ENE_BUFF_LOAN, NULL},
#endif /* INCLUDE_ENE_END */

    { 0, END_TBL_END, NULL, 0, NULL, FALSE},
    };

#endif /* INCconfigNeth */

