#include <iolib.h>
#include <stdio.h>
#include <ctype.h>
#include <lstlib.h>
#include <string.h>
#include <stdlib.h>
#include <usrlib.h>

/* Lexer globals */
int nextchar;
char lexeme[1024];
int lex_column, lex_row;

/* Parsing declarations */
typedef struct svxi_copynode {
  struct svxi_copynode * next;
  struct svxi_copynode * previous;
  char                   source[1024];
  char                   target[1024];
} vxi_copynode;

typedef struct svxi_diskspecnode {
  struct svxi_diskspecnode * next;
  struct svxi_diskspecnode * previous;
  LIST                       copylist;
  char                       bootrom[1024];
  char                       name[1024];
} vxi_diskspecnode;

LIST vxi_diskspeclist;

typedef enum evxi_token {vxi_using, vxi_from, vxi_install, vxi_colon, vxi_bootrom, vxi_string, 
	      vxi_filename, vxi_eof, vxi_error} vxi_token;

char * vxi_tokennames[] =
{"using", "from", "install", "colon (\":\")", "bootrom", "quoted string", "file name", "EOF",
 "ERROR"};

int parse_column, parse_row;

vxi_token vxi_next_token;
int       got_bootrom = FALSE;

/* Install declarations */
STATUS mkbootAta
    (
    int ctrl,			/* controller number:	(0 - 1)		 */
    int drive,			/* drive number:	(0 - 1)		 */
    char *in			/* name of file to read: "bootrom_uncmp" */
    );


/* Floppy Eject Routine */

int flopedj (char name[])
{
  int  floppy_drive;
  char floppy_device[] = "/fd0/";

  char ans;

  if (!(floppy_drive = open (floppy_device, O_RDWR, 0777))) {
    printf ("Error: Unable to open floppy device \"%s\"\n", floppy_device);
    return 0;
  }

  if (ioctl (floppy_drive, FIOUNMOUNT, 0)) {
    printf ("Error: Unable to unmount floppy device \"%s\"\n", floppy_device);
    return 0;
  }

  close (floppy_drive);
  
  printf ("Insert %s and hit enter, please.", name);
  ans = getchar();
  return 1;
}

int vxiscan (FILE * fp) {

    /* State machine for reading a token. The best representation for a state 
       machine is using goto labels for the states */

 state_start:
    nextchar = 0;
    lexeme[nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;
    parse_column = lex_column;
    parse_row    = lex_row;

    switch (lexeme[nextchar]) {
    case 'f':
      goto state_f;
    case 'u':
      goto state_u;
    case 'i':
      goto state_i;
    case ':':
      return vxi_colon;
    case 'b':
      goto state_b;
    case '"':
      goto state_stringbody;
    case EOF:
      return vxi_eof;
    case '.':
      goto state_filenamepostdot;
    case ' ':
    case '\t':
    case '\r':
      goto state_start;

    case '\n':
      lex_row++;
      lex_column = 0;
      goto state_start;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

    /******************************************/ 
    /* States for reading in the "using" token */
    /******************************************/ 

 state_u:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 's':
      goto state_us;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_us:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'i':
      goto state_usi;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_usi:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'n':
      goto state_usin;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_usin:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'g':
      goto state_using;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_using:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_using;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_from;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_from;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

    /******************************************/ 
    /* States for reading in the "from" token */
    /******************************************/ 

 state_f:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'r':
      goto state_fr;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_fr:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'o':
      goto state_fro;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_fro:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'm':
      goto state_from;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

 state_from:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_from;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_from;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_from;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

    /*********************************************/ 
    /* States for reading in the "install" token */
    /*********************************************/ 

 state_i:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'n':
      goto state_in;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_in:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 's':
      goto state_ins;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_ins:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 't':
      goto state_inst;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_inst:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'a':
      goto state_insta;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_insta:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'l':
      goto state_instal;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_instal:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'l':
      goto state_install;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_install:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_install;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_install;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_install;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

    /*********************************************/ 
    /* States for reading in the "bootrom" token */
    /*********************************************/ 

 state_b:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'o':
      goto state_bo;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_bo:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'o':
      goto state_boo;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_boo:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 't':
      goto state_boot;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lexeme[nextchar] = '\0';
      lex_row++;
      lex_column = 0;
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_boot:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'r':
      goto state_bootr;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_bootr:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'o':
      goto state_bootro;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_bootro:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case 'm':
      goto state_bootrom;
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_bootrom:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_bootrom;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_bootrom;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_bootrom;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

    /********************************************/ 
    /* States for reading in the "string" token */
    /********************************************/ 

 state_stringbody:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case '"':
      nextchar++;
      return vxi_string;
    case EOF:
      printf ("ERROR @ line %d, column %d: Unterminated string line.\n", lex_row, lex_column);
      return vxi_error;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      printf ("ERROR @ line %d, column %d: Unterminated string line.\n", lex_row, lex_column);
      return vxi_error;
    default:
      goto state_stringbody;
    }

    /*********************************************/ 
    /* States for reading in the "filename" token */
    /*********************************************/ 

 state_filenamepredot:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case '.':
      goto state_filenamepostdot;
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepredot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }
 state_filenamepostdot:
    lexeme[++nextchar] = fgetc (fp);
    lexeme[nextchar + 1] = '\0';
    lex_column++;

    switch (lexeme[nextchar]) {
    case EOF:
    case ' ':
    case '\t':
    case '\r':
      lexeme[nextchar] = '\0';
      return vxi_filename;
    case ':':
      ungetc (lexeme[nextchar--], fp);
      lexeme[nextchar + 1] = '\0';
      lex_column--;
      return vxi_filename;
    case '\n':
      lex_row++;
      lex_column = 0;
      lexeme[nextchar] = '\0';
      return vxi_filename;
    default:
      if (isalnum (lexeme[nextchar])) {
	goto state_filenamepostdot;
      } else {
	printf ("ERROR @ line %d, column %d: illegal character.\n", lex_row, lex_column);
	return vxi_error;
      } 
    }

    printf ("ERROR @ line %d, column %d: Fallthru coding error.\n", lex_row, lex_column);
    return vxi_error;

}


int vxiparsefilename (FILE * fp, char * filename) {

  if (vxi_next_token == vxi_filename) {
    strcpy (filename, lexeme);
    vxi_next_token = vxiscan (fp);
    return TRUE;
  } else {
    printf ("ERROR at line %d, column %d: Filename expected, %s found.\n",
	    parse_row, parse_column, lexeme
	    );
    return FALSE;
  }
}

int vxiparsestring (FILE * fp, char * filename) {

  char * stptr;

  if (vxi_next_token == vxi_string) {
    stptr = lexeme + 1;
    strncpy (filename, stptr, strlen(stptr) - 1);
    filename [strlen(stptr) - 1] = '\0';
    vxi_next_token = vxiscan (fp);
    return TRUE;
  } else {
    printf ("ERROR at line %d, column %d: String expected, %s found.\n",
	    parse_row, parse_column, lexeme
	    );
    return FALSE;
  }
}

int vxiparsekeyword (FILE * fp, vxi_token keyword) {

  if (vxi_next_token == keyword) {
    vxi_next_token = vxiscan (fp);
    return TRUE;
  } else {
    printf ("ERROR at line %d, column %d: %s keyword expected, %s token (\"%s\") found.\n",
	    parse_row, parse_column, vxi_tokennames[keyword], vxi_tokennames[vxi_next_token],
	    lexeme
	    );
    return FALSE;
  }
}  

int vxiparsecopyline (FILE * fp, LIST * copylist) {

  vxi_copynode * newnode = malloc (sizeof(vxi_copynode));

  /* Find the target file name */
  if (!(vxiparsefilename (fp, newnode->target))) {
    free (newnode);
    return FALSE;
  }

  /* Find the source file name */
  if (vxi_next_token == vxi_from) {
    vxiparsekeyword (fp, vxi_from);
    if (!(vxiparsefilename (fp, newnode->source))) {
      free (newnode);
      return FALSE;
    }
  } else {
    strcpy (newnode->source, newnode->target);
  }

  /* Add the node to the list */
  lstAdd (copylist, (NODE *)newnode);
  return TRUE;
}

int vxiparsebootromline (FILE * fp, char * filename) {

  if (!(vxiparsekeyword (fp, vxi_bootrom))) {
    return FALSE;
  }
  if (!(vxiparsekeyword (fp, vxi_from))) {
    return FALSE;
  }
  if (!(vxiparsefilename (fp, filename))) {
    return FALSE;
  }
  return TRUE;
}

int vxiparsediskspec (FILE * fp) {

  char filename[1024];
  vxi_diskspecnode * newdiskspec;

  /* Parse the disk-specific info */
  if (!(vxiparsekeyword (fp, vxi_using))) {
    return FALSE;
  }
  if (!(vxiparsestring (fp, filename))) {
    return FALSE;
  }
  if (!(vxiparsekeyword (fp, vxi_install))) {
    return FALSE;
  }
  if (!(vxiparsekeyword (fp, vxi_colon))) {
    return FALSE;
  }

  /* Create and initialize the new diskspec entry */
  newdiskspec = malloc (sizeof (vxi_diskspecnode));
  strcpy (newdiskspec->name, filename);
  newdiskspec->bootrom[0] = '\0';
  lstInit (&(newdiskspec->copylist));
  lstAdd (&vxi_diskspeclist, (NODE *)newdiskspec);

  /* Parse the boorom line (if any). */
  if (vxi_next_token == vxi_bootrom) {
    if (got_bootrom) {
      printf ("ERROR at line %d, column %d: Only one bootrom installation is allowed.\n",
	      parse_row, parse_column);
      return FALSE;
    }
    got_bootrom = TRUE;
    if (!(vxiparsebootromline (fp, newdiskspec->bootrom))) {
      return FALSE;
    }
  }

  /* Parse the copy lines for this disk */
  while (vxi_next_token == vxi_filename) {
    if (!(vxiparsecopyline (fp, &(newdiskspec->copylist)))) {
      return FALSE;
    }
  }
  
  return TRUE;
}


int vxinstall (char filename[])
{
  FILE * install_file;

  vxi_diskspecnode * diskspecnode;
  vxi_copynode     * copynode;

  char copyfilename[1024] = "/ata0/"; 

  install_file = fopen (filename,"r"); 
  lstInit (&vxi_diskspeclist);

  if (install_file == NULL) {
    printf ("ERROR: Unable to open %s for processing\n", filename);
    return 1;
  }

  /* Parse the install file */
  for (lex_column = 0, lex_row=1,vxi_next_token=vxiscan(install_file);
       vxi_next_token != vxi_eof;
       ) {

    if (!vxiparsediskspec (install_file)) {
      printf ("Unable to install due to errors in file %s.\n", filename);
      fclose (install_file);
      return FALSE;
    }
  }
  fclose (install_file);

  /* Process the install requests */
  while ((diskspecnode = (vxi_diskspecnode *) (lstGet (&(vxi_diskspeclist))))) {

    if (!(flopedj (diskspecnode->name))) {
      printf ("Installation aborted.\n");
      return FALSE;
    }
    if (diskspecnode->bootrom[0]) {
      printf ("   install bootrom %s onto harddisk.\n", diskspecnode->bootrom);
      if (mkbootAta (0, 0, diskspecnode->bootrom)) {
        printf ("ERROR: Ata Bootdisk creation from %s failed. Aborting.\n", diskspecnode->bootrom);
	return FALSE; 
      }
    }

    while ((copynode = (vxi_copynode *)lstGet (&(diskspecnode->copylist)))) {
      printf ("   install %s onto hardisk from file %s on floppy.\n",
	      copynode->target, copynode->source);
      strcpy (copyfilename + 6, copynode->target);
      if (copy (copynode->source, copyfilename)) {
	printf ("ERROR: copy \"%s\" to \"%s\" failed.", copynode->source, copyfilename);
      }
      free (copynode);
    }

    free (diskspecnode);
  }

  return TRUE;
}
