/* pc386/config.h - PC [34]86/Pentium/Pentiumpro configuration header */

/* Copyright 1984-1999 Wind River Systems, Inc. */

/*
modification history
--------------------
03b,15mar99,cn   corrected cross-dependencies between INCLUDE_PCI and 
		 INCLUDE_LN_97X_END, INCLUDE_EL_3C90X_END (SPR# 25680).
03a,12mar99,cn   added support for el3c90xEnd driver (SPR# 25327).
02z,08mar99,sbs  added support for SMC Elite Ultra ethernet card.(SPR #25234)
                 moved INCLUDE_LN_97X_END into INCLUDE_END loop.
                 added support for ne2000End driver (SPR #25398)
02y,26feb99,dat	 removed FEI from NETIF_USR_ENTRIES (23818)
02x,25feb99,hdn  added PentiumPro's MESI bus snoop.
		 removed GLOBAL bit from VM_STATE_FOR_MEM_OS.
02w,24feb99,pr   removed CONSOLE_TTY define for PC_CONSOLE (SPR#23075)
02v,01feb99,jkf  added END support for AMD 7997x PCI PCNet-FAST card.
                 made FEI_END the default.
02u,26nov98,ms_  add elt3c509 END support
02t,26jan99,jkf  INCLUDE_ADD_BOOTMEM added.  INCLUDE_END
                 is again made the default.  SPR#21338
02s,12nov98,dat  END drivers are not selected by default (See SPR xxxxx)
02r,28aug98,sbs  changed WDB_COMM_TYPE to WDB_COMM_END.
02q,03aug98,cn   new BSP revision id
02o,07jul98,db   changed BSP_VERSION to "1.2" and BSP_REVISION to "/0".
		 added BSP_VER_1_2 macro (Tornado 2.0 release).
02n,28may98,hdn  added support for APIC.
02m,12may98,hdn  merged with pcPentium/config.h. obsolete INCLUDE_IDE.
		 changed LOCAL_MEM_SIZE to 8MB. cleaned up.
02l,24apr98,yp   added defines for TFFS.
02k,31mar98,cn   Added Enhanced Network Driver support.
02j,24mar98,sbs  corrected SYS_WARM_FD to be default SYS_WARM_TYPE.
02i,18mar98,sbs  added SYS_WARM_BIOS, SYS_WARM_FD, SYS_WARM_ATA. 
                 added SYS_INT_TRAPGATE, SYS_INT_INTGATE.
02h,16jan98,gnn  Removed documentation and support for END, 
		 not supported yet.
02g,28apr97,gnn  Added documentation for END_OVERRIDE and INCLUDE_END.
02f,25apr97,gnn  Added Enhanced Network Driver support.
02h,05aug97,dds  added INCLUDE_AIC_7880.
02g,11jul97,dds  #undef INCLUDE_CDROMFS.
02f,10jul97,dds  added SCSI-2 support. REV level 2
02e,26feb97,mas  added defs of USER_RESERVED_MEM and LOCAL_MEM_AUTOSIZE; added
		 warm boot parameters (SPR 7806, 7850).
02d,22nov96,dat  fixed warning from NETIF_USR_ENTRIES.
02c,20nov96,hdn  added support for PRO100B.
02b,01nov96,hdn  added support for PCMCIA.
02a,10oct96,dat  release 1.1/1, (Tornado 1.0.1)
01z,03sep96,hdn  added the compression support. removed BOOTABLE macro.
01y,09aug96,hdn  renamed INT_VEC_IRQ0 to INT_NUM_IRQ0.
01x,05aug96,hdn  changed INT_LVL_ENE 0x0b to 0x05(default int level).
01w,19jul96,hdn  added support for ATA driver.
01v,25jun96,hdn  added support for TIMESTAMP timer.
01u,14jun96,hdn  added support for PCI bus.
01t,13jun96,hdn  added INCLUDE_ESMC for SMC91c9x Ethernet driver.
01s,28sep95,dat  new BSP revision id
01r,14jun95,hdn  added INCLUDE_SW_FP for FPP software emulation library.
01q,08jun95,ms   changed PC_CONSOLE defines.
01p,12jan95,hdn  changed SYS_CLK_RATE_MAX to a safe number.
01o,08dec94,hdn  changed EEROM to EEPROM.
01n,15oct94,hdn  changed CONFIG_ELC and CONFIG_ULTRA.
		 added INCLUDE_LPT for LPT driver.
		 added INCLUDE_EEX32 for Intel EtherExpress32.
		 changed the default boot line.
		 moved INT_VEC_IRQ0 to pc.h.
01m,03jun94,hdn  deleted shared memory network related macros.
01l,28apr94,hdn  changed ROM_SIZE to 0x7fe00.
01k,22apr94,hdn  added macros INT_VEC_IRQ0, FD_DMA_BUF, FD_DMA_BUF_SIZE.
		 moved a macro PC_KBD_TYPE from pc.h.
		 added SLIP driver with 9600 baudrate.
01j,15mar94,hdn  changed ULTRA configuration.
		 changed CONSOLE_TTY number from 0 to 2.
01i,09feb94,hdn  added 3COM EtherlinkIII driver and Eagle NE2000 driver.
                 changed RAM_HIGH_ADRS and RAM_LOW_ADRS.
                 changed LOCAL_MEM_SIZE to 4MB.
01h,27jan94,hdn  changed RAM_HIGH_ADRS 0x110000 to 0x00108000.
		 changed RAM_ENTRY 0x10000 to 0x00008000.
01g,17dec93,hdn  added support for Intel EtherExpress driver.
01f,24nov93,hdn  added INCLUDE_MMU_BASIC.
01e,08nov93,vin  added support for pc console drivers.
01d,03aug93,hdn  changed network board's address and vector.
01c,22apr93,hdn  changed default boot line.
01b,07apr93,hdn  renamed compaq to pc.
01a,15may92,hdn  written based on frc386.
*/

/*
This module contains the configuration parameters for the
PC [34]86/Pentium/Pentiumpro.
*/

#ifndef	INCconfigh
#define	INCconfigh

/* BSP version/revision identification, before configAll.h */

#define BSP_VER_1_1	1	/* 1.2 is backward compatible with 1.1 */
#define BSP_VER_1_2	1
#define BSP_VERSION	"1.2"
#define BSP_REV		"/0"	/* 0 for first revision */

#include "configAll.h"
#include "pc.h"

#if	(CPU == I80386)
#define DEFAULT_BOOT_LINE \
	"fd=0,0(0,0)host:/fd0/vxWorks.st h=90.0.0.3 e=90.0.0.50 u=target"
#elif	(CPU == I80486)
#define DEFAULT_BOOT_LINE \
	"fd=0,0(0,0)host:/fd0/vxWorks.st h=90.0.0.3 e=90.0.0.50 u=target"
#elif	(CPU_VARIANT == PENTIUM)
#define DEFAULT_BOOT_LINE \
	"fd=0,0(0,0)host:/fd0/vxWorks.st h=90.0.0.3 e=90.0.0.50 u=target"
#elif	(CPU_VARIANT == PENTIUMPRO)
#define DEFAULT_BOOT_LINE \
        "fd=0,0(0,0)host:/fd0/flopkrnl e=10.10.5.1:ffffff00 h=10.10.5.2 u=target s=/fd0/install.scr"
#endif	/* (CPU == I80386) */

/* Warm boot (reboot) devices and parameters */

#define SYS_WARM_BIOS 		0 	/* warm start from BIOS */
#define SYS_WARM_FD   		1 	/* warm start from FD */
#define SYS_WARM_ATA  		2	/* warm start from ATA */
#define SYS_WARM_TFFS  		3	/* warm start from DiskOnChip */

#define SYS_WARM_TYPE		SYS_WARM_FD /* warm start device */
#define SYS_WARM_FD_DRIVE       0       /* 0 = drive a:, 1 = b: */
#define SYS_WARM_FD_TYPE        0       /* 0 = 3.5" 2HD, 1 = 5.25" 2HD */
#define SYS_WARM_ATA_CTRL       0       /* controller 0 */
#define SYS_WARM_ATA_DRIVE      0       /* 0 = c:, 1 = d: */
#define SYS_WARM_TFFS_DRIVE     0       /* 0 = c: (DOC) */

/* IDT entry type options */

#define SYS_INT_TRAPGATE 	0x0000ef00 	/* trap gate */
#define SYS_INT_INTGATE  	0x0000ee00 	/* int gate */

/* driver and file system options */

#define	INCLUDE_DOSFS		/* include dosFs file system */
#define	INCLUDE_FD		/* include floppy disk driver */
#define	INCLUDE_LPT		/* include parallel port driver */
#define	INCLUDE_ATA		/* include IDE/EIDE(ATA) hard disk driver */
#undef	INCLUDE_TIMESTAMP	/* include TIMESTAMP timer for Wind View */
#undef	INCLUDE_TFFS		/* include TrueFFS driver for Flash */
#undef	INCLUDE_PCMCIA		/* include PCMCIA driver */

#ifdef	INCLUDE_PCMCIA
#define INCLUDE_ATA		/* include ATA driver */
#define INCLUDE_SRAM		/* include SRAM driver */
#undef	INCLUDE_TFFS		/* include TFFS driver */
#ifdef	INCLUDE_NETWORK
#define INCLUDE_ELT		/* include 3COM EtherLink III driver */
#endif	/* INCLUDE_NETWORK */
#endif	/* INCLUDE_PCMCIA */

#ifdef	INCLUDE_TFFS
#define	INCLUDE_SHOW_ROUTINES
#endif	/* INCLUDE_TFFS */

#if	FALSE                   /* change FALSE to TRUE for SCSI interface */
#define INCLUDE_SCSI            /* include SCSI driver */
#define INCLUDE_AIC_7880        /* include AIC 7880 SCSI driver */
#define INCLUDE_SCSI_BOOT       /* include ability to boot from SCSI */
#undef  INCLUDE_CDROMFS         /* file system to be used */
#define INCLUDE_TAPEFS          /* file system to be used */
#endif
#define INCLUDE_SCSI2           /* select SCSI2 not SCSI1 */

/* Network driver options */
#undef	INCLUDE_END		/* Use Enhanced Network Drivers */
#undef	INCLUDE_ULTRA		/* include SMC Elite16 Ultra interface */
#undef	INCLUDE_ENE		/* include Eagle/Novell NE2000 interface */
#define	INCLUDE_ELT		/* include 3COM EtherLink III interface */
#undef	INCLUDE_ESMC		/* include SMC 91c9x Ethernet interface */
#undef	INCLUDE_FEI		/* include Intel Ether Express PRO100B PCI */
#define INCLUDE_SLIP		/* include serial line interface */
#define SLIP_TTY	1	/* serial line IP channel COM2 */
#undef	INCLUDE_ELC		/* include SMC Elite16 interface */
#undef	INCLUDE_EEX		/* include INTEL EtherExpress interface */
#undef	INCLUDE_EEX32		/* include INTEL EtherExpress flash 32 */
#undef	INCLUDE_EX		/* include Excelan Ethernet interface */
#undef	INCLUDE_ENP		/* include CMC Ethernet interface*/
#undef	INCLUDE_SM_NET		/* include backplane net interface */
#undef	INCLUDE_SM_SEQ_ADDR	/* shared memory network auto address setup */
#undef  INCLUDE_EL_3C90X_END    /* 3com fast etherLink XL PCI */
#undef  INCLUDE_LN_97X_END      /* AMD 79C972 END DRIVER */
 
/* verify network choices and dependencies */
 
#if defined(INCLUDE_EL_3C90X_END) || defined(INCLUDE_LN_97X_END)
#ifndef INCLUDE_END
#   define INCLUDE_END                  /* no netif support for these devices */
#endif /* INCLUDE_END */
#endif /* INCLUDE_EL_3C90X_END || INCLUDE_LN_97X_END */

#ifdef INCLUDE_END
#   undef  WDB_COMM_TYPE
#   define WDB_COMM_TYPE	WDB_COMM_END /* END is prefered choice */

#   ifdef INCLUDE_FEI
#	undef INCLUDE_FEI	/* don't use BSD driver */
#	define INCLUDE_FEI_END	/* Use END driver instead */
#   endif

#   ifdef INCLUDE_ELT
#	undef INCLUDE_ELT	/* don't use BSD driver */
#	define INCLUDE_ELT_3C509_END /* Use END driver instead */
#   endif

#   ifdef INCLUDE_ULTRA
#       undef INCLUDE_ULTRA     /* don't use BSD driver */
#       define INCLUDE_ULTRA_END /* use END driver instead */
#   endif

#   ifdef INCLUDE_ENE
#       undef INCLUDE_ENE     /* don't use BSD driver */
#       define INCLUDE_ENE_END /* use END driver instead */
#   endif

#endif

#if defined(INCLUDE_FEI) || defined(INCLUDE_LN_97X_END) ||      \
defined (INCLUDE_EL_3C90X_END) || defined(INCLUDE_FEI_END)
#   define INCLUDE_PCI          /* they all are PCI based */
#endif
 

/* Misc. options */

#define INCLUDE_MMU_BASIC 	/* bundled mmu support */
#undef	VM_PAGE_SIZE
#define	VM_PAGE_SIZE		PAGE_SIZE_4KB	/* 4KB page */

#define VM_STATE_MASK_FOR_ALL \
	VM_STATE_MASK_VALID | VM_STATE_MASK_WRITABLE | VM_STATE_MASK_CACHEABLE
#define VM_STATE_FOR_IO \
	VM_STATE_VALID | VM_STATE_WRITABLE | VM_STATE_CACHEABLE_NOT
#define VM_STATE_FOR_MEM_OS \
	VM_STATE_VALID | VM_STATE_WRITABLE | VM_STATE_CACHEABLE
#define VM_STATE_FOR_MEM_APPLICATION \
	VM_STATE_VALID | VM_STATE_WRITABLE | VM_STATE_CACHEABLE
#define VM_STATE_FOR_PCI \
	VM_STATE_VALID | VM_STATE_WRITABLE | VM_STATE_CACHEABLE_NOT

/* 
 * software floating point emulation support. DO NOT undefine hardware fp 
 * support in configAll.h as it is required for software fp emulation.
 */


#define INCLUDE_SW_FP		

#if	(CPU_VARIANT == PENTIUM) /* Pentium specific macros */

#undef	INCLUDE_SW_FP		/* Pentium has hardware FPP */
#undef	USER_D_CACHE_MODE	/* Pentium write-back data cache support */
#define	USER_D_CACHE_MODE	CACHE_COPYBACK
#define	INCLUDE_MTRR_GET	/* get MTRR to sysMtrr[] */
#define	INCLUDE_PMC		/* include PMC */

#elif	(CPU_VARIANT == PENTIUMPRO) /* PentiumPro specific macros */

#undef	INCLUDE_SW_FP		/* PentiumPro has hardware FPP */
#undef	USER_D_CACHE_MODE	/* PentiumPro write-back data cache w MESI */
#define	USER_D_CACHE_MODE	(CACHE_COPYBACK | CACHE_SNOOP_ENABLE)
#define	INCLUDE_MTRR_GET	/* get MTRR to sysMtrr[] */
#define	INCLUDE_PMC		/* include PMC */
#undef	VIRTUAL_WIRE_MODE	/* Interrupt Mode: Virtual Wire Mode */
#undef	SYMMETRIC_IO_MODE	/* Interrupt Mode: Symmetric IO Mode */

#if	defined(VIRTUAL_WIRE_MODE) || defined(SYMMETRIC_IO_MODE)
#define	INCLUDE_APIC_TIMER	/* include Local APIC timer */
#define	PIT0_FOR_AUX		/* use channel 0 as an Aux Timer */
#endif	/* defined(VIRTUAL_WIRE_MODE) || defined(SYMMETRIC_IO_MODE) */

#define	INCLUDE_TIMESTAMP_TSC	/* include TSC for timestamp */
#define	PENTIUMPRO_TSC_FREQ	0	  /* auto detect TSC freq */
#if	FALSE
#define	PENTIUMPRO_TSC_FREQ	150000000 /* use specified TSC freq */
#endif	/* FALSE */

#define	INCLUDE_MMU_PENTIUMPRO	/* include 32bit MMU for PentiumPro */
#ifdef	INCLUDE_MMU_PENTIUMPRO

#undef	VM_PAGE_SIZE		/* page size could be 4KB or 4MB */
#define	VM_PAGE_SIZE		PAGE_SIZE_4KB	/* 4KB page */
#if	FALSE
#define	VM_PAGE_SIZE		PAGE_SIZE_4MB	/* 4MB page */
#endif	/* FALSE */

#undef	VM_STATE_MASK_FOR_ALL
#undef	VM_STATE_FOR_IO
#undef	VM_STATE_FOR_MEM_OS
#undef	VM_STATE_FOR_MEM_APPLICATION
#undef	VM_STATE_FOR_PCI
#define VM_STATE_MASK_FOR_ALL \
	VM_STATE_MASK_VALID | VM_STATE_MASK_WRITABLE | \
	VM_STATE_MASK_CACHEABLE | VM_STATE_MASK_WBACK | VM_STATE_MASK_GLOBAL
#define VM_STATE_FOR_IO \
	VM_STATE_VALID | VM_STATE_WRITABLE | \
	VM_STATE_CACHEABLE_NOT | VM_STATE_WBACK_NOT | VM_STATE_GLOBAL_NOT
#define VM_STATE_FOR_MEM_OS \
	VM_STATE_VALID | VM_STATE_WRITABLE | \
	VM_STATE_CACHEABLE | VM_STATE_WBACK | VM_STATE_GLOBAL_NOT
#define VM_STATE_FOR_MEM_APPLICATION \
	VM_STATE_VALID | VM_STATE_WRITABLE | \
	VM_STATE_CACHEABLE | VM_STATE_WBACK | VM_STATE_GLOBAL_NOT
#define VM_STATE_FOR_PCI \
	VM_STATE_VALID | VM_STATE_WRITABLE | \
	VM_STATE_CACHEABLE_NOT | VM_STATE_WBACK_NOT | VM_STATE_GLOBAL_NOT

#endif	/* INCLUDE_MMU_PENTIUMPRO */
#endif	/* (CPU_VARIANT == PENTIUM) */


#define IO_ADRS_ELC	0x240
#define INT_LVL_ELC	0x0b
#define MEM_ADRS_ELC	0xc8000
#define MEM_SIZE_ELC	0x4000
#define CONFIG_ELC	0	/* 0=EEPROM 1=RJ45+AUI 2=RJ45+BNC */

#define IO_ADRS_ULTRA	0x240
#define INT_LVL_ULTRA	0x0b
#define MEM_ADRS_ULTRA	0xc8000
#define MEM_SIZE_ULTRA	0x4000
#define CONFIG_ULTRA	0	/* 0=EEPROM 1=RJ45+AUI 2=RJ45+BNC */

#define IO_ADRS_EEX	0x240
#define INT_LVL_EEX	0x0b
#define NTFDS_EEX	0x00
#define CONFIG_EEX	0	/* 0=EEPROM  1=AUI  2=BNC  3=RJ45 */
				/* Auto-detect is not supported, so choose */
				/* the right one you're going to use */

#define IO_ADRS_ELT	0x300
#define INT_LVL_ELT	0x0a
#define NRF_ELT		0x00
#define CONFIG_ELT	0	/* 0=EEPROM 1=AUI  2=BNC  3=RJ45 */

#define IO_ADRS_ENE	0x300
#define INT_LVL_ENE	0x05
				/* Hardware jumper is used to set */
				/* RJ45(Twisted Pair) AUI(Thick) BNC(Thin) */

#define IO_ADRS_ESMC	0x300
#define INT_LVL_ESMC	0x0b
#define CONFIG_ESMC	0	/* 0=EEPROM 1=AUI  2=BNC 3=RJ45 */
#define RX_MODE_ESMC	0	/* 0=interrupt level 1=task level */

#ifdef	INCLUDE_EEX32
#define INCLUDE_EI		/* include 82596 driver */
#define INT_LVL_EI	0x0b
#define EI_SYSBUS	0x44	/* 82596 SYSBUS value */
#define EI_POOL_ADRS	NONE	/* memory allocated from system memory */
#endif	/* INCLUDE_EEX32 */

#define FEI_POOL_ADRS	NONE	/* allocate pool space */

#ifdef  INCLUDE_SLIP
#define SLIP_TTY	1	/* serial line IP channel COM2 */
#define SLIP_BAUDRATE	19200	/* baudrate 19200 */
#endif  /* INCLUDE_SLIP */

/* vectors for PIC(i8259a) and APIC */

#ifdef	SYMMETRIC_IO_MODE

/*
 * Vector number could be any number in between 0x20 to 0xff.
 * Interrupt priority is implied by its vector number, according to
 * the following relationship: 
 *   priority = vectorNo / 16
 * The lowest priority is 1 and 15 is the highest.  To avoid losing
 * interrupts, software should allocate no more than 2 interrupt
 * vectors per priority.  Here is an example to get the vectorNo.
 *   vectorNo(IRQn) = (0xe0 - (n * 8))
 */
#define	NUMBER_OF_IRQS		24
#undef	PIT0_INT_LVL
#define	PIT0_INT_LVL		0x2	/* interrupt level */
#define	INT_NUM_IRQ0		0xe0	/* vector number for IRQ0 */
#define INT_VEC_GET(irq)	(INT_NUM_IRQ0 - (irq * 8))
#define SPURIOUS_INT_VEC	0xff	/* local interrupt */
#define TIMER_INT_VEC		0xf0	/* local interrupt */
#define ERROR_INT_VEC		0xef	/* local interrupt */
#define PIT0_INT_VEC		(INT_VEC_GET (PIT0_INT_LVL))
#define	COM1_INT_VEC		(INT_VEC_GET (COM1_INT_LVL))
#define	COM2_INT_VEC		(INT_VEC_GET (COM2_INT_LVL))
#define RTC_INT_VEC		(INT_VEC_GET (RTC_INT_LVL))
#define FD_INT_VEC		(INT_VEC_GET (FD_INT_LVL))
#define ATA0_INT_VEC 		(INT_VEC_GET (ATA0_INT_LVL))
#define ATA1_INT_VEC		(INT_VEC_GET (ATA1_INT_LVL))
#define PCIC_INT_VEC		(INT_VEC_GET (PCIC_INT_LVL))
#define TCIC_INT_VEC		(INT_VEC_GET (TCIC_INT_LVL))
#define ELT0_INT_VEC		(INT_VEC_GET (ELT0_INT_LVL))
#define ELT1_INT_VEC		(INT_VEC_GET (ELT1_INT_LVL))
#define LPT_INT_VEC		(INT_VEC_GET (LPT_INT_LVL))
#define FEI0_INT_VEC		(INT_VEC_GET (FEI0_INT_LVL))
#define FEI1_INT_VEC		(INT_VEC_GET (FEI1_INT_LVL))
#define FEI2_INT_VEC		(INT_VEC_GET (FEI2_INT_LVL))
#define FEI3_INT_VEC		(INT_VEC_GET (FEI3_INT_LVL))
#define KBD_INT_VEC		(INT_VEC_GET (KBD_INT_LVL))
#define INT_VEC_ELC		(INT_VEC_GET (INT_LVL_ELC))
#define INT_VEC_ULTRA		(INT_VEC_GET (INT_LVL_ULTRA))
#define INT_VEC_EEX		(INT_VEC_GET (INT_LVL_EEX))
#define INT_VEC_ELT		(INT_VEC_GET (INT_LVL_ELT))
#define INT_VEC_ENE		(INT_VEC_GET (INT_LVL_ENE))
#define INT_VEC_ESMC		(INT_VEC_GET (INT_LVL_ESMC))
#define INT_VEC_EI		(INT_VEC_GET (INT_LVL_EI))

#else	/* SYMMETRIC_IO_MODE */

/* 
 * Vector number is not flexable as APIC and obtained by:
 *   vectorNo(IRQn) = vectorNo(IRQ0) + n
 */
#define	NUMBER_OF_IRQS		16
#define INT_NUM_IRQ0		0x20	/* vector number for IRQ0 */
#define INT_VEC_GET(irq)	(INT_NUM_IRQ0 + irq)
#define SPURIOUS_INT_VEC	0xff	/* local interrupt */
#define TIMER_INT_VEC		0xf0	/* local interrupt */
#define ERROR_INT_VEC		0xef	/* local interrupt */
#define PIT0_INT_VEC		(INT_VEC_GET (PIT0_INT_LVL))
#define	COM1_INT_VEC		(INT_VEC_GET (COM1_INT_LVL))
#define	COM2_INT_VEC		(INT_VEC_GET (COM2_INT_LVL))
#define RTC_INT_VEC		(INT_VEC_GET (RTC_INT_LVL))
#define FD_INT_VEC		(INT_VEC_GET (FD_INT_LVL))
#define ATA0_INT_VEC 		(INT_VEC_GET (ATA0_INT_LVL))
#define ATA1_INT_VEC		(INT_VEC_GET (ATA1_INT_LVL))
#define PCIC_INT_VEC		(INT_VEC_GET (PCIC_INT_LVL))
#define TCIC_INT_VEC		(INT_VEC_GET (TCIC_INT_LVL))
#define ELT0_INT_VEC		(INT_VEC_GET (ELT0_INT_LVL))
#define ELT1_INT_VEC		(INT_VEC_GET (ELT1_INT_LVL))
#define LPT_INT_VEC		(INT_VEC_GET (LPT_INT_LVL))
#define FEI0_INT_VEC		(INT_VEC_GET (FEI0_INT_LVL))
#define FEI1_INT_VEC		(INT_VEC_GET (FEI1_INT_LVL))
#define FEI2_INT_VEC		(INT_VEC_GET (FEI2_INT_LVL))
#define FEI3_INT_VEC		(INT_VEC_GET (FEI3_INT_LVL))
#define KBD_INT_VEC		(INT_VEC_GET (KBD_INT_LVL))
#define INT_VEC_ELC		(INT_VEC_GET (INT_LVL_ELC))
#define INT_VEC_ULTRA		(INT_VEC_GET (INT_LVL_ULTRA))
#define INT_VEC_EEX		(INT_VEC_GET (INT_LVL_EEX))
#define INT_VEC_ELT		(INT_VEC_GET (INT_LVL_ELT))
#define INT_VEC_ENE		(INT_VEC_GET (INT_LVL_ENE))
#define INT_VEC_ESMC		(INT_VEC_GET (INT_LVL_ESMC))
#define INT_VEC_EI		(INT_VEC_GET (INT_LVL_EI))

#endif	/* SYMMETRIC_IO_MODE */


/* miscellaneous definitions */

#define NV_RAM_SIZE     NONE            /* no NVRAM */

/* 
 * SYS_CLK_RATE_MAX depends upon a CPU power and a work load of an application.
 * The value was chosen in order to pass the internal test suit,
 * but it could go up to PIT_CLOCK.
 */
#define SYS_CLK_RATE_MIN  19            /* minimum system clock rate */
#define SYS_CLK_RATE_MAX  (PIT_CLOCK/256) /* maximum system clock rate */
#define AUX_CLK_RATE_MIN  2             /* minimum auxiliary clock rate */
#define AUX_CLK_RATE_MAX  8192          /* maximum auxiliary clock rate */


/* pc console definitions  */

#if	TRUE
#define INCLUDE_PC_CONSOLE 		/*  KBD and VGA are included */
#endif  /* TRUE/FALSE */

#ifdef INCLUDE_PC_CONSOLE

#define	PC_CONSOLE		0	/* console number */
#define	N_VIRTUAL_CONSOLES	2	/* shell / application */

#endif /* INCLUDE_PC_CONSOLE */

#undef	NUM_TTY
#define NUM_TTY			(N_UART_CHANNELS)

/* define a type of keyboard. The default is 101 KEY for PS/2 */

#define PC_KBD_TYPE		PC_PS2_101_KBD
#if	FALSE
#define PC_KBD_TYPE		PC_XT_83_KBD
#endif	/* FALSE */


/* memory addresses */

/* User reserved memory.  See sysMemTop(). */

#define	USER_RESERVED_MEM	0

/*
 * Local-to-Bus memory address constants:
 * the local memory address always appears at 0 locally;
 * it is not dual ported.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x00000000	/* fixed */
#define LOCAL_MEM_BUS_ADRS	0x00000000	/* fixed */
#define LOCAL_MEM_SIZE		0x00800000	/* 8MB w lower mem */

/*
 * Auto-sizing of memory is supported when this option is defined, in which
 * case LOCAL_MEM_SIZE is ignored.  See sysyPhysMemTop().
 */

#define	LOCAL_MEM_AUTOSIZE

/*
 * The following parameters are defined here and in the Makefile.
 * The must be kept synchronized; effectively config.h depends on Makefile.
 * Any changes made here must be made in the Makefile and vice versa.
 */

#ifdef	BOOTCODE_IN_RAM
#define ROM_BASE_ADRS		0x00008000	/* base address of ROM */
#define ROM_TEXT_ADRS		(ROM_BASE_ADRS)	/* booting from A: or C: */
#define ROM_SIZE		0x00090000	/* size of ROM */
#else
#define ROM_BASE_ADRS		0xfff20000	/* base address of ROM */
#define ROM_TEXT_ADRS		(ROM_BASE_ADRS)	/* booting from EPROM */
#define ROM_SIZE		0x0007fe00	/* size of ROM */
#endif

#define RAM_LOW_ADRS		0x00108000	/* VxWorks image entry point */
#define RAM_HIGH_ADRS		0x00008000	/* Boot image entry point */

/*
 * The macro INCLUDE_ADD_BOOTMEM enables sysHwInit2,sysLib.c code which 
 * adds some upper memory (>1MB) to the bootrom image memory pool.  
 * It should not be defined for x86 systems with limited memory,< 4MB.  
 * The default value for ADDED_BOOTMEM_SIZE is 0x00200000 (2MB).
 * This value may be increased, but one must ensure that the pool 
 * does not overlap with the downloaded vxWorks image.  If there is 
 * an overlap, then loading the vxWorks runtime image will corrupt 
 * the added memory pool.   The calculation is:
 * (RAM_LOW_ADRS + vxWorks image size) < (memTopPhys - ADDED_BOOTMEM_SIZE)
 * Where: RAM_LOW_ADRS == 0x00108000 and memTopPhys is from sysLib.c.
 * This corrects SPR#21338.
 */
 
#define INCLUDE_ADD_BOOTMEM  /* Add upper memory to low memory bootrom */
#define ADDED_BOOTMEM_SIZE   0x00200000   /* 2MB */

#endif	/* INCconfigh */

#if defined(PRJ_BUILD)
#include "prjParams.h"
#endif

