###############################################################################
##
##           FlightSafety International Simulation Systems Division
##                    Broken Arrow, OK  USA  918-259-4000
##
##                      JPATS T-6A Flight Training Device
##
##
##  Engineer:  Ted E. Dennison
##
##
## DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
## Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
## technical or operational data or information from automatic dissemination
## under the International Exchange Program or by other means.  This protection
## covers information required solely for administrative or operational
## purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
##
## WARNING:  This document contains technical data whose export is restricted
## by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
## Executive Order 12470.  Violation of these export control laws is subject
## to severe criminal penalties.  Dissemination of this document is controlled
## under DOD Directive 5230.25
##
###############################################################################

###############################################################################
# Extra definitions for building propeller_cat files. This file will get 
# textually included into the master JPATS makefile.
###############################################################################

###############################################################################
# To add a data file to the build, place its name in the variable below. If
# it ends in .ito, it will automaticly get generated from a .csv file with 
# the same name in the same directory. This is the only part of this makefile
# that should have to change.

Propeller_Data_Files_Root = cpj.ito ctj.ito dcpn.ito fcpaa.ito \
                             ftmach.ito kcpaj.ito kcpj.ito 

###############################################################################
# Don't edit below here unless you know what you are doing!
###############################################################################

# The directory the files are located in. Any source .csv files *must* also be
# in this directory.
Propeller_Cat_Dir = data/propeller_cat/

# The full pathname of the data files
Propeller_Data_Files = $(addprefix $(Propeller_Cat_Dir), $(Propeller_Data_Files_Root))

# Add this file's data files and clean target to the full system's
Data_Files += $(Propeller_Data_Files)
Clean_Targets += propeller_cat_clean

# Copy all data files from electical_cat in the source directory into
# propeller_cat in the target directory
$(Propeller_Data_Files) : % : $(jpatsdir)%
	xcopy /k /r $(subst /,\,$<) $(subst /,\,$(dir $@))

# Clean rule
propeller_cat_clean :
	-del $(subst /,\,$(jpatsdir)$(Propeller_Cat_Dir)*.ito)
	-del /f $(subst /,\,$(Propeller_Data_Files))
	-rmdir $(subst /,\,$(Propeller_Cat_Dir))