###############################################################################
##
##           FlightSafety International Simulation Systems Division
##                    Broken Arrow, OK  USA  918-259-4000
##
##                      JPATS T-6A Flight Training Device
##
##
##  Engineer:  Ted E. Dennison
##
##
## DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
## Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
## technical or operational data or information from automatic dissemination
## under the International Exchange Program or by other means.  This protection
## covers information required solely for administrative or operational
## purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
##
## WARNING:  This document contains technical data whose export is restricted
## by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
## Executive Order 12470.  Violation of these export control laws is subject
## to severe criminal penalties.  Dissemination of this document is controlled
## under DOD Directive 5230.25
##
###############################################################################

###############################################################################
# Extra definitions for building powerplant_cat files. This file will get 
# textually included into the master JPATS makefile.
###############################################################################

###############################################################################
# To add a data file to the build, place its name in the variable below. If
# it ends in .ito, it will automaticly get generated from a .csv file with 
# the same name in the same directory. This is the only part of this makefile
# that should have to change.

Powerplant_Data_Files_Root = ditthot.ito dshpcnpn.ito ff3dcam.ito ffcngc.ito \
                             fncshpc.ito fngdmach.ito fngdngc.ito fshppla.ito \
                             hpdiff.ito hpflow.ito ipdiff.ito ipflow.ito ittcngc.ito \
                             kfmvdelt.ito kittngac.ito kittngbl.ito kngffacc.ito \
                             kngffbld.ito kshpcnp.ito kshpngac.ito kshpngbl.ito \
                             ngcffc.ito ngcfidle.ito ngcgidle.ito ngcittc.ito \
                             ngcshpc.ito ngddeclm.ito pengoil.ito plapcl.ito \
                             pclpla.ito shpcngc.ito taccng.ito tdecng.ito tittngc.ito \
                             fngpwr.ito dfngdnpl.ito dt1mach.ito ipbpump.ito \
                             shpmrp0l.ito shpmrp0h.ito \
                             shpmrp2l.ito shpmrp2h.ito \
                             shpmrp3l.ito shpmrp3h.ito \
                             shpmrp4l.ito shpmrp4h.ito \
                             shpmrp5l.ito shpmrp5h.ito \
                             shpmrp7l.ito shpmrp7h.ito dpeoilnz.ito \
                             test25.ito dngseizure.ito \
                             dnpdwf.ito dqdwf.ito
 



###############################################################################
# Don't edit below here unless you know what you are doing!
###############################################################################

# The directory the files are located in. Any source .csv files *must* also be
# in this directory.
Powerplant_Cat_Dir = data/powerplant_cat/

# The full pathname of the data files
Powerplant_Data_Files = $(addprefix $(Powerplant_Cat_Dir), $(Powerplant_Data_Files_Root))

# Add this file's data files and clean target to the full system's
Data_Files += $(Powerplant_Data_Files)
Clean_Targets += powerplant_cat_clean

# Copy all data files from electical_cat in the source directory into
# powerplant_cat in the target directory
$(Powerplant_Data_Files) : % : $(jpatsdir)%
	xcopy /k /r $(subst /,\,$<) $(subst /,\,$(dir $@))

# Clean rule
powerplant_cat_clean :
	-del $(subst /,\,$(jpatsdir)$(Powerplant_Cat_Dir)*.ito)
	-del /f $(subst /,\,$(Powerplant_Data_Files))
	-rmdir $(subst /,\,$(Powerplant_Cat_Dir))
