###############################################################################
##
##           FlightSafety International Simulation Systems Division
##                    Broken Arrow, OK  USA  918-259-4000
##
##                      JPATS T-6A Flight Training Device
##
##
##  Engineer:  Ted E. Dennison
##
##
## DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
## Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
## technical or operational data or information from automatic dissemination
## under the International Exchange Program or by other means.  This protection
## covers information required solely for administrative or operational
## purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
##
## WARNING:  This document contains technical data whose export is restricted
## by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
## Executive Order 12470.  Violation of these export control laws is subject
## to severe criminal penalties.  Dissemination of this document is controlled
## under DOD Directive 5230.25
##
###############################################################################

###############################################################################
# Extra definitions for building flight_instruments_cat files. This file will get 
# textually included into the master JPATS makefile.
###############################################################################

###############################################################################
# To add a data file to the build, place its name in the variable below. If
# it ends in .ito, it will automaticly get generated from a .csv file with 
# the same name in the same directory. This is the only part of this makefile
# that should have to change.

Flight_Instruments_Data_Files_Root = aoacal.ito ashake.ito cas_ai.ito dhpadc.ito \
ias_sa.ito tm_cai.ito vkiasadc.ito sb_alt.ito sb_ias.ito 


###############################################################################
# Don't edit below here unless you know what you are doing!
###############################################################################

# The directory the files are located in. Any source .csv files *must* also be
# in this directory.
Flight_Instruments_Cat_Dir = data/flight_instruments_cat/

# The full pathname of the data files
Flight_Instruments_Data_Files = $(addprefix $(Flight_Instruments_Cat_Dir), $(Flight_Instruments_Data_Files_Root))

# Add this file's data files and clean target to the full system's
Data_Files += $(Flight_Instruments_Data_Files)
Clean_Targets += flight_instruments_cat_clean

# Copy all data files from flight_instruments_cat in the source directory into
# flight_instruments_cat in the target directory
$(Flight_Instruments_Data_Files) : % : $(jpatsdir)%
	xcopy /k /r $(subst /,\,$<) $(subst /,\,$(dir $@))

# Clean rule
flight_instruments_cat_clean :
	-del $(subst /,\,$(jpatsdir)$(Flight_Instruments_Cat_Dir)*.ito)
	-del /f $(subst /,\,$(Flight_Instruments_Data_Files))
	-rmdir $(subst /,\,$(Flight_Instruments_Cat_Dir))