###############################################################################
##
##           FlightSafety International Simulation Systems Division
##                    Broken Arrow, OK  USA  918-259-4000
##
##                      JPATS T-6A Flight Training Device
##
##
##  Engineer:  Ted E. Dennison
##
##
## DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
## Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
## technical or operational data or information from automatic dissemination
## under the International Exchange Program or by other means.  This protection
## covers information required solely for administrative or operational
## purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
##
## WARNING:  This document contains technical data whose export is restricted
## by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
## Executive Order 12470.  Violation of these export control laws is subject
## to severe criminal penalties.  Dissemination of this document is controlled
## under DOD Directive 5230.25
##
###############################################################################

###############################################################################
# Extra definitions for building atmosphere_cat files. This file will get 
# textually included into the master JPATS makefile.
###############################################################################

###############################################################################
# To add a data file to the build, place its name in the variable below. If
# it ends in .ito, it will automaticly get generated from a .csv file with 
# the same name in the same directory. This is the only part of this makefile
# that should have to change.

Atmosphere_Data_Files_Root = dmbds.ito dmblp1.ito dmblp2.ito dmblt1.ito dmblt2.ito \
dmbrollm.ito dmbvs.ito dmbwd1.ito dmbwd2.ito dmhs1.ito dmhs2.ito dmswd.ito dmvs1.ito \
dmvs2.ito rsws.ito wsm1xv.ito wsm1yv.ito wsm1zv.ito wsm2xv.ito wsm2yv.ito wsm2zv.ito wsm3xv.ito \
wsm3yv.ito wsm3zv.ito wsm4xv.ito wsm4yv.ito wsm4zv.ito wsm5xv.ito wsm5yv.ito \
wsm5zv.ito wsm6xv.ito wsm6yv.ito wsm6zv.ito wsm7xv.ito wsm7yv.ito wsm7zv.ito \
wsm8xv.ito wsm8yv.ito wsm8zv.ito  


###############################################################################
# Don't edit below here unless you know what you are doing!
###############################################################################

# The directory the files are located in. Any source .csv files *must* also be
# in this directory.
Atmosphere_Cat_Dir = data/atmosphere_cat/

# The full pathname of the data files
Atmosphere_Data_Files = $(addprefix $(Atmosphere_Cat_Dir), $(Atmosphere_Data_Files_Root))

# Add this file's data files and clean target to the full system's
Data_Files += $(Atmosphere_Data_Files)
Clean_Targets += atmosphere_cat_clean

# Copy all data files from atmosphere_cat in the source directory into
# atmosphere_cat in the target directory
$(Atmosphere_Data_Files) : % : $(jpatsdir)%
	xcopy /k /r $(subst /,\,$<) $(subst /,\,$(dir $@))

# Clean rule
atmosphere_cat_clean :
	-del $(subst /,\,$(jpatsdir)$(Atmosphere_Cat_Dir)*.ito)
	-del /f $(subst /,\,$(Atmosphere_Data_Files))
	-rmdir $(subst /,\,$(Atmosphere_Cat_Dir))