###############################################################################
##
##           FlightSafety International Simulation Systems Division
##                    Broken Arrow, OK  USA  918-259-4000
##
##                      JPATS T-6A Flight Training Device
##
##
##  Engineer:  Ted E. Dennison
##
##
## DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
## Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
## technical or operational data or information from automatic dissemination
## under the International Exchange Program or by other means.  This protection
## covers information required solely for administrative or operational
## purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
##
## WARNING:  This document contains technical data whose export is restricted
## by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
## Executive Order 12470.  Violation of these export control laws is subject
## to severe criminal penalties.  Dissemination of this document is controlled
## under DOD Directive 5230.25
##
###############################################################################

###############################################################################
# Extra definitions for building aircraft_body_cat files. This file will get 
# textually included into the master JPATS makefile.
###############################################################################

###############################################################################
# To add a data file to the build, place its name in the variable below. If
# it ends in .ito, it will automaticly get generated from a .csv file with 
# the same name in the same directory. This is the only part of this makefile
# that should have to change.

Aircraft_Body_Data_Files_Root = fclaa.ito fcdaa.ito cd0a.ito fcmaa.ito fcyaa.ito fcnaa.ito cn0a.ito kcmaa.ito kcraa.ito cha.ito kclaa.ito dchada.ito fcraa.ito fchetab.ito kchetab.ito dcheb.ito che.ito dchede.ito dehb.ito eha.ito kehtb.ito kehta.ito fehtb.ito fehta.ito dehla.ito fehab.ito fehaa.ito dehsa.ito nha.ito fnhta.ito fnhtb.ito knht.ito knhb.ito clh.ito cdh.ito fehice.ito fehga.ito kehgh.ito fchrtab.ito kchrtab.ito chr.ito dchrdr.ito sva.ito ksvt.ito fsvtb.ito fsvta.ito fsvab.ito fsvaa.ito nva.ito knvb.ito fnvta.ito fnvtb.ito knvt.ito clv.ito cdv.ito cmvp.ito fsvb.ito ksva.ito kcldyn.ito dclwbb.ito fclwbga.ito fclta.ito fcltb.ito kclwbgh.ito kclta.ito kcltb.ito dclwbla.ito dclwbsa.ito clwbq.ito dcdwbb.ito fcdta.ito fcdtb.ito kcdta.ito kcdtb.ito dcdwbla.ito dcdwbsa.ito dcdwblt.ito dcmwbb.ito fcmta.ito fcmtb.ito kcmta.ito kcmtb.ito dcmwblb.ito dcmwbsa.ito cmwbq.ito cywba.ito fcyta.ito fcytb.ito kcyta.ito kcytb.ito cywbp.ito dcywblb.ito fcywbb.ito kcywba.ito crwba.ito fcrta.ito fcrtb.ito kcrta.ito kcrtb.ito kcrwba.ito kcrwbal.ito fcrwbb.ito crwbp.ito crwbr.ito cnwba.ito fcnta.ito fcntb.ito kcnta.ito kcntb.ito kcnwba.ito fcnwbb.ito dcnwblb.ito cnwbr.ito cnwbp.ito cdwba.ito clwba.ito cmwba.ito fclwbice.ito fcdwbga.ito kcdwbgh.ito fcdwbice.ito fcrwbgb.ito mubrake.ito muskid.ito muy.ito muyref.ito muroll.ito fstrutm.ito fstrutn.ito fstrutb.ito tdflm.ito tdfln.ito tldreff.ito tldl.ito btsf.ito bfadef.ito tsfbf.ito dhmrsprg.ito hmrsprg.ito fclwbgt.ito crwbpl.ito cnwbpl.ito dsvsa.ito dchab.ito

###############################################################################
# Don't edit below here unless you know what you are doing!
###############################################################################

# The directory the files are located in. Any source .csv files *must* also be
# in this directory.
Aircraft_Body_Cat_Dir = data/aircraft_body_cat/

# The full pathname of the data files
Aircraft_Body_Data_Files = $(addprefix $(Aircraft_Body_Cat_Dir), $(Aircraft_Body_Data_Files_Root))

# Add this file's data files and clean target to the full system's
Data_Files += $(Aircraft_Body_Data_Files)
Clean_Targets += aircraft_body_cat_clean

# Copy all data files from aircraft_body_cat in the source directory into
# aircraft_body_cat in the target directory
$(Aircraft_Body_Data_Files) : % : $(jpatsdir)%
	xcopy /k /r $(subst /,\,$<) $(subst /,\,$(dir $@))

# Clean rule
aircraft_body_cat_clean :
	-del $(subst /,\,$(jpatsdir)$(Aircraft_Body_Cat_Dir)*.ito)
	-del /f $(subst /,\,$(filter %a.ito,$(Aircraft_Body_Data_Files)))
	-del /f $(subst /,\,$(filter-out %a.ito,$(Aircraft_Body_Data_Files)))
	-rmdir $(subst /,\,$(Aircraft_Body_Cat_Dir))