﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;

namespace CAE_WEB_PROJECT.SOITable
{
    public partial class importSOITemplatedata : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            NameValueCollection nvc = Request.Form;
            string soiid = nvc["importsoiid"];
            //Response.Write("soiid: " + soiid + "<br/>");

            
            if (Request.Files["myfile"] != null)
            {
                HttpPostedFile MyFile = Request.Files["myfile"];
                string fname = Path.GetFileName(MyFile.FileName);
                string excelPath = Server.MapPath("~/files/") + Path.GetFileName(MyFile.FileName);

                MyFile.SaveAs(Server.MapPath(Path.Combine("~/files/", fname)));
                          
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;

                string conString = string.Empty;
                string extension = Path.GetExtension(MyFile.FileName);
                switch (extension)
                {
                    case ".xls": //Excel 97-03
                        conString = ConfigurationManager.ConnectionStrings["Excel03ConString"].ConnectionString;
                        break;
                    case ".xlsx": //Excel 07 or higher
                        conString = ConfigurationManager.ConnectionStrings["Excel07+ConString"].ConnectionString;
                        break;
                }
                             
                int row_number = 1;
                conString = string.Format(conString, excelPath);
                using (OleDbConnection excel_con = new OleDbConnection(conString))
                {
                    excel_con.Open();
                    string sheet1 = excel_con.GetOleDbSchemaTable(OleDbSchemaGuid.Tables, null).Rows[0]["TABLE_NAME"].ToString();

                    DataTable dtExcelData = new DataTable();

                    //[OPTIONAL]: It is recommended as otherwise the data will be considered as String by default.
                    dtExcelData.Columns.AddRange(new DataColumn[16] { new DataColumn("Id", typeof(int)),
                    new DataColumn("day", typeof(int)),
                    new DataColumn("lessid", typeof(string)),
                    new DataColumn("duration", typeof(double)),
                    new DataColumn("prebrief", typeof(double)),
                    new DataColumn("postbrief", typeof(double)),
                    new DataColumn("num_missions", typeof(int)),
                    new DataColumn("pilot", typeof(bool)),
                    new DataColumn("pilot_prereqs", typeof(string)),
                    new DataColumn("cso", typeof(bool)),
                    new DataColumn("cso_prereqs", typeof(string)),
                    new DataColumn("sma", typeof(bool)),
                    new DataColumn("sma_prereqs", typeof(string)),
                    new DataColumn("lm", typeof(bool)),
                    new DataColumn("lm_prereqs", typeof(string)),
                    new DataColumn("review", typeof(int))});

                    OleDbCommand command = new OleDbCommand("SELECT * FROM [" + sheet1 + "]", excel_con);
                    OleDbDataReader reader = command.ExecuteReader();
                                        
                    string day = "";
                    string lessid = "";
                    string duration = "";
                    string prebrief = "";
                    string postbrief = "";
                    string num_missions = "";
                    string pilot = "";
                    string pilot_prereqs = "";
                    string cso = "";
                    string cso_prereqs = "";
                    string sma = "";
                    string sma_prereqs = "";
                    string lm = "";
                    string lm_prereqs = "";
                    string review = "";
                    //List<int> lessids = new List<int>();
                    while (reader.Read())
                    {                        
                        day = reader.GetValue(0).ToString();
                        lessid = reader.GetValue(1).ToString();
                        duration = reader.GetValue(2).ToString();
                        prebrief = reader.GetValue(3).ToString();
                        postbrief = reader.GetValue(4).ToString();
                        num_missions = reader.GetValue(5).ToString();
                        pilot = reader.GetValue(6).ToString();
                        pilot_prereqs = reader.GetValue(7).ToString();
                        cso = reader.GetValue(8).ToString();
                        cso_prereqs = reader.GetValue(9).ToString();
                        sma = reader.GetValue(10).ToString();
                        sma_prereqs = reader.GetValue(11).ToString();
                        lm = reader.GetValue(12).ToString();
                        lm_prereqs = reader.GetValue(13).ToString();
                        review = reader.GetValue(14).ToString();

                        if (day == "")
                        {
                            Response.Write("<script>alert('ERROR: day field cannot be blank! Check Row Number: " + row_number + "')</script>");
                            Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                            excel_con.Close();
                            return;
                        }
                        if (lessid == "")
                        {
                            Response.Write("<script>alert('ERROR: lessid field cannot be blank! Check Row Number: " + row_number + "')</script>");
                            Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                            excel_con.Close();
                            return;
                        }
                        if (duration == "")
                        {
                            duration = "0";
                        }
                        if (prebrief == "")
                        {
                            prebrief = "0";
                        }
                        if (postbrief == "")
                        {
                            postbrief = "0";
                        }
                        if (num_missions == "")
                        {
                            num_missions = "0";
                        }
                        if (pilot == "")
                        {
                            pilot = "False";
                        }
                        if (cso == "")
                        {
                            cso = "False";
                        }
                        if (sma == "")
                        {
                            sma = "False";
                        }
                        if (lm == "")
                        {
                            lm = "False";
                        }
                        if (pilot_prereqs == "")
                        {
                            pilot_prereqs = "None";
                        }
                        if (cso_prereqs == "")
                        {
                            cso_prereqs = "None";
                        }
                        if (sma_prereqs == "")
                        {
                            sma_prereqs = "None";
                        }
                        if (lm_prereqs == "")
                        {
                            lm_prereqs = "None";
                        }
                        if (review == "")
                        {
                            review = "0";
                        }
                        /*
                        day = (int)reader.GetValue(0);
                        lessid = (string)reader.GetValue(1);
                        duration = (double)reader.GetValue(2);
                        prebrief = (double)reader.GetValue(3);
                        postbrief = (double)reader.GetValue(4);
                        num_missions = (int)reader.GetValue(5);
                        pilot = (string)reader.GetValue(6);
                        pilot_prereqs = (string)reader.GetValue(7);
                        cso = (string)reader.GetValue(8);
                        cso_prereqs = (string)reader.GetValue(9);
                        sma = (string)reader.GetValue(10);
                        sma_prereqs = (string)reader.GetValue(11);
                        lm = (string)reader.GetValue(12);
                        lm_prereqs = (string)reader.GetValue(13);
                        review = (int)reader.GetValue(14);
                        */

                        SqlConnection con3 = new SqlConnection(cs);
                        con3.Open();
                        SqlCommand cmd3 = new SqlCommand("SELECT * from lesson where lessnumber='" + lessid + "'");
                        cmd3.Connection = con3;
                        SqlDataReader reader3 = cmd3.ExecuteReader();
                        {
                            if (reader3.HasRows)
                            {
                                while (reader3.Read())
                                {
                                    //convert lessnumber to lessid
                                    //Response.Write("lessnumber: " + lessid + "<br/>");
                                    lessid = reader3["lessid"].ToString();
                                    //int lessidint = Convert.ToInt32(lessid);
                                    //lessids.Add(lessidint);

                                    /*
                                    Response.Write("day: " + day + "<br/>");
                                    Response.Write("lessid: " + lessid + "<br/>");
                                    Response.Write("duration: " + duration + "<br/>");
                                    Response.Write("prebrief: " + prebrief + "<br/>");
                                    Response.Write("postbrief: " + postbrief + "<br/>");
                                    Response.Write("num_missions: " + num_missions + "<br/>");
                                    Response.Write("pilot: " + pilot + "<br/>");
                                    */

                                    if (pilot_prereqs != "None")
                                    {
                                        List<int> pilot_prereq_lessids = new List<int>();
                                        List<string> pilot_prereqs_list = pilot_prereqs.Split(',').ToList();                             

                                        for (int i = 0; i < pilot_prereqs_list.Count; i++)
                                        {
                                            SqlConnection con5 = new SqlConnection(cs);
                                            con5.Open();
                                            SqlCommand cmd5 = new SqlCommand("SELECT lessid from lesson where lessnumber='" + pilot_prereqs_list[i] + "'");
                                            cmd5.Connection = con5;
                                            SqlDataReader reader5 = cmd5.ExecuteReader();
                                            {
                                                if (reader5.HasRows)
                                                {
                                                    while (reader5.Read())
                                                    {
                                                        //convert lessnumber to lessid                                                   
                                                        string pilot_prereq_lessid = reader5["lessid"].ToString();
                                                        int pilot_prereq_lessidint = Convert.ToInt32(pilot_prereq_lessid);
                                                        pilot_prereq_lessids.Add(pilot_prereq_lessidint);
                                                    }
                                                }
                                                else
                                                {
                                                    Response.Write("<script>alert('ERROR: Lesson Number " + pilot_prereqs_list[i] + " does not exist in database! Check the pilot_prereqs column for errors!')</script>");
                                                    Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                                                    con3.Dispose();
                                                    con5.Dispose();
                                                    excel_con.Close();
                                                    return;
                                                }
                                            }
                                            con5.Dispose();
                                        }
                                        pilot_prereqs = string.Join(",", pilot_prereq_lessids);
                                    }

                                    //Response.Write("pilot_prereqs: " + pilot_prereqs + "<br/>");
                                    //Response.Write("cso: " + cso + "<br/>");

                                    if (cso_prereqs != "None")
                                    {
                                        List<int> cso_prereq_lessids = new List<int>();
                                        List<string> cso_prereqs_list = cso_prereqs.Split(',').ToList();

                                        for (int i = 0; i < cso_prereqs_list.Count; i++)
                                        {
                                            SqlConnection con5 = new SqlConnection(cs);
                                            con5.Open();
                                            SqlCommand cmd5 = new SqlCommand("SELECT lessid from lesson where lessnumber='" + cso_prereqs_list[i] + "'");
                                            cmd5.Connection = con5;
                                            SqlDataReader reader5 = cmd5.ExecuteReader();
                                            {
                                                if (reader5.HasRows)
                                                {
                                                    while (reader5.Read())
                                                    {
                                                        //convert lessnumber to lessid                                                   
                                                        string cso_prereq_lessid = reader5["lessid"].ToString();
                                                        int cso_prereq_lessidint = Convert.ToInt32(cso_prereq_lessid);
                                                        cso_prereq_lessids.Add(cso_prereq_lessidint);
                                                    }
                                                }
                                                else
                                                {
                                                    Response.Write("<script>alert('ERROR: Lesson Number " + cso_prereqs_list[i] + " does not exist in database! Check the cso_prereqs column for errors!')</script>");
                                                    Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                                                    con3.Dispose();
                                                    con5.Dispose();
                                                    excel_con.Close();
                                                    return;
                                                }
                                            }
                                            con5.Dispose();
                                        }
                                        cso_prereqs = string.Join(",", cso_prereq_lessids);
                                    }

                                    //Response.Write("cso_prereqs: " + cso_prereqs + "<br/>");
                                    //Response.Write("sma: " + sma + "<br/>");

                                    if (sma_prereqs != "None")
                                    {
                                        List<int> sma_prereq_lessids = new List<int>();
                                        List<string> sma_prereqs_list = sma_prereqs.Split(',').ToList();

                                        for (int i = 0; i < sma_prereqs_list.Count; i++)
                                        {
                                            SqlConnection con5 = new SqlConnection(cs);
                                            con5.Open();
                                            SqlCommand cmd5 = new SqlCommand("SELECT lessid from lesson where lessnumber='" + sma_prereqs_list[i] + "'");
                                            cmd5.Connection = con5;
                                            SqlDataReader reader5 = cmd5.ExecuteReader();
                                            {
                                                if (reader5.HasRows)
                                                {
                                                    while (reader5.Read())
                                                    {
                                                        //convert lessnumber to lessid                                                   
                                                        string sma_prereq_lessid = reader5["lessid"].ToString();
                                                        int sma_prereq_lessidint = Convert.ToInt32(sma_prereq_lessid);
                                                        sma_prereq_lessids.Add(sma_prereq_lessidint);
                                                    }
                                                }
                                                else
                                                {
                                                    Response.Write("<script>alert('ERROR: Lesson Number " + sma_prereqs_list[i] + " does not exist in database! Check the sma_prereqs column for errors!')</script>");
                                                    Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                                                    con3.Dispose();
                                                    con5.Dispose();
                                                    excel_con.Close();
                                                    return;
                                                }
                                            }
                                            con5.Dispose();
                                        }
                                        sma_prereqs = string.Join(",", sma_prereq_lessids);
                                    }

                                    //Response.Write("sma_prereqs: " + sma_prereqs + "<br/>");
                                    //Response.Write("lm: " + lm + "<br/>");                                                                       
                                    
                                    if (lm_prereqs != "None")
                                    {
                                        List<int> lm_prereq_lessids = new List<int>();
                                        List<string> lm_prereqs_list = lm_prereqs.Split(',').ToList();
                                        //Response.Write("lm_prereqs_list: " + lm_prereqs_list[0] + "  lm_prereqs_count: " + lm_prereqs_list.Count + "<br/>");
                                        
                                        for (int i = 0; i < lm_prereqs_list.Count; i++)
                                        {
                                            SqlConnection con5 = new SqlConnection(cs);
                                            con5.Open();
                                            SqlCommand cmd5 = new SqlCommand("SELECT lessid from lesson where lessnumber='" + lm_prereqs_list[i] + "'");
                                            cmd5.Connection = con5;
                                            SqlDataReader reader5 = cmd5.ExecuteReader();
                                            {
                                                if (reader5.HasRows)
                                                {
                                                    while (reader5.Read())
                                                    {
                                                        //convert lessnumber to lessid                                                   
                                                        string lm_prereq_lessid = reader5["lessid"].ToString();
                                                        int lm_prereq_lessidint = Convert.ToInt32(lm_prereq_lessid);
                                                        lm_prereq_lessids.Add(lm_prereq_lessidint);
                                                    }
                                                }
                                                else
                                                {
                                                    Response.Write("<script>alert('ERROR: Lesson Number " + lm_prereqs_list[i] + " does not exist in database! Check the lm_prereqs column for errors!')</script>");
                                                    Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                                                    con3.Dispose();
                                                    con5.Dispose();
                                                    excel_con.Close();
                                                    return;
                                                }
                                            }
                                            con5.Dispose();
                                        }
                                        lm_prereqs = string.Join(",", lm_prereq_lessids);                                        
                                    }               
                                    
                                    //Response.Write("lm_prereqs: " + lm_prereqs + "<br/>");
                                    //Response.Write("review: " + review + "<br/><br/>");

                                    
                                    SqlConnection con4 = new SqlConnection(cs);
                                    SqlCommand cmd4 = new SqlCommand("insert into Builds_templates (soiid, row_number, day, lessid, duration, prebrief, postbrief, num_missions, pilot, pilot_prereqs, cso, cso_prereqs, sma, sma_prereqs, lm, lm_prereqs, review) values (" + soiid + "," + row_number + "," +
                                        day + "," + lessid + "," + duration + "," + prebrief + "," + postbrief + "," + num_missions + ",'" + pilot + "','" + pilot_prereqs + "','" +
                                        cso + "','" + cso_prereqs + "','" + sma + "','" + sma_prereqs + "','" + lm + "','" + lm_prereqs + "','" + review + "')", con4);
                                    con4.Open();
                                    cmd4.ExecuteNonQuery();
                                    con4.Dispose();
                                    
                                    row_number++;
                                }
                            }
                            else
                            {
                                Response.Write("<script>alert('ERROR: Lesson Number " + lessid + " does not exist in database!')</script>");
                                Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                                con3.Dispose();
                                excel_con.Close();
                                return;
                            }
                        }
                        con3.Dispose();                                    
                    }
                    reader.Close();

                    Response.Write("<script>alert('Import Successful')</script>");
                    Response.Write("<script>window.location.href='../SOITable/newsoitable.aspx?soiid=" + soiid + "'</script>");
                }
            }    
        }
    }
}