﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class PubReport : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string pubid = Request.QueryString["pubid"];
            if (String.IsNullOrEmpty(pubid))
            {
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("PUBSQUERY");
                var worksheet = excel.Workbook.Worksheets["PUBSQUERY"];
                var headerLabels = new List<string[]>()
                  {
                    new string[] { "PUBID","PUBNUMBER","PUBNAME","LESSNUMBER", "REV", "REV DATE", "LESSTITLE" }
                  };
                string Range = "A1:" + Char.ConvertFromUtf32(headerLabels[0].Length + 64) + "1";
                var headerCells = worksheet.Cells[Range];
                headerCells.LoadFromArrays(headerLabels);
                headerCells.Style.Fill.PatternType = OfficeOpenXml.Style.ExcelFillStyle.Solid;
                headerCells.Style.Fill.BackgroundColor.SetColor(System.Drawing.Color.DeepSkyBlue);
                worksheet.View.FreezePanes(2, 1); // Freeze the header cells row

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/PUBSQUERY.xlsx"));
                
                int rowcounter = 2;
                DbToWeb myConverter = new DbToWeb();
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                string[] stmtArray = {
                    "SELECT p.PUBID, p.PUBNUMBER, p.PUBNAME, l.LESSNUMBER, l.LESSTITLE, l.LESSREV, l.REVDATE ",
                    "from PUBS p, LESSON l, PUBLESS pl where p.PUBID=", pubid, " and pl.PUBLESSIDFK=", pubid,
                    " and l.LESSID=pl.LESSPUBIDFK and l.MP!=1"
                };
                SqlCommand cmd = new SqlCommand(String.Join("", stmtArray));
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string PUBID = reader["PUBID"].ToString();
                        int PUBIDINT = Int32.Parse(PUBID);
                        string PUBNUMBER = reader["PUBNUMBER"].ToString();
                        string PUBNAME = reader["PUBNAME"].ToString();
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();
                        string revCode = myConverter.getRevName(reader["LESSREV"].ToString(), cs);
                        string revDate = myConverter.interpretDate(reader["REVDATE"].ToString());

                        var Data = new List<object[]>()
                        {
                            new object[] { PUBIDINT, PUBNUMBER, PUBNAME, LESSNUMBER, revCode, revDate, LESSTITLE },  
                        };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        // Removed AutoFitColumns()
                        rowcounter++;
                    }
                }
                con.Dispose();

                worksheet.Column(1).Width = 8;     // PUBID
                worksheet.Column(2).Width = 24;    // PUB NUMBER
                worksheet.Column(2).Style.WrapText = true;
                worksheet.Column(3).Width = 60;    // PUBNAME
                worksheet.Column(3).Style.WrapText = true;
                worksheet.Column(4).Width = 22;    // LESSNUMBER
                worksheet.Column(4).Style.WrapText = true;
                worksheet.Column(5).Width = 4;     // REV
                worksheet.Column(6).Width = 12;    // REV DATE
                worksheet.Column(7).Width = 60;    // LESSTITLE
                worksheet.Column(7).Style.WrapText = true;

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/PUBSQUERY.xlsx"));           
            Response.Redirect("../files/PUBSQUERY.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();           
        }
    }
}