﻿<%@ Page Title="Publications" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Publications.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.Publications" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var PUBID;
    var PUBNUMBER;
    var PUBNAME;
    var PUBDATE;    
    var REV;
    var LESSONS;
    var PUBREV;
    var selid;

    $(document).ready(function () {
        $(function () {
            $("#PUBDATE").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#EditPUBDATE").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $.ajax({
            url: 'getpublications.asmx/GetPublications',
            method: 'post',
            dataType: 'json',
            success: function (data) {
                $('#example').dataTable({
                    "bPaginate": false,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bInfo": true,
                    "bAutoWidth": true,
                    "scrollY": "400px",
                    "sScrollX": "100%",
                    "sScrollXInner": "100%",
                    "scrollCollapse": true,
                    "language": {
                        "emptyTable": "No Publications"
                    },
                    data: data,
                    columns: [
                        { 'data': 'PUBID' },
                        { 'data': 'PUBNUMBER' },
                        { 'data': 'PUBNAME' },
                        { 'data': 'PUBDATE' },
                        { 'data': 'REV' },
                        { 'data': 'LESSONS' },     
                        { 'data': 'PUBREV', "visible": false },
                        { 'data': 'Id', "visible": false }
                    ]
                });
                var table = $('#example').DataTable();

                $('#example tbody').on('click', 'tr', function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        selid = null;
                    }
                    else {
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        var data = table.row(this).data();
                        //const myJSON = JSON.stringify(data);
                        //alert(myJSON);                        
                        savedata(data);
                    }
                });
            }
        });
    });

    function savedata(rowdata) {
        PUBID = rowdata.PUBID;
        PUBNUMBER = rowdata.PUBNUMBER;
        PUBNAME = rowdata.PUBNAME;
        PUBDATE = rowdata.PUBDATE;
        REV = rowdata.REV; 
        LESSONS = rowdata.LESSONS;
        PUBREV = rowdata.PUBREV;
        selid = rowdata.Id;
    }

    function addPUB() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }

    function editdata() {       
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#EditPUBNUMBER').val(PUBNUMBER);
            $('#EditPUBNAME').val(PUBNAME);
            $('#EditPUBDATE').val(PUBDATE);
            $('#EditPUBREV').val(PUBREV);        
        }
    }

    function deletedata() {      
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this publication?") == true) {
                window.location.href = "../CAT/deletePUB.aspx?selid=" + selid;
            } else {
                return;
            }
        }
    }

    function checkdups() {
        window.location.href = "../CAT/pubduplicates.aspx";
    }

    function checkDate(form) {
        var PUBdateString = form.PUBDATE.value;

        if (PUBdateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(PUBdateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = PUBdateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }    
        }
    }

    function checkDate2(form) {
        var PUBdateString = form.EditPUBDATE.value;  

        if (PUBdateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(PUBdateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = PUBdateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }
        }
    }
</script>

<style>
#main {
    overflow-x: hidden;
}

@media screen and (max-width: 1300px) {
  #myModal{
        width: 525px;
    }
  #myModal2{
        width: 525px;
    }
}

.modal{
    width: 1700px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Publications</h1></div>
<hr />
<div id="PUBTable" style="margin: 35px;">
<div style="min-width: 500px;">
    <asp:Label ID="Label4" runat="server" /> 
</div>
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th style="width: 50px;">PUB ID</th>
                <th style="width: 200px; min-width: 200px;">PUB Number</th>    
                <th style="width: 300px; min-width: 300px;">PUB Name</th>  
                <th style="width: 50px;">PUB Date</th>                 
                <th style="width: 50px;">PUB Rev</th> 
                <th style="width: 600px; min-width: 600px;">Associated Lessons</th>
                <th style="display:none;">Rev</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add New Publication</h4><br />
       <form class="form login" name="form1" action="../CAT/addPUB.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate(this)">
       <div class="form__field">
       <input style="color: white" type="text" name="PUBNUMBER" id="PUBNUMBER" placeholder="PUB Number" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="PUBNAME" id="PUBNAME" placeholder="PUB Name" required="required"/>
       </div>
       <div class="form__field" style="color: black">
       <input id="PUBDATE" name="PUBDATE" type="text" placeholder="PUB Date" style="color: white" autocomplete="off" />
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="PUBREV" name="PUBREV" style="width: 100%;">
                 <asp:Label ID="Label2" runat="server" />  
            </select>
       </div>
       <div class="form__field">
       <input type="submit" value="Submit" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Publication</h4><br />
       <form class="form login" name="form1" action="../CAT/editPUBrow.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate2(this)">
       <input type="hidden" name="editid" id="editid" />   
       <div class="form__field">
       <input style="color: white" type="text" name="EditPUBNUMBER" id="EditPUBNUMBER" placeholder="PUB Number" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="EditPUBNAME" id="EditPUBNAME" placeholder="PUB Name" required="required"/>
       </div>
       <div class="form__field" style="color: black">
       <input id="EditPUBDATE" name="EditPUBDATE" type="text" placeholder="PUB Date" style="color: white" autocomplete="off" />
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="EditPUBREV" name="EditPUBREV" style="width: 100%;">
                 <asp:Label ID="Label3" runat="server" />  
            </select>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
