﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using iText.Kernel.Colors;
using iText.Kernel.Pdf;
using iText.Kernel.Pdf.Canvas;
using iText.Kernel.Font;
using iText.Layout;
using iText.Layout.Element;
using iText.Layout.Properties;
using iText.Layout.Renderer;
using iText.Layout.Borders;
using iText.IO.Font.Constants;
using iText.Kernel.Pdf.Canvas.Draw;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class rptFEA : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            bool showDebugMsg = false;
            string type = Request.QueryString["type"];

            /*
            Type 1 = Standard FEA
            Type 2 = MESL FEA
            Type 3 = FOUO FEA
            Type 4 = Verification Report 
            */

            string lessid = Request.QueryString["lessid"];
            if (lessid == null)
            {
                Response.Write("<script>alert('Error: No Lesson ID')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }
            DbToWeb myConverter = new DbToWeb();
            string lessnumber = "";
            string lesstitle = "";
            string feadate = "";
            string media = ""; 
            string lessnote = "";
            string mesl = "";
            string classification = "";
            string rev = "";
            string revdate = "";
            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand("SELECT * from Lesson where lessid=" + lessid);
            cmd.Connection = con;
            SqlDataReader reader = cmd.ExecuteReader();
            {
                if (reader.Read())
                {
                    lessnumber = reader["lessnumber"].ToString();
                    lesstitle = reader["lesstitle"].ToString();
                    feadate = myConverter.interpretDate(reader["feadate"].ToString());
                    media = reader["mediaiku"].ToString();
                    if (media != "")
                    {
                        SqlConnection con2 = new SqlConnection(cs);
                        con2.Open();
                        SqlCommand cmd2 = new SqlCommand("SELECT * from MEDIAIku where id=" + media);
                        cmd2.Connection = con2;
                        SqlDataReader reader2 = cmd2.ExecuteReader();
                        {
                            while (reader2.Read())
                            {
                                media = reader2["media"].ToString();
                            }
                        }
                        con2.Dispose();
                    }                   
                    lessnote = reader["lessnote"].ToString();
                    mesl = reader["mesl"].ToString();
                    classification = reader["classification"].ToString();
                    if (classification != "")
                    {                        
                        SqlConnection con3 = new SqlConnection(cs);
                        con3.Open();
                        SqlCommand cmd3 = new SqlCommand("SELECT * from CLASSIFICATION where id=" + classification);
                        cmd3.Connection = con3;
                        SqlDataReader reader3 = cmd3.ExecuteReader();
                        {
                            while (reader3.Read())
                            {
                                classification = reader3["classification"].ToString();
                            }
                        }
                        con3.Dispose();
                    }
                    rev = reader["lessrev"].ToString();
                    if (rev != "")
                    {
                        SqlConnection con3 = new SqlConnection(cs);
                        con3.Open();
                        SqlCommand cmd3 = new SqlCommand("SELECT * from REViku where id=" + rev);
                        cmd3.Connection = con3;
                        SqlDataReader reader3 = cmd3.ExecuteReader();
                        {
                            while (reader3.Read())
                            {
                                rev = reader3["rev"].ToString();
                            }
                        }
                        con3.Dispose();
                    }
                    revdate = myConverter.interpretDate(reader["revdate"].ToString());
                }
            }
            con.Dispose();

            string objnumber = "";
            int objvCount = 0;
            SqlConnection con4 = new SqlConnection(cs);
            con4.Open();
            SqlCommand cmd4 = new SqlCommand("SELECT count(*) as totalobj from Objectives where lessidfk=" + lessid);
            cmd4.Connection = con4;
            SqlDataReader reader4 = cmd4.ExecuteReader();
            {
                while (reader4.Read())
                {
                    string totalobj = reader4["totalobj"].ToString();
                    objvCount = Int32.Parse(totalobj);
                }
            }
            con4.Dispose();

            MemoryStream baos = new MemoryStream();
            PdfWriter writer = new PdfWriter(baos);
            PdfDocument pdfDocument = new PdfDocument(writer.SetSmartMode(true));

            Document d = new Document(pdfDocument, iText.Kernel.Geom.PageSize.LETTER);
            PdfFont bold = PdfFontFactory.CreateFont(StandardFonts.HELVETICA_BOLD);           

            d.SetTextAlignment(TextAlignment.CENTER);
            string pdftitle = "AIRCREW TRAINING AND REHEARSAL SUPPORT";               
            Text text1 = new Text(pdftitle).SetFont(bold);         
            Text text2 = new Text("Lesson Front End Analysis Report").SetFont(bold);
       
            d.Add(new Paragraph(text1));
            d.Add(new Paragraph(text2));

            SolidLine line = new SolidLine(1f);
            LineSeparator ls = new LineSeparator(line);

            d.Add(ls);
            d.Add(ls);

            if (type == "3")
            {
                Text textFOUO = new Text("This document contains FOUO information. All page/portion markings contained within reflect the original, source referenced, U.S. Government document. " +
                    "Further questions regarding specific FOUO content (e.g., portion markings not enumerated) should be directed to the responsible U.S. Government representative(s).").SetFontSize(9);
                d.Add(new Paragraph(textFOUO));
            }

            d.Add(new Paragraph(""));
            Text text3 = new Text("Lesson Identifier:").SetFont(bold);
            Text text4 = new Text(lessnumber);
            Text text5 = new Text("Lesson Title:").SetFont(bold);
            Text text6 = new Text(lesstitle);
            iText.Layout.Element.Table table = new iText.Layout.Element.Table(new float[] { 25, 25, 25, 25, 25 });   
                Cell cell11 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text3));                
                Cell cell12 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text4));
                Cell cell13 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(""));
                Cell cell14 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text5));
                Cell cell15 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text6));
            table.AddCell(cell11);
            table.AddCell(cell12);
            table.AddCell(cell13);
            table.AddCell(cell14);
            table.AddCell(cell15);
            d.Add(table);

            if (type == "4")
            {
                d.Add(new Paragraph(""));
                Text text32 = new Text("Rev:").SetFont(bold);
                Text text33 = new Text(rev);
                Text text34 = new Text("Rev Date:").SetFont(bold);
                Text text35 = new Text(revdate);
                iText.Layout.Element.Table table10 = new iText.Layout.Element.Table(new float[] { 25, 25, 25, 25, 25 });
                    Cell cell101 = new Cell(1, 1)   
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .SetTextAlignment(TextAlignment.LEFT)
                    .Add(new Paragraph(text32));
                    Cell cell102 = new Cell(1, 1)          
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .SetTextAlignment(TextAlignment.LEFT)
                    .Add(new Paragraph(text33));
                    Cell cell103 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(""));
                    Cell cell104 = new Cell(1, 1)       
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .SetTextAlignment(TextAlignment.LEFT)
                    .Add(new Paragraph(text34));
                    Cell cell105 = new Cell(1, 1)           
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .SetTextAlignment(TextAlignment.LEFT)
                    .Add(new Paragraph(text35));
                table10.AddCell(cell101);
                table10.AddCell(cell102);
                table10.AddCell(cell103);
                table10.AddCell(cell104);
                table10.AddCell(cell105);
                d.Add(table10);
            }

            d.Add(new Paragraph(""));
            Text text7 = new Text("FEA Date:").SetFont(bold);
            Text text8 = new Text(feadate);
            Text text9 = new Text("Media:").SetFont(bold);
            Text text10 = new Text(media);

            iText.Layout.Element.Table table2 = new iText.Layout.Element.Table(new float[] { 25, 25, 25, 25, 25, 25, 25, 25 });
                Cell cell21 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text7));
                Cell cell22 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text8));
                Cell cell23 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(""));
                Cell cell24 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text9));
                Cell cell25 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(text10));
                Cell cell26 = new Cell(1, 1)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .Add(new Paragraph(""));
            table2.AddCell(cell21);
            table2.AddCell(cell22);
            table2.AddCell(cell23);
            table2.AddCell(cell24);
            table2.AddCell(cell25);
            table2.AddCell(cell26);       
            d.Add(table2);

            d.Add(new Paragraph(""));
            Text text13 = new Text("Lesson Note:").SetFont(bold);
            Text text14 = new Text(lessnote);     
            iText.Layout.Element.Table table3 = new iText.Layout.Element.Table(new float[] { 25, 25 });
                Cell cell31 = new Cell(1, 1)
                .SetWidth(65)            
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .SetTextAlignment(TextAlignment.LEFT)
                .Add(new Paragraph(text13));
                Cell cell32 = new Cell(1, 1)
                .SetWidth(400)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .SetTextAlignment(TextAlignment.LEFT)
                .Add(new Paragraph(text14));
            table3.AddCell(cell31);
            table3.AddCell(cell32);
            d.Add(table3);

            if (type == "2" || type == "4")
            {
                d.Add(new Paragraph(""));
                Text text30 = new Text("MESL:").SetFont(bold);
                Text text31 = new Text(mesl);
                iText.Layout.Element.Table table9 = new iText.Layout.Element.Table(new float[] { 25, 25 });
                Cell cell91 = new Cell(1, 1)
                .SetWidth(35)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .SetTextAlignment(TextAlignment.LEFT)
                .Add(new Paragraph(text30));
                Cell cell92 = new Cell(1, 1)
                .SetWidth(500)
                .SetBorder(Border.NO_BORDER)
                .SetFontSize(10)
                .SetTextAlignment(TextAlignment.LEFT)
                .Add(new Paragraph(text31));
                table9.AddCell(cell91);
                table9.AddCell(cell92);
                d.Add(table9);
            }

            d.Add(new Paragraph(""));
            Text text15 = new Text("Classification:").SetFont(bold);
            classification = classification.ToUpper();
            Text text16 = new Text(classification);
            iText.Layout.Element.Table table4 = new iText.Layout.Element.Table(new float[] { 25, 25 });
            Cell cell41 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetFontSize(10)
            .Add(new Paragraph(text15));
            Cell cell42 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetFontSize(10)
            .Add(new Paragraph(text16));
            table4.AddCell(cell41);
            table4.AddCell(cell42);
            d.Add(table4);
            d.Add(ls);

            //Include publications and categories for verification report
            if (type == "4")
            {
                d.Add(new Paragraph("Publications:").SetFont(bold).SetTextAlignment(TextAlignment.LEFT));
                iText.Layout.Element.Table table11 = new iText.Layout.Element.Table(new float[] { 15, 15, 15, 15, 15 });
                SqlConnection con7 = new SqlConnection(cs);
                con7.Open();
                SqlCommand cmd7 = new SqlCommand("SELECT * from PUBLESS where LESSPUBIDfk=" + lessid);
                cmd7.Connection = con7;
                SqlDataReader reader7 = cmd7.ExecuteReader();
                {
                    while (reader7.Read())
                    {
                        string PUBLESSIDFK = reader7["PUBLESSIDFK"].ToString();
                        if (PUBLESSIDFK != "")
                        {
                            SqlConnection con8 = new SqlConnection(cs);
                            con8.Open();
                            SqlCommand cmd8 = new SqlCommand("SELECT * from PUBS where PUBID=" + PUBLESSIDFK);
                            cmd8.Connection = con8;
                            SqlDataReader reader8 = cmd8.ExecuteReader();
                            {
                                while (reader8.Read())
                                {                       
                                    string PUBNUMBER = reader8["PUBNUMBER"].ToString();
                                    string PUBNAME = reader8["PUBNAME"].ToString();
                                    
                                    Text text32 = new Text("Pub ID:").SetFont(bold);
                                    Text text33 = new Text(PUBNUMBER);
                                    Text text34 = new Text("Pub Title:").SetFont(bold);
                                    Text text35 = new Text(PUBNAME);
                                    
                                    Cell cell111 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetTextAlignment(TextAlignment.LEFT)
                                    .SetWidth(65)
                                    .Add(new Paragraph(text32));
                                    Cell cell112 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetTextAlignment(TextAlignment.LEFT)
                                    .SetWidth(200)
                                    .Add(new Paragraph(text33));
                                    Cell cell113 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetWidth(20)
                                    .Add(new Paragraph(""));
                                    Cell cell114 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetTextAlignment(TextAlignment.LEFT)
                                    .SetWidth(65)
                                    .Add(new Paragraph(text34));
                                    Cell cell115 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetTextAlignment(TextAlignment.LEFT)
                                    .SetWidth(300)
                                    .Add(new Paragraph(text35));
                                    table11.AddCell(cell111);
                                    table11.AddCell(cell112);
                                    table11.AddCell(cell113);
                                    table11.AddCell(cell114);
                                    table11.AddCell(cell115);                                                                      
                                }
                            }
                            con8.Dispose();
                        }
                    }
                }
                con7.Dispose();
                d.Add(table11);
                d.Add(ls);
                /***************** End Publications ******************/

                d.Add(new Paragraph("Categories:").SetFont(bold).SetTextAlignment(TextAlignment.LEFT));
                iText.Layout.Element.Table table12 = new iText.Layout.Element.Table(new float[] { 15, 15 });
                SqlConnection con9 = new SqlConnection(cs);
                con9.Open();
                SqlCommand cmd9 = new SqlCommand("SELECT * from TOPICLESS where LESSIDfkTOPIC=" + lessid);
                cmd9.Connection = con9;
                SqlDataReader reader9 = cmd9.ExecuteReader();
                {
                    while (reader9.Read())
                    {
                        string TOPICIDFKLESS = reader9["TOPICIDFKLESS"].ToString();
                        if (TOPICIDFKLESS == "")
                        {
                            TOPICIDFKLESS = "0";
                        }
                        if (TOPICIDFKLESS != "")
                        {
                            SqlConnection con10 = new SqlConnection(cs);
                            con10.Open();
                            SqlCommand cmd10 = new SqlCommand("SELECT * from TOPICS where TOPICID=" + TOPICIDFKLESS);
                            cmd10.Connection = con10;
                            SqlDataReader reader10 = cmd10.ExecuteReader();
                            {
                                while (reader10.Read())
                                {
                                    string TOPIC = reader10["TOPIC"].ToString();                                 

                                    Text text32 = new Text("Topic:").SetFont(bold);
                                    Text text33 = new Text(TOPIC);                          

                                    Cell cell121 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetTextAlignment(TextAlignment.LEFT)                             
                                    .Add(new Paragraph(text32));
                                    Cell cell122 = new Cell(1, 1)
                                    .SetBorder(Border.NO_BORDER)
                                    .SetFontSize(10)
                                    .SetTextAlignment(TextAlignment.LEFT)                               
                                    .Add(new Paragraph(text33));    
                                    table12.AddCell(cell121);
                                    table12.AddCell(cell122);                             
                                }
                            }
                            con10.Dispose();
                        }
                    }
                }
                con9.Dispose();
                d.Add(table12);
                d.Add(ls);
                /***************** End Categories ******************/
            }

            if (objvCount != 0)
            {
                for (int i = 1; i <= objvCount; i++)
                {                   
                    var objid = new List<string>();
                    var objDescList = new List<string>();
                    var objrpl = new List<string>();

                    SqlConnection con5 = new SqlConnection(cs);
                    con5.Open();
                    SqlCommand cmd5 = new SqlCommand("SELECT * from Objectives where lessidfk=" + lessid + " order by id");
                    cmd5.Connection = con5;
                    SqlDataReader reader5 = cmd5.ExecuteReader();
                    {
                        while (reader5.Read())
                        {
                            string objdesc = reader5["objdesc"].ToString();
                            if (objdesc == "")
                            {
                                Response.Write("<script>alert('At least one of the objectives was left blank!')</script>");
                                if (type == "4")
                                {
                                    string jScript = "<script>window.close();</script>";
                                    ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                                }
                                else
                                {
                                    Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                                }
                                con5.Dispose();
                                return;
                            }
                            objnumber = "No. " + i;

                            objrpl.Add(myConverter.getRPLName(reader5["rpl"].ToString(), cs));
                            objDescList.Add(reader5["objdesc"].ToString());
                            objid.Add(reader5["objid"].ToString());                        
                        }
                    }
                    con5.Dispose();

                    var objidArray = objid.ToArray();
                    var objdescArray = objDescList.ToArray();
                    var objrplArray = objrpl.ToArray();
                    

                    d.Add(new Paragraph(""));
                    Text text17 = new Text("Objective:").SetFont(bold);          
                    Text text18 = new Text(objnumber);
                    Text text19 = new Text("RPL:").SetFont(bold);
                    Text text20 = new Text(objrplArray[i-1]);
                    Text text21 = new Text(objdescArray[i-1]);
                    iText.Layout.Element.Table table5 = new iText.Layout.Element.Table(new float[] { 25, 30, 25, 25, 25, 25, 25 });
                    Cell cell51 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(text17));
                    Cell cell52 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(text18));
                    Cell cell53 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(""));
                    Cell cell54 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(text19));
                    Cell cell55 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(text20));
                    Cell cell56 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .Add(new Paragraph(""));
                    Cell cell57 = new Cell(1, 1)
                    .SetBorder(Border.NO_BORDER)
                    .SetFontSize(10)
                    .SetTextAlignment(TextAlignment.LEFT)
                    .Add(new Paragraph(text21));
                    table5.AddCell(cell51);
                    table5.AddCell(cell52);
                    table5.AddCell(cell53);
                    table5.AddCell(cell54);
                    table5.AddCell(cell55);
                    table5.AddCell(cell56);
                    table5.AddCell(cell57);
                    d.Add(table5);
                    d.Add(ls);

                    string questionnum = "";                     
                    int questioncounter = 0;

                    SqlConnection con6 = new SqlConnection(cs);
                    con6.Open();
                    SqlCommand cmd6 = new SqlCommand("SELECT count(*) as questioncounter from QUESTION where objidfk=" + objidArray[i-1]);
                    cmd6.Connection = con6;
                    SqlDataReader reader6 = cmd6.ExecuteReader();
                    {
                        while (reader6.Read())
                        {
                            string totalquestions = reader6["questioncounter"].ToString();
                            if (totalquestions == "")
                            {
                                questioncounter = 0;
                            }
                            else
                            {
                                questioncounter = Int32.Parse(totalquestions);
                            }                           
                        }
                    }
                    con6.Dispose();

                    if (questioncounter != 0)
                    {
                        for (int j = 1; j <= questioncounter; j++)
                        {
                            var questionDescList = new List<string>();

                            SqlConnection con7 = new SqlConnection(cs);
                            con7.Open();
                            SqlCommand cmd7 = new SqlCommand("SELECT * from QUESTION where objidfk=" + objidArray[i-1]);
                            cmd7.Connection = con7;
                            SqlDataReader reader7 = cmd7.ExecuteReader();
                            {
                                while (reader7.Read())
                                {
                                    questionnum = "No. " + j;

                                    string questiondesc = reader7["QUESTIONDESC"].ToString();
                                    if (questiondesc == "")
                                    {
                                        Response.Write("<script>alert('At least one of the questions was left blank!')</script>");
                                        if (type == "4")
                                        {
                                            string jScript = "<script>window.close();</script>";
                                            ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                                        }
                                        else
                                        {
                                            Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                                        }
                                        con7.Dispose();
                                        return;
                                    }

                                    questionDescList.Add(reader7["QUESTIONDESC"].ToString());
                                    if (media == "PERFORMANCE")
                                    {
                                        if (reader7["QUESTIONDESC"].ToString() != "N/A")
                                        {
                                            Response.Write("<script>alert('At least one of the objectives did not have N/A as the question description!')</script>");
                                            if (type == "4")
                                            {
                                                string jScript = "<script>window.close();</script>";
                                                ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                                            }
                                            else
                                            {
                                                Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                                            }
                                            con7.Dispose();
                                            return;
                                        }
                                    }
                                    else
                                    {
                                        //if (media == "EXAM" || media == "LD" || lesstitle.Contains("quiz") || lesstitle.Contains("Quiz") || lesstitle.Contains("QUIZ") || lesstitle.Contains("review") || lesstitle.Contains("Review") || lesstitle.Contains("REVIEW") ||
                                        //lesstitle.Contains("critique") || lesstitle.Contains("Critique") || lesstitle.Contains("CRITIQUE") || lesstitle.Contains("mission planning") || lesstitle.Contains("Mission Planning") || lesstitle.Contains("MISSION PLANNING"))
                                        string title_uppercased = lesstitle.ToUpper();
                                        if (media == "EXAM" || media == "LD" || title_uppercased.Contains("QUIZ") || title_uppercased.Contains("REVIEW") ||
                                            title_uppercased.Contains("CRITIQUE") || title_uppercased.Contains("MISSION PLANNING"))
                                        {
                                            //do nothing, basically allows report to load if any of these conditions are met
                                        }
                                        else
                                        {
                                            if (reader7["QUESTIONDESC"].ToString() == "N/A")
                                            {
                                                Response.Write("<script>alert('At least one of the objectives has a question description as N/A when it should not!')</script>");
                                                if (type == "4")
                                                {
                                                    string jScript = "<script>window.close();</script>";
                                                    ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                                                }
                                                else
                                                {
                                                    Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                                                }
                                                con7.Dispose();
                                                return;
                                            }
                                        }
                                    }
                                }      
                            }
                            con7.Dispose();

                            var questiondescArray = questionDescList.ToArray();

                            d.Add(new Paragraph(""));
                            Text text22 = new Text("Question:").SetFont(bold);
                            Text text23 = new Text(questionnum);               
                            Text text24 = new Text(questiondescArray[j-1]);
                            iText.Layout.Element.Table table6 = new iText.Layout.Element.Table(new float[] { 25, 25, 30, 25, 25 });
                            Cell cell61 = new Cell(1, 1)
                            .SetBorder(Border.NO_BORDER)
                            .SetFontSize(10)
                            .Add(new Paragraph(""));
                            Cell cell62 = new Cell(1, 1)
                            .SetBorder(Border.NO_BORDER)
                            .SetFontSize(10)
                            .Add(new Paragraph(text22));
                            Cell cell63 = new Cell(1, 1)
                            .SetBorder(Border.NO_BORDER)
                            .SetFontSize(10)
                            .Add(new Paragraph(text23));
                            Cell cell64 = new Cell(1, 1)
                            .SetBorder(Border.NO_BORDER)
                            .SetFontSize(10)
                            .Add(new Paragraph(""));
                            Cell cell65 = new Cell(1, 1)
                            .SetBorder(Border.NO_BORDER)
                            .SetFontSize(10)
                            .SetTextAlignment(TextAlignment.LEFT)
                            .Add(new Paragraph(text24));                         
                            table6.AddCell(cell61);
                            table6.AddCell(cell62);
                            table6.AddCell(cell63);
                            table6.AddCell(cell64);
                            table6.AddCell(cell65);
                            d.Add(table6);

                            string diagnostic = "I DON\'T KNOW WHY";
                            SqlConnection con2 = new SqlConnection(cs);
                            con2.Open();
                            SqlCommand cmd2 = new SqlCommand("SELECT * from SOILESS where LESSIDfk=" + lessid + " order by id desc");
                            cmd2.Connection = con2;
                            SqlDataReader reader2 = cmd2.ExecuteReader();
                            {
                                if (reader2.HasRows)
                                {
                                    while (reader2.Read())
                                    {
                                        string SOIIDFK = reader2["SOIIDFK"].ToString();
                                        SqlConnection con8 = new SqlConnection(cs);
                                        con8.Open();
                                        SqlCommand cmd8 = new SqlCommand("SELECT * from SOI where SOIID=" + SOIIDFK);
                                        cmd8.Connection = con8;
                                        SqlDataReader reader8 = cmd8.ExecuteReader();
                                        {
                                            if (!reader8.HasRows) diagnostic = "reader8 has no rows: " + cmd8.CommandText; // DEBUG
                                            while (reader8.Read())
                                            {
                                                string SOITITLE = reader8["SOITITLE"].ToString();
                                                string SOIDATE = myConverter.interpretDate(reader8["SOIDATE"].ToString());

                                                var MI_list = new List<string>();
                                                SqlConnection con9 = new SqlConnection(cs);
                                                con9.Open();
                                                SqlCommand cmd9 = new SqlCommand("SELECT * from SOIMI where soiidfk=" + SOIIDFK);
                                                cmd9.Connection = con9;
                                                SqlDataReader reader9 = cmd9.ExecuteReader();
                                                {
                                                    if (!reader9.HasRows) diagnostic = "reader9 has no rows: " + cmd9.CommandText; // DEBUG
                                                    while (reader9.Read())
                                                    {
                                                        string MIIDFK = reader9["MIIDFK"].ToString();
                                                        string SOIMIID = reader9["SOIMIID"].ToString();
                                                        if (MIIDFK != "")
                                                        {
                                                            SqlConnection con10 = new SqlConnection(cs);
                                                            con10.Open();
                                                            SqlCommand cmd10 = new SqlCommand("SELECT * from MI where MIID=" + MIIDFK);
                                                            cmd10.Connection = con10;
                                                            SqlDataReader reader10 = cmd10.ExecuteReader();
                                                            {
                                                                if (!reader10.HasRows) diagnostic = "reader10 has no rows: " + cmd10.CommandText; // DEBUG
                                                                while (reader10.Read())
                                                                {
                                                                    string MIDESC = reader10["MIDESC"].ToString();
                                                                    SqlConnection con11 = new SqlConnection(cs);
                                                                    con11.Open();
                                                                    SqlCommand cmd11 = new SqlCommand("SELECT * from SOIMI2OBJ where OBJIDFK=" + objid[i - 1] + " and SOIMIIDFK=" + SOIMIID + " order by id");
                                                                    cmd11.Connection = con11;
                                                                    SqlDataReader reader11 = cmd11.ExecuteReader();
                                                                    {
                                                                        if (!reader11.HasRows) diagnostic = "reader11 has no rows: " + cmd11.CommandText; // DEBUG
                                                                        while (reader11.Read())
                                                                        {
                                                                            string SOIMIOBJID = reader11["SOIMIOBJID"].ToString();
                                                                            if (SOIMIOBJID != "")
                                                                            {
                                                                                MI_list.Add(MIDESC);
                                                                            }
                                                                        }
                                                                    }
                                                                    con11.Dispose();
                                                                }
                                                            }
                                                            con10.Dispose();
                                                        }
                                                    }
                                                }
                                                con9.Dispose();

                                                var MI_array = MI_list.ToArray();

                                                d.Add(new Paragraph(""));
                                                Text text25 = new Text("Syllabus:").SetFont(bold);
                                                Text text26 = new Text(SOITITLE);
                                                Text text27 = new Text("Date:").SetFont(bold);
                                                Text text28 = new Text(SOIDATE);
                                                iText.Layout.Element.Table table7 = new iText.Layout.Element.Table(new float[] { 45, 30, 30, 25, 25, 25 });
                                                Cell cell71 = new Cell(1, 1)
                                                .SetBorder(Border.NO_BORDER)
                                                .SetFontSize(10)
                                                .Add(new Paragraph(""));
                                                Cell cell72 = new Cell(1, 1)
                                                .SetBorder(Border.NO_BORDER)
                                                .SetFontSize(10)
                                                .Add(new Paragraph(text25));
                                                Cell cell73 = new Cell(1, 1)
                                                .SetBorder(Border.NO_BORDER)
                                                .SetFontSize(10)
                                                .SetWidth(120)
                                                .SetTextAlignment(TextAlignment.LEFT)
                                                .Add(new Paragraph(text26));
                                                Cell cell74 = new Cell(1, 1)
                                                .SetBorder(Border.NO_BORDER)
                                                .SetFontSize(10)
                                                .Add(new Paragraph(""));
                                                Cell cell75 = new Cell(1, 1)
                                                .SetBorder(Border.NO_BORDER)
                                                .SetFontSize(10)
                                                .Add(new Paragraph(text27));
                                                Cell cell76 = new Cell(1, 1)
                                                .SetBorder(Border.NO_BORDER)
                                                .SetFontSize(10)
                                                .Add(new Paragraph(text28));
                                                table7.AddCell(cell71);
                                                table7.AddCell(cell72);
                                                table7.AddCell(cell73);
                                                table7.AddCell(cell74);
                                                table7.AddCell(cell75);
                                                table7.AddCell(cell76);
                                                d.Add(table7);

                                                if (MI_array.Length > 0)
                                                {
                                                    d.Add(new Paragraph(""));
                                                    Text text29 = new Text("MI/TTL:").SetFont(bold);
                                                    iText.Layout.Element.Table table8 = new iText.Layout.Element.Table(new float[] { 25, 25, 35 });
                                                    for (int k = 0; k < MI_array.Length; k++)
                                                    {
                                                        Cell cell81 = new Cell(1, 1)
                                                        .SetBorder(Border.NO_BORDER)
                                                        .SetFontSize(10)
                                                        .SetWidth(100)
                                                        .Add(new Paragraph(""));
                                                        Cell cell82 = new Cell(1, 1)
                                                        .SetBorder(Border.NO_BORDER)
                                                        .SetFontSize(10)
                                                        .Add(new Paragraph(text29));
                                                        Cell cell83 = new Cell(1, 1)
                                                        .SetBorder(Border.NO_BORDER)
                                                        .SetFontSize(10)
                                                        .SetWidth(300)
                                                        .SetTextAlignment(TextAlignment.LEFT)
                                                        .Add(new Paragraph(MI_array[k]));
                                                        table8.AddCell(cell81);
                                                        table8.AddCell(cell82);
                                                        table8.AddCell(cell83);
                                                    }
                                                    d.Add(table8);
                                                }
                                                else
                                                {
                                                    if (showDebugMsg)
                                                    {
                                                        Response.Write($"<script>alert('{diagnostic}')</script>");
                                                    }
                                                    else
                                                    {
                                                        Response.Write("<script>alert('Either one objective is missing an MI or select \"No MIs Apply\" for a PERFORMANCE/EXAM/QUIZ/REVIEW/CRITIQUE/MISSION PLANNING lesson!')</script>");
                                                    }
                                                    if (type == "4")
                                                    {
                                                        string jScript = "<script>window.close();</script>";
                                                        ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                                                    }
                                                    else
                                                    {
                                                        Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                                                    }
                                                    con8.Dispose();
                                                    return;
                                                }
                                            }
                                        }
                                        con8.Dispose();
                                    }                                 
                                }
                                else
                                {
                                    if (showDebugMsg)
                                    {
                                        Response.Write("<script>alert('reader2 has no rows')</script>");
                                    }
                                    else
                                    {
                                        Response.Write("<script>alert('Either one objective is missing an MI or select \"No MIs Apply\" for a PERFORMANCE/EXAM/QUIZ/REVIEW/CRITIQUE/MISSION PLANNING lesson!')</script>");                                   
                                    }

                                    if (type == "4")
                                    {
                                        string jScript = "<script>window.close();</script>";
                                        ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                                    }
                                    else
                                    {
                                        Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                                    }
                                    con2.Dispose();
                                    return;
                                }
                            }
                            con2.Dispose();

                            d.Add(ls);
                        }
                    }
                    else
                    {
                        //No Questions
                        if (media != "PERFORMANCE")
                        {
                            Response.Write("<script>alert('At least one objective had no questions added!')</script>");
                            if (type == "4")
                            {
                                string jScript = "<script>window.close();</script>";
                                ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                            }
                            else
                            {
                                Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                            }
                            return;
                        }
                        else
                        {
                            Response.Write("<script>alert('At least one of the objectives did not have N/A as the question description!')</script>");
                            if (type == "4")
                            {
                                string jScript = "<script>window.close();</script>";
                                ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                            }
                            else
                            {
                                Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                            }
                            return;

                        }
                    }
                }
            }
            else
            {
                //No Objectives
                Response.Write("<script>alert('No objectives added to this lesson!')</script>");
                if (type == "4")
                {
                    string jScript = "<script>window.close();</script>";
                    ClientScript.RegisterClientScriptBlock(this.GetType(), "keyClientBlock", jScript);
                }
                else
                {
                    Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");
                }                
                return;
            }
            
            d.Close();

            byte[] byte1 = baos.ToArray();

            string TargetLocation = Server.MapPath("~/files/");

            if (type == "1")
            {
                using (FileStream fs = File.Create(TargetLocation + "rptFEA1.pdf")) { fs.Write(byte1, 0, (int)byte1.Length); }

                string DEST = TargetLocation + "rptFEA.pdf";
                string SRC = TargetLocation + "rptFEA1.pdf";

                PdfDocument pdfDoc = new PdfDocument(new PdfReader(SRC), new PdfWriter(DEST));
                Document doc = new Document(pdfDoc);

                int numberOfPages = pdfDoc.GetNumberOfPages();
                for (int i = 1; i <= numberOfPages; i++)
                {
                    // Write aligned text to the specified by parameters point
                    doc.ShowTextAligned(new Paragraph(String.Format("Page " + i + " of " + numberOfPages)),
                            568f, 15f, i, TextAlignment.RIGHT, VerticalAlignment.TOP, 0);
                    DateTime dt = DateTime.Now;
                    string today = dt.ToLongDateString();
                    doc.ShowTextAligned(new Paragraph(String.Format(today)),
                            45f, 15f, i, TextAlignment.LEFT, VerticalAlignment.TOP, 0);
                }
                doc.Close();
                   
                Response.Redirect("~/files/rptFEA.pdf", false);
                Context.ApplicationInstance.CompleteRequest();
            }
            else if (type == "2")
            {
                using (FileStream fs = File.Create(TargetLocation + "rptFEA_PEFORM_MESL1.pdf")) { fs.Write(byte1, 0, (int)byte1.Length); }

                string DEST = TargetLocation + "rptFEA_PEFORM_MESL.pdf";
                string SRC = TargetLocation + "rptFEA_PEFORM_MESL1.pdf";

                PdfDocument pdfDoc = new PdfDocument(new PdfReader(SRC), new PdfWriter(DEST));
                Document doc = new Document(pdfDoc);

                int numberOfPages = pdfDoc.GetNumberOfPages();
                for (int i = 1; i <= numberOfPages; i++)
                {
                    // Write aligned text to the specified by parameters point
                    doc.ShowTextAligned(new Paragraph(String.Format("Page " + i + " of " + numberOfPages)),
                            568f, 15f, i, TextAlignment.RIGHT, VerticalAlignment.TOP, 0);
                    DateTime dt = DateTime.Now;
                    string today = dt.ToLongDateString();
                    doc.ShowTextAligned(new Paragraph(String.Format(today)),
                            45f, 15f, i, TextAlignment.LEFT, VerticalAlignment.TOP, 0);
                }
                doc.Close();

                Response.Redirect("~/files/rptFEA_PEFORM_MESL.pdf", false);
                Context.ApplicationInstance.CompleteRequest();
            }
            else if (type == "3")
            {
                using (FileStream fs = File.Create(TargetLocation + "rptFEA_FOUO1.pdf")) { fs.Write(byte1, 0, (int)byte1.Length); }

                string DEST = TargetLocation + "rptFEA_FOUO.pdf";
                string SRC = TargetLocation + "rptFEA_FOUO1.pdf";

                PdfDocument pdfDoc = new PdfDocument(new PdfReader(SRC), new PdfWriter(DEST));
                Document doc = new Document(pdfDoc);

                int numberOfPages = pdfDoc.GetNumberOfPages();
                for (int i = 1; i <= numberOfPages; i++)
                {
                    // Write aligned text to the specified by parameters point
                    doc.ShowTextAligned(new Paragraph(String.Format("Page " + i + " of " + numberOfPages)),
                            568f, 15f, i, TextAlignment.RIGHT, VerticalAlignment.TOP, 0);
                    DateTime dt = DateTime.Now;
                    string today = dt.ToLongDateString();
                    doc.ShowTextAligned(new Paragraph(String.Format(today)),
                            45f, 15f, i, TextAlignment.LEFT, VerticalAlignment.TOP, 0);
                }
                doc.Close();

                Response.Redirect("~/files/rptFEA_FOUO.pdf", false);
                Context.ApplicationInstance.CompleteRequest();
            }     
            else if (type == "4")
            {
                using (FileStream fs = File.Create(TargetLocation + "rptVerification1.pdf")) { fs.Write(byte1, 0, (int)byte1.Length); }

                string DEST = TargetLocation + "rptVerification.pdf";
                string SRC = TargetLocation + "rptVerification1.pdf";

                PdfDocument pdfDoc = new PdfDocument(new PdfReader(SRC), new PdfWriter(DEST));
                Document doc = new Document(pdfDoc);

                int numberOfPages = pdfDoc.GetNumberOfPages();
                for (int i = 1; i <= numberOfPages; i++)
                {
                    // Write aligned text to the specified by parameters point
                    doc.ShowTextAligned(new Paragraph(String.Format("Page " + i + " of " + numberOfPages)),
                            568f, 15f, i, TextAlignment.RIGHT, VerticalAlignment.TOP, 0);
                    DateTime dt = DateTime.Now;
                    string today = dt.ToLongDateString();
                    doc.ShowTextAligned(new Paragraph(String.Format(today)),
                            45f, 15f, i, TextAlignment.LEFT, VerticalAlignment.TOP, 0);
                }
                doc.Close();

                Response.Redirect("~/files/rptVerification.pdf", false);
                Context.ApplicationInstance.CompleteRequest();
            }
        }
    }
}