﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using System.Text;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class ReviewReports : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('Session Timeout')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            DbToWeb myConverter = new DbToWeb();
            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;

            List<string> instructorList = new List<string>();
            instructorList.Add("<option value='0'>Select Instructor</option>");
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand("SELECT Id from Members where catroles=4");
            cmd.Connection = con;
            SqlDataReader reader = cmd.ExecuteReader();
            {
                while (reader.Read())
                {
                    string instid = reader["Id"].ToString();
                    string instructor = myConverter.identifyMember(instid, cs);
                    instructorList.Add($"<option value={instid}>{instructor}</option>");
                }
            }
            con.Dispose();
            Label1.Text = String.Join("", instructorList.ToArray());

            List<string> lessonList = new List<string>();
            lessonList.Add("<option value='0'>Select Lesson</option>");
            SqlConnection con2 = new SqlConnection(cs);
            con2.Open();
            SqlCommand cmd2 = new SqlCommand("SELECT LESSID,LESSNUMBER,LESSTITLE from Lesson where (MP != 1) and (status != 2) order by LESSNUMBER");
            cmd2.Connection = con2;
            SqlDataReader reader2 = cmd2.ExecuteReader();
            {
                while (reader2.Read())
                {
                    string lessid = reader2["LESSID"].ToString();
                    string LESSNUMBER = reader2["LESSNUMBER"].ToString();
                    string LESSTITLE = reader2["LESSTITLE"].ToString();
                    lessonList.Add($"<option value=\"{lessid}\">{LESSNUMBER} | {LESSTITLE}</option>");
                }
            }
            con2.Dispose();
            Label2.Text = String.Join("", lessonList.ToArray());

            string instructorid = Request.QueryString["instructorid"];
            if (instructorid != null)
            {
                List<string> tableRows = new List<string>();
                SqlConnection con3 = new SqlConnection(cs);
                con3.Open();
                SqlCommand cmd3 = new SqlCommand($"SELECT * FROM Review WHERE instructorid={instructorid} ORDER BY review_date");
                cmd3.Connection = con3;
                SqlDataReader reader3 = cmd3.ExecuteReader();
                {
                    while (reader3.Read())
                    {
                        string lessid = reader3["lessid"].ToString();
                        string lessname = "";
                        SqlConnection con5 = new SqlConnection(cs);
                        con5.Open();
                        SqlCommand cmd5 = new SqlCommand("SELECT * FROM Lesson WHERE lessid=" + lessid);
                        cmd5.Connection = con5;
                        SqlDataReader reader5 = cmd5.ExecuteReader();
                        {
                            while (reader5.Read())
                            {
                                string lessnumber = reader5["lessnumber"].ToString();
                                string lesstitle = reader5["lesstitle"].ToString();
                                lessname = lessnumber + " | " + lesstitle;
                            }
                        }
                        con5.Dispose();

                        string review_date = myConverter.interpretDate(reader3["review_date"].ToString());
                        //string tcp = reader3["tcp"].ToString();
                        //string hasTCP = tcp == "1" ? "Yes" : "No";
                        string comments = reader3["comments"].ToString();
                        string instructorname = myConverter.identifyMember(instructorid, cs);

                        tableRows.Add($"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>");
                    }
                }
                con3.Dispose();
                Label3.Text = String.Join("", tableRows.ToArray());
            }

            string allReviews = Request.QueryString["all"];
            if (!String.IsNullOrEmpty(allReviews))
            {
                List<string> tableRows = new List<string>();
                if (allReviews == "reviews")
                {
                    SqlConnection con3 = new SqlConnection(cs);
                    con3.Open();
                    SqlCommand cmd3 = new SqlCommand("SELECT * from Review order by review_date");
                    cmd3.Connection = con3;
                    SqlDataReader reader3 = cmd3.ExecuteReader();
                    {
                        while (reader3.Read())
                        {
                            string lessid = reader3["lessid"].ToString();
                            string lessname = "";
                            SqlConnection con5 = new SqlConnection(cs);
                            con5.Open();
                            SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                            cmd5.Connection = con5;
                            SqlDataReader reader5 = cmd5.ExecuteReader();
                            {
                                while (reader5.Read())
                                {
                                    string lessnumber = reader5["lessnumber"].ToString();
                                    string lesstitle = reader5["lesstitle"].ToString();
                                    lessname = lessnumber + " | " + lesstitle;
                                }
                            }
                            con5.Dispose();

                            string review_date = myConverter.interpretDate(reader3["review_date"].ToString());
                            //string tcp = reader3["tcp"].ToString();
                            //string hasTCP = tcp == "1" ? "Yes" : "No";
                            string comments = reader3["comments"].ToString();
                            string instructorname = myConverter.identifyMember(reader3["instructorid"].ToString(), cs);

                            //tableRows.Add($"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{hasTCP}</td><td>{comments}</td></tr>");
                            tableRows.Add($"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>");
                        }
                    }
                    con3.Dispose();
                    Label3.Text = String.Join("", tableRows.ToArray());
                }
                else if (allReviews == "lessons") // include lessons that have no reviews yet
                {
                    SqlConnection con3b = new SqlConnection(cs);
                    con3b.Open();
                    SqlCommand cmd3b = new SqlCommand("SELECT lessnumber, lesstitle, lessrev, revdate, review_date, comments, instructorid FROM Lesson l LEFT JOIN Review r on l.lessid = r.lessid ORDER BY lessnumber, review_date");
                    cmd3b.Connection = con3b;
                    SqlDataReader reader3b = cmd3b.ExecuteReader();
                    {
                        while (reader3b.Read())
                        {
                            string revCode = myConverter.getRevName(reader3b["lessrev"].ToString(), cs);
                            string revDate = myConverter.interpretDate(reader3b["revdate"].ToString());
                            string[] lessonData = {
                                reader3b["lessnumber"].ToString(), " | ", reader3b["lesstitle"].ToString(), // lessnumber | lesstitle
                                revCode != "" ? " | REV " + revCode : "", // some lessons have "-" or no rev
                                revDate != "" ? " | " + revDate : "" // some lessons have no rev date
                            };
                            string lessonName = String.Join("", lessonData);
                            string reviewDate = myConverter.interpretDate(reader3b["review_date"].ToString());
                            string comments = reader3b["comments"].ToString();
                            string instructor = myConverter.identifyMember(reader3b["instructorid"].ToString(), cs);

                            tableRows.Add($"<tr><td>{lessonName}</td><td>{reviewDate}</td><td>{instructor}</td><td>{comments}</td></tr>");
                        }
                    }
                    con3b.Dispose();
                    Label3.Text = String.Join("", tableRows.ToArray());
                }
            }

            string lessonids = Request.QueryString["lessid"];
            if (lessonids != null)
            {
                string labeltext3 = "";
                if (lessonids.Contains(","))
                {
                    List<string> listOfLessons = new List<string>(lessonids.Split(','));
                    for (int i = 0; i < listOfLessons.Count; i++)
                    {    
                        SqlConnection con3 = new SqlConnection(cs);
                        con3.Open();
                        SqlCommand cmd3 = new SqlCommand("SELECT * from Review where lessid=" + listOfLessons[i] + " order by review_date");
                        cmd3.Connection = con3;
                        SqlDataReader reader3 = cmd3.ExecuteReader();
                        {
                            while (reader3.Read())
                            {
                                string lessid = reader3["lessid"].ToString();
                                string lessname = "";
                                SqlConnection con5 = new SqlConnection(cs);
                                con5.Open();
                                SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                                cmd5.Connection = con5;
                                SqlDataReader reader5 = cmd5.ExecuteReader();
                                {
                                    while (reader5.Read())
                                    {
                                        string lessnumber = reader5["lessnumber"].ToString();
                                        string lesstitle = reader5["lesstitle"].ToString();
                                        lessname = lessnumber + " | " + lesstitle;
                                    }
                                }
                                con5.Dispose();

                                string review_date = myConverter.interpretDate(reader3["review_date"].ToString());
                                //string tcp = reader3["tcp"].ToString();
                                //string hasTCP = tcp == "1" ? "Yes" : "No";

                                string comments = reader3["comments"].ToString();
                                instructorid = reader3["instructorid"].ToString();
                                string instructorname = "";
                                SqlConnection con4 = new SqlConnection(cs);
                                con4.Open();
                                SqlCommand cmd4 = new SqlCommand("SELECT * from members where id=" + instructorid);
                                cmd4.Connection = con4;
                                SqlDataReader reader4 = cmd4.ExecuteReader();
                                {
                                    while (reader4.Read())
                                    {
                                        string firstname = reader4["firstname"].ToString();
                                        string lastname = reader4["lastname"].ToString();
                                        string username = reader4["username"].ToString();
                                        instructorname = lastname + "," + firstname + " (" + username + ")";
                                    }
                                }
                                con4.Dispose();

                                //labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{hasTCP}</td><td>{comments}</td></tr>";
                                labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>";
                            }
                        }
                        con3.Dispose();
                    }
                    Label3.Text = labeltext3;
                }
                else
                {                    
                    SqlConnection con3 = new SqlConnection(cs);
                    con3.Open();
                    SqlCommand cmd3 = new SqlCommand("SELECT * from Review where lessid=" + lessonids + " order by review_date");
                    cmd3.Connection = con3;
                    SqlDataReader reader3 = cmd3.ExecuteReader();
                    {
                        while (reader3.Read())
                        {
                            string lessid = reader3["lessid"].ToString();
                            string lessname = "";
                            SqlConnection con5 = new SqlConnection(cs);
                            con5.Open();
                            SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                            cmd5.Connection = con5;
                            SqlDataReader reader5 = cmd5.ExecuteReader();
                            {
                                while (reader5.Read())
                                {
                                    string lessnumber = reader5["lessnumber"].ToString();
                                    string lesstitle = reader5["lesstitle"].ToString();
                                    lessname = lessnumber + " | " + lesstitle;
                                }
                            }
                            con5.Dispose();

                            string review_date = myConverter.interpretDate(reader3["review_date"].ToString());
                            //string tcp = reader3["tcp"].ToString();
                            //string hasTCP = tcp == "1" ? "Yes" : "No";

                            string comments = reader3["comments"].ToString();
                            instructorid = reader3["instructorid"].ToString();
                            string instructorname = "";
                            SqlConnection con4 = new SqlConnection(cs);
                            con4.Open();
                            SqlCommand cmd4 = new SqlCommand("SELECT * from members where id=" + instructorid);
                            cmd4.Connection = con4;
                            SqlDataReader reader4 = cmd4.ExecuteReader();
                            {
                                while (reader4.Read())
                                {
                                    string firstname = reader4["firstname"].ToString();
                                    string lastname = reader4["lastname"].ToString();
                                    string username = reader4["username"].ToString();
                                    instructorname = lastname + "," + firstname + " (" + username + ")";
                                }
                            }
                            con4.Dispose();

                            //labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{hasTCP}</td><td>{comments}</td></tr>";
                            labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>";
                        }
                    }
                    con3.Dispose();
                    Label3.Text = labeltext3;
                }
            }
            string startdate = Request.QueryString["startdate"];
            string enddate = Request.QueryString["enddate"];
            if (startdate != null)
            {
                string labeltext3 = "";
                SqlConnection con3 = new SqlConnection(cs);
                con3.Open();
                SqlCommand cmd3 = new SqlCommand("SELECT * from Review where review_date between '" + startdate + "' and '" + enddate + "' order by review_date");
                cmd3.Connection = con3;
                SqlDataReader reader3 = cmd3.ExecuteReader();
                {
                    while (reader3.Read())
                    {
                        string lessid = reader3["lessid"].ToString();
                        string lessname = "";
                        SqlConnection con5 = new SqlConnection(cs);
                        con5.Open();
                        SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                        cmd5.Connection = con5;
                        SqlDataReader reader5 = cmd5.ExecuteReader();
                        {
                            while (reader5.Read())
                            {
                                string lessnumber = reader5["lessnumber"].ToString();
                                string lesstitle = reader5["lesstitle"].ToString();
                                lessname = lessnumber + " | " + lesstitle;
                            }
                        }
                        con5.Dispose();

                        string review_date = myConverter.interpretDate(reader3["review_date"].ToString());
                        //string tcp = reader3["tcp"].ToString();
                        //string hasTCP = tcp == "1" ? "Yes" : "No";

                        string comments = reader3["comments"].ToString();
                        instructorid = reader3["instructorid"].ToString();
                        string instructorname = "";
                        SqlConnection con4 = new SqlConnection(cs);
                        con4.Open();
                        SqlCommand cmd4 = new SqlCommand("SELECT * from members where id=" + instructorid);
                        cmd4.Connection = con4;
                        SqlDataReader reader4 = cmd4.ExecuteReader();
                        {
                            while (reader4.Read())
                            {
                                string firstname = reader4["firstname"].ToString();
                                string lastname = reader4["lastname"].ToString();
                                string username = reader4["username"].ToString();
                                instructorname = lastname + "," + firstname + " (" + username + ")";
                            }
                        }
                        con4.Dispose();

                        //labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{hasTCP}</td><td>{comments}</td></tr>";
                        labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>";
                    }
                }
                con3.Dispose();
                Label3.Text = labeltext3;
            }

            /*
            string tcprequested = Request.QueryString["tcp"];
            if (tcprequested != null)
            {
                string labeltext3 = "";
                SqlConnection con3 = new SqlConnection(cs);
                con3.Open();
                SqlCommand cmd3 = new SqlCommand("SELECT * from Review where tcp=" + tcprequested + " order by review_date");
                cmd3.Connection = con3;
                SqlDataReader reader3 = cmd3.ExecuteReader();
                {
                    while (reader3.Read())
                    {
                        string lessid = reader3["lessid"].ToString();
                        string lessname = "";
                        SqlConnection con5 = new SqlConnection(cs);
                        con5.Open();
                        SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                        cmd5.Connection = con5;
                        SqlDataReader reader5 = cmd5.ExecuteReader();
                        {
                            while (reader5.Read())
                            {
                                string lessnumber = reader5["lessnumber"].ToString();
                                string lesstitle = reader5["lesstitle"].ToString();
                                lessname = lessnumber + " | " + lesstitle;
                            }
                        }
                        con5.Dispose();

                        string review_date = myConverter.interpretDate(reader3["review_date"].ToString());
                        //string tcp = reader3["tcp"].ToString();
                        //string hasTCP = tcp == "1" ? "Yes" : "No";

                        string comments = reader3["comments"].ToString();
                        instructorid = reader3["instructorid"].ToString();
                        string instructorname = "";
                        SqlConnection con4 = new SqlConnection(cs);
                        con4.Open();
                        SqlCommand cmd4 = new SqlCommand("SELECT * from members where id=" + instructorid);
                        cmd4.Connection = con4;
                        SqlDataReader reader4 = cmd4.ExecuteReader();
                        {
                            while (reader4.Read())
                            {
                                string firstname = reader4["firstname"].ToString();
                                string lastname = reader4["lastname"].ToString();
                                string username = reader4["username"].ToString();
                                instructorname = lastname + "," + firstname + " (" + username + ")";
                            }
                        }
                        con4.Dispose();

                        //labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{hasTCP}</td><td>{comments}</td></tr>";
                        labeltext3 += $"<tr><td>{lessname}</td><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>";
                    }
                }
                con3.Dispose();
                Label3.Text = labeltext3;
            }
            */
        }
    }
}