﻿<%@ Page Title="Project Progress" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Project_Progress.aspx.cs" Inherits="CAE_WEB_PROJECT.smartsheet.Project_Progress" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 

<script> 
    var selid;
    var editphaseid;
    var edittaskid;
    var Assigned_To;
    var Type_Task;
    var Rework_Instance;
    var Comments;    

    $(document).ready(function () {   
        $('.js-example-basic-single').select2();

        var projectid = getUrlVars()["id"];
        $('#projectid').val(projectid);
        $('#editprojectid').val(projectid);
        $('#attachprojectid').val(projectid);

        $('#example').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Progress"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data = table.row(this).data();
                savedata(data);
            }
        });           
    }); 

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function savedata(rowdata) {      
        Assigned_To = rowdata[3];        
        Type_Task = rowdata[4];
        Rework_Instance = rowdata[5];
        Comments = rowdata[12];
        editphaseid = rowdata[13];
        edittaskid = rowdata[14];  
        selid = rowdata[15]; 
    }

    function editdata() {
        if (edittaskid == 1) {
            alert("Cannot edit first row.");  
            return false;
        }            

        if (selid == null) {
            alert("No row selected");           
        }
        else {   
            loadmembers();
            loadtaskedit();            
            // Get the modal
            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
                $("#edittask").empty(); //clears task dropdown
                $("#editmembers").empty(); //clears members dropdown
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";  
                    $("#edittask").empty(); //clears task dropdown
                    $("#editmembers").empty(); //clears members dropdown
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none"; 
                    $("#edittask").empty(); //clears task dropdown
                    $("#editmembers").empty(); //clears members dropdown
                }
            };

            $('#editid').val(selid);
            $('#editphase').val(editphaseid);
            $('#editmembers').val(Assigned_To);
            $('#edittypetask').val(Type_Task);
            $('#editreworkinstance').val(Rework_Instance);
            $('#comments').val(Comments);            
        }      
    }

    function assignto() {
        // Get the modal
        var modal = document.getElementById("myModal2");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close2")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";            
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";              
            }
        };
    }

    function attach() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            // Get the modal
            var modal = document.getElementById("myModal3");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close3")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#attacheditid').val(selid);
        }
    }

    function deletedata() {
        var projectid = getUrlVars()["id"];
        if (edittaskid == 1) {
            alert("Cannot delete first row, but you can delete the entire project on the Smartsheet Projects page.");
            return false;
        } 

        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this row?") == true) {
                window.location.href = "../admin/deleteprojectprogress.aspx?id=" + selid + "&projectid=" + projectid;
            } else {
                return;
            }            
        }
    }

    function changetasks() {
        $("#task").empty(); //clears task dropdown

        var selection = document.getElementById("phase");
        var phaseid = selection.value;        
        //alert(phaseid);
        if (phaseid == "") {
            return false;
        }

        $.get("../smartsheet/gettasks.aspx?phaseid=" + phaseid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");            
            var data = myArray[0];   
            //alert(myArray[0]); 
            const myData = data.split("|");
          
            var taskselection = document.getElementById("task"); 
            var element = document.createElement("option");          
            element.textContent = "Select a Task";
            element.value = "";            
            taskselection.appendChild(element);    
            
            for (let i = 0; i < myData.length-1; i++) {
                //alert(myData[i]);   
                var el = document.createElement("option");
                var optdata = myData[i];
                const optvalue = optdata.split("~");
                el.textContent = optvalue[1];
                el.value = optvalue[0];
                taskselection.appendChild(el);                
            }                    
        });        
    }

    function changetasksedit() {
        $("#edittask").empty(); //clears task dropdown

        var selection = document.getElementById("editphase");
        var phaseid = selection.value;
        //alert(phaseid);
        if (phaseid == "") {
            return false;
        }

        $.get("../smartsheet/gettasks.aspx?phaseid=" + phaseid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");
            var data = myArray[0];
            //alert(myArray[0]); 
            const myData = data.split("|");

            var taskselection = document.getElementById("edittask");
            var element = document.createElement("option");
            element.textContent = "Select a Task";
            element.value = "";
            taskselection.appendChild(element);

            for (let i = 0; i < myData.length - 1; i++) {
                //alert(myData[i]);   
                var el = document.createElement("option");
                var optdata = myData[i];
                const optvalue = optdata.split("~");
                el.textContent = optvalue[1];
                el.value = optvalue[0];
                taskselection.appendChild(el);
            }             
        });        
    }
    function loadtaskedit() {
        var taskselection = document.getElementById("edittask");
        var element = document.createElement("option");
        element.textContent = "Select a Task";
        element.value = "";
        taskselection.appendChild(element);
        //alert(editphaseid);
        //alert(edittaskid); 
        $.get("../smartsheet/gettasks.aspx?phaseid=" + editphaseid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");
            var data = myArray[0];
            //alert(myArray[0]); 
            const myData = data.split("|");
            var taskselection = document.getElementById("edittask");

            for (let i = 0; i < myData.length - 1; i++) {
                //alert(myData[i]);   
                var el = document.createElement("option");
                var optdata = myData[i];
                const optvalue = optdata.split("~");
                el.textContent = optvalue[1]; 
                el.value = optvalue[0];
                if (optvalue[0] == edittaskid) {
                    el.selected = "selected";
                }
                taskselection.appendChild(el);           
            }
        });   
    }
    function loadmembers() {
        $.get("../smartsheet/loadmembers.aspx?selid=" + selid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");
            var data = myArray[0];
            //alert(myArray[0]); 
            const myData = data.split("|");
            var taskselection = document.getElementById("editmembers");
            for (let i = 0; i < myData.length - 1; i++) {
                //alert(myData[i]);
                var el = document.createElement("option");
                var optdata = myData[i];
                const optvalue = optdata.split("~");
                el.textContent = optvalue[1];
                el.value = optvalue[0];
                if (optvalue[2] == 1) {
                    el.selected = "selected";
                }
                taskselection.appendChild(el);
            }
        }); 
    }
</script>

<style>
.profilediv {
    display: table;
}

#profilespan {
    display: table-cell;
    vertical-align: middle;
    width: 100%;
}

#main{
    overflow-x: hidden;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1><asp:Label ID="Label2" runat="server" /></h1></div>
<hr />
<div style="margin: 35px; min-width: 500px;">
    <asp:Label ID="ButtonLabel" runat="server" />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th style="min-width: 300px;">Attachments</th>
                <th>Phase</th>
                <th style="min-width: 400px;">Task Name</th>
                <th style="min-width: 300px;">Assigned To</th>  
                <th>Type Task</th>
                <th>Rework Instance</th>
                <th>Date Assigned</th> 
                <th>Date Started</th>
                <th>Date Completed</th>
                <th style="min-width: 100px;">Status</th> 
                <th>Days Assigned</th>
                <th>Hours to Complete Task</th>
                <th style="min-width: 400px;">Comments</th> 
                <th style="display:none;">PhaseID</th>
                <th style="display:none;">TaskID</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Row</h4><br />
       <form class="form login" name="form1" action="../smartsheet/editprojectrow.aspx" method="post" enctype="multipart/form-data">
       <input type="hidden" name="editid" id="editid" />   
       <input type="hidden" name="editprojectid" id="editprojectid" /> 
       <div style="margin-left: 15px; color: black;">
            Select Member(s):
       </div>
       <div class="form__field" style="color: black">            
            <select class="js-example-basic-single" id="editmembers" name="editmembers" required="required" multiple="multiple" style="width: 100%;">                               
            </select>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="editphase" name="editphase" required="required" onchange="changetasksedit()">
                <asp:Label ID="Label5" runat="server" />
            </select>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="edittask" name="edittask" required="required">                 
            </select>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="edittypetask" id="edittypetask" placeholder="Type Task" />
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="editreworkinstance" id="editreworkinstance" placeholder="Rework Instance" />
       </div> 
       <div class="form__field">
       <textarea class="textareastyle" name="comments" id="comments" placeholder="Comments"></textarea>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Assign To</h4><br />
       <form class="form login" name="form1" action="../smartsheet/assignto.aspx" method="post" enctype="multipart/form-data">
        <input type="hidden" name="projectid" id="projectid" /> 
       <div style="margin-left: 15px; color: black;">
            Select Member(s):
       </div>
       <div class="form__field" style="color: black">            
            <select class="js-example-basic-single" id="members" name="members" required="required" multiple="multiple" style="width: 100%;">
                <asp:Label ID="Label3" runat="server" />
            </select>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="phase" name="phase" required="required" onchange="changetasks()">
                <asp:Label ID="Label4" runat="server" />
            </select>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="task" name="task" required="required">  
                <option value="">Select a Task</option>
            </select>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="typetask" id="typetask" placeholder="Type Task" />
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="reworkinstance" id="reworkinstance" placeholder="Rework Instance" />
       </div>
       <div class="form__field">
       <input type="submit" value="Submit" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal3" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close3">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Attach File(s)</h4><br />
       <form class="form login" name="form1" action="../smartsheet/attachfiles.aspx?id=project" method="post" enctype="multipart/form-data">
       <input type="hidden" name="attachprojectid" id="attachprojectid" /> 
       <input type="hidden" name="attacheditid" id="attacheditid" />   
       <div class="form__field">            
       <input type="file" id="files" name="files" multiple style="color:black;" required="required">        
       </div> 
       <br /><br />
       <div class="form__field">
       <input type="submit" value="Upload" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
