﻿<%@ Page Title="Edit Members" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="EditMembers.aspx.cs" Inherits="CAE_WEB_PROJECT.admin.EditMembers" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var lastname;
    var firstname;
    var username;
    var email;
    var selid;

    $(document).ready(function () {
        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Members"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;               
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');   
                var data = table.row(this).data();        
                savedata(data);
            }          
        });       
    }); 

    function savedata(rowdata) {
        lastname = rowdata[0];
        firstname = rowdata[1];
        username = rowdata[2];
        email = rowdata[3];
        selid = rowdata[4];       
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            // Get the modal
            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#firstname').val(firstname);
            $('#lastname').val(lastname);
            $('#username').val(username);
            $('#email').val(email);            
        }        
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this member?") == true) {
                window.location.href = "../admin/deletememberrow.aspx?selid=" + selid;
            } else {
                return;
            }            
        }
    }

    function checkEmail(form1) {
        if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(form1.email.value)) {
            return true;
        }
        else {
            alert("You have entered an invalid email address!")
            return false;
        }
    }

    function impersonate() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to impersonate this member?") == true) {
                window.location.href = "../admin/impersonate.aspx?selid=" + selid;
            } else {
                return;
            }
        }
    }

    function resetpword() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to reset the password for this member?") == true) {
                window.location.href = "../admin/resetpassword.aspx?selid=" + selid;
            } else {
                return;
            }
        }
    }
</script>
<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Edit Members</h1></div>
<hr />
<div style="margin: 35px;">
<button class="button" onclick="editdata()">Edit Row</button>
<button class="button" onclick="deletedata()">Delete Row</button>
<button class="button" onclick="impersonate()">Impersonate</button>
<!--
<button class="button" onclick="resetpword()">Reset Password</button>
-->
<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th>Last Name</th>
                <th>First Name</th>
                <th>Username</th>
                <th>Email</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Member</h4><br />
       <form class="form login" name="form1" action="../admin/editmemberrow.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkEmail(this)">
       <input type="hidden" name="editid" id="editid" />   
       <div class="form__field">
       <input style="color: white" type="text" name="lastname" id="lastname" placeholder="Last Name" onkeypress="return event.charCode != 32" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="firstname" id="firstname" placeholder="First Name" onkeypress="return event.charCode != 32" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="username" id="username" placeholder="Username" onkeypress="return event.charCode != 32" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="email" id="email" placeholder="Email Address" onkeypress="return event.charCode != 32" required="required"/>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
