﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class importMIdata : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            NameValueCollection nvc = Request.Form;
            string ctsid = nvc["ctsid"];

            if (Request.Files["myfile"] != null)
            {
                HttpPostedFile MyFile = Request.Files["myfile"];
                string fname = Path.GetFileName(MyFile.FileName);
                string excelPath = Server.MapPath("~/files/") + Path.GetFileName(MyFile.FileName);


                MyFile.SaveAs(Server.MapPath(Path.Combine("~/files/", fname)));

                int newidint = 0;
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con2 = new SqlConnection(cs);
                con2.Open();
                SqlCommand cmd2 = new SqlCommand("SELECT top 1 * from MI order by id desc");
                cmd2.Connection = con2;
                SqlDataReader reader2 = cmd2.ExecuteReader();
                {
                    while (reader2.Read())
                    {
                        string newid = reader2["MIID"].ToString();
                        newidint = int.Parse(newid);             
                    }
                }
                con2.Dispose();

                string conString = string.Empty;              
                string extension = Path.GetExtension(MyFile.FileName);
                switch (extension)
                {
                    case ".xls": //Excel 97-03
                        conString = ConfigurationManager.ConnectionStrings["Excel03ConString"].ConnectionString;
                        break;
                    case ".xlsx": //Excel 07 or higher
                        conString = ConfigurationManager.ConnectionStrings["Excel07+ConString"].ConnectionString;
                        break;
                }

                int numberOfRows = 0;
                conString = string.Format(conString, excelPath);
                using (OleDbConnection excel_con = new OleDbConnection(conString))
                {
                    excel_con.Open();
                    string sheet1 = excel_con.GetOleDbSchemaTable(OleDbSchemaGuid.Tables, null).Rows[0]["TABLE_NAME"].ToString();
                   
                    DataTable dtExcelData = new DataTable();                                     

                    //[OPTIONAL]: It is recommended as otherwise the data will be considered as String by default.
                    dtExcelData.Columns.AddRange(new DataColumn[2] { new DataColumn("Id", typeof(int)),
                    new DataColumn("MIDESC", typeof(string))});
                    
                    using (OleDbDataAdapter oda = new OleDbDataAdapter("SELECT * FROM [" + sheet1 + "]", excel_con))
                    {
                        oda.Fill(dtExcelData);                  
                        numberOfRows = dtExcelData.Rows.Count;
                    }
                    excel_con.Close();                    

                    string consString = ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                    using (SqlConnection con = new SqlConnection(consString))
                    {
                        using (SqlBulkCopy sqlBulkCopy = new SqlBulkCopy(con))
                        {
                            //Set the database table name
                            sqlBulkCopy.DestinationTableName = "dbo.MI";

                            //[OPTIONAL]: Map the Excel columns with that of the database table
                            sqlBulkCopy.ColumnMappings.Add("Id", "Id");                            
                            sqlBulkCopy.ColumnMappings.Add("MIDESC", "MIDESC");                                      
                            con.Open();
                            sqlBulkCopy.WriteToServer(dtExcelData);
                            con.Close();                   
                        }
                    }
                }

                int startingMIID = newidint + numberOfRows;
                SqlConnection con3 = new SqlConnection(cs);
                con3.Open();
                SqlCommand cmd3 = new SqlCommand("SELECT top " + numberOfRows + " * from MI order by id desc");
                cmd3.Connection = con3;
                SqlDataReader reader3 = cmd3.ExecuteReader();
                {
                    while (reader3.Read())
                    {
                        string id = reader3["id"].ToString();
                        SqlConnection con4 = new SqlConnection(cs);
                        SqlCommand cmd4 = new SqlCommand("UPDATE MI SET MIID=" + startingMIID + ",CTSIDfk=" + ctsid + " where id=" + id, con4);
                        con4.Open();
                        cmd4.ExecuteNonQuery();
                        con4.Dispose();
                        startingMIID = startingMIID - 1;
                    }
                }
                con3.Dispose();                
    
                Response.Write("<script>alert('Import Successful')</script>");
                Response.Write("<script>window.location.href='../CAT/CTS.aspx?id=" + ctsid + "'</script>");
            }
        }
    }
}