﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Web.Script.Serialization;

namespace CAE_WEB_PROJECT.CAT
{
    /// <summary>
    /// Summary description for getreviews
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    [System.Web.Script.Services.ScriptService]
    public class getreviews : System.Web.Services.WebService
    {
        private string interpretDate(string date)
        {
            if (date == "1/1/1900 12:00:00 AM")
            {
                date = "";
            }
            if (date != "")
            {
                var dateTime = DateTime.Parse(date);
                date = dateTime.ToString("MM/dd/yyyy");
            }
            return date;
        }

        private string identifyMember(string memberId, string cs)
        {
            string memberName = "";
            if (memberId != "")
            {
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("SELECT * from members where id=" + memberId);
                cmd.Connection = con;
                SqlDataReader reader3 = cmd.ExecuteReader();
                {
                    while (reader3.Read())
                    {
                        string firstname = reader3["firstname"].ToString();
                        string lastname = reader3["lastname"].ToString();
                        string username = reader3["username"].ToString();
                        memberName = $"{lastname}, {firstname} ({username})";
                    }
                }
                con.Dispose();
            }
            return memberName;
        }

        [WebMethod]
        public void GetReviews()
        {
            string cs = ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            List<Review> reviewslist = new List<Review>();
            using (SqlConnection con = new SqlConnection(cs))
            {
                SqlCommand cmd = new SqlCommand("SELECT * from review order by id");
                cmd.Connection = con;
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        Review review = new Review();

                        review.Id = Convert.ToInt32(reader["ID"]);
                        string lessid = reader["lessid"].ToString();
                        review.lessid = Convert.ToInt32(reader["lessid"]);
                        string lessname = "";
                        SqlConnection con2 = new SqlConnection(cs);
                        con2.Open();
                        SqlCommand cmd2 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                        cmd2.Connection = con2;
                        SqlDataReader reader2 = cmd2.ExecuteReader();
                        {
                            while (reader2.Read())
                            {
                                string lessnumber = reader2["lessnumber"].ToString();
                                string lesstitle = reader2["lesstitle"].ToString();
                                lessname = lessnumber + " | " + lesstitle;
                            }
                        }
                        con2.Dispose();
                        review.lessname = lessname;

                        review.review_date = this.interpretDate(reader["review_date"].ToString());

                        string instructorid = reader["instructorid"].ToString();
                        review.instructorid = Convert.ToInt32(reader["instructorid"]);
                        review.instructorname = this.identifyMember(instructorid, cs);

                        review.last_change_date = this.interpretDate(reader["last_change_date"].ToString());

                        string chgAuthorId = reader["last_change_author"].ToString();
                        review.last_author_name = this.identifyMember(chgAuthorId, cs);

                        /*
                        reviews.tcpid = Convert.ToInt32(reader["tcp"]);
                        string tcpid = reader["tcp"].ToString();
                        string tcpname = "";
                        if (tcpid == "1")
                        {
                            tcpname = "Yes";
                        }
                        else
                        {
                            tcpname = "No";
                        }
                        reviews.tcpname = tcpname;
                        */

                        review.comments = reader["comments"].ToString();

                        reviewslist.Add(review);
                    }
                }
                con.Dispose();
            }
            JavaScriptSerializer js = new JavaScriptSerializer();
            js.MaxJsonLength = Int32.MaxValue;
            Context.Response.Write(js.Serialize(reviewslist));
        }
    }
}
