﻿<%@ Page Title="Lesson" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Lesson.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.Lesson" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/main.js"></script>
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script src="../scripts/catformlib.js"></script>

<script>
    const lessonCache = {};

    //Table 1 Variables
    var QID;
    var QNumber;
    var Description;
    var selid;

    //Table 2 Variables
    var SOIID;
    var SOITitle;
    var SOIDate;
    var selid2;

    //Table 3 Variables
    var PUBID;
    var PUBTitle;
    var PUBDate;
    var PUBRev;
    var selid3;

    //Table 4 Variables
    var Topic;
    var selid4;

    //Table 5 Variables
    var review_date;
    var instructorname;
    var tcp;
    var comments;
    var selid5;

    //Table 6 Variables
    var feedback_date;
    var feedback_type;
    var tcp;
    var comments;
    var selid6;

    const cacheLessonData = () => {
        // MMR VERIFIED 9/4/2024: the referenced ids match what is generated in Lesson.aspx.cs
        lessonCache.LESSNUMBER = $('#LESSNUMBER').val();
        lessonCache.LESSTITLE = $('#LESSTITLE').val();
        lessonCache.REVNUMBER = $('#REV').val();
        lessonCache.REVDATE = $('#REVDATE').val();
        lessonCache.MEDIANUMBER = $('#MEDIATYPE').val();
        lessonCache.SUBTYPENUMBER = $('#SUBTYPE').val()
        lessonCache.FEADATE = $('#FEADATE').val();
        lessonCache.STATUSNUMBER = $('#STATUS').val();
        lessonCache.CLASSNUMBER = $('#CLASSIFICATION').val();
        lessonCache.ICWL = $('#ICWL').val();
        lessonCache.MPNUMBER = $('#MP').val();
        lessonCache.LESSNOTE = $('#LESSNOTE').val();
        lessonCache.MESL = $('#MESL').val();
        lessonCache.AC130J = $("#FORMAC130J").prop("checked") ? "True" : "";
        lessonCache.HC130J = $("#FORMHC130J").prop("checked") ? "True" : "";
        lessonCache.MC130J = $("#FORMMC130J").prop("checked") ? "True" : "";
        lessonCache.UH1N = $("#FORMUH1N").prop("checked") ? "True" : "";
        lessonCache.HH60 = $("#FORMHH60").prop("checked") ? "True" : "";
        lessonCache.CV22 = $("#FORMCV22").prop("checked") ? "True" : "";
        lessonCache.FTRUCKER = $("#FORMFTRUCKER").prop("checked") ? "True" : "";
        lessonCache.PRIMARY_INSTRUCTOR_NUMBER = $('#PRIMARYINSTRUCTOR').val();
        lessonCache.ALTERNATE_INSTRUCTOR_NUMBER = $('#ALTERNATEINSTRUCTOR').val();
    };

    let currTab = null;
    function onBeforeUnloadPage(ev) {
        switch (currTab.id) {
            case "tab-nav-1":
                if (editLessonFormIsChanged(lessonCache)) {
                    ev.preventDefault();
                }
                break;
            default:
                break;
        }
    }
    function onSelectTab(ev) {
        const newTab = this;
        // The 'change' event is not cancelable on a set of radio buttons! Sad.
        if (!currTab) {
            console.log('HERE is a case where currTab is not set! So we need this!');
            return; // TODO: verify this is not needed, because there's always a current tab (default is the 1st, 'Info')
        }
        // Check the contents of the tab we're navigating away from.
        // Has the user forgotton to submit changes?
        switch (currTab.id) {
            case "tab-nav-1":
                if (editLessonFormIsChanged(lessonCache)) {
                    currTab.checked = true; // How we get around the lack of cancelability
                    askUserAboutChanges('changeAlert', 'lessonForm', () => {
                        newTab.checked = true;
                        currTab = newTab;
                    });
                }
                else {
                    currTab = newTab;
                }
                break;
            default:
                currTab = newTab;
                // TODO: ?
                break;
        }
    }

    $(document).ready(function () {
        $(function () {
            $("#REVDATE").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#FEADATE").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });
        cacheLessonData();

        const tabid = getUrlVars()["tabid"] || "1";
        switch (tabid) {
            case "1":
                currTab = document.getElementById("tab-nav-1");
                break;
            case "2":
                currTab = document.getElementById("tab-nav-2");
                break;
            case "3":
                currTab = document.getElementById("tab-nav-3");
                break;
            case "4":
                currTab = document.getElementById("tab-nav-4");
                break;
            case "5":
                currTab = document.getElementById("tab-nav-5");
                break;
            case "6":
                currTab = document.getElementById("tab-nav-6");
                break;
            case "7":
                currTab = document.getElementById("tab-nav-7");
                break;
        }
        if (!currTab)
            console.log('No currTab; tabid is', tabid, 'type', typeof tabid);
        else
        currTab.checked = true;
        $('input[name="tabs"]').each(function () { this.addEventListener('change', onSelectTab) })

        $("#selLesson").select2();
        $("#selObjective").select2();
        $("#PUBID").select2();
        $("#TOPIC").select2();
        var id = getUrlVars()["id"];

        var objectiveid = getUrlVars()["objid"];
        if (objectiveid != 0) {
            document.getElementById("selObjective").value = objectiveid;
            $("#selObjective").select2();
            document.getElementById("mitoobjbutton").style.display = "inline";
        }
        else {
            document.getElementById("mitoobjbutton").style.display = "none";
        }

        if (id != 0) {
            window.onbeforeunload = onBeforeUnloadPage;
            document.getElementById("LessonTabs").style.visibility = "visible";
            $('#LESSID').val(id);
            document.getElementById("selLesson").value = id;
            $("#selLesson").select2();
        }

        var questionid = getUrlVars()["questionid"];
        if (questionid != 0 && objectiveid != 0) {
            document.getElementById("QuestionsTable").style.visibility = "visible";
        }

        $('#example').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Questions"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data = table.row(this).data();
                savedata(data);
            }
        }); 

        $('#example2').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No SOIs"
            }
        });

        var table2 = $('#example2').DataTable();

        $('#example2 tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid2 = null;
            }
            else {
                table2.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data2 = table2.row(this).data();
                savedata2(data2);
            }
        });

        $('#example3').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Publications"
            }
        });

        var table3 = $('#example3').DataTable();

        $('#example3 tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid3 = null;
            }
            else {
                table3.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data3 = table3.row(this).data();
                savedata3(data3);
            }
        });

        $('#example4').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Categories"
            }
        });

        var table4 = $('#example4').DataTable();

        $('#example4 tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid4 = null;
            }
            else {
                table4.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data4 = table4.row(this).data();
                savedata4(data4);
            }
        });

        $('#example5').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Reviews"
            }
        });

        var table5 = $('#example5').DataTable();

        $('#example5 tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid5 = null;
            }
            else {
                table5.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                //var data5 = table5.row(this).data();
                //savedata5(data5);
            }
        });

        $('#example6').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Feedback"
            }
        });

        var table6 = $('#example6').DataTable();

        $('#example6 tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid6 = null;
            }
            else {
                table6.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                //var data6 = table6.row(this).data();
                //savedata6(data6);
            }
        });

        const dlg = document.getElementById('changeAlert');
        dlg.addEventListener('keydown', function (ev) {
            // Make Esc equivalent to the Cancel button:
            if (ev.key === 'Escape') this.returnValue = 'c';
        });
    });

    function savedata(rowdata) {
        QID = rowdata[0];
        QNumber = rowdata[1]
        Description = rowdata[2];
        Description = Description.replace("<textarea rows=\"10\" cols=\"130\" style=\"resize: none;\" readonly=\"\">", "");
        Description = Description.replace("</textarea>", "");
        selid = rowdata[3];
    }

    function savedata2(rowdata) {
        SOIID = rowdata[0];
        SOITitle = rowdata[1]
        SOIDate = rowdata[2];
        selid2 = rowdata[3];
    }

    function savedata3(rowdata) {
        PUBID = rowdata[0];
        PUBTitle = rowdata[1]
        PUBDate = rowdata[2];
        PUBRev = rowdata[3];   
        selid3 = rowdata[4];
    }

    function savedata4(rowdata) {
        Topic = rowdata[0];
        selid4 = rowdata[1];
    }

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function addQuestion() {
        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };

        var objectiveid = getUrlVars()["objid"];
        $('#objid').val(objectiveid);
        var lessid = getUrlVars()["id"];
        $('#qlessid').val(lessid);
    }

    function addPUB() {
        // Get the modal
        var modal = document.getElementById("myModal3");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close3")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };

        var objectiveid = getUrlVars()["objid"];
        $('#objid3').val(objectiveid);
        var lessid = getUrlVars()["id"];
        $('#lessid3').val(lessid);
    }

    function addCAT() {
        // Get the modal
        var modal = document.getElementById("myModal4");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close4")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };

        var objectiveid = getUrlVars()["objid"];
        $('#objid4').val(objectiveid);
        var lessid = getUrlVars()["id"];
        $('#lessid4').val(lessid);
    }

    function editdata() {  
        if (selid == null) {
            alert("No row selected")
            return;
        }

        // Get the modal
        const modal = document.getElementById("myModal2");
        modal.style.display = "block";

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;
        const revertAndClose = () => {
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        $('#myModal2 .close2')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            revertAndClose();
        }
        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (ev) {
            if (ev.target == modal) {
                revertAndClose();
            }
        }
        document.onkeydown = function (ev) {
            if (ev.key === 'Escape') {
                revertAndClose();
            }
        };

        // These all apply to form "Edit Question"
        $('#editrowid').val(selid);
        var objectiveid = getUrlVars()["objid"];
        $('#editobjid').val(objectiveid);
        var lessid = getUrlVars()["id"];
        $('#editlessid').val(lessid);
        $('#EditQNumber').val(QNumber);
        $('#EditDesc').val(Description);
    }        

    function deldata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this question?") == true) {
                var objectiveid = getUrlVars()["objid"];
                var lessid = getUrlVars()["id"];
                window.location.href = "../CAT/deletequestion.aspx?selid=" + selid + "&lessid=" + lessid + "&objid=" + objectiveid;
            } else {
                return;
            }
        }
    }

    function deldata3() {
        if (selid3 == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to dissociate this publication from this lesson?") == true) {
                var objectiveid = getUrlVars()["objid"];
                var lessid = getUrlVars()["id"];
                window.location.href = "../CAT/removepub.aspx?selid=" + selid3 + "&lessid=" + lessid + "&objid=" + objectiveid;
            } else {
                return;
            }
        }
    }

    function deldata4() {
        if (selid4 == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to dissociate this category from this lesson?") == true) {
                var objectiveid = getUrlVars()["objid"];
                var lessid = getUrlVars()["id"];
                window.location.href = "../CAT/removecat.aspx?selid=" + selid4 + "&lessid=" + lessid + "&objid=" + objectiveid;
            } else {
                return;
            }
        }
    }

    function loadtabs() {
        var dropdownid = document.getElementById('selLesson').value;
        //alert(dropdownid);
        window.location.href = "../CAT/Lesson.aspx?id=" + dropdownid + "&objid=0&questionid=0";
    }

    function EditObjectives() {
        var id = getUrlVars()["id"];
        window.location.href = "../CAT/EditObjectives.aspx?id=" + id;
    }

    function loadquestions() {
        var lessonid = getUrlVars()["id"];  
        var objectiveid = document.getElementById('selObjective').value;
        window.location.href = "../CAT/Lesson.aspx?id=" + lessonid + "&objid=" + objectiveid + "&questionid=1&tabid=2";
    }

    function changecursor() { 
        //this function is not being called, leaving for reference
        document.body.style.cursor = 'wait';
        setTimeout(function () {
            document.body.style.cursor = 'default';
        }, 14000);
    }

    function addMI() {
        var objectiveid = getUrlVars()["objid"];
        var lessid = getUrlVars()["id"];
        window.location.href = "../CAT/viewMItoObj.aspx?lessid=" + lessid + "&objid=" + objectiveid + "&soiid=0";
    }

    function verificationrpt() {
        var lessid = getUrlVars()["id"];
        window.open("../CAT/rptFEA.aspx?lessid=" + lessid + "&type=4", "_blank");
    }

    function datepickeroff() {
        $("#REVDATE").datepicker("disable");
    }

    function datepickeroff2() {
        $("#FEADATE").datepicker("disable");
    }

    function openICWL() {
        window.open('../images/ICWL.pdf', '_blank');
    }

    function deleteless() {
        if (confirm("Are you sure that you want to delete this lesson?") == true) {
            var lessid = getUrlVars()["id"];
            window.location.href = "../CAT/delLesson.aspx?selid=" + lessid;
        } else {
            return;
        }
    }

    function checkDate(dateStr) {
        // Empty string is OK; else we need to analyze it
        if (dateStr) {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateStr)) {
                return false;
            }

            // Parse the date parts to integers
            const parts = dateStr.split("/");
            const month = parseInt(parts[0], 10);
            const year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                return false;
            }
        }
        return true;
    }

    function isAllValid(form) {
        let isGood = true;
        const beforeunloadHandler = window.onbeforeunload;
        window.onbeforeunload = null;
        if (!checkDate(form.REVDATE.value)) {
            alert("ERROR: Dates must be valid!");
            isGood = false;
        }
        if (!checkDate(form.FEADATE.value)) {
            alert("ERROR: Dates must be valid!");
            isGood = false;
        }
        if (!isGood) {
            window.onbeforeunload = beforeunloadHandler;
            return false;
        }
    }

    function togglereadonly() {
        const $rev = $('#REV');
        const $revDate = $('#REVDATE');
        const $classif = $('#CLASSIFICATION');
        const $icwl = $('#ICWL');

        // TODO: find out what MP=='A' means, and why these fields get disabled in that case,
        // and whether the values in these fields should be cleared when MP 'A' is selected.
        // This also goes for EditLessons.aspx
        if ($('#MP').val() == '1') {
            $rev.removeAttr("required")
                .css({ backgroundColor: "black", pointerEvents: "none" });
            $revDate.prop('readOnly', true)
                .css({ backgroundColor: "black" })
                .datepicker("disable");
            $classif.removeAttr("required")
                .css({ backgroundColor: "black", pointerEvents: "none" });
            $icwl.css({ backgroundColor: "black", pointerEvents: "none" });
        }
        else {
            $rev.attr("required", true)
                .css({ backgroundColor: "#3b4148", pointerEvents: "auto" });
            $revDate.prop('readOnly', false)
                .css({ backgroundColor: "#3b4148" })
                .datepicker("enable");
            $classif.attr("required", true)
                .css({ backgroundColor: "#3b4148", pointerEvents: "auto" });
            $icwl.css({ backgroundColor: "#3b4148", pointerEvents: "auto" });
        }            
    }
</script>

<style>

.select2-search__field {
    color: black;
}
#main {
    overflow-x: hidden;  
    min-height: 500px;
}
.editlink{
    font-size: small;
    text-decoration: none;
    line-height: 30px;
}
.editlink:hover{
    text-decoration: underline;
}

@import "compass/css3";

* {
  box-sizing: border-box;
}

::selection {
  background-color: #005EB8;
}

.tabbed {
  width: 1500px;
  height: 1800px;
  margin: 20px auto;
}

.tabbed > input {
  display: none;
}

.tabbed > label {
  display: block;
  float: left;
  padding: 12px 20px;
  margin-right: 5px;
  cursor: pointer;
  transition: background-color .3s;
}

.tabbed > label:hover,
.tabbed > input:checked + label {
  background: #005EB8;
  color: white;
}

.tabs {
  clear: both;
  perspective: 600px;
}

.tabs > div {
  width: 1500px;
  position: absolute;
  border: 2px solid #005EB8;
  padding: 10px 30px 40px;
  line-height: 1.4em;
  opacity: 0;
  transform: rotateX(-20deg);
  transform-origin: top center;
  transition: opacity .3s, transform 1s;
  z-index: 0;
}

#tab-nav-1:checked ~ .tabs > div:nth-of-type(1),
#tab-nav-2:checked ~ .tabs > div:nth-of-type(2),
#tab-nav-3:checked ~ .tabs > div:nth-of-type(3),
#tab-nav-4:checked ~ .tabs > div:nth-of-type(4),
#tab-nav-5:checked ~ .tabs > div:nth-of-type(5),
#tab-nav-6:checked ~ .tabs > div:nth-of-type(6),
#tab-nav-7:checked ~ .tabs > div:nth-of-type(7){
  transform: rotateX(0);
  opacity: 1;
  z-index: 1;
}

@media screen and (max-width: 1500px) {
  .tabbed { width: 400px }
  .tabbed > label { display: none }
  .tabs > div {
    width: 400px;
    border: none;
    padding: 0;
    opacity: 1;
    position: relative;
    transform: none;
    margin-bottom: 60px;
  }
  .tabs > div h2 {
    border-bottom: 2px solid #005EB8;
    padding-bottom: .5em;
  }
  #main{
    height: 5000px;
  }
  #myModal{
    width: 525px;
  }
  #myModal2{
    width: 525px;
  }
  #divcheckboxes {
    overflow-x: auto;  
    white-space: nowrap;
  }
}

.modal{
    width: 1700px;
}
#myModal4{
    width: 525px;
}

#divcheckboxes{
    background-color: #3b4148;
    border-radius: 0.25rem;
}
#divcheckboxes > input[type="checkbox"] {
    margin-left: 18px;
}
#divcheckboxes label{
    padding: 1rem 5px;
}
.InfoTitles{
    padding-top: 1rem;
    float: left;
    width: 200px;
    color: black;
    text-align: right;
}
#infobutton{
    height: 20px;
    width: 20px;
    cursor: pointer;
}
#changeAlert {
    position: absolute;
    left: 50%; top: 50%;
    transform: translate(-50%, -50%);
    width: 450px;
    padding: 10px;
    border: 2px solid darkred;
}
#changeAlert form {
    margin-top: 20px;
    text-align: center;
}
#changeAlert button {
    width: 108px;
    padding: 4px 0;
    color: #fff;
    background-color: #606060;
    border: none;
    border-radius: 2px;
}
#changeAlert button:not(:first-of-type) {
    margin-left: 10px;
}
#changeAlert button[autofocus] {
    background-color: #0080ff;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Lesson</h1></div>
<hr />
<br />

<div style="text-align: center; min-width: 550px;">
    <select id="selLesson" style="width: 450px;" onchange="loadtabs()">
        <asp:Label ID="Label1" runat="server" />
    </select>
    <asp:Label ID="Label11" runat="server" />
</div>

<br />
<hr />
<br />
<asp:Label ID="Label2" runat="server" />

<div id="LessonTabs" style="margin: 35px; visibility: hidden;">
  <div class="tabbed">
    <input type="radio" name="tabs" id="tab-nav-1" checked>
    <label for="tab-nav-1">Info</label>
    <input type="radio" name="tabs" id="tab-nav-2">
    <label for="tab-nav-2">Objectives and Questions</label>
    <input type="radio" name="tabs" id="tab-nav-3">
    <label for="tab-nav-3">Associated SOIs</label>
    <input type="radio" name="tabs" id="tab-nav-4">
    <label for="tab-nav-4">Associated Publications</label>
    <input type="radio" name="tabs" id="tab-nav-5">
    <label for="tab-nav-5">Categories</label>
    <input type="radio" name="tabs" id="tab-nav-6">
    <label for="tab-nav-6">Reviews</label>
    <input type="radio" name="tabs" id="tab-nav-7">
    <label for="tab-nav-7">Feedback</label>
    <div class="tabs">
      <!-- Info -->
      <div><h2>Info</h2>
       <div style="float: right; margin-top: 4px;">
          <!--<img src="../images/adobe.png" onclick="verificationrpt()" title="Verification Report" alt="Verification Report" style="width: 30px; height: 32px; cursor: pointer;" /> -->
            <asp:Label ID="Label12" runat="server" /> 
            <button class="button" onclick="verificationrpt()">Verification Report</button><br /><br />
       </div>
       <br /><br /><br /><br />
       <div style="color: maroon; background-color: aliceblue; text-align: center; border: 2px solid #005EB8; padding: 3px;"><b>Due to inconsistencies in lesson duration between multiple SOIs, please see associated AETC Bookstore published SOI for exact lesson duration.</b></div>
       <br /><br />
       <form id="lessonForm" class="form login" name="form1" action="../CAT/UpdateLesson.aspx?id=lesson" method="post" enctype="multipart/form-data" onsubmit="return isAllValid(this)">
          <asp:Label ID="Label10" runat="server" />
       </form>
      </div>

      <!-- Objectives and Questions -->
      <div><h2>Objectives and Questions</h2><br />
        <select id="selObjective" style="width: 85%;" onchange="loadquestions()">
            <asp:Label ID="Label3" runat="server" />
        </select>
        <a class="editlink" style="color: blue; cursor: pointer;" onclick="EditObjectives();">(edit list)</a>

        <div id="QuestionsTable" style="margin: 35px; visibility: hidden; min-width: 400px;">
            <hr />
            <button id="mitoobjbutton" class="button" onclick="addMI()" style="float: right;">Add MIs to Objective</button>
            <br /><br /><br />
            <h3 style="text-align: center;">Question(s)</h3>
                <asp:Label ID="Label15" runat="server" />
            <br />      
            <table id="example" class="display" style="width:100%; border: none;">
                <thead style="background-color: #005EB8; color: white">
                    <tr>
                        <th>Question ID</th>
                        <th>Question Number</th>
                        <th>Question Text</th>
                        <th style="display:none;">ID</th>
                    </tr>
                </thead>
                <tbody>
                    <asp:Label ID="Label4" runat="server" />
                </tbody>
            </table>
        </div>
      </div>      

      <!-- Associated SOIs -->
      <div id="SOIs"><h2>Associated SOIs</h2><br />

        <!-- Commenting out buttons because this data is READ ONLY on Lesson page and maintained on SOI page -->
        <!--
        <button class="button" onclick="addSOI()">Add New</button>
        <button class="button" onclick="editdata2()">Edit Row</button>
        <button class="button" onclick="deldata2()">Dissociate</button>
        <br /><br />   
        -->
        <table id="example2" class="display" style="width:100%; border: none">
            <thead style="background-color: #005EB8; color: white">
                <tr>
                    <th>SOI ID</th>
                    <th>SOI Title</th>
                    <th>SOI Date</th>
                    <th style="display:none;">ID</th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="Label5" runat="server" />
            </tbody>
        </table>
      </div>

      <!-- Associated Publications -->
      <div><h2>Associated Publications</h2><br />
        <asp:Label ID="Label16" runat="server" />
        <table id="example3" class="display" style="width:100%; border: none">
            <thead style="background-color: #005EB8; color: white">
                <tr>
                    <th>Pub Number</th>
                    <th>Pub Title</th>
                    <th>Pub Date</th>
                    <th>Pub Rev</th>
                    <th style="display:none;">ID</th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="Label6" runat="server" />
            </tbody>
        </table>
      </div>
      
      <!-- Categories -->
      <div><h2>Categories</h2><br />
        <asp:Label ID="Label17" runat="server" />
        <table id="example4" class="display" style="width:100%; border: none">
            <thead style="background-color: #005EB8; color: white">
                <tr>
                    <th>Topic</th>
                    <th style="display:none;">ID</th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="Label7" runat="server" />
            </tbody>
        </table>
      </div>

      <!-- Reviews -->
      <div><h2>Reviews</h2><br />
        <table id="example5" class="display" style="width:100%; border: none">
            <thead style="background-color: #005EB8; color: white">
                <tr>
                    <th style="width: 50px;">Review Date</th>
                    <th style="width: 100px; min-width: 100px;">Instructor</th>
                    <!--th style="width: 50px;">TCP Requested</th-->
                    <th style="width: 300px; min-width: 300px;">Comments</th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="Label13" runat="server" />
            </tbody>
        </table>
      </div>

      <!-- Feedback -->
      <div><h2>Feedback</h2><br />
        <table id="example6" class="display" style="width:100%; border: none">
            <thead style="background-color: #005EB8; color: white">
                <tr>
                    <th style="width: 50px;">Feedback Date</th>
                    <th style="width: 100px; min-width: 100px;">Feedback Type</th>
                    <!--th style="width: 50px;">TCP Requested</th-->
                    <th style="width: 300px; min-width: 300px;">Comments</th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="Label14" runat="server" />
            </tbody>
        </table>
      </div>

    </div>
  </div>
</div>

<!------------------------------------------------------ Objectives and Questions ----------------------------------------------------------------->
<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add New Question</h4><br />
       <form class="form login" name="form1" action="../CAT/addQuestion.aspx" method="post" enctype="multipart/form-data" >
           <input type="hidden" name="qlessid" id="qlessid" />
           <input type="hidden" name="objid" id="objid" />
           <div class="form__field">
               <input style="color: white" type="number" name="QNumber" id="QNumber" placeholder="Question Number" min="1" />
           </div>
           <div class="form__field">
               <textarea class="textareastyle" name="Desc" id="Desc" placeholder="Question Text" style="resize: none;" ></textarea>
           </div>
           <div class="form__field">
               <input type="submit" value="Submit" style="width: 300px;" />
           </div>
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Question</h4><br />
       <form class="form login" name="form1" action="../CAT/editQuestion.aspx" method="post" enctype="multipart/form-data" >
           <input type="hidden" name="editrowid" id="editrowid" />
           <input type="hidden" name="editlessid" id="editlessid" />
           <input type="hidden" name="editobjid" id="editobjid" />
           <div class="form__field">
               <input style="color: white" type="number" name="EditQNumber" id="EditQNumber" placeholder="Question Number" min="1" />
           </div>
           <div class="form__field">
               <textarea class="textareastyle" name="EditDesc" id="EditDesc" placeholder="Question Text" style="resize: none;" ></textarea>
           </div>
           <div class="form__field">
               <input type="submit" value="Update" style="width: 300px;" />
           </div>
       </form>
  </div>
</div>

<!-------------------------------------------------- Associated Publications ------------------------------------------------------------->
<!-- The Modal -->
<div id="myModal3" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close3">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add Publication</h4><br />
       <form class="form login" name="form1" action="../CAT/addPublication.aspx" method="post" enctype="multipart/form-data" >
           <input type="hidden" name="lessid3" id="lessid3" />
           <input type="hidden" name="objid3" id="objid3" />
           <div class="form__field" style="color: black;">
                <select class="selectstyle" id="PUBID" name="PUBID" style="width: 100%;" required>
                     <asp:Label ID="Label8" runat="server" />
                </select>
           </div>
           <div class="form__field">
               <input type="submit" value="Submit" style="width: 300px;" />
           </div>
       </form>
  </div>
</div>

<!--------------------------------------------------------- Categories ------------------------------------------------------------------->
<!-- The Modal -->
<div id="myModal4" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close4">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add Category</h4><br />
       <form class="form login" name="form1" action="../CAT/addCategory.aspx" method="post" enctype="multipart/form-data" >
           <input type="hidden" name="lessid4" id="lessid4" />
           <input type="hidden" name="objid4" id="objid4" />
           <div class="form__field" style="color: black">
                <select class="selectstyle" id="TOPIC" name="TOPIC" style="width: 100%;" required>
                     <asp:Label ID="Label9" runat="server" />
                </select>
           </div>
           <div class="form__field">
               <input type="submit" value="Submit" />
           </div>
       </form>
  </div>
</div>

<dialog id="changeAlert">
    <p>Changes have been made to the information in this form.
       Would you like to save the changes?</p>
    <form method="dialog">
        <button value="c">Cancel</button>
        <button value="n">Don't Save</button>
        <button value="y" autofocus>Save</button>
    </form>
</dialog>

</asp:Content>
