﻿<%@ Page Title="Reviews" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Reviews.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.Reviews" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var lessname;
    var review_date;
    var instructorname;
    var tcpname;    
    var comments; 
    var lessid;
    var instructorid;
    var tcpid;
    var selid;
    // TODO: delete all of the above when we have everything using the cache object instead

    const rvwItemCache = {};

    $(document).ready(function () {
        $(function () {
            $("#review_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#editreview_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $("#lessid").select2();

        $.ajax({
            url: 'getreviews.asmx/GetReviews',
            method: 'post',
            dataType: 'json',
            success: function (data) {
                $('#example').dataTable({
                    "bPaginate": false,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bInfo": true,
                    "bAutoWidth": true,
                    "scrollY": "400px",
                    "sScrollX": "100%",
                    "sScrollXInner": "100%",
                    "scrollCollapse": true,
                    "language": {
                        "emptyTable": "No Reviews"
                    },
                    data: data,
                    columns: [
                        { 'data': 'lessname' },
                        { 'data': 'review_date' },
                        { 'data': 'instructorname' },
                        { 'data': 'last_change_date' },
                        { 'data': 'last_author_name' },
                        //{ 'data': 'tcpname' },
                        { 'data': 'comments' },   
                        { 'data': 'lessid', "visible": false },
                        { 'data': 'instructorid', "visible": false },
                        //{ 'data': 'tcpid', "visible": false },
                        { 'data': 'Id', "visible": false }
                    ]
                });
                var table = $('#example').DataTable();

                $('#example tbody').on('click', 'tr', function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        rvwItemCache.Id = null;
                    }
                    else {
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        var data = table.row(this).data();
                        //const myJSON = JSON.stringify(data);
                        //alert(myJSON);                        
                        cacheData(data);
                    }
                });
            }
        });
    });

    function cacheData(rowdata) {
        Object.assign(rvwItemCache, rowdata);
    }

    // Clear entries/selections from the modal form.
    // Note that we don't need to call this after submit, because the page is reloaded by addReview/editReview.
    const clearForm = () => {
        document.getElementById('rvwform').reset();
        setTimeout(function () {
            $('#lessid').trigger('change');
        }, 0);
        $('#rvwid').val('');
    };

    function newReview() {
        const modal = document.getElementById("modalScreen");
        clearForm();
        document.getElementById('formTitle').innerHTML = 'New Review';
        $('#rvwform').attr('action', '../CAT/addReview.aspx');
        modal.style.display = "block";

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;
        const revertAndClose = () => {
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        // (Note: the documentation for document.querySelector describes a really inefficient approach)
        $('#modalScreen .close')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            revertAndClose();
        }

        // When the user clicks anywhere outside of content area of the modal, close it
        // (*not* when the click is inside the content area, except the x, handled above)
        window.onclick = function (ev) {
            if (ev.target == modal) {
                revertAndClose();
            }
        }

        document.onkeydown = function (evt) {
            if (evt.key === 'Escape') {
                revertAndClose();
            }
        };
    }

    function editData() {       
        if (rvwItemCache.Id == null) {
            alert("No row selected");
            return;
        }

        clearForm();
        document.getElementById('formTitle').innerHTML = 'Edit Review';
        $('#rvwform').attr('action', '../CAT/editReview.aspx');

        $('#rvwid').val(rvwItemCache.Id);

        setTimeout(function () {
            $('#lessid').val(rvwItemCache.lessid).trigger('change');
        }, 0);

        $('#review_date').val(rvwItemCache.review_date);
        $('#instructorid').val(rvwItemCache.instructorid);

        //alert(tcp);
        /*
        if (tcpid == 1) {
            setTimeout(function () {
                $("#tcp").prop("checked", true);
            }, 0);
        }
        else {
            setTimeout(function () {
                $("#tcp").prop("checked", false);
            }, 0);
        }
        */
        $('#comments').val(rvwItemCache.comments);      

        // Get the modal
        const modal = document.getElementById("modalScreen");
        modal.style.display = "block";

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;

        const revertAndClose = () => {
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        $('#modalScreen .close')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            revertAndClose();
        }

        // When the user clicks anywhere outside of content area of the modal, close it
        window.onclick = function (ev) {
            if (ev.target == modal) {
                revertAndClose();
            }
        }

        document.onkeydown = function (evt) {
            if (evt.key === 'Escape') {
                revertAndClose();
            }
        };
    }

    function deleteData() {      
        if (rvwItemCache.Id == null) {
            alert("No row selected")
        }
        else if (confirm("Are you sure that you want to delete this review?") == true) {
            window.location.href = "../CAT/deletereview.aspx?selid=" + rvwItemCache.Id;
        }
    }

    function checkDate(form) {
        var review_dateString = form.review_date.value;

        if (review_dateString) {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(review_dateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = review_dateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }    
        }
    }

    // This is basicly exactly the same as previous function.
    // TODO: delete when we have consolidated the 2 forms
    function checkDate2(form) {
        var editreview_dateString = form.editreview_date.value;  

        if (editreview_dateString) {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(editreview_dateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = editreview_dateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }
        }
    }
</script>

<style>
.select2-search__field {
    color: black;
}
#main {
    overflow-x: hidden;
}

@media screen and (max-width: 1300px) {
  #myModal{
        width: 525px;
    }
  #myModal2{
        width: 525px;
    }
}

.modal{
    width: 1700px;
}
/* "TCP" (TCP Requested) checkbox removed (until further notice) */
#tcpcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 15px;
    width: 130px;
}
#tcp{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#tcpcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Reviews</h1></div>
<hr />
<div id="PUBTable" style="margin: 35px;">
<div style="min-width: 500px;">
    <asp:Label ID="Label4" runat="server" /> 
</div>
<table id="example" class="display" style="width:100%; border: none;">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th style="min-width: 100px;">Lesson</th>
                <th style="width: 50px;">Review Date</th>    
                <th style="width: 50px;">Instructor</th>  
                <th style="width: 50px;">Last Changed</th>    
                <th style="width: 50px;">Changed By</th>  
                <!--th style="width: 50px;">TCP Requested</th-->
                <th style="min-width: 250px;">Comments</th>
                <th style="display:none;">Lesson ID</th>
                <th style="display:none;">Instructor ID</th>
                <!--th style="display:none;">TCP ID</th-->
                <th style="display:none;">ID</th>
            </tr>
        </thead>
    </table>
</div>

<!-- The Modal -->
<div id="modalScreen" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 id="formTitle" style="text-align: center">New Review</h4><br />
       <form id="rvwform" class="form login" name="form1" action="../CAT/addReview.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate(this)">
           <input type="hidden" name="rvwid" id="rvwid" /> 
           <div class="form__field" style="color: black">
                <select class="selectstyle" id="lessid" name="lessid" style="width: 100%;" required>
                     <asp:Label ID="Label1" runat="server" />
                </select>
           </div>
           <div class="form__field" style="color: black">
               <input id="review_date" name="review_date" type="text" placeholder="Review Date" style="color: white" autocomplete="off" required />
           </div>
           <div class="form__field" style="color: black">
                <select class="selectstyle" id="instructorid" name="instructorid" style="width: 100%;" required>
                     <asp:Label ID="Label2" runat="server" />
                </select>
           </div>
           <!--div class="form__field" id="tcpcheckbox">
           &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='tcp' name='tcp'><label for='tcp'>&nbsp;&nbsp;TCP&nbsp;&nbsp;&nbsp;&nbsp;</label>
           </div-->
           <div class='form__field'>
               <textarea class='textareastyle' name='comments' id='comments' placeholder='Comments' style='resize: none;'></textarea>
           </div>
           <div class="form__field">
               <input type="submit" value="Submit" style="width: 300px;" />
           </div>
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Review</h4><br />
       <form class="form login" name="form1" action="../CAT/editReview.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate2(this)">
       <input type="hidden" name="editid" id="editid" /> 
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="editlessid" name="editlessid" style="width: 100%;" required>
                 <asp:Label ID="Label3" runat="server" />  
            </select>
       </div>
       <div class="form__field" style="color: black">
       <input id="editreview_date" name="editreview_date" type="text" placeholder="Review Date" style="color: white" autocomplete="off" required />
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="editinstructorid" name="editinstructorid" style="width: 100%;" required>
                 <asp:Label ID="Label5" runat="server" />  
            </select>
       </div>
       <div class="form__field" id="edittcpcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='edittcp' name='edittcp'><label for='edittcp'>&nbsp;&nbsp;TCP&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class='form__field'>
           <textarea class='textareastyle' name='editcomments' id='editcomments' placeholder='Comments' style='resize: none;'></textarea>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" style="width: 300px;" />
       </div>       
       </form>
  </div>
</div>

</asp:Content>
