﻿<%@ Page Title="Course Training Standards (CTS)" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="CTS.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.CTS" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 
   
<script>
    var MIID;
    var Description;
    var selid;

    $(document).ready(function () {   
        
        $("#ddlTest").select2();
        var id = getUrlVars()["id"];

        if (id != 0) {
            document.getElementById("MITable").style.visibility = "visible"; 
            $('#CTSID').val(id);
            document.getElementById("ddlTest").value = id;
            $("#ddlTest").select2();  
        }

        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": true,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Manuever Items (MIs)"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;               
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');   
                var data = table.row(this).data();
                savedata(data);
            }          
        });       
    }); 

    function savedata(rowdata) {
        MIID = rowdata[0];
        Description = rowdata[1];
        selid = rowdata[2];       
    }

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function addMI() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }
        var modalcheck = document.getElementById("myModal3");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };        
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }
            var modalcheck = document.getElementById("myModal3");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#EditMIID').val(MIID);
            $('#EditDesc').val(Description);            
        }        
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this item?") == true) {
                var ctsid = getUrlVars()["id"];
                window.location.href = "../CAT/deleteitem.aspx?selid=" + selid + "&ctsid=" + ctsid;
            } else {
                return;
            }            
        }
    }

    function loaddatatable() {
        var dropdownid = document.getElementById('ddlTest').value;
        //alert(dropdownid);     
        window.location.href = "../CAT/CTS.aspx?id=" + dropdownid;
    }

    function importdata() {
        var modalcheck = document.getElementById("myModal");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        var ctsid = getUrlVars()["id"];
        $('#ctsid').val(ctsid);
        // Get the modal
        var modal = document.getElementById("myModal3");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close3")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }
</script>

<style>
.select2-search__field {
    color: black;
}
#main {
    overflow-x: hidden;
}
#editlink{
    font-size: small;
    text-decoration: none;
    line-height: 30px;
}
#editlink:hover{
    text-decoration: underline;
}

@media screen and (max-width: 1300px) {
  #myModal{
        width: 525px;
    }
  #myModal2{
        width: 525px;
    }
  #myModal3{
        width: 525px;
    }
  #importimg{
      width: 95%;
  }
}

.modal{
    width: 1000px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Course Training Standards (CTS)</h1></div>
<hr />
<br />

<div style="text-align: center; min-width: 550px;">   
    <select id="ddlTest" style="width: 450px;" onchange="loaddatatable()">
        <asp:Label ID="Label3" runat="server" />
    </select>
    <asp:Label ID="Label4" runat="server" />
</div>

<br />
<hr />
<div id="MITable" style="margin: 35px; visibility: hidden;">
<table style="border: 1px solid; background-color: antiquewhite; margin: auto; left: 0; right: 0; top: 0; bottom: 0; padding: 5px; width: 50%; min-width: 500px;">
<thead>
<tr>
<th style="width: 33%;">CTS ID</th>
<th style="width: 34%;">CTS</th>
<th style="width: 33%;">Release Date</th>
</tr>
</thead>
<tbody style="text-align: center;">
<tr>
<asp:Label ID="Label1" runat="server" />
</tr>
</tbody>
</table>
<br />
<div style="min-width: 500px;">
<asp:Label ID="Label5" runat="server" />  
</div>
<br /><br />
<h2 style="text-align: center;">Manuever Items (MIs)</h2>
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th style="width: 300px;">MI ID</th>
                <th>Description</th>    
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label2" runat="server" />                          
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add New Item</h4><br />
       <form class="form login" name="form1" action="../CAT/addMI.aspx" method="post" enctype="multipart/form-data" >
       <input type="hidden" name="CTSID" id="CTSID" /> 
       <div class="form__field">
       <input style="color: white" type="text" name="Desc" id="Desc" placeholder="Description" required="required"/>
       </div>
       <div class="form__field">
       <input type="submit" value="Submit" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Item</h4><br />
       <form class="form login" name="form1" action="../CAT/editMIrow.aspx" method="post" enctype="multipart/form-data" >
       <input type="hidden" name="editid" id="editid" />  
       <div class="form__field" style="display: none;">
       <input style="color: white" type="number" name="EditMIID" id="EditMIID" placeholder="MI ID" required="required"/>
       </div>       
       <div class="form__field">
       <input style="color: white" type="text" name="EditDesc" id="EditDesc" placeholder="Description" required="required"/>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal3" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">    
    <span class="close3">&times;</span>
    <br /><br />
    <h4 style="text-align: center">Import Data</h4><br />
    <p style="color: maroon; font-weight: bold; margin-left: 10px;">Excel file must be in the following format for successful import:</p><br />
    <img id="importimg" src="../images/mi-import-ss.png" style="margin-left: 10px;" /><br /><br />    
       <form class="form login" name="form1" action="../CAT/importMIdata.aspx" method="post" enctype="multipart/form-data" >
       <input type="hidden" name="ctsid" id="ctsid" />  
       <div class="form__field"> 
            <input style="color: black; margin-left: 30px;" type="file" id="myfile" name="myfile" required="required">
       </div>    
       <div class="form__field">
       <input type="submit" value="Import" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
