﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;

namespace CAE_WEB_PROJECT.CAT
{
    /**
     * A utility class with operations to convert values from the database
     * into strings in standard formats to display on our web pages
     */
    public class DbToWeb
    {
        private Dictionary<string, string> memberCache = new Dictionary<string, string>();
        private Dictionary<string, string> revCache = new Dictionary<string, string>();
        private Dictionary<string, int> airfrmIdCache = new Dictionary<string, int>();
        private List<string> airframeNameList = new List<string>();
        private Dictionary<string, string> rplCache = new Dictionary<string, string>();

        /**
         * <summary>
         * identifyMember: get a display string for the given member Id, in the form
         * "Lastname, Firstname (username)".
         * Populates the <c>memberCache</c> from the database on first use.
         * </summary>
         * <remarks>
         * Warning: this should only be used in loops, for example, when generating a
         * listview with a members column (such as Instructor) with multiple rows.
         * This is because it fetches *all* the member rows from the DB on first use,
         * creates a formatted name string for each, and caches them in the Dictionary
         * (declared above) for easy lookup.
         * You wouldn't want to do all that if you expected to display only one or two
         * members on your page.
         * </remarks>
         */
        public string identifyMember(string memberId, string cs)
        {
            string memberName = "";
            if (!String.IsNullOrEmpty(memberId))
            {
                if (memberCache.Count == 0)
                {
                    SqlConnection con = new SqlConnection(cs);
                    con.Open();
                    SqlCommand cmd = new SqlCommand("SELECT Id, firstname, lastname, username from members");
                    cmd.Connection = con;
                    SqlDataReader reader3 = cmd.ExecuteReader();
                    {
                        while (reader3.Read())
                        {
                            string id = reader3["Id"].ToString();
                            string firstname = reader3["firstname"].ToString();
                            string lastname = reader3["lastname"].ToString();
                            string username = reader3["username"].ToString();
                            memberCache.Add(id, $"{lastname}, {firstname} ({username})");
                        }
                    }
                    con.Dispose();
                }
                memberName = memberCache[memberId];
            }
            return memberName;
        }

        public string getRevName(string revId, string cs)
        {
            // Currently there are 116 REV names, most of which are unlikely to be used (AFAIK).
            // I'm still on the fence about this implementation.
            string revName = "";
            if (!String.IsNullOrEmpty(revId))
            {
                if (revCache.Count == 0)
                {
                    SqlConnection con = new SqlConnection(cs);
                    con.Open();
                    SqlCommand cmd = new SqlCommand("SELECT id, rev from REVIku");
                    cmd.Connection = con;
                    SqlDataReader rdr = cmd.ExecuteReader();
                    {
                        while (rdr.Read())
                        {
                            revCache.Add(rdr["id"].ToString(), rdr.GetString(1));
                        }
                    }
                    con.Dispose();
                }
                if (!revCache.TryGetValue(revId, out revName))
                {
                    revName = "BAD: " + revId;
                }
            }
            return revName;
        }

        public string interpretDate(string date)
        {
            if (String.IsNullOrEmpty(date)) { return ""; }
            if (date == "1/1/1900 12:00:00 AM")
            {
                date = "";
            }
            if (date != "")
            {
                var dateTime = DateTime.Parse(date);
                date = dateTime.ToString("MM/dd/yyyy");
            }
            return date;
        }

        public string getRPLName(string rplId, string cs)
        {
            string rplName = "";
            if (!String.IsNullOrEmpty(rplId))
            {
                if (rplCache.Count == 0)
                {
                    SqlConnection con = new SqlConnection(cs);
                    con.Open();
                    SqlCommand cmd = new SqlCommand("SELECT Id, RPL from RPLIku");
                    cmd.Connection = con;
                    SqlDataReader rdr = cmd.ExecuteReader();
                    {
                        while (rdr.Read())
                        {
                            rplCache.Add(rdr["Id"].ToString(), rdr["RPL"].ToString());
                        }
                    }
                    con.Dispose();
                }
                if (!rplCache.TryGetValue(rplId, out rplName))
                {
                    rplName = "BAD: " + rplId;
                }
            }
            return rplName;
        }

        public string[] getAirframeNames(string cs)
        {
            return airframeNameList.Count == 0 ? buildAirframeDictionary(cs) : airframeNameList.ToArray();
        }

        public int getAirframeId(string name, string cs = "")
        {
            if (airfrmIdCache.Count == 0)
            {
                buildAirframeDictionary(cs);
            }
            return airfrmIdCache[name];
        }

        /*
         * Translate an airframe label to an airframe column name in the Lesson table.
         * For handling the legacy columns that individually identify applicable airframes.
         * Ideally, eventually all Lesson records will have that data migrated to the 'airframes' column,
         * and then this can be removed.
         */
        public string getAirframeColumnName(string label)
        {
            string colName = "";
            switch (label)
            {
                case "Ft Rucker":
                    colName = "FTRUCKER";
                    break;
                default:
                    colName = label;
                    break;
            }
            return colName;
        }

        /*
         * --- Implementation explanation -------------------------------------------------------
         * Since Id is the primary key in AIRFRAMEIku, and therefore its association to an airframe is
         * least likely to change, and the values start at 1, (Id value - 1) makes a good choice
         * for flag index into the new Lesson.airframes value.
         */
        public uint getAirframeFlagValue(string name, string cs = "")
        {
            // Get the position of the bit in afFlags corresponding to the named airframe:
            int flagIdx = getAirframeId(name, cs) - 1;
            // Unpack the state of the bit for the airframe
            return (uint)(1 << flagIdx);
        }
        public bool isApplicableAirframe(string name, uint afFlags, string cs = "")
        {
            return (afFlags & getAirframeFlagValue(name, cs)) != 0;
        }

        private string[] buildAirframeDictionary(string cs)
        {
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand($"SELECT Id, AIRFRAME from AIRFRAMEIku WHERE seq IS NOT NULL ORDER BY seq");
            cmd.Connection = con;
            SqlDataReader rdr = cmd.ExecuteReader();
            {
                while (rdr.Read())
                {
                    int id = rdr.GetInt32(0);
                    string name = rdr.GetString(1);
                    airfrmIdCache.Add(name, id);
                    airframeNameList.Add(name);
                }
            }
            con.Dispose();
            // We'll want to iterate the Airframe names in the order specified by seq; that's why we return the following.
            return airframeNameList.ToArray();
        }
    }
}