﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using Microsoft.Office.Interop.Excel;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class Lesson : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('Session Timeout')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            string catroles = "";
            string userid = Session["UserID"].ToString();
            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            SqlConnection con21 = new SqlConnection(cs);
            con21.Open();
            SqlCommand cmd21 = new SqlCommand("SELECT catroles from Members where id=" + userid);
            cmd21.Connection = con21;
            SqlDataReader reader21 = cmd21.ExecuteReader();
            {
                if (reader21.Read())
                {
                    catroles = reader21["catroles"].ToString();
                }
            }
            con21.Dispose();
            switch (catroles)
            {
                case "1": case "2": case "3": case "4": case "5": case "7":
                    // The only roles allowed to change Lesson records
                    break;
                default:
                    // TODO: consider either (a) "Forbidden" or (b) just immediately send to the default page
                    Response.Write("<script>alert('Sorry')</script>");
                    Response.Write("<script>window.location.href='../Default.aspx'</script>");
                    return;
            }

            DbToWeb myConverter = new DbToWeb();

            string LessonID = Request.QueryString["id"];
            string ObjectiveID = Request.QueryString["objid"];
            string QuestionID = Request.QueryString["questionid"];

            List<string> lessonList = new List<string>();
            lessonList.Add("<option value='0'>Select Lesson</option>");
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand("SELECT * from Lesson where (MP IS NULL or MP != 1) and (status != 2) order by LESSNUMBER");
            cmd.Connection = con;
            SqlDataReader reader = cmd.ExecuteReader();
            {
                while (reader.Read())
                {       
                    string lessid = reader["lessid"].ToString();
                    string LESSNUMBER = reader["LESSNUMBER"].ToString();
                    string LESSTITLE = reader["LESSTITLE"].ToString();
                    lessonList.Add($"<option value='{lessid}'>{LESSNUMBER} | {LESSTITLE}</option>");
                }
            }
            con.Dispose();
            Label1.Text = string.Join("", lessonList.ToArray());

            if (catroles == "1")
            {
                Label11.Text = "<a class='editlink' href='../CAT/EditLessons.aspx'>(edit list)</a>";
                Label12.Text = "<button class='button' onclick='deleteless()'>Delete Lesson</button>";
            }

            string labeltext2 = "";
            List<string> infoFormLines = new List<string>();
            if (LessonID != "0")
            {
                string LESSID = "";
                SqlConnection con2 = new SqlConnection(cs);
                con2.Open();
                SqlCommand cmd2 = new SqlCommand("SELECT * from Lesson where lessid=" + LessonID);
                cmd2.Connection = con2;
                SqlDataReader reader2 = cmd2.ExecuteReader();
                {
                    if (reader2.Read())
                    {
                        int afColIndex = -1;
                        try
                        {
                            afColIndex = reader2.GetOrdinal("airframes");
                        }
                        catch (IndexOutOfRangeException ex)
                        {
                            // Let it go; we have -1 as a red flag.
                        }

                        string id = reader2["id"].ToString();
                        LESSID = reader2["LESSID"].ToString();
                        string LESSNUMBER = reader2["LESSNUMBER"].ToString();
                        string LESSTITLE = reader2["LESSTITLE"].ToString();
                        labeltext2 += "<h2 style='text-align: center; padding-top: 5px;'>" + LESSNUMBER + " | " + LESSTITLE + "</h2><br/>";
                        // "lessid" is already taken in the "Add New Question" form
                        // TODO: do in-depth iteration of all element ids, and change them to something less ambiguous where practical
                        infoFormLines.Add($"<input type='hidden' name='lessonid' id='lessonid' value='{id}' />");
                        infoFormLines.Add("<div class='InfoTitles'>Lesson Number:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add($"<input type='text' name='LESSNUMBER' id='LESSNUMBER' placeholder='Lesson Number' required='required' value='{LESSNUMBER}' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='color: white;'/>");
                        }
                        else
                        {
                            infoFormLines.Add("style='color: white; background-color: black;' readonly />");
                        }
                        infoFormLines.Add("</div><div class='InfoTitles'>Lesson Title:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add($"<input type='text' name='LESSTITLE' id='LESSTITLE' placeholder='Lesson Title' required='required' value='{LESSTITLE}' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='color: white;'/>");
                        }
                        else
                        {
                            infoFormLines.Add("style='color: white; background-color: black;' readonly />");
                        }
                        infoFormLines.Add("</div><div class='InfoTitles'>Rev:&nbsp;</div><div class='form__field' style='color: black;'>");
                        infoFormLines.Add("<select class='selectstyle' id='REV' name='REV' required ");
                        if (catroles == "1" || catroles == "3")
                        {
                            infoFormLines.Add("style='width: 100%;'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black;'>");
                        }
                        string LESSREV = reader2["LESSREV"].ToString();
                        infoFormLines.Add("<option value='' disabled>Select Rev</option>");
                        SqlConnection con16 = new SqlConnection(cs);
                        con16.Open();
                        SqlCommand cmd16 = new SqlCommand("SELECT * from REVIku");
                        cmd16.Connection = con16;
                        SqlDataReader reader16 = cmd16.ExecuteReader();
                        {
                            while (reader16.Read())
                            {
                                string REVID = reader16["id"].ToString();
                                string REV = reader16["REV"].ToString();
                                infoFormLines.Add($"<option value='{REVID}'{(REVID == LESSREV ? " selected = 'selected'" : "")}>{REV}</option>");
                            }
                        }
                        con16.Dispose();
                        infoFormLines.Add("</select></div>");

                        string REVDATE = myConverter.interpretDate(reader2["REVDATE"].ToString());
                        infoFormLines.Add("<div class='InfoTitles'>Rev Date:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add($"<input type='text' name='REVDATE' id='REVDATE' placeholder='Rev Date' value='{REVDATE}' autocomplete='off' ");
                        if (catroles == "1" || catroles == "3")
                        {
                            infoFormLines.Add("style='color: white;' />");
                        }
                        else
                        {
                            infoFormLines.Add("readonly onclick='datepickeroff()' style='color: white; background-color: black;' />");
                        }
                        infoFormLines.Add("</div><div class='InfoTitles'>Media Type:&nbsp;</div><div class='form__field' style='color: black'>");
                        infoFormLines.Add("<select class='selectstyle' id='MEDIATYPE' name='MEDIATYPE' required ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='width: 100%;'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black;'>");
                        }
                        string MEDIATYPE = reader2["MEDIAIKU"].ToString();
                        infoFormLines.Add("<option value='' disabled>Select Media Type</option>");
                        SqlConnection con17 = new SqlConnection(cs);
                        con17.Open();
                        SqlCommand cmd17 = new SqlCommand("SELECT * from MEDIAIku");
                        cmd17.Connection = con17;
                        SqlDataReader reader17 = cmd17.ExecuteReader();
                        {
                            while (reader17.Read())
                            {
                                string MEDIAID = reader17["id"].ToString();
                                string MEDIA = reader17["MEDIA"].ToString();
                                infoFormLines.Add($"<option value='{MEDIAID}'{(MEDIAID == MEDIATYPE ? " selected='selected'" : "")}>{MEDIA}</option>");
                            }
                        }
                        con17.Dispose();
                        infoFormLines.Add("</select></div>");


                        infoFormLines.Add("<div class='InfoTitles'>Subtype:&nbsp;</div><div class='form__field' style='color: black'>");
                        infoFormLines.Add("<select class='selectstyle' id='SUBTYPE' name='SUBTYPE' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='width: 100%;'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black;'>");
                        }
                        string SUBTYPEID = reader2["SUBTYPE"].ToString();
                        infoFormLines.Add("<option value=''>Select Subtype</option>");
                        SqlConnection con23 = new SqlConnection(cs);
                        con23.Open();
                        SqlCommand cmd23 = new SqlCommand("SELECT * from Subtypes");
                        cmd23.Connection = con23;
                        SqlDataReader reader23 = cmd23.ExecuteReader();
                        {
                            while (reader23.Read())
                            {
                                string SUBID = reader23["id"].ToString();
                                string SUBTYPE = reader23["SUBTYPE"].ToString();
                                infoFormLines.Add($"<option value='{SUBID}'{(SUBID == SUBTYPEID ? " selected='selected'" : "")}>{SUBTYPE}</option>");
                            }
                        }
                        con23.Dispose();
                        infoFormLines.Add("</select></div>");


                        string FEADATE = myConverter.interpretDate(reader2["FEADATE"].ToString());
                        infoFormLines.Add("<div class='InfoTitles'>FEA Date:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add($"<input type='text' name='FEADATE' id='FEADATE' placeholder='FEA Date' value='{FEADATE}' autocomplete='off' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='color: white' />");
                        }
                        else
                        {
                            infoFormLines.Add("readonly onclick='datepickeroff2()' style='color: white; background-color: black;' />");
                        }
                        infoFormLines.Add("</div>");
                        infoFormLines.Add("<div class='InfoTitles'>Status:&nbsp;</div><div class='form__field' style='color: black'>");
                        infoFormLines.Add("<select class='selectstyle' id='STATUS' name='STATUS' required ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='width: 100%;'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black;'>");
                        }
                        string STATUS = reader2["STATUS"].ToString();
                        infoFormLines.Add("<option value='' disabled>Select Status</option>");                    
                        SqlConnection con18 = new SqlConnection(cs);
                        con18.Open();
                        SqlCommand cmd18 = new SqlCommand("SELECT * from STATUSIKU");
                        cmd18.Connection = con18;
                        SqlDataReader reader18 = cmd18.ExecuteReader();
                        {
                            while (reader18.Read())
                            {
                                string STATUSID = reader18["id"].ToString();
                                string STATUSOPTION = reader18["STATUS"].ToString();
                                infoFormLines.Add($"<option value='{STATUSID}'{(STATUSID == STATUS ? " selected='selected'" : "")}>{STATUSOPTION}</option>");
                            }
                        }
                        con18.Dispose();
                        infoFormLines.Add("</select></div>");
                        infoFormLines.Add("<div class='InfoTitles'>Classification:&nbsp;</div><div class='form__field' style='color: black'>");
                        infoFormLines.Add("<select class='selectstyle' id='CLASSIFICATION' name='CLASSIFICATION' required ");
                        if (catroles == "1" || catroles == "2" || catroles == "3")
                        {
                            infoFormLines.Add("style='width: 100%;'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black'>");
                        }
                        string CLASSIFICATION = reader2["CLASSIFICATION"].ToString();
                        infoFormLines.Add("<option value='' disabled>Select Classification</option>");
                        SqlConnection con19 = new SqlConnection(cs);
                        con19.Open();
                        SqlCommand cmd19 = new SqlCommand("SELECT * from CLASSIFICATION");
                        cmd19.Connection = con19;
                        SqlDataReader reader19 = cmd19.ExecuteReader();
                        {
                            while (reader19.Read())
                            {
                                string CLASSID = reader19["id"].ToString();
                                string CLASSIFICATIONOPTION = reader19["CLASSIFICATION"].ToString();
                                infoFormLines.Add($"<option value='{CLASSID}'{(CLASSID == CLASSIFICATION ? " selected='selected'" : "")}>{CLASSIFICATIONOPTION}</option>");
                            }
                        }
                        con19.Dispose();
                        infoFormLines.Add("</select></div>");
                        infoFormLines.Add("<div class='InfoTitles'><img id='infobutton' onclick='openICWL();' src='../images/question.png' />&nbsp;ICWL:&nbsp;</div>");
                        infoFormLines.Add("<div class='form__field' style='color: black;'><select class='selectstyle' id='ICWL' name='ICWL' ");
                        // TODO: consider generating static HTML rather than form fields for items that a given catrole is not allowed to edit
                        if (catroles == "1" || catroles == "3")
                        {
                            infoFormLines.Add("style='width: 100%;'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black'>");
                        }
                        string ICWL = reader2["ICWL"].ToString();
                        infoFormLines.Add("<option value=''>Select ICWL</option>");
                        SqlConnection con20 = new SqlConnection(cs);
                        con20.Open();
                        SqlCommand cmd20 = new SqlCommand("SELECT * from ICWL");
                        cmd20.Connection = con20;
                        SqlDataReader reader20 = cmd20.ExecuteReader();
                        {
                            while (reader20.Read())
                            {
                                string ICWLID = reader20["id"].ToString();
                                string ICWLOPTION = reader20["ICWL"].ToString();
                                infoFormLines.Add($"<option value='{ICWLID}'{(ICWLID == ICWL ? " selected='selected'" : "")}>{ICWLOPTION}</option>");
                            }
                        }
                        con20.Dispose();
                        infoFormLines.Add("</select></div>");
                        /*
                        string LESS_DURATION = reader2["LESS_DURATION"].ToString();
                        infoFormLines.Add("<div class='InfoTitles'>Lesson Duration:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add($"<input type='text' name='LESSDURATION' id='LESSDURATION' placeholder='Lesson Duration' required='required' value='{LESS_DURATION}' "); 
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='color: white;'/>");
                        }
                        else
                        {
                            infoFormLines.Add("style='color: white; background-color: black;' readonly />");
                        }
                        infoFormLines.Add("</div>");
                        */

                        infoFormLines.Add("<div class='InfoTitles'>&nbsp;MP:&nbsp;</div><div class='form__field' style='color: black'>");
                        infoFormLines.Add("<select class='selectstyle' id='MP' name='MP' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='width: 100%;' onchange='togglereadonly();'>");
                        }
                        else
                        {
                            infoFormLines.Add("style='width: 100%; pointer-events: none; background-color: black;'>");
                        }
                        string MP = reader2["MP"].ToString();
                        infoFormLines.Add("<option value=''>Select MP</option>");
                        SqlConnection con22 = new SqlConnection(cs);
                        con22.Open();
                        SqlCommand cmd22 = new SqlCommand("SELECT * from MP");
                        cmd22.Connection = con22;
                        SqlDataReader reader22 = cmd22.ExecuteReader();
                        {
                            while (reader22.Read())
                            {
                                string MPID = reader22["id"].ToString();
                                string MPDESC = reader22["MP"].ToString();
                                infoFormLines.Add($"<option value='{MPID}'{(MPID == MP ? " selected='selected'" : "")}>{MPDESC}</option>");
                            }
                        }
                        con22.Dispose();
                        infoFormLines.Add("</select></div>");

                        /*
                        string SPTTIME = reader2["SPTTIME"].ToString();
                        infoFormLines.Add("<div class='InfoTitles'>Spt Time:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add($"<input type='text' name='SPTTIME' id='SPTTIME' placeholder='Spt Time' value='{SPTTIME}' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("style='color: white;'/>");
                        }
                        else
                        {
                            infoFormLines.Add("style='color: white; background-color: black;' readonly />");
                        }
                        infoFormLines.Add("</div>");
                        */

                        string LESSNOTE = reader2["LESSNOTE"].ToString();
                        infoFormLines.Add("<div class='InfoTitles'>Note:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add("<textarea name='LESSNOTE' id='LESSNOTE' placeholder='Note' style='resize: none;' ");
                        if (catroles == "1" || catroles == "2" || catroles == "3")
                        {
                            infoFormLines.Add("class='textareastyle'>");
                        }
                        else
                        {
                            infoFormLines.Add("class='textareastylereadonly' readonly>");
                        }
                        infoFormLines.Add(LESSNOTE + "</textarea></div>");
                        string MESL = reader2["MESL"].ToString();
                        infoFormLines.Add("<div class='InfoTitles'>MESL:&nbsp;</div><div class='form__field'>");
                        infoFormLines.Add("<textarea name='MESL' id='MESL' placeholder='MESL' style='resize: none;' ");
                        if (catroles == "1")
                        {
                            infoFormLines.Add("class='textareastyle'>");
                        }
                        else
                        {
                            infoFormLines.Add("class='textareastylereadonly' readonly>");
                        }
                        infoFormLines.Add(MESL + "</textarea></div>");

                        // Applicable Airframes checkboxes
                        infoFormLines.Add("<div class='InfoTitles'>Applicable Airframes:&nbsp;</div>");
                        
                        string onclickAttr = " onclick='return false;'";
                        string styleAttr = " style='background-color: black;'";
                        if (catroles == "1" || catroles == "2" || catroles == "3")
                        {
                            onclickAttr = "";
                            styleAttr = "";
                        }
                        infoFormLines.Add($"<div class='form__field' id='divcheckboxes'{styleAttr}>");
                        string[] airframeNames = myConverter.getAirframeNames(cs);
                        try
                        {
                            // We expect that this newly-introduced airframes column will be null for all records that
                            // existed previous to its addition and have not been updated yet.
                            // The following will throw if the airframes value is null, or if afColIndex is still -1:
                            uint airframeFlags = (uint)reader2.GetInt32(afColIndex);
                            foreach (string label in airframeNames)
                            {
                                string field = myConverter.getAirframeColumnName(label);
                                string chkdAttr = myConverter.isApplicableAirframe(label, airframeFlags) ? " checked" : "";
                                infoFormLines.Add($"<input type='checkbox' id='FORM{field}' name='FORM{field}'{onclickAttr}{chkdAttr}><label for='FORM{field}'>{label}</label>");
                            }
                        }
                        catch
                        {
                            // Then try the legacy columns
                            foreach (string label in airframeNames)
                            {
                                string field = myConverter.getAirframeColumnName(label);
                                string chkdAttr;
                                // AC130J is not one of the legacy fields, so trying to get it from the reader will throw
                                try
                                {
                                    chkdAttr = reader2[field].ToString() == "True" ? " checked" : "";
                                }
                                catch (IndexOutOfRangeException)
                                {
                                    chkdAttr = "";
                                }
                                infoFormLines.Add($"<input type='checkbox' id='FORM{field}' name='FORM{field}'{onclickAttr}{chkdAttr}><label for='FORM{field}'>{label}</label>");
                            }
                        }
                        infoFormLines.Add("</div>");
                        // End checkboxes row.

                        string PRIMARY_INSTRUCTOR = reader2["PRIMARY_INSTRUCTOR"].ToString();
                        string ALTERNATE_INSTRUCTOR = reader2["ALTERNATE_INSTRUCTOR"].ToString();
                        List<string> instructorOptionsList = new List<string>();
                        string primaryOption = "";
                        string alternateOption = "";

                        infoFormLines.Add("<div class='InfoTitles'>Primary Instructor:&nbsp;</div><div class='form__field' style='color: black;'>");
                        styleAttr = "style='width: 100%; pointer-events: none; background-color: black;'";
                        if (catroles == "1" || catroles == "4" || catroles == "5" || catroles == "7")
                        {
                            styleAttr = "style = 'width: 100%;'";
                        }
                        infoFormLines.Add($"<select class='selectstyle' id='PRIMARYINSTRUCTOR' name='PRIMARYINSTRUCTOR' {styleAttr}>");
                        infoFormLines.Add("<option value=''>Select Primary Instructor</option>");
                        SqlConnection con24 = new SqlConnection(cs);
                        con24.Open();

                        SqlCommand cmd24 = new SqlCommand("SELECT Id from Members where catroles=4 and catrole_status!=2");
                        cmd24.Connection = con24;
                        SqlDataReader reader24 = cmd24.ExecuteReader();
                        {
                            while (reader24.Read())
                            {
                                string MEMBERID = reader24["id"].ToString();
                                string expandedName = myConverter.identifyMember(MEMBERID, cs);
                                bool isPrimary = MEMBERID == PRIMARY_INSTRUCTOR;
                                bool isAlternate = MEMBERID == ALTERNATE_INSTRUCTOR;
                                if (isPrimary || isAlternate)
                                {
                                    // Note that the Primary Instructor and Alternate Instructor assigned to the lesson are *not* added
                                    // to the instructorOptionsList, which will be used for both select lists; instead, they will be
                                    // placed at the top of the resulting options HTML (just after the unselectable prompt option).
                                    string optionHtml = $"<option value='{MEMBERID}'>{expandedName}</option>";
                                    if (isPrimary)
                                    {
                                        infoFormLines.Add(
                                            $"<option value='{MEMBERID}' selected='selected'>{expandedName}</option>"
                                        );
                                        primaryOption = optionHtml; // for adding to the Alternate Instructor option list
                                    }
                                    else if (isAlternate)
                                    {
                                        infoFormLines.Add(optionHtml);
                                        alternateOption = $"<option value='{MEMBERID}' selected='selected'>{expandedName}</option>";
                                    }
                                }
                                else
                                {
                                    instructorOptionsList.Add($"<option value='{MEMBERID}'>{expandedName}</option>");
                                }
                            }
                        }
                        con24.Dispose();
                        if (PRIMARY_INSTRUCTOR != "" && primaryOption == "")
                        {
                            // Oops, we didn't see the assigned Primary Instructor in the query results: either not active status, or
                            // not an instructor anymore. Try fetching the member record by Id.
                            string instructorIdentity = myConverter.identifyMember(PRIMARY_INSTRUCTOR, cs);
                            infoFormLines.Add($"<option value='{PRIMARY_INSTRUCTOR}' selected='selected'>{instructorIdentity}</option>");
                        }
                        string instructorOptionsHTML = string.Join("", instructorOptionsList.ToArray());
                        infoFormLines.Add(instructorOptionsHTML);
                        infoFormLines.Add("</select></div>");

                        infoFormLines.Add("<div class='InfoTitles'>Alternate Instructor:&nbsp;</div><div class='form__field' style='color: black'>");
                        styleAttr = "style='width: 100%; pointer-events: none; background-color: black;'";
                        if (catroles == "1" || catroles == "4" || catroles == "5" || catroles == "7")
                        {
                            styleAttr = "style='width: 100%;'";
                        }
                        infoFormLines.Add($"<select class='selectstyle' id='ALTERNATEINSTRUCTOR' name='ALTERNATEINSTRUCTOR' {styleAttr}>");
                        infoFormLines.Add("<option value=''>Select Alternate Instructor</option>");
                        if (ALTERNATE_INSTRUCTOR != "")
                        {
                            if (alternateOption == "")
                            {
                                // The assigned Alternate Instructor was not found in the query results. Try by Id.
                                string expandedName = myConverter.identifyMember(ALTERNATE_INSTRUCTOR, cs);
                                infoFormLines.Add($"<option value='{ALTERNATE_INSTRUCTOR}' selected='selected'>{expandedName}</option>");
                            }
                            else
                            {
                                infoFormLines.Add(alternateOption);
                            }
                        }
                        if (primaryOption != "")
                        {
                            infoFormLines.Add(primaryOption);
                        }
                        infoFormLines.Add(instructorOptionsHTML);
                        infoFormLines.Add("</select></div>");

                        if (catroles == "1" || catroles == "2" || catroles == "3" || catroles == "4" || catroles == "5" || catroles == "7")
                        {
                            infoFormLines.Add("<div class='form__field'><input type='submit' value='Update' style='width: 300px;' /></div>");
                        }
                    }
                }
                con2.Dispose();

                Label2.Text = labeltext2;
                Label10.Text = string.Join("", infoFormLines.ToArray());

                string labeltext3 = "";
                labeltext3 += "<option value='0'>Select Objective</option>";
                SqlConnection con3 = new SqlConnection(cs);
                con3.Open();
                SqlCommand cmd3 = new SqlCommand("SELECT * from OBJECTIVES where LESSIDfk=" + LESSID);
                cmd3.Connection = con3;
                SqlDataReader reader3 = cmd3.ExecuteReader();
                {
                    while (reader3.Read())
                    {
                        string OBJDESC = reader3["OBJDESC"].ToString();
                        string OBJID = reader3["OBJID"].ToString();
                        string OBJRPL = reader3["RPL"].ToString();
                        labeltext3 += "<option value=" + OBJID + ">" + OBJID + " | RPL: " + OBJRPL + " | " + OBJDESC + "</option>";
                    }
                }
                con3.Dispose();

                Label3.Text = labeltext3;

                string labeltext5 = "";
                SqlConnection con5 = new SqlConnection(cs);
                con5.Open();
                SqlCommand cmd5 = new SqlCommand("SELECT * from SOILESS where LESSIDfk=" + LESSID);
                cmd5.Connection = con5;
                SqlDataReader reader5 = cmd5.ExecuteReader();
                {
                    while (reader5.Read())
                    {
                        string SOIIDFK = reader5["SOIIDFK"].ToString();
                        SqlConnection con6 = new SqlConnection(cs);
                        con6.Open();
                        SqlCommand cmd6 = new SqlCommand("SELECT * from SOI where SOIID=" + SOIIDFK);
                        cmd6.Connection = con6;
                        SqlDataReader reader6 = cmd6.ExecuteReader();
                        {
                            while (reader6.Read())
                            {
                                string id = reader6["id"].ToString();
                                string SOIID = reader6["SOIID"].ToString();
                                string SOITITLE = reader6["SOITITLE"].ToString();
                                string SOIDATE = reader6["SOIDATE"].ToString();
                                if (SOIDATE != "")
                                {
                                    var SOIDATE_DateTime = DateTime.Parse(SOIDATE);
                                    SOIDATE = SOIDATE_DateTime.ToString("MM/dd/yyyy");
                                }
                                labeltext5 += "<tr><td>" + SOIID + "</td><td>" + SOITITLE + "</td><td>" + SOIDATE + "</td><td style='display: none'>" + id + "</td></tr>";
                            }
                        }
                        con6.Dispose();
                    }
                }
                con5.Dispose();

                Label5.Text = labeltext5;

                string labeltext6 = "";
                SqlConnection con7 = new SqlConnection(cs);
                con7.Open();
                SqlCommand cmd7 = new SqlCommand("SELECT * from PUBLESS where LESSPUBIDfk=" + LESSID);
                cmd7.Connection = con7;
                SqlDataReader reader7 = cmd7.ExecuteReader();
                {
                    while (reader7.Read())
                    {
                        string PUBLESSIDFK = reader7["PUBLESSIDFK"].ToString();
                        if (PUBLESSIDFK != "")
                        {
                            SqlConnection con8 = new SqlConnection(cs);
                            con8.Open();
                            SqlCommand cmd8 = new SqlCommand("SELECT * from PUBS where PUBID=" + PUBLESSIDFK);
                            cmd8.Connection = con8;
                            SqlDataReader reader8 = cmd8.ExecuteReader();
                            {
                                while (reader8.Read())
                                {
                                    string id = reader8["id"].ToString();
                                    string PUBNUMBER = reader8["PUBNUMBER"].ToString();
                                    string PUBNAME = reader8["PUBNAME"].ToString();
                                    string PUBDATE = myConverter.interpretDate(reader8["PUBDATE"].ToString());
                                    string PUBREV = reader8["PUBREV"].ToString();
                                    string REV = "";
                                    if (PUBREV != "")
                                    {
                                        SqlConnection con12 = new SqlConnection(cs);
                                        con12.Open();
                                        SqlCommand cmd12 = new SqlCommand("SELECT * from REVIku where ID=" + PUBREV);
                                        cmd12.Connection = con12;
                                        SqlDataReader reader12 = cmd12.ExecuteReader();
                                        {
                                            while (reader12.Read())
                                            {
                                                REV = reader12["REV"].ToString();
                                            }
                                        }
                                        con12.Dispose();
                                    }
                                    else
                                    {
                                        PUBREV = "0";
                                    }

                                    labeltext6 += "<tr><td>" + PUBNUMBER + "</td><td>" + PUBNAME + "</td><td>" + PUBDATE + "</td><td>" + REV + "</td><td style='display: none'>" + id + "</td></tr>";
                                }
                            }
                            con8.Dispose();
                        }
                    }
                }
                con7.Dispose();

                Label6.Text = labeltext6;

                string labeltext16 = "";
                if (catroles == "1" || catroles == "2" || catroles == "3")
                {
                    labeltext16 += "<button class='button' onclick='addPUB()'>Add Publication</button>&nbsp;";
                    labeltext16 += "<button class='button' onclick='deldata3()'>Dissociate</button><br /><br />";
                    Label16.Text = labeltext16;
                }

                string labeltext7 = "";
                SqlConnection con9 = new SqlConnection(cs);
                con9.Open();
                SqlCommand cmd9 = new SqlCommand("SELECT * from TOPICLESS where LESSIDfkTOPIC=" + LESSID);
                cmd9.Connection = con9;
                SqlDataReader reader9 = cmd9.ExecuteReader();
                {
                    while (reader9.Read())
                    {
                        string TOPICIDFKLESS = reader9["TOPICIDFKLESS"].ToString();
                        if (TOPICIDFKLESS == "")
                        {
                            TOPICIDFKLESS = "0";
                        }
                        SqlConnection con10 = new SqlConnection(cs);
                        con10.Open();
                        SqlCommand cmd10 = new SqlCommand("SELECT * from TOPICS where TOPICID=" + TOPICIDFKLESS);
                        cmd10.Connection = con10;
                        SqlDataReader reader10 = cmd10.ExecuteReader();
                        {
                            while (reader10.Read())
                            {
                                string id = reader10["id"].ToString();
                                string TOPIC = reader10["TOPIC"].ToString();
                                labeltext7 += "<tr><td>" + TOPIC + "</td><td style='display: none'>" + id + "</td></tr>";
                            }                            
                        }
                        con10.Dispose();
                    }
                    
                }
                con9.Dispose();

                Label7.Text = labeltext7;

                string labeltext17 = "";
                if (catroles == "1" || catroles == "2" || catroles == "3")
                {
                    labeltext17 += "<button class='button' onclick='addCAT()'>Add Category</button>&nbsp;";
                    labeltext17 += "<button class='button' onclick='deldata4()'>Dissociate</button><br /><br />";
                    Label17.Text = labeltext17;
                }

                string labeltext8 = "";
                labeltext8 += "<option value=''>Select Publication</option>";
                SqlConnection con13 = new SqlConnection(cs);
                con13.Open();
                SqlCommand cmd13 = new SqlCommand("SELECT * from Pubs order by id");
                cmd13.Connection = con13;
                SqlDataReader reader13 = cmd13.ExecuteReader();
                {
                    while (reader13.Read())
                    {
                        string id = reader13["id"].ToString();
                        string PUBID = reader13["PUBID"].ToString();
                        string PUBNUMBER = reader13["PUBNUMBER"].ToString();
                        string PUBNAME = reader13["PUBNAME"].ToString();

                        SqlConnection con15 = new SqlConnection(cs);
                        con15.Open();
                        SqlCommand cmd15 = new SqlCommand("SELECT * from PUBLESS where PUBLESSIDfk=" + PUBID + " and LESSPUBIDfk=" + LESSID);
                        cmd15.Connection = con15;
                        SqlDataReader reader15 = cmd15.ExecuteReader();
                        {
                            if (reader15.HasRows)
                            {                          
                                //do nothing
                            }
                            else
                            {
                                labeltext8 += "<option value=" + id + ">" + PUBNUMBER + " | " + PUBNAME + "</option>";
                            }
                        }
                        con15.Dispose();

                        //labeltext8 += "<option value=" + id + ">" + PUBNUMBER + " | " + PUBNAME + "</option>";
                    }
                }
                con13.Dispose();

                Label8.Text = labeltext8;

                string labeltext9 = "";
                labeltext9 += "<option value=''>Select Category</option>";
                SqlConnection con14 = new SqlConnection(cs);
                con14.Open();
                SqlCommand cmd14 = new SqlCommand("SELECT * from TOPICS order by TOPIC ASC");
                cmd14.Connection = con14;
                SqlDataReader reader14 = cmd14.ExecuteReader();
                {
                    while (reader14.Read())
                    {
                        string id = reader14["id"].ToString();
                        string TOPICID = reader14["TOPICID"].ToString();
                        string TOPIC = reader14["TOPIC"].ToString();

                        SqlConnection con16 = new SqlConnection(cs);
                        con16.Open();
                        SqlCommand cmd16 = new SqlCommand("SELECT * from TOPICLESS where TOPICIDfkLESS=" + TOPICID + " and LESSIDfkTOPIC=" + LESSID);
                        cmd16.Connection = con16;
                        SqlDataReader reader16 = cmd16.ExecuteReader();
                        {
                            if (reader16.HasRows)
                            {
                                //do nothing
                            }
                            else
                            {
                                labeltext9 += "<option value=" + id + ">" + TOPIC + "</option>";
                            }
                        }
                        con16.Dispose();                        
                    }
                }
                con14.Dispose();

                Label9.Text = labeltext9;
            }
            else // selected LessonID is 0 (no selection)
            {
                //do nothing
            }

            string labeltext15 = "";
            if (catroles == "1" || catroles == "2" || catroles == "3")
            {
                labeltext15 += "<div style='min-width: 500px; width: 500px; white-space: nowrap;'>";
                labeltext15 += "<button class='button' onclick='addQuestion()'>Add New</button>&nbsp;";
                labeltext15 += "<button class='button' onclick='editdata()'>Edit Row</button>&nbsp;";
                labeltext15 += "<button class='button' onclick='deldata()'>Delete Row</button>";
                labeltext15 += "</div>";
                Label15.Text = labeltext15;
            }

            if (QuestionID != "0")
            {
                string labeltext4 = "";

                SqlConnection con4 = new SqlConnection(cs);
                con4.Open();
                SqlCommand cmd4 = new SqlCommand("SELECT * from QUESTION where objidfk=" + ObjectiveID + " order by QUESTIONNUM");
                cmd4.Connection = con4;
                SqlDataReader reader4 = cmd4.ExecuteReader();
                {
                    while (reader4.Read())
                    {
                        string id = reader4["id"].ToString();
                        string QUESTIONID = reader4["QUESTIONID"].ToString();
                        string QUESTIONNUM = reader4["QUESTIONNUM"].ToString();
                        string QUESTIONDESC = reader4["QUESTIONDESC"].ToString();                        
                        labeltext4 += "<tr><td>" + QUESTIONID + "</td><td>" + QUESTIONNUM + "</td><td><textarea rows='10' cols='130' style='resize: none;' readonly>" + QUESTIONDESC + "</textarea></td><td style='display: none'>" + id + "</td></tr>";                   
                    }
                }
                con4.Dispose();

                Label4.Text = labeltext4;
            }
            else
            {
                //do nothing
            }

            string labeltext11 = "";
            SqlConnection con26 = new SqlConnection(cs);
            con26.Open();
            SqlCommand cmd26 = new SqlCommand("SELECT * from REVIEW where lessid=" + LessonID);
            cmd26.Connection = con26;
            SqlDataReader reader26 = cmd26.ExecuteReader();
            {
                while (reader26.Read())
                {                  
                    string review_date = myConverter.interpretDate(reader26["review_date"].ToString());
                    string instructorid = reader26["instructorid"].ToString();
                    string instructorname = myConverter.identifyMember(instructorid, cs);
                    /*
                    string tcp = reader26["tcp"].ToString();
                    if (tcp == "1")
                    {
                        tcp = "Yes";
                    }
                    else
                    {
                        tcp = "No";
                    }
                    */
                    string comments = reader26["comments"].ToString();
                    //labeltext11 += $"<tr><td>{review_date}</td><td>{instructorname}</td><td>{tcp}</td><td>{comments}</td></tr>";
                    labeltext11 += $"<tr><td>{review_date}</td><td>{instructorname}</td><td>{comments}</td></tr>";
                }
            }
            con26.Dispose();

            Label13.Text = labeltext11;


            string labeltext12 = "";
            SqlConnection con28 = new SqlConnection(cs);
            con28.Open();
            SqlCommand cmd28 = new SqlCommand("SELECT * from FEEDBACK where lessid=" + LessonID);
            cmd28.Connection = con28;
            SqlDataReader reader28 = cmd28.ExecuteReader();
            {
                while (reader28.Read())
                {
                    string feedback_date = myConverter.interpretDate(reader28["feedback_date"].ToString());
                    string feedbacktypeid = reader28["feedback_type"].ToString();
                    string feedbacktype = "";
                    SqlConnection con29 = new SqlConnection(cs);
                    con29.Open();
                    SqlCommand cmd29 = new SqlCommand("SELECT * from feedback_types where id=" + feedbacktypeid);
                    cmd29.Connection = con29;
                    SqlDataReader reader29 = cmd29.ExecuteReader();
                    {
                        while (reader29.Read())
                        {
                            feedbacktype = reader29["feedback_type"].ToString();
                        }
                    }
                    con29.Dispose();
                    /*
                    string tcp = reader28["tcp"].ToString();
                    if (tcp == "1")
                    {
                        tcp = "Yes";
                    }
                    else
                    {
                        tcp = "No";
                    }
                    */
                    string comments = reader28["comments"].ToString();
                    //labeltext12 += $"<tr><td>{feedback_date}</td><td>{feedbacktype}</td><td>{tcp}</td><td>{comments}</td></tr>";
                    labeltext12 += $"<tr><td>{feedback_date}</td><td>{feedbacktype}</td><td>{comments}</td></tr>";
                }
            }
            con28.Dispose();

            Label14.Text = labeltext12;
        }
    }
}