﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class ExportFeedbackReports : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string feedbacktypeid = Request.QueryString["feedbacktypeid"];
            string alllessons = Request.QueryString["all"];
            string startdate = Request.QueryString["startdate"];
            string enddate = Request.QueryString["enddate"];
            string tcprequested = Request.QueryString["tcp"];

            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("FEEDBACKREPORT");
                var worksheet = excel.Workbook.Worksheets["FEEDBACKREPORT"];

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/FEEDBACKREPORT.xlsx"));

                //Add header row columns name in string list array
                var headerLabels = new List<string[]>()
                  {
                    new string[] { "LESSON","FEEDBACK DATE","FEEDBACK TYPE","PRIMARY INSTRUCTOR","ALTERNATE INSTRUCTOR","TCP REQUESTED","COMMENTS" }
                  };

                // Get the header range
                string Range = "A1:" + Char.ConvertFromUtf32(headerLabels[0].Length + 64) + "1";
                var headerCells = worksheet.Cells[Range];
                headerCells.LoadFromArrays(headerLabels);
                headerCells.Style.Fill.PatternType = OfficeOpenXml.Style.ExcelFillStyle.Solid;
                headerCells.Style.Fill.BackgroundColor.SetColor(System.Drawing.Color.DeepSkyBlue);
                worksheet.View.FreezePanes(2, 1); // Freeze the header cells row

                int rowcounter = 2;

                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();

                SqlCommand cmd = new SqlCommand("");
                if (alllessons == "true")
                {
                    cmd = new SqlCommand("SELECT * from Feedback order by feedback_date");
                }
                if (feedbacktypeid != null)
                {
                    cmd = new SqlCommand("SELECT * from Feedback where feedback_type=" + feedbacktypeid + " order by feedback_date");
                }
                if (startdate != null)
                {
                    cmd = new SqlCommand("SELECT * from Feedback where feedback_date between '" + startdate + "' and '" + enddate + "' order by feedback_date");
                }
                if (tcprequested != null)
                {
                    cmd = new SqlCommand("SELECT * from Feedback where tcp=" + tcprequested + " order by feedback_date");
                }
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string lessid = reader["lessid"].ToString();
                        string lessname = "";
                        string primary_instructor = "";
                        string alternate_instructor = "";
                        SqlConnection con5 = new SqlConnection(cs);
                        con5.Open();
                        SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                        cmd5.Connection = con5;
                        SqlDataReader reader5 = cmd5.ExecuteReader();
                        {
                            while (reader5.Read())
                            {
                                primary_instructor = reader5["primary_instructor"].ToString();
                                alternate_instructor = reader5["alternate_instructor"].ToString();
                                string lessnumber = reader5["lessnumber"].ToString();
                                string lesstitle = reader5["lesstitle"].ToString();
                                lessname = lessnumber + " | " + lesstitle;
                            }
                        }
                        con5.Dispose();

                        string primary_instructor_name = "";
                        string alternate_instructor_name = "";

                        if (primary_instructor != "")
                        {
                            SqlConnection con6 = new SqlConnection(cs);
                            con6.Open();
                            SqlCommand cmd6 = new SqlCommand("SELECT * from members where id=" + primary_instructor);
                            cmd6.Connection = con6;
                            SqlDataReader reader6 = cmd6.ExecuteReader();
                            {
                                while (reader6.Read())
                                {
                                    string firstname = reader6["firstname"].ToString();
                                    string lastname = reader6["lastname"].ToString();
                                    string username = reader6["username"].ToString();
                                    primary_instructor_name = lastname + "," + firstname + " (" + username + ")";
                                }
                            }
                            con6.Dispose();
                        }
                        if (alternate_instructor != "")
                        {
                            SqlConnection con7 = new SqlConnection(cs);
                            con7.Open();
                            SqlCommand cmd7 = new SqlCommand("SELECT * from members where id=" + alternate_instructor);
                            cmd7.Connection = con7;
                            SqlDataReader reader7 = cmd7.ExecuteReader();
                            {
                                while (reader7.Read())
                                {
                                    string firstname = reader7["firstname"].ToString();
                                    string lastname = reader7["lastname"].ToString();
                                    string username = reader7["username"].ToString();
                                    alternate_instructor_name = lastname + "," + firstname + " (" + username + ")";
                                }
                            }
                            con7.Dispose();
                        }

                        string feedback_date = reader["feedback_date"].ToString();
                        if (feedback_date == "1/1/1900 12:00:00 AM")
                        {
                            feedback_date = "";
                        }
                        if (feedback_date != "")
                        {
                            var feedback_date_DateTime = DateTime.Parse(feedback_date);
                            feedback_date = feedback_date_DateTime.ToString("MM/dd/yyyy");
                        }
                        string tcp = reader["tcp"].ToString();
                        string tcpname = "";
                        if (tcp == "1")
                        {
                            tcpname = "Yes";
                        }
                        else
                        {
                            tcpname = "No";
                        }

                        string comments = reader["comments"].ToString();
                        string feedback_typeid = reader["feedback_type"].ToString();
                        string feedback_typename = "";
                        SqlConnection con4 = new SqlConnection(cs);
                        con4.Open();
                        SqlCommand cmd4 = new SqlCommand("SELECT * from feedback_types where id=" + feedback_typeid);
                        cmd4.Connection = con4;
                        SqlDataReader reader4 = cmd4.ExecuteReader();
                        {
                            while (reader4.Read())
                            {
                                feedback_typename = reader4["feedback_type"].ToString();
                            }
                        }
                        con4.Dispose();

                        //Table Rows
                        //Now add some data in rows for each column
                        var Data = new List<object[]>()
                        {
                            new object[] { lessname, feedback_date, feedback_typename, primary_instructor_name, alternate_instructor_name, tcpname, comments},
                        };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        // Removed AutoFitColumns()
                        rowcounter++;
                    }
                }
                con.Dispose();

                worksheet.Column(1).Width = 60;    // LESSON
                worksheet.Column(1).Style.WrapText = true;
                worksheet.Column(2).Width = 14.3;  // FEEDBACK DATE
                worksheet.Column(3).Width = 20;    // FEEDBACK TYPE
                worksheet.Column(4).Width = 24;    // PRIMARY INSTRUCTOR
                worksheet.Column(5).Width = 24;    // ALTERNATE INSTRUCTOR
                worksheet.Column(6).Width = 14.3;  // TCP REQUESTED
                worksheet.Column(7).Width = 80;    // COMMENTS
                worksheet.Column(7).Style.WrapText = true;

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/FEEDBACKREPORT.xlsx"));
            Response.Redirect("../files/FEEDBACKREPORT.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}