﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using iText.Kernel.Colors;
using iText.Kernel.Pdf;
using iText.Kernel.Pdf.Canvas;
using iText.Kernel.Font;
using iText.Layout;
using iText.Layout.Element;
using iText.Layout.Properties;
using iText.Layout.Renderer;
using iText.Layout.Borders;
using iText.IO.Font.Constants;
using iText.Kernel.Pdf.Canvas.Draw;

namespace CAE_WEB_PROJECT.SOITable
{
    public partial class sptreport : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string buildid = Request.QueryString["buildid"];
            string reportid = Request.QueryString["reportid"];

            MemoryStream baos = new MemoryStream();
            PdfWriter writer = new PdfWriter(baos);
            PdfDocument pdfDocument = new PdfDocument(writer.SetSmartMode(true));

            Document d = new Document(pdfDocument, iText.Kernel.Geom.PageSize.LETTER);
            PdfFont bold = PdfFontFactory.CreateFont(StandardFonts.TIMES_BOLD);
            PdfFont bolditalic = PdfFontFactory.CreateFont(StandardFonts.TIMES_BOLDITALIC);

            d.SetTextAlignment(TextAlignment.CENTER);
            string pdftitle = "Spt Report";
            Text text0 = new Text(pdftitle).SetFont(bold);

            d.Add(new Paragraph(text0));

            SolidLine line = new SolidLine(1f);
            LineSeparator ls = new LineSeparator(line);

            d.Add(ls);
            d.Add(ls);

            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;

            d.Add(new Paragraph(""));
            d.Add(new Paragraph("Support Hour Breakdown")).SetTextAlignment(TextAlignment.CENTER);
            d.Add(new Paragraph(""));
            string subheader1 = "C";
            string subheader2 = "TR";
            string subheader3 = "A";
            string subheader4 = "F";
            Text text1 = new Text(subheader1).SetFont(bolditalic);
            Text text2 = new Text(subheader2).SetFont(bolditalic);
            Text text3 = new Text(subheader3).SetFont(bolditalic);
            Text text4 = new Text(subheader4).SetFont(bolditalic);
            iText.Layout.Element.Table table = new iText.Layout.Element.Table(new float[] { 100, 200, 30, 30, 30, 30, 30, 30, 70 });
            Cell cell01 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBorderLeft(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell02 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell03 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell04 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBorderRight(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell05 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.RIGHT)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text1));
            Cell cell06 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetPaddingLeft(-2)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBorderRight(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text2));
            Cell cell07 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.RIGHT)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text3));
            Cell cell08 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetPaddingLeft(-2)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBorderRight(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text4));
            Cell cell09 = new Cell(1, 1)
            .SetBorder(Border.NO_BORDER)
            .SetBorderTop(new SolidBorder(1))
            .SetBorderRight(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(""));
          
            table.AddCell(cell01);
            table.AddCell(cell02);
            table.AddCell(cell03);
            table.AddCell(cell04);
            table.AddCell(cell05);
            table.AddCell(cell06);
            table.AddCell(cell07);
            table.AddCell(cell08);
            table.AddCell(cell09);                      

            Text text5 = new Text("\nIdentifier").SetFont(bolditalic);
            Text text6 = new Text("\nTitle").SetFont(bolditalic);
            Text text7 = new Text("\nMP").SetFont(bolditalic);
            Text text8 = new Text("Total\nSupt\nHours").SetFont(bolditalic);
            Text text9 = new Text("\nPre-Msn").SetFont(bolditalic);
            Text text10 = new Text("\nPost-Msn").SetFont(bolditalic);
            Text text11 = new Text("\nMedia").SetFont(bolditalic);

            Cell cell10 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text5));
            Cell cell11 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text6));
            Cell cell12 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text7));
            Cell cell13 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text8));
            Cell cell14 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text9));
            Cell cell15 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text10));
            Cell cell16 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text9));
            Cell cell17 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text10));
            Cell cell18 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetBackgroundColor(ColorConstants.LIGHT_GRAY)
            .SetFontSize(10)
            .Add(new Paragraph(text11));

            table.AddCell(cell10);
            table.AddCell(cell11);
            table.AddCell(cell12);
            table.AddCell(cell13);
            table.AddCell(cell14);
            table.AddCell(cell15);
            table.AddCell(cell16);
            table.AddCell(cell17);
            table.AddCell(cell18);

            int Sptcounter = 0;
            double totalduration = 0;
            double ctrprebrief = 0;
            double ctrpostbrief = 0;
            double afprebrief = 0;
            double afpostbrief = 0;

            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand("SELECT l.subtype, l.lessnumber, l.lesstitle, b.duration, b.prebrief, b.postbrief, b.review, m.mp, l.mediaiku, a.media from Builds_list b, lesson l, mp m, mediaiku a where b.buildid=" + buildid + " and b.lessid=l.lessid and m.id=l.mp and l.mediaiku=a.id order by b.id");
            cmd.Connection = con;
            SqlDataReader reader = cmd.ExecuteReader();
            {
                while (reader.Read())
                {
                    string lessnumber = reader["lessnumber"].ToString();
                    string lesstitle = reader["lesstitle"].ToString();
                    string mediatype = reader["media"].ToString();
                    string mediaid = reader["mediaiku"].ToString();
                    string mp = reader["MP"].ToString();
                    string durationstring = reader["duration"].ToString();
                    double duration = Convert.ToDouble(durationstring);
                    durationstring = duration.ToString("#,##0.0");
                    string prebriefstring = reader["prebrief"].ToString();
                    double prebrief = Convert.ToDouble(prebriefstring);
                    string postbriefstring = reader["postbrief"].ToString();
                    double postbrief = Convert.ToDouble(postbriefstring);

                    prebriefstring = prebrief.ToString("#,##0.0");
                    postbriefstring = postbrief.ToString("#,##0.0");
                    string review = reader["review"].ToString();
                    if (mediaid == "1" && review == "1")
                    {
                        durationstring = "R";
                    }

                    string subtype = reader["subtype"].ToString();
                    if (subtype != "")
                    {
                        SqlConnection con2 = new SqlConnection(cs);
                        con2.Open();
                        SqlCommand cmd2 = new SqlCommand("select * from subtypes where id=" + subtype);
                        cmd2.Connection = con2;
                        SqlDataReader reader2 = cmd2.ExecuteReader();
                        {
                            while (reader2.Read())
                            {
                                string subtypecategory = reader2["subtypecategory"].ToString();
                                if (subtypecategory == "0") // -- ATDs
                                {
                                    mediatype = "ATD";
                                }
                                else //subtypecategory = "1"  -- Flight
                                {
                                    mediatype = "FLY";
                                }
                            }
                        }
                        con2.Dispose();
                    }

                    if (prebriefstring == "0.0")
                    {
                        prebriefstring = "";
                    }
                    if (postbriefstring == "0.0")
                    {
                        postbriefstring = "";
                    }

                    if (mediaid == "4")
                    {
                        mediatype = "PERF";
                    }
                    if (mediaid == "9")
                    {
                        mediatype = "IBT";
                    }

                    if (mp == "C")
                    {
                        ctrprebrief += prebrief;
                        ctrpostbrief += postbrief;

                        Cell cell19 = new Cell(1, 1)
                        .SetTextAlignment(TextAlignment.LEFT)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(lessnumber));
                        Cell cell20 = new Cell(1, 1)
                        .SetTextAlignment(TextAlignment.LEFT)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(lesstitle));
                        Cell cell21 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(mp));
                        Cell cell22 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(durationstring));
                        Cell cell23 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(prebriefstring));
                        Cell cell24 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(postbriefstring));
                        Cell cell25 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(""));
                        Cell cell26 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(""));
                        Cell cell27 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(mediatype));

                        table.AddCell(cell19);
                        table.AddCell(cell20);
                        table.AddCell(cell21);
                        table.AddCell(cell22);
                        table.AddCell(cell23);
                        table.AddCell(cell24);
                        table.AddCell(cell25);
                        table.AddCell(cell26);
                        table.AddCell(cell27);    
                    }
                    else if (mp == "A")
                    {
                        afprebrief += prebrief;
                        afpostbrief += postbrief;

                        Cell cell19 = new Cell(1, 1)
                        .SetTextAlignment(TextAlignment.LEFT)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(lessnumber));
                        Cell cell20 = new Cell(1, 1)
                        .SetTextAlignment(TextAlignment.LEFT)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(lesstitle));
                        Cell cell21 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(mp));
                        Cell cell22 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(durationstring));
                        Cell cell23 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(""));
                        Cell cell24 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(""));
                        Cell cell25 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(prebriefstring));
                        Cell cell26 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(postbriefstring));
                        Cell cell27 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(mediatype));

                        table.AddCell(cell19);
                        table.AddCell(cell20);
                        table.AddCell(cell21);
                        table.AddCell(cell22);
                        table.AddCell(cell23);
                        table.AddCell(cell24);
                        table.AddCell(cell25);
                        table.AddCell(cell26);
                        table.AddCell(cell27);     
                    }
                    else // mp = "B"
                    {
                        ctrprebrief += prebrief;
                        ctrpostbrief += postbrief;
                        afprebrief += prebrief;
                        afpostbrief += postbrief;

                        Cell cell19 = new Cell(1, 1)
                        .SetTextAlignment(TextAlignment.LEFT)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(lessnumber));
                        Cell cell20 = new Cell(1, 1)
                        .SetTextAlignment(TextAlignment.LEFT)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(lesstitle));
                        Cell cell21 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(mp));
                        Cell cell22 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(durationstring));
                        Cell cell23 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(prebriefstring));
                        Cell cell24 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(postbriefstring));
                        Cell cell25 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(prebriefstring));
                        Cell cell26 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(postbriefstring));
                        Cell cell27 = new Cell(1, 1)
                        .SetBorder(new SolidBorder(1))
                        .SetFontSize(10)
                        .Add(new Paragraph(mediatype));

                        table.AddCell(cell19);
                        table.AddCell(cell20);
                        table.AddCell(cell21);
                        table.AddCell(cell22);
                        table.AddCell(cell23);
                        table.AddCell(cell24);
                        table.AddCell(cell25);
                        table.AddCell(cell26);
                        table.AddCell(cell27);
                    }
                    Sptcounter++;
                    totalduration += duration;
                }
            }
            con.Dispose();

            Cell cell28 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .SetHeight(10)
            .Add(new Paragraph(""));
            Cell cell29 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell30 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell31 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell32 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell33 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell34 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell35 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell36 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));

            table.AddCell(cell28);
            table.AddCell(cell29);
            table.AddCell(cell30);
            table.AddCell(cell31);
            table.AddCell(cell32);
            table.AddCell(cell33);
            table.AddCell(cell34);
            table.AddCell(cell35);
            table.AddCell(cell36);

            string totaldurationstring = totalduration.ToString();
            string ctrprebriefstring = ctrprebrief.ToString();
            string ctrpostbriefstring = ctrpostbrief.ToString();
            string afprebriefstring = afprebrief.ToString();
            string afpostbriefstring = afpostbrief.ToString();

            string Sptcounterstring = Sptcounter.ToString();

            Cell cell37 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)           
            .Add(new Paragraph("Total Events: " + Sptcounterstring));
            Cell cell38 = new Cell(1, 1)
            .SetTextAlignment(TextAlignment.LEFT)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell39 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));
            Cell cell40 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(totaldurationstring));
            Cell cell41 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(ctrprebriefstring));
            Cell cell42 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(ctrpostbriefstring));
            Cell cell43 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(afprebriefstring));
            Cell cell44 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(afpostbriefstring));
            Cell cell45 = new Cell(1, 1)
            .SetBorder(new SolidBorder(1))
            .SetFontSize(10)
            .Add(new Paragraph(""));

            table.AddCell(cell37);
            table.AddCell(cell38);
            table.AddCell(cell39);
            table.AddCell(cell40);
            table.AddCell(cell41);
            table.AddCell(cell42);
            table.AddCell(cell43);
            table.AddCell(cell44);
            table.AddCell(cell45);

            d.Add(table);

            //Finalization
            d.Close();
            byte[] byte1 = baos.ToArray();
            string TargetLocation = Server.MapPath("~/files/");
            using (FileStream fs = File.Create(TargetLocation + "sptreport1.pdf")) { fs.Write(byte1, 0, (int)byte1.Length); }

            string DEST = TargetLocation + "sptreport.pdf";
            string SRC = TargetLocation + "sptreport1.pdf";

            PdfDocument pdfDoc = new PdfDocument(new PdfReader(SRC), new PdfWriter(DEST));
            Document doc = new Document(pdfDoc);

            int numberOfPages = pdfDoc.GetNumberOfPages();
            for (int i = 1; i <= numberOfPages; i++)
            {
                // Write aligned text to the specified by parameters point
                doc.ShowTextAligned(new Paragraph(String.Format("Page " + i + " of " + numberOfPages)),
                        568f, 15f, i, TextAlignment.RIGHT, VerticalAlignment.TOP, 0);
                DateTime dt = DateTime.Now;
                string today = dt.ToLongDateString();
                doc.ShowTextAligned(new Paragraph(String.Format(today)),
                        45f, 15f, i, TextAlignment.LEFT, VerticalAlignment.TOP, 0);
            }
            doc.Close();

            Response.Redirect("~/files/sptreport.pdf", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}