﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class AddFeedback : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            NameValueCollection nvc = Request.Form;
            string lessid = nvc["lessid"];
            string fbdate = nvc["feedback_date"];
            string fbtype = nvc["feedback_type"];
            string comments = nvc["comments"];
            comments = comments.Replace("'", "''");
            // TODO: Need more SANITIZATION of the comments to mitigate SQL injection vulnerability
            // (maybe we also need to ensure that we're using only values in the expected range for the other fields,
            // in case of man-in-the-middle or bypassing the web form)
            string[] optProps = {
                "duration_rxn",
                "duration_sugg",
                "content_rxn",
                "flow_rxn",
                "functlty_rxn",
                "inc_know_rxn",
                "sense_rxn",
                "objectvs_rxn",
                "accuracy_rxn",
                "engaging_rxn",
                "needs_mm_rxn",
                "needs_ui_rxn",
                "issues_rxn",
                "sg_used_rxn",
                "sg_value_rxn",
                "ci_style_rxn",
                "ppt_value_rxn",
                "ppt_fit_rxn",
                "ppt_amt_rxn",
                "format_rxn",
                "need_aids_rxn"
            };
            // Towards building the SQL command using only the required fields and the nonempty optional fields:
            List<string> cmdParts = new List<string>();
            List<string> cmdParts2 = new List<string>();
            cmdParts.Add( "insert into Feedback (lessid, feedback_date, feedback_type" );
            for (int i = 0; i < optProps.Length; ++i)
            {
                string columnName = optProps[i];
                if (!string.IsNullOrEmpty(nvc[columnName]))
                {
                    cmdParts.Add(columnName);
                    cmdParts2.Add(nvc[columnName]);
                }
            }
            cmdParts.Add( $"comments) values ({lessid},'{fbdate}',{fbtype}" );
            cmdParts.AddRange(cmdParts2);
            cmdParts.Add( $"'{comments}')" );

            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;

            SqlConnection con = new SqlConnection(cs);
            //SqlCommand cmd = new SqlCommand($"insert into Feedback (lessid, feedback_date, feedback_type, comments) values ({lessid},'{fbdate}',{fbtype},'{comments}')", con);
            string commandStr = string.Join(", ", cmdParts.ToArray());
            SqlCommand cmd = new SqlCommand(commandStr, con);
            con.Open();
            cmd.ExecuteNonQuery();
            con.Dispose();

            //Response.Write($"<script>alert('Feedback Added')</script>");
            Response.Write($"<script>alert(\"Feedback Added\\nUsed: {commandStr}\")</script>");
            Response.Write("<script>window.location.href='../CAT/Feedback.aspx'</script>");
        }
    }
}