﻿<%@ Page Title="Feedback" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Feedback.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.Feedback" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 

<script>
    const fbItemCache = {};

    $(document).ready(function () {
        $(function () {
            $("#feedback_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $("#lessid").select2() // initialize, then attach the handler
            .on('select2:select', function (ev) {
                const mediaiku = ev.params.data.element.dataset.mediaiku;
                switch (mediaiku) {
                    case '1': // CAI
                        $('#fbform > .lde-only').css('display', '');
                        $('#fbform > .cai-only').css('display', 'flex');
                        break;
                    case '2': // LDE
                    case '3': // LD
                        $('#fbform > .cai-only').css('display', '');
                        $('#fbform > .lde-only').css('display', 'flex');
                }
            });

        $.ajax({
            url: 'getfeedback.asmx/GetFeedback',
            method: 'post',
            dataType: 'json',
            success: function (data) {
                $('#example').dataTable({
                    "bPaginate": false,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bInfo": true,
                    "bAutoWidth": true,
                    "scrollY": "400px",
                    "sScrollX": "100%",
                    "sScrollXInner": "100%",
                    "scrollCollapse": true,
                    "language": {
                        "emptyTable": "No Feedback"
                    },
                    data: data,
                    columns: [
                        { 'data': 'lessname' },
                        { 'data': 'feedback_date' },
                        { 'data': 'feedbacktype' },
                        //{ 'data': 'tcpname' },
                        { 'data': 'comments' },   
                        { 'data': 'lessid', "visible": false },
                        { 'data': 'feedbacktypeid', "visible": false },
                        //{ 'data': 'tcpid', "visible": false },
                        { 'data': 'Id', "visible": false }
                    ]
                });
                var table = $('#example').DataTable();

                $('#example tbody').on('click', 'tr', function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        fbItemCache.Id = null;
                    }
                    else {
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        var data = table.row(this).data();
                        //const myJSON = JSON.stringify(data);
                        //alert(myJSON);                        
                        cacheData(data);
                    }
                });
            }
        });
    });

    function cacheData(rowdata) {
        Object.assign(fbItemCache, rowdata);
    }

    // Clear entries/selections from the modal form.
    // Note that we don't need to call this after submit, because the page is reloaded by addFeedback/editFeedback.
    const clearForm = () => {
        document.getElementById('fbform').reset();
        setTimeout(function () {
            $('#lessid').trigger('change');
        }, 0);
        $('#fbid').val('');
        $('#fbform > .lde-only').css('display', '');
        $('#fbform > .cai-only').css('display', '');
    };

    function newfeedback() {
        const modal = document.getElementById("modalScreen");
        clearForm();
        document.getElementById('formTitle').innerHTML = 'New Feedback';
        $('#fbform').attr('action', '../CAT/addFeedback.aspx');
        modal.style.display = "block";

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;
        const revertAndClose = () => {
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        // (Note: the documentation for document.querySelector describes a really inefficient approach)
        $('#modalScreen .close')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            revertAndClose();
        }

        // When the user clicks anywhere outside of content area of the modal, close it
        // (*not* when the click is inside the content area, except the x, handled above)
        window.onclick = function (ev) {
            if (ev.target == modal) {
                revertAndClose();
            }
        }

        document.onkeydown = function (evt) {
            if (evt.key === 'Escape') {
                revertAndClose();
            }
        };
    }

    function editdata() {       
        if (fbItemCache.Id == null) {
            alert("No row selected");
            return;
        }

        clearForm();
        document.getElementById('formTitle').innerHTML = 'Edit Feedback';
        $('#fbform').attr('action', '../CAT/editFeedback.aspx');

        $('#fbid').val(fbItemCache.Id);
        setTimeout(function () {
            $('#lessid').val(fbItemCache.lessid).trigger('change');
        }, 0);
        $('#feedback_date').val(fbItemCache.feedback_date);
        $('#feedback_type').val(fbItemCache.feedbacktypeid);
        if (fbItemCache.duration_rxn) $('#duration_rxn').val(fbItemCache.duration_rxn);
        if (fbItemCache.duration_sugg) $('#duration_sugg').val(fbItemCache.duration_sugg);
        if (fbItemCache.content_rxn) $('#content_rxn').val(fbItemCache.content_rxn);
        if (fbItemCache.flow_rxn) $('#flow_rxn').val(fbItemCache.flow_rxn);
        if (fbItemCache.functlty_rxn) $('#functlty_rxn').val(fbItemCache.functlty_rxn);
        if (fbItemCache.inc_know_rxn) $('#inc_know_rxn').val(fbItemCache.inc_know_rxn);
        if (fbItemCache.sense_rxn) $('#sense_rxn').val(fbItemCache.sense_rxn);
        if (fbItemCache.objectvs_rxn) $('#objectvs_rxn').val(fbItemCache.objectvs_rxn);
        if (fbItemCache.accuracy_rxn) $('#accuracy_rxn').val(fbItemCache.accuracy_rxn);
        if (fbItemCache.engaging_rxn) $('#engaging_rxn').val(fbItemCache.engaging_rxn);
        if (fbItemCache.needs_mm_rxn) $('#needs_mm_rxn').val(fbItemCache.needs_mm_rxn);
        if (fbItemCache.issues_rxn) $('#issues_rxn').val(fbItemCache.issues_rxn);
        if (fbItemCache.sg_used_rxn) $('#sg_used_rxn').val(fbItemCache.sg_used_rxn);
        if (fbItemCache.sg_value_rxn) $('#sg_value_rxn').val(fbItemCache.sg_value_rxn);
        if (fbItemCache.ppt_value_rxn) $('#ppt_value_rxn').val(fbItemCache.ppt_value_rxn);
        if (fbItemCache.ppt_fit_rxn) $('#ppt_fit_rxn').val(fbItemCache.ppt_fit_rxn);
        if (fbItemCache.ppt_amt_rxn) $('#ppt_amt_rxn').val(fbItemCache.ppt_amt_rxn);
        if (fbItemCache.format_rxn) $('#format_rxn').val(fbItemCache.format_rxn);
        $('#comments').val(fbItemCache.comments);
        // Lesson Type-specific questions:
        switch (fbItemCache.mediaIKU) {
            case '1': // Chosen lesson is CAI
                if (fbItemCache.needs_ui_rxn) $('#needs_ui_rxn').val(fbItemCache.needs_ui_rxn);
                $('#fbform > .cai-only').css('display', 'flex');
                break;
            case '2': // LDE
            case '3': // LD
                if (fbItemCache.ci_style_rxn) $('#ci_style_rxn').val(fbItemCache.ci_style_rxn);
                if (fbItemCache.need_aids_rxn) $('#need_aids_rxn').val(fbItemCache.need_aids_rxn);
                $('#fbform > .lde-only').css('display', 'flex');
        }
        
        // Get the modal
        const modal = document.getElementById("modalScreen");
        modal.style.display = "block";

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;

        const revertAndClose = () => {
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        $('#modalScreen .close')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            revertAndClose();
        }

        // When the user clicks anywhere outside of content area of the modal, close it
        window.onclick = function (ev) {
            if (ev.target == modal) {
                revertAndClose();
            }
        }

        document.onkeydown = function (evt) {
            if (evt.key === 'Escape') {
                revertAndClose();
            }
        };
    }

    function deletedata() {      
        if (fbItemCache.Id == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this feedback?") == true) {
                window.location.href = "../CAT/deletefeedback.aspx?selid=" + fbItemCache.Id;
            } else {
                return;
            }
        }
    }

    function checkDate(form) {
        var feedback_dateString = form.feedback_date.value;

        if (feedback_dateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(feedback_dateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = feedback_dateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }    
        }
    }
</script>

<style>
.select2-search__field {
    color: black;
}
#main {
    overflow-x: hidden;
}

/* "TCP Requested" checkbox removed (until further notice) */
#tcpcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 15px;
    width: 130px;
}
#tcp{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#tcpcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#feedback_date {
    width: 38% !important;
}
#duration_sugg {
    width: 5em !important;
}
#duration_sugg + span {
  padding: 1rem;
  font-size: large;
}
.modal form.form.login input {
    margin: 0;
}
.modal form.form.login .selectstyle {
    width: 38% !important;
    margin: 0;
}
.modal form.form.login label {
    text-align: right;
    width: 60%;
}
.modal form.form.login label.above-field {
    display: block;
    width: auto;
    text-align: left;
    color: black;
    padding-bottom: 0;
}
#fbform > .cai-only, #fbform > .lde-only {
    display: none;
}
@media only screen and (max-width: 1300px) {
    .modal form.form.login label {
        width: 50%;
    }
    #feedback_date {
        width: 232px !important;
    }
    .modal form.form.login .selectstyle {
        width: 232px !important;
    }
}
</style>

<br /><br />
<div style="text-align:center; font-family:sans-serif;"><h1>Feedback</h1></div>
<hr />
<div id="PUBTable" style="margin: 35px;">
    <div style="min-width: 500px;">
        <asp:Label ID="buttonsHtml" runat="server" />
    </div>
    <table id="example" class="display" style="width:100%; border:none;">
        <thead style="background-color: #005EB8; color: white">
            <tr>         
                <th style="min-width: 100px;">Lesson</th>
                <th style="width: 50px;">Feedback Date</th>
                <th style="width: 50px;">Feedback Type</th>
                <!--th style="width: 50px;">TCP Requested</th-->
                <th style="min-width: 300px;">Comments</th>
                <th style="display:none;">Lesson ID</th>
                <th style="display:none;">Feedback Type ID</th>
                <!--th style="display:none;">TCP ID</th-->
                <th style="display:none;">ID</th>
            </tr>
        </thead>
    </table>
</div>

<!-- The Modal -->
<div id="modalScreen" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
    <br /><br />
    <h4 id="formTitle" style="text-align: center">New Feedback</h4><br />
    <form id='fbform' class="form login" name="form1" action="../CAT/addFeedback.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate(this)">
        <input type="hidden" name="fbid" id="fbid" />
        <div class="form__field" style="color: black">
            <select class="selectstyle" id="lessid" name="lessid" style="width:100%;" required>
                <asp:Label ID="lessidOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black; ">
            <label>Feedback date:</label>
            <input id="feedback_date" name="feedback_date" type="text" placeholder="Click to select the date" style="color: white" autocomplete="off" required />
        </div>
        <div class="form__field" style="color: black">
            <label>Feedback type:</label>
            <select class="selectstyle" id="feedback_type" name="feedback_type" required>
                <asp:Label ID="fbtypeOpts" runat="server" />
            </select>
        </div>
        <!--div class="form__field" id="tcpcheckbox">
        &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='tcp' name='tcp'><label for='tcp'>&nbsp;&nbsp;TCP&nbsp;&nbsp;&nbsp;&nbsp;</label>
        </div-->
        <div class="form__field" style="color: black">
            <label>Is the lesson duration appropriate?</label>
            <select class="selectstyle" id="duration_rxn" name="duration_rxn">
                <asp:Label ID="durationRxnOpts" runat="server" />
            </select>
        </div>
        <!--  -->
        <div class="form__field" style="color: black; ">
            <label>If the duration is not correct, how much time should be allotted to the lesson?</label>
            <input id="duration_sugg" name="duration_sugg" type="number" min="30" max="500" step="5" autocomplete="off" /><span>minutes</span>
        </div>
        <div class="form__field" style="color: black">
            <label>Are you satisfied with the instructional content of the lesson?</label>
            <select class="selectstyle" id="content_rxn" name="content_rxn">
                <asp:Label ID="contentRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>Are you satisfied with how the lesson flows?</label>
            <select class="selectstyle" id="flow_rxn" name="flow_rxn">
                <asp:Label ID="flowRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>Are you satisfied with the functionality of the lesson?</label>
            <select class="selectstyle" id="functlty_rxn" name="functlty_rxn">
                <asp:Label ID="functltyRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>This lesson increased my knowledge on the subject.</label>
            <select class="selectstyle" id="inc_know_rxn" name="inc_know_rxn">
                <asp:Label ID="incKnowRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The lesson flow was easy to follow and made sense.</label>
            <select class="selectstyle" id="sense_rxn" name="sense_rxn">
                <asp:Label ID="senseRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The objectives of the lesson were clearly stated and content was applicable to the objectives.</label>
            <select class="selectstyle" id="objectvs_rxn" name="objectvs_rxn">
                <asp:Label ID="objvsRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The content of the lesson was technically accurate.</label>
            <select class="selectstyle" id="accuracy_rxn" name="accuracy_rxn">
                <asp:Label ID="accurRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The way in which the subject matter was presented, e.g., text, interactivity, photographs, audio, visual aids, was helpful in understanding and being engaged with the content.</label>
            <select class="selectstyle" id="engaging_rxn" name="engaging_rxn">
                <asp:Label ID="engageRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>This lesson would benefit from more audio/visual aids, such as photos, videos, or sound recordings.</label>
            <select class="selectstyle" id="needs_mm_rxn" name="needs_mm_rxn">
                <asp:Label ID="needsMMRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field cai-only" style="color: black"><!-- CAI ONLY -->
            <label>This lesson would benefit from interactivity.</label>
            <select class="selectstyle" id="needs_ui_rxn" name="needs_ui_rxn">
                <asp:Label ID="needsUIRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>There were too many issues with grammar, spelling, and formatting.</label>
            <select class="selectstyle" id="issues_rxn" name="issues_rxn">
                <asp:Label ID="issuesRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>I used the Student Guide for this lesson.</label>
            <select class="selectstyle" id="sg_used_rxn" name="sg_used_rxn">
                <asp:Label ID="sgUsedRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The Student Guide was a valuable resource for this lesson.</label>
            <select class="selectstyle" id="sg_value_rxn" name="sg_value_rxn">
                <asp:Label ID="sgValueRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field lde-only" style="color: black"><!-- LDE/LD ONLY -->
            <label>The instructor presented the information in a clear and logical manner.</label>
            <select class="selectstyle" id="ci_style_rxn" name="ci_style_rxn">
                <asp:Label ID="ciStyleRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The usage of PowerPoint slides contributed to my learning.</label>
            <select class="selectstyle" id="ppt_value_rxn" name="ppt_value_rxn">
                <asp:Label ID="pptValueRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The PowerPoint slides were clear and appropriate.</label>
            <select class="selectstyle" id="ppt_fit_rxn" name="ppt_fit_rxn">
                <asp:Label ID="pptFitRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The amount of content on each slide of the PowerPoint was appropriate.</label>
            <select class="selectstyle" id="ppt_amt_rxn" name="ppt_amt_rxn">
                <asp:Label ID="pptAmtRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field" style="color: black">
            <label>The content in the lesson would have been more appropriately taught in a different format, e.g., in a CAI, lecture, or with actual equipment.</label>
            <select class="selectstyle" id="format_rxn" name="format_rxn">
                <asp:Label ID="formatRxnOpts" runat="server" />
            </select>
        </div>
        <div class="form__field lde-only" style="color: black"><!-- LDE/LD ONLY -->
            <label>Instructional aids such as mock-ups or training items would have been beneficial for this lesson.</label>
            <select class="selectstyle" id="need_aids_rxn" name="need_aids_rxn">
                <asp:Label ID="needAidsRxnOpts" runat="server" />
            </select>
        </div>
        <label class="above-field">Any additional comments/suggestions for improvement?</label>
        <div class='form__field'>
            <textarea class='textareastyle' name='comments' id='comments' placeholder='Comments' style='resize: none;'></textarea>
        </div>
        <div class="form__field">
            <input type="submit" value="Submit" style="width: 300px;" />
        </div>
    </form>
  </div>
</div>

</asp:Content>
