﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class NewLesson : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('Session Timeout')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            string catroles = "";
            string userid = Session["UserID"].ToString();
            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            SqlConnection userCon = new SqlConnection(cs);
            userCon.Open();
            SqlCommand selUserCmd = new SqlCommand("SELECT catroles from Members where id=" + userid);
            selUserCmd.Connection = userCon;
            SqlDataReader userRdr = selUserCmd.ExecuteReader();
            {
                if (userRdr.Read())
                {
                    catroles = userRdr["catroles"].ToString();
                }
            }
            userCon.Dispose();
            if (catroles != "1") // Only a CAT ADMIN is allowed to create lesson records
            {
                // TODO: consider, e.g., a FORBIDDEN response
                Response.Write("<script>alert('Sorry')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            DbToWeb lookup = new DbToWeb();
            NameValueCollection nvc = Request.Form;
            string LESSNUMBER = nvc["LESSNUMBER"];
            string LESSTITLE = nvc["LESSTITLE"];
            LESSTITLE = LESSTITLE.Replace("'", "''");
            string REV = nvc["REV"];
            string REVDATE = nvc["REVDATE"];
            string MEDIATYPE = nvc["MEDIATYPE"];
            string SUBTYPE = nvc["SUBTYPE"];
            string FEADATE = nvc["FEADATE"];
            string STATUS = nvc["STATUS"];
            string CLASSIFICATION = nvc["CLASSIFICATION"];
            string ICWL = nvc["ICWL"];
            //string LESSDURATION = nvc["LESSDURATION"];
            string LESSNOTE = nvc["LESSNOTE"];
            LESSNOTE = LESSNOTE.Replace("'", "''");
            string MESL = nvc["MESL"];
            MESL = MESL.Replace("'", "''");
            string MP = nvc["MP"];
            //string SPTTIME = nvc["SPTTIME"];
            string PRIMARY_INSTRUCTOR = nvc["PRIMARYINSTRUCTOR"];
            string ALTERNATE_INSTRUCTOR = nvc["ALTERNATEINSTRUCTOR"];

            int LESSIDINT = 0;
            SqlConnection lessidCon = new SqlConnection(cs);
            lessidCon.Open();
            SqlCommand lessidCmd = new SqlCommand("SELECT top 1 LESSID from LESSON order by id desc");
            lessidCmd.Connection = lessidCon;
            SqlDataReader lessidRdr = lessidCmd.ExecuteReader();
            {
                if (lessidRdr.Read())
                {
                    LESSIDINT = lessidRdr.GetInt32(0) + 1;
                }
            }
            lessidCon.Dispose();

            List<string> insertStmtList = new List<string>();
            insertStmtList.Add($"{LESSIDINT},'{LESSNUMBER}','{LESSTITLE}'");
            insertStmtList.Add((string.IsNullOrEmpty(REV) ? "NULL" : $"'{REV}'"));
            insertStmtList.Add((string.IsNullOrEmpty(REVDATE) ? "NULL" : $"'{REVDATE}'"));
            insertStmtList.Add((string.IsNullOrEmpty(FEADATE) ? "NULL" : $"'{FEADATE}'"));
            insertStmtList.Add($"{STATUS},'{LESSNOTE}',{MEDIATYPE}");
            insertStmtList.Add((string.IsNullOrEmpty(SUBTYPE) ? "NULL" : SUBTYPE));
            // Applicable Airframes:
            string[] airframeNames = lookup.getAirframeNames(cs);
            uint airframeFlags = 0;
            foreach (string name in airframeNames)
            {
                string colName = lookup.getAirframeColumnName(name);
                if (nvc["FORM" + colName] == "on")
                {
                    airframeFlags |= lookup.getAirframeFlagValue(colName);
                    if (colName != "AC130J")
                        insertStmtList.Add("'True'");
                }
                else if (colName != "AC130J")
                {
                    insertStmtList.Add("'False'");
                }
            }
            insertStmtList.Add($"{airframeFlags}");
            // NOTE the per-airframe columns will no longer need to be updated when all of the values
            // have been migrated to the airframes column.
            // END Applicable Airframes.
            insertStmtList.Add($"'{MESL}'");
            insertStmtList.Add($"{(string.IsNullOrEmpty(CLASSIFICATION) ? "NULL" : "'" + CLASSIFICATION + "'")}");
            insertStmtList.Add((string.IsNullOrEmpty(ICWL) ? "NULL" : ICWL));
            insertStmtList.Add((string.IsNullOrEmpty(MP) ? "NULL" : MP));
            insertStmtList.Add((string.IsNullOrEmpty(PRIMARY_INSTRUCTOR) ? "NULL" : PRIMARY_INSTRUCTOR));
            insertStmtList.Add((string.IsNullOrEmpty(ALTERNATE_INSTRUCTOR) ? "NULL" : ALTERNATE_INSTRUCTOR));

            string[] insertStmtParts = new string[] {
                "insert into LESSON (",
                "LESSID, LESSNUMBER, LESSTITLE, LESSREV, REVDATE, FEADATE, STATUS, LESSNOTE, MEDIAIku, SUBTYPE, ",
                "HC130J, MC130J, UH1N, HH60, CV22, FTRUCKER, AIRFRAMES, MESL, CLASSIFICATION, ICWL, MP, ",
                "PRIMARY_INSTRUCTOR, ALTERNATE_INSTRUCTOR",
                ") values (",
                string.Join(",", insertStmtList.ToArray()),
                ")"
            };
            SqlConnection insertCon = new SqlConnection(cs);
            SqlCommand insertCmd = new SqlCommand(string.Join("", insertStmtParts), insertCon);
            insertCon.Open();
            insertCmd.ExecuteNonQuery();
            insertCon.Dispose();     

            Response.Write("<script>alert('New Lesson Added')</script>");                     
            Response.Write("<script>window.location.href='../CAT/EditLessons.aspx'</script>");            
        }
    }
}