﻿<%@ Page Title="Edit SOI Build" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="editsoitable.aspx.cs" Inherits="CAE_WEB_PROJECT.SOITable.editsoitable" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="../scripts/dataTables.rowReorder.min.js"></script>

<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
<link rel="stylesheet" href="../styles/rowReorder.dataTables.min.css" /> 

<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" />

<script>
    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    var ROW;
    var DAYSTRING;
    var LESSON;
    var DURATION;
    var PREBRIEF;
    var POSTBRIEF;
    var NUM_MISSIONS;
    var PILOT;
    var PILOT_PREREQS;
    var CSO;
    var CSO_PREREQS;
    var SMA;
    var SMA_PREREQS;
    var LM;
    var LM_PRREQS;
    var LESSID;
    var PILOT_PREREQ_LIST;
    var CSO_PREREQ_LIST;
    var SMA_PREREQ_LIST;
    var LM_PREREQ_LIST;
    var REVIEW;
    var DAY;
    var selid;

    $(document).ready(function () {
        $("#LESSID").select2();
        $("#PILOTPREREQS").select2({
            placeholder: "Select Pilot Prereqs"
        });   
        $("#CSOPREREQS").select2({
            placeholder: "Select CSO Prereqs"
        }); 
        $("#SMAPREREQS").select2({
            placeholder: "Select SMA Prereqs"
        }); 
        $("#LMPREREQS").select2({
            placeholder: "Select LM Prereqs"
        }); 

        $("#EDITLESSID").select2();
        $("#EDITPILOTPREREQS").select2({
            placeholder: "Select Pilot Prereqs"
        });
        $("#EDITCSOPREREQS").select2({
            placeholder: "Select CSO Prereqs"
        });
        $("#EDITSMAPREREQS").select2({
            placeholder: "Select SMA Prereqs"
        });
        $("#EDITLMPREREQS").select2({
            placeholder: "Select LM Prereqs"
        }); 

        var buildid = getUrlVars()["buildid"];       

        $('#buildid').val(buildid);
        $('#editbuildid').val(buildid);

        $.ajax({
            url: 'getbuilds.asmx/GetBuilds?buildid=' + buildid,
            method: 'post',
            dataType: 'json',
            success: function (data) {
                $('#example').dataTable({
                    "bPaginate": false,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bInfo": true,
                    "bAutoWidth": true,      
                    "scrollY": "400px",
                    "sScrollX": "100%",
                    "sScrollXInner": "100%",
                    "scrollCollapse": true,
                    "language": {
                        "emptyTable": "No Build"
                    },
                    data: data,
                    columns: [
                        { 'data': 'ROW' },
                        { 'data': 'DAYSTRING' },
                        { 'data': 'LESSON' },
                        { 'data': 'DURATION' },
                        { 'data': 'PREBRIEF' },
                        { 'data': 'POSTBRIEF' },
                        { 'data': 'NUM_MISSIONS' },
                        { 'data': 'PILOT' },
                        { 'data': 'PILOT_PREREQS' },
                        { 'data': 'CSO' },
                        { 'data': 'CSO_PREREQS' },
                        { 'data': 'SMA' },
                        { 'data': 'SMA_PREREQS' },
                        { 'data': 'LM' },
                        { 'data': 'LM_PREREQS' },  
                        { 'data': 'LESSID', "visible": false },  
                        { 'data': 'PILOT_PREREQ_LIST', "visible": false },  
                        { 'data': 'CSO_PREREQ_LIST', "visible": false }, 
                        { 'data': 'SMA_PREREQ_LIST', "visible": false }, 
                        { 'data': 'LM_PREREQ_LIST', "visible": false }, 
                        { 'data': 'REVIEW', "visible": false },
                        { 'data': 'DAY', "visible": false },
                        { 'data': 'ID', "visible": false }
                    ],
                    columnDefs: [
                        { width: 20, targets: 0 },
                        { width: 20, targets: 1 },
                        { width: 250, targets: 2 },
                        { width: 15, targets: 3 },
                        { width: 15, targets: 4 },
                        { width: 40, targets: 5 },
                        { width: 15, targets: 6 },
                        { width: 20, targets: 7 },
                        { width: 250, targets: 8 },
                        { width: 20, targets: 9 },
                        { width: 250, targets: 10 },
                        { width: 20, targets: 11 },
                        { width: 250, targets: 12 },
                        { width: 20, targets: 13 },
                        { width: 250, targets: 14 },
                        { width: 0, targets: 15 }, 
                        { width: 0, targets: 16 }, 
                        { width: 0, targets: 17 }, 
                        { width: 0, targets: 18 }, 
                        { width: 0, targets: 19 }, 
                        { width: 0, targets: 20 }, 
                        { width: 0, targets: 21 },
                        { width: 0, targets: 22 }      
                    ],
                    fixedColumns: true,
                    rowReorder: {
                        dataSrc: 'ROW',
                        selector: 'tr td:first-of-type'
                    }
                });
                var table = $('#example').DataTable();

                const rowindex = [];
                const newrows = [];

                let rowindextext = "";   
                let newrowstext = "";              
                
                table.on('row-reorder', function (e, diff, edit) {                   
                    document.getElementById("savebutton").style.display = "inline";
                    var result = "";
                    for (var i = 0, ien = diff.length; i < ien; i++) {                           
                        result += ' Row ' + diff[i].newData + ' (was ' + diff[i].oldData + ')';
                        rowindex.push(diff[i].oldData);
                        newrows.push(diff[i].newData);
                    }
                    //alert(result);
                    rowindextext = rowindex.toString();
                    newrowstext = newrows.toString();

                    $("#rowindex").val(rowindextext);
                    $("#newrow").val(newrowstext);
                                        
                    table.rowReorder.disable();
                    
                    let firstCol = document.querySelectorAll('tr td:first-of-type');
                    for (let i = 0; i < firstCol.length; i++) {
                        firstCol[i].style.cursor = 'auto';
                    }                
                });            

                $('#example tbody').on('click', 'tr', function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        selid = null;
                    }
                    else {
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        var data = table.row(this).data();
                        //const myJSON = JSON.stringify(data);
                        //alert(myJSON);
                        savedata(data);
                    }
                });
            }
        });
    });

    function savedata(rowdata) {
        ROW = rowdata.ROW;
        DAYSTRING = rowdata.DAYSTRING;
        LESSON = rowdata.LESSON;
        DURATION = rowdata.DURATION;
        PREBRIEF = rowdata.PREBRIEF;
        POSTBRIEF = rowdata.POSTBRIEF;
        NUM_MISSIONS = rowdata.NUM_MISSIONS;
        PILOT = rowdata.PILOT;
        PILOT_PREREQS = rowdata.PILOT_PREREQS;
        CSO = rowdata.CSO;
        CSO_PREREQS = rowdata.CSO_PREREQS;
        SMA = rowdata.SMA;
        SMA_PREREQS = rowdata.SMA_PREREQS;
        LM = rowdata.LM;
        LM_PREREQS = rowdata.LM_PREREQS;
        LESSID = rowdata.LESSID;
        PILOT_PREREQ_LIST = rowdata.PILOT_PREREQ_LIST;
        CSO_PREREQ_LIST = rowdata.CSO_PREREQ_LIST;
        SMA_PREREQ_LIST = rowdata.SMA_PREREQ_LIST;
        LM_PREREQ_LIST = rowdata.LM_PREREQ_LIST;
        REVIEW = rowdata.REVIEW;
        DAY = rowdata.DAY;
        selid = rowdata.ID;
    }

    function newlesson() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            setTimeout(function () {
                $('#EDITPILOTPREREQS').select2();
                $('#EDITPILOTPREREQS').select2().val('');
                $('#EDITPILOTPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITCSOPREREQS').select2();
                $('#EDITCSOPREREQS').select2().val('');
                $('#EDITCSOPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITSMAPREREQS').select2();
                $('#EDITSMAPREREQS').select2().val('');
                $('#EDITSMAPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITLMPREREQS').select2();
                $('#EDITLMPREREQS').select2().val('');
                $('#EDITLMPREREQS').select2().trigger('change');
            }, 0);

            setTimeout(function () {
                $("#EDITPILOTPREREQS").select2({
                    placeholder: "Select Pilot Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITCSOPREREQS").select2({
                    placeholder: "Select CSO Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITSMAPREREQS").select2({
                    placeholder: "Select SMA Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITLMPREREQS").select2({
                    placeholder: "Select LM Prereqs"
                });
            }, 0);

            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";  
                setTimeout(function () {
                    $('#EDITPILOTPREREQS').select2();
                    $('#EDITPILOTPREREQS').select2().val('');
                    $('#EDITPILOTPREREQS').select2().trigger('change');                    
                }, 0);   
                setTimeout(function () {
                    $('#EDITCSOPREREQS').select2();
                    $('#EDITCSOPREREQS').select2().val('');
                    $('#EDITCSOPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITSMAPREREQS').select2();
                    $('#EDITSMAPREREQS').select2().val('');
                    $('#EDITSMAPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITLMPREREQS').select2();
                    $('#EDITLMPREREQS').select2().val('');
                    $('#EDITLMPREREQS').select2().trigger('change');
                }, 0);
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                    setTimeout(function () {
                        $('#EDITPILOTPREREQS').select2();
                        $('#EDITPILOTPREREQS').select2().val('');
                        $('#EDITPILOTPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITCSOPREREQS').select2();
                        $('#EDITCSOPREREQS').select2().val('');
                        $('#EDITCSOPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITSMAPREREQS').select2();
                        $('#EDITSMAPREREQS').select2().val('');
                        $('#EDITSMAPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITLMPREREQS').select2();
                        $('#EDITLMPREREQS').select2().val('');
                        $('#EDITLMPREREQS').select2().trigger('change');
                    }, 0); 
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                    setTimeout(function () {
                        $('#EDITPILOTPREREQS').select2();
                        $('#EDITPILOTPREREQS').select2().val('');
                        $('#EDITPILOTPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITCSOPREREQS').select2();
                        $('#EDITCSOPREREQS').select2().val('');
                        $('#EDITCSOPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITSMAPREREQS').select2();
                        $('#EDITSMAPREREQS').select2().val('');
                        $('#EDITSMAPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITLMPREREQS').select2();
                        $('#EDITLMPREREQS').select2().val('');
                        $('#EDITLMPREREQS').select2().trigger('change');
                    }, 0); 
                }
            };

            $('#editid').val(selid);
            $('#EDITDAY').val(DAY);          

            setTimeout(function () {
                $('#EDITLESSID').select2();
                $('#EDITLESSID').select2().val(LESSID);
                $('#EDITLESSID').select2().trigger('change');
            }, 0);

            $('#EDITDURATION').val(DURATION);
            $('#EDITPREBRIEF').val(PREBRIEF);
            $('#EDITPOSTBRIEF').val(POSTBRIEF);
            $('#EDITMISSIONS').val(NUM_MISSIONS);
                      
            if (PILOT == "True") {
                setTimeout(function () {
                    $("#EDITPILOT").prop("checked", true);
                }, 0);               
            }
            else {
                setTimeout(function () {
                    $("#EDITPILOT").prop("checked", false);
                }, 0);                 
            }
            if (CSO == "True") {
                setTimeout(function () {
                    $("#EDITCSO").prop("checked", true);
                }, 0);                 
            }
            else {
                setTimeout(function () {
                    $("#EDITCSO").prop("checked", false);
                }, 0);                 
            }
            if (SMA == "True") {
                setTimeout(function () {
                    $("#EDITSMA").prop("checked", true);
                }, 0);                
            }
            else {
                setTimeout(function () {
                    $("#EDITSMA").prop("checked", false);
                }, 0);                 
            }
            if (LM == "True") {
                setTimeout(function () {
                    $("#EDITLM").prop("checked", true);
                }, 0);                
            }
            else {
                setTimeout(function () {
                    $("#EDITLM").prop("checked", false);
                }, 0);                  
            }
            //alert(PILOT_PREREQ_LIST);      
            if (PILOT_PREREQ_LIST != "None") {
                const myData = JSON.parse("[" + PILOT_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITPILOTPREREQS').select2();
                    $('#EDITPILOTPREREQS').select2().val(myData);
                    $('#EDITPILOTPREREQS').select2().trigger('change');
                }, 0);
            }
            if (CSO_PREREQ_LIST != "None") {
                const myData2 = JSON.parse("[" + CSO_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITCSOPREREQS').select2();
                    $('#EDITCSOPREREQS').select2().val(myData2);
                    $('#EDITCSOPREREQS').select2().trigger('change');
                }, 0);
            }
            if (SMA_PREREQ_LIST != "None") {
                const myData3 = JSON.parse("[" + SMA_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITSMAPREREQS').select2();
                    $('#EDITSMAPREREQS').select2().val(myData3);
                    $('#EDITSMAPREREQS').select2().trigger('change');
                }, 0);
            }
            if (LM_PREREQ_LIST != "None") {
                const myData4 = JSON.parse("[" + LM_PREREQ_LIST + "]");       
                setTimeout(function () {
                    $('#EDITLMPREREQS').select2();
                    $('#EDITLMPREREQS').select2().val(myData4);
                    $('#EDITLMPREREQS').select2().trigger('change');
                }, 0);
            }   
            
            if (REVIEW == 1) {
                setTimeout(function () {
                    $("#EDITReview").prop("checked", true);
                }, 0);                
            }
            else {
                setTimeout(function () {
                    $("#EDITReview").prop("checked", false);
                }, 0);                   
            }
        }
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var buildid = getUrlVars()["buildid"];
            if (confirm("Are you sure that you want to delete this row?") == true) {
                window.location.href = "../SOITable/deletelesson.aspx?type=build&buildid=" + buildid + "&selid=" + selid;
            } else {
                return;
            }
        }
    }
    function canceldrag() {
        var buildid = getUrlVars()["buildid"];
        window.location.href = "../SOITable/editsoitable.aspx?buildid=" + buildid;
    }

    function backtoactivebuilds() {
        window.location.href = "../SOITable/activesoibuilds.aspx";
    }

    function Pilotprereq() {    
        var data = $('#PILOTPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#PILOT").prop("checked", true);
        }
        else {
            $("#PILOT").prop("checked", false);
        }
    }

    function CSOprereq() {
        var data = $('#CSOPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#CSO").prop("checked", true);
        }
        else {
            $("#CSO").prop("checked", false);
        }
        validateCSO();
    }

    function SMAprereq() {
        var data = $('#SMAPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#SMA").prop("checked", true);
        }
        else {
            $("#SMA").prop("checked", false);
        }
        validateSMA();
    }

    function LMprereq() {
        var data = $('#LMPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#LM").prop("checked", true);
        }
        else {
            $("#LM").prop("checked", false);
        }
    }

    function Pilotprereq2() {
        var data = $('#EDITPILOTPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITPILOT").prop("checked", true);
        }
        else {
            $("#EDITPILOT").prop("checked", false);
        }
    }

    function CSOprereq2() {
        var data = $('#EDITCSOPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITCSO").prop("checked", true);
        }
        else {
            $("#EDITCSO").prop("checked", false);
        }
        validateCSO2();
    }

    function SMAprereq2() {
        var data = $('#EDITSMAPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITSMA").prop("checked", true);
        }
        else {
            $("#EDITSMA").prop("checked", false);
        }
        validateSMA2();
    }

    function LMprereq2() {
        var data = $('#EDITLMPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITLM").prop("checked", true);
        }
        else {
            $("#EDITLM").prop("checked", false);
        }
    }

    function validateSMA() {
        if ($("#SMA").is(':checked')) {
            $("#CSO").prop("checked", false);
        }
    }
    function validateCSO() {
        if ($("#CSO").is(':checked')) {
            $("#SMA").prop("checked", false);  
        }
    }

    function validateSMA2() {
        if ($("#EDITSMA").is(':checked')) {
            $("#EDITCSO").prop("checked", false);
        }
    }
    function validateCSO2() {
        if ($("#EDITCSO").is(':checked')) {
            $("#EDITSMA").prop("checked", false);
        }
    }

    function checkmediatype() {
        //alert(rowCnt);
        var lessid = $('#LESSID').val();
        if (lessid == "") {
            return false;
        }

        var duration = $('#DURATION').val();
        var prebrief = $('#PREBRIEF').val();
        var postbrief = $('#POSTBRIEF').val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");
                    $("#reviewcheckbox")[0].style.display = 'flex';

                    if ($("#Review").is(':checked')) {
                        $("#DURATION")[0].type = 'text';
                        $("#DURATION")[0].style.backgroundColor = 'black';
                        $("#DURATION").val('R');
                        $("#DURATION").prop("readonly", true);
                        /*
                        $("#PREBRIEF")[0].type = 'text';
                        $("#PREBRIEF")[0].style.backgroundColor = 'black';
                        $("#PREBRIEF").val('R');
                        $("#PREBRIEF").prop("readonly", true);

                        $("#POSTBRIEF")[0].type = 'text';
                        $("#POSTBRIEF")[0].style.backgroundColor = 'black';
                        $("#POSTBRIEF").val('R');
                        $("#POSTBRIEF").prop("readonly", true);
                        */
                    }
                    else {
                        if (duration == 0 || duration == "R") {
                            $("#DURATION")[0].type = 'number';
                            $("#DURATION")[0].style.backgroundColor = '#3b4148';
                            $("#DURATION").val('0');
                            $("#DURATION").prop("readonly", false);
                        }
                        /*
                        if (prebrief == 0 || prebrief == "R") {
                            $("#PREBRIEF")[0].type = 'number';
                            $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#PREBRIEF").val('0');
                            $("#PREBRIEF").prop("readonly", false);
                        }
                        if (postbrief == 0 || postbrief == "R") {
                            $("#POSTBRIEF")[0].type = 'number';
                            $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#POSTBRIEF").val('0');
                            $("#POSTBRIEF").prop("readonly", false);
                        }
                        */
                    }
                }
                else {
                    $("#reviewcheckbox")[0].style.display = 'none';

                    if (duration == 0 || duration == "R") {
                        $("#DURATION")[0].type = 'number';
                        $("#DURATION")[0].style.backgroundColor = '#3b4148';
                        $("#DURATION").val('0');
                        $("#DURATION").prop("readonly", false);
                    }
                    /*
                    if (prebrief == 0 || prebrief == "R") {
                        $("#PREBRIEF")[0].type = 'number';
                        $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#PREBRIEF").val('0');
                        $("#PREBRIEF").prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#POSTBRIEF")[0].type = 'number';
                        $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#POSTBRIEF").val('0');
                        $("#POSTBRIEF").prop("readonly", false);
                    }
                    */
                }
            });
        }
        else {
            $("#reviewcheckbox")[0].style.display = 'none';

            if (duration == 0 || duration == "R") {
                $("#DURATION")[0].type = 'number';
                $("#DURATION")[0].style.backgroundColor = '#3b4148';
                $("#DURATION").val('0');
                $("#DURATION").prop("readonly", false);
            }
            /*
            if (prebrief == 0 || prebrief == "R") {
                $("#PREBRIEF")[0].type = 'number';
                $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#PREBRIEF").val('0');
                $("#PREBRIEF").prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#POSTBRIEF")[0].type = 'number';
                $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#POSTBRIEF").val('0');
                $("#POSTBRIEF").prop("readonly", false);
            }
            */
        }
    }

    function checkmediatype2() {
        //alert(rowCnt);
        var lessid = $('#EDITLESSID').val();
        if (lessid == "") {
            return false;
        }

        var duration = $('#EDITDURATION').val();
        var prebrief = $('#EDITPREBRIEF').val();
        var postbrief = $('#EDITPOSTBRIEF').val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");
                    $("#EDITreviewcheckbox")[0].style.display = 'flex';

                    if ($("#EDITReview").is(':checked')) {
                        $("#EDITDURATION")[0].type = 'text';
                        $("#EDITDURATION")[0].style.backgroundColor = 'black';
                        $("#EDITDURATION").val('R');
                        $("#EDITDURATION").prop("readonly", true);
                        /*
                        $("#EDITPREBRIEF")[0].type = 'text';
                        $("#EDITPREBRIEF")[0].style.backgroundColor = 'black';
                        $("#EDITPREBRIEF").val('R');
                        $("#EDITPREBRIEF").prop("readonly", true);

                        $("#EDITPOSTBRIEF")[0].type = 'text';
                        $("#EDITPOSTBRIEF")[0].style.backgroundColor = 'black';
                        $("#EDITPOSTBRIEF").val('R');
                        $("#EDITPOSTBRIEF").prop("readonly", true);
                        */
                    }
                    else {
                        if (duration == 0 || duration == "R") {
                            $("#EDITDURATION")[0].type = 'number';
                            $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                            $("#EDITDURATION").val('0');
                            $("#EDITDURATION").prop("readonly", false);
                        }
                        /*
                        if (prebrief == 0 || prebrief == "R") {
                            $("#EDITPREBRIEF")[0].type = 'number';
                            $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#EDITPREBRIEF").val('0');
                            $("#EDITPREBRIEF").prop("readonly", false);
                        }
                        if (postbrief == 0 || postbrief == "R") {
                            $("#EDITPOSTBRIEF")[0].type = 'number';
                            $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#EDITPOSTBRIEF").val('0');
                            $("#EDITPOSTBRIEF").prop("readonly", false);
                        }
                        */
                    }
                }
                else {
                    $("#EDITreviewcheckbox")[0].style.display = 'none';

                    if (duration == 0 || duration == "R") {
                        $("#EDITDURATION")[0].type = 'number';
                        $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                        $("#EDITDURATION").val('0');
                        $("#EDITDURATION").prop("readonly", false);
                    }
                    /*
                    if (prebrief == 0 || prebrief == "R") {
                        $("#EDITPREBRIEF")[0].type = 'number';
                        $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#EDITPREBRIEF").val('0');
                        $("#EDITPREBRIEF").prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#EDITPOSTBRIEF")[0].type = 'number';
                        $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#EDITPOSTBRIEF").val('0');
                        $("#EDITPOSTBRIEF").prop("readonly", false);
                    }
                    */
                }
            });
        }
        else {
            $("#EDITreviewcheckbox")[0].style.display = 'none';

            if (duration == 0 || duration == "R") {
                $("#EDITDURATION")[0].type = 'number';
                $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                $("#EDITDURATION").val('0');
                $("#EDITDURATION").prop("readonly", false);
            }
            /*
            if (prebrief == 0 || prebrief == "R") {
                $("#EDITPREBRIEF")[0].type = 'number';
                $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#EDITPREBRIEF").val('0');
                $("#EDITPREBRIEF").prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#EDITPOSTBRIEF")[0].type = 'number';
                $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#EDITPOSTBRIEF").val('0');
                $("#EDITPOSTBRIEF").prop("readonly", false);
            }
            */
        }
    }

    function changevalues() {
        if ($("#Review").is(':checked')) {
            $("#DURATION")[0].type = 'text';
            $("#DURATION")[0].style.backgroundColor = 'black';
            $("#DURATION").val('R');
            $("#DURATION").prop("readonly", true);
            /*
            $("#PREBRIEF")[0].type = 'text';
            $("#PREBRIEF")[0].style.backgroundColor = 'black';
            $("#PREBRIEF").val('R');
            $("#PREBRIEF").prop("readonly", true);

            $("#POSTBRIEF")[0].type = 'text';
            $("#POSTBRIEF")[0].style.backgroundColor = 'black';
            $("#POSTBRIEF").val('R');
            $("#POSTBRIEF").prop("readonly", true);
            */
        }
        else {
            $("#DURATION")[0].type = 'number';
            $("#DURATION")[0].style.backgroundColor = '#3b4148';
            $("#DURATION").val('0');
            $("#DURATION").prop("readonly", false);
            /*
            $("#PREBRIEF")[0].type = 'number';
            $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#PREBRIEF").val('0');
            $("#PREBRIEF").prop("readonly", false);

            $("#POSTBRIEF")[0].type = 'number';
            $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#POSTBRIEF").val('0');
            $("#POSTBRIEF").prop("readonly", false);
            */
        }
    }

    function changevalues2() {
        if ($("#EDITReview").is(':checked')) {
            $("#EDITDURATION")[0].type = 'text';
            $("#EDITDURATION")[0].style.backgroundColor = 'black';
            $("#EDITDURATION").val('R');
            $("#EDITDURATION").prop("readonly", true);
            /*
            $("#EDITPREBRIEF")[0].type = 'text';
            $("#EDITPREBRIEF")[0].style.backgroundColor = 'black';
            $("#EDITPREBRIEF").val('R');
            $("#EDITPREBRIEF").prop("readonly", true);

            $("#EDITPOSTBRIEF")[0].type = 'text';
            $("#EDITPOSTBRIEF")[0].style.backgroundColor = 'black';
            $("#EDITPOSTBRIEF").val('R');
            $("#EDITPOSTBRIEF").prop("readonly", true);
            */
        }
        else {
            $("#EDITDURATION")[0].type = 'number';
            $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
            $("#EDITDURATION").val('0');
            $("#EDITDURATION").prop("readonly", false);
            /*
            $("#EDITPREBRIEF")[0].type = 'number';
            $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#EDITPREBRIEF").val('0');
            $("#EDITPREBRIEF").prop("readonly", false);

            $("#EDITPOSTBRIEF")[0].type = 'number';
            $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#EDITPOSTBRIEF").val('0');
            $("#EDITPOSTBRIEF").prop("readonly", false);
            */
        }
    }

    function savetemplate() {
        let text = "Are you sure that you want to proceed? This will overwrite if a template was already saved for this SOI.";
        if (confirm(text) == true) {
            var buildid = getUrlVars()["buildid"];
            window.location.href = "../SOITable/savebuildastemplate.aspx?buildid=" + buildid;
        } else {
            return;
        }
    }

    function checklesson(form) {
        var lessoncheck = form.LESSID.value;

        if (lessoncheck == "") {
            alert("Lesson dropdown field is required!");
            return false;
        }
    }

    function checklesson2(form) {
        var lessoncheck = form.EDITLESSID.value;

        if (lessoncheck == "") {
            alert("Lesson dropdown field is required!");
            return false;
        }
    }
</script>

<style>
table tr td:first-of-type {
  cursor: move;  
}
table tr td{
  text-align: center;
}

#main {
    overflow-x: hidden;
}

@media screen and (max-width: 1300px) {  
  #myModal{
        width: 580px;
        min-width: 580px;
        font-size: 10px;
    }
  #myModal2{
        width: 580px;
        min-width: 580px;
        font-size: 10px;    
    }
}

.modal{
    width: 1700px;
}
#pilotcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 130px;
}
#PILOT{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#pilotcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#csocheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#CSO{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#csocheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#smacheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#SMA{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#smacheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#lmcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 105px;
}
#LM{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#lmcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#reviewcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 138px;
}
#Review{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#reviewcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}

#EDITpilotcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 130px;
}
#EDITPILOT{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITpilotcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITcsocheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#EDITCSO{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITcsocheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITsmacheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#EDITSMA{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITsmacheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITlmcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 105px;
}
#EDITLM{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITlmcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITreviewcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 138px;
}
#EDITReview{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITreviewcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}

.InfoTitles{
    margin-top: 13px;
    float: left;
    width: 200px;
    color: black;
    text-align: right;
}

.select2-search__field {
    color: black;
}

.buttonred {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: darkred;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 16px;
    padding: 1rem;
    cursor: pointer;
}

.buttonred:focus,
.buttonred:hover {
    background-color: darkred;
    color: white
}

.buttongreen {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: darkgreen;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 16px;
    padding: 1rem;
    cursor: pointer;
}

.buttongreen:focus,
.buttongreen:hover {
    background-color: darkgreen;
    color: white
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Edit SOI Build<br /><span style="color: #005EB8"><asp:Label ID="Label1" runat="server" /></span></h1></div>
<hr />
<button style="margin-left: 20px; margin-top: 4px;" class="button" onclick="backtoactivebuilds()">&#11164; Back to Active SOI Builds</button>
<div id="SOITable" style="margin: 35px; min-width: 600px;">
<button class="button" onclick="newlesson()">Add Row</button>
<button class="button" onclick="editdata()">Edit Row</button>
<button class="button" onclick="deletedata()">Delete Row</button>
<button class="buttongreen" onclick="savetemplate()">Save Build as Template</button>
<br /><br />

<form runat="server">
    <div style="display: none;">
    <input type="text" id="rowindex" runat="server" ClientIDMode="Static" style="color:black" value=""  />
    <input type="text" id="newrow" runat="server" ClientIDMode="Static" style="color:black" value=""  />
    </div>
    <div id="savebutton" style="display: none;">
        <asp:Button runat="server" class="buttongreen" id="btnSave" Text="Save Change" OnClick="btnSave_Click" />
        <button class="buttonred" onclick="canceldrag()">Cancel</button>
    </div>    
</form>


<table id="example" class="display" style="width:100%; border: none;">
        <thead style="background-color: #005EB8; color: white">
            <tr>    
                <th>Order</th>
                <th>Day</th>
                <th>Lesson</th>    
                <th>Duration</th>   
                <th>Pre Brief</th> 
                <th>Post Brief</th> 
                <th># of Missions</th> 
                <th>Pilot</th>
                <th>Pilot Prereqs</th> 
                <th>CSO</th> 
                <th>CSO Prereqs</th> 
                <th>SMA</th>             
                <th>SMA Prereqs</th>        
                <th>LM</th>
                <th>LM Prereqs</th> 
                <th>LESSID</th>
                <th>Pilot Prereqs List</th>
                <th>CSO Prereqs List</th>
                <th>SMA Prereqs List</th>
                <th>LM Prereqs List</th>
                <th>Review</th>
                <th>Day</th>
                <th>ID</th> 
            </tr>
        </thead>
        <tbody>                    
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add Row</h4><br />
       <form class="form login" name="form1" action="../SOITable/newlesson.aspx?type=build" method="post" enctype="multipart/form-data" onsubmit="return checklesson(this)">
       <input type="hidden" name="buildid" id="buildid" /> 
       <div class="form__field">
       <div class='InfoTitles'>Day:&nbsp;</div><input style="color: white;" type="number" min="1" name="DAY" id="DAY" placeholder="Day" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Lesson:&nbsp;</div>
            <select class="selectstyle" id="LESSID" name="LESSID" style="width: 100%;" onchange="checkmediatype();">
                 <asp:Label ID="Label2" runat="server" />  
            </select>
       </div> 
    
       <div class="form__field" id="reviewcheckbox" style="display: none" >
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='Review' name='Review' onchange='changevalues();'><label for='Review'>Review&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>

       <div class="form__field">
       <div class='InfoTitles'>Duration:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="DURATION" id="DURATION" placeholder="Duration" required="required"/>
       </div> 
       <div class="form__field">
       <div class='InfoTitles'>Pre Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="PREBRIEF" id="PREBRIEF" placeholder="Pre Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Post Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="POSTBRIEF" id="POSTBRIEF" placeholder="Post Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'># of Missions:&nbsp;</div><input style="color: white;" type="number" min="0" value="0" name="MISSIONS" id="MISSIONS" placeholder="# of Missions" required="required"/>
       </div> 

       <div class="form__field" id="pilotcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='PILOT' name='PILOT'><label for='PILOT'>PILOT&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>Pilot Prereqs:&nbsp;</div>
            <select class="selectstyle" id="PILOTPREREQS" name="PILOTPREREQS" style="width: 100%;" onchange="Pilotprereq();" multiple="multiple">
                 <asp:Label ID="Label3" runat="server" />  
            </select>
       </div>  

       <div class="form__field" id="csocheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='CSO' name='CSO' onchange="validateCSO();"><label for='CSO'>CSO&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>CSO Prereqs:&nbsp;</div>
            <select class="selectstyle" id="CSOPREREQS" name="CSOPREREQS" style="width: 100%;" onchange="CSOprereq();" multiple="multiple">
                 <asp:Label ID="Label4" runat="server" />  
            </select>
       </div> 
           
       <div class="form__field" id="smacheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='SMA' name='SMA' onchange="validateSMA();"><label for='SMA'>SMA&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>SMA Prereqs:&nbsp;</div>
            <select class="selectstyle" id="SMAPREREQS" name="SMAPREREQS" style="width: 100%;" onchange="SMAprereq();" multiple="multiple">
                 <asp:Label ID="Label5" runat="server" />  
            </select>
       </div> 

       <div class="form__field" id="lmcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='LM' name='LM'><label for='LM'>LM&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>LM Prereqs:&nbsp;</div>
            <select class="selectstyle" id="LMPREREQS" name="LMPREREQS" style="width: 100%;" onchange="LMprereq();" multiple="multiple">
                 <asp:Label ID="Label6" runat="server" />  
            </select>
       </div> 

       <div class="form__field">
       <input type="submit" value="Submit" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Row</h4><br />
       <form class="form login" name="form1" action="../SOITable/editlesson.aspx?type=build" method="post" enctype="multipart/form-data" onsubmit="return checklesson2(this)">
       <input type="hidden" name="editbuildid" id="editbuildid" /> 
       <input type="hidden" name="editid" id="editid" />  
       <div class="form__field">
       <div class='InfoTitles'>Day:&nbsp;</div><input style="color: white;" type="number" min="1" name="EDITDAY" id="EDITDAY" placeholder="Day" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Lesson:&nbsp;</div>
            <select class="selectstyle" id="EDITLESSID" name="EDITLESSID" style="width: 100%;" onchange="checkmediatype2();">
                 <asp:Label ID="Label7" runat="server" />  
            </select>
       </div> 
    
       <div class="form__field" id="EDITreviewcheckbox" style="display: none" >
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITReview' name='EDITReview' onchange='changevalues2();'><label for='EDITReview'>Review&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>

       <div class="form__field">
       <div class='InfoTitles'>Duration:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITDURATION" id="EDITDURATION" placeholder="Duration" required="required"/>
       </div> 
       <div class="form__field">
       <div class='InfoTitles'>Pre Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITPREBRIEF" id="EDITPREBRIEF" placeholder="Pre Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Post Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITPOSTBRIEF" id="EDITPOSTBRIEF" placeholder="Post Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'># of Missions:&nbsp;</div><input style="color: white;" type="number" min="0" value="0" name="EDITMISSIONS" id="EDITMISSIONS" placeholder="# of Missions" required="required"/>
       </div> 

       <div class="form__field" id="EDITpilotcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITPILOT' name='EDITPILOT'><label for='EDITPILOT'>PILOT&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>Pilot Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITPILOTPREREQS" name="EDITPILOTPREREQS" style="width: 100%;" onchange="Pilotprereq2();" multiple="multiple">
                 <asp:Label ID="Label8" runat="server" />  
            </select>
       </div>  

       <div class="form__field" id="EDITcsocheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITCSO' name='EDITCSO' onchange="validateCSO2();"><label for='EDITCSO'>CSO&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>CSO Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITCSOPREREQS" name="EDITCSOPREREQS" style="width: 100%;" onchange="CSOprereq2();" multiple="multiple">
                 <asp:Label ID="Label9" runat="server" />  
            </select>
       </div> 
           
       <div class="form__field" id="EDITsmacheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITSMA' name='EDITSMA' onchange="validateSMA2();"><label for='EDITSMA'>SMA&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>SMA Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITSMAPREREQS" name="EDITSMAPREREQS" style="width: 100%;" onchange="SMAprereq2();" multiple="multiple">
                 <asp:Label ID="Label10" runat="server" />  
            </select>
       </div> 

       <div class="form__field" id="EDITlmcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITLM' name='EDITLM'><label for='EDITLM'>LM&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>LM Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITLMPREREQS" name="EDITLMPREREQS" style="width: 100%;" onchange="LMprereq2();" multiple="multiple">
                 <asp:Label ID="Label11" runat="server" />  
            </select>
       </div> 

       <div class="form__field">
       <input type="submit" value="Update" style="width: 300px;" />
       </div>          
       </form>
  </div>  
</div>


</asp:Content>
